/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BaseInputCheckPasswordSRP;
import telegram4j.tl.InputCheckPasswordSRP;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseInputCheckPasswordSRP
implements BaseInputCheckPasswordSRP {
    private final int identifier;
    private final long srpId;
    private final ByteBuf a;
    private final ByteBuf m1;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseInputCheckPasswordSRP(long srpId) {
        this.srpId = srpId;
        this.a = null;
        this.m1 = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableBaseInputCheckPasswordSRP(Builder builder) {
        this.srpId = builder.srpId;
        this.a = builder.a_build();
        this.m1 = builder.m1_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableBaseInputCheckPasswordSRP(int identifier, long srpId, ByteBuf a, ByteBuf m1) {
        this.identifier = identifier;
        this.srpId = srpId;
        this.a = a;
        this.m1 = m1;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseInputCheckPasswordSRP.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public long srpId() {
        return this.srpId;
    }

    @Override
    public ByteBuf a() {
        return this.a.duplicate();
    }

    @Override
    public ByteBuf m1() {
        return this.m1.duplicate();
    }

    public final ImmutableBaseInputCheckPasswordSRP withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseInputCheckPasswordSRP(value, this.srpId, this.a, this.m1);
    }

    public final ImmutableBaseInputCheckPasswordSRP withSrpId(long value) {
        if (this.srpId == value) {
            return this;
        }
        return new ImmutableBaseInputCheckPasswordSRP(this.identifier, value, this.a, this.m1);
    }

    public ImmutableBaseInputCheckPasswordSRP withA(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.a == newValue) {
            return this;
        }
        return new ImmutableBaseInputCheckPasswordSRP(this.identifier, this.srpId, newValue, this.m1);
    }

    public ImmutableBaseInputCheckPasswordSRP withM1(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.m1 == newValue) {
            return this;
        }
        return new ImmutableBaseInputCheckPasswordSRP(this.identifier, this.srpId, this.a, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseInputCheckPasswordSRP && this.equalTo(0, (ImmutableBaseInputCheckPasswordSRP)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseInputCheckPasswordSRP another) {
        return this.identifier == another.identifier && this.srpId == another.srpId && this.a().equals((Object)another.a()) && this.m1().equals((Object)another.m1());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.srpId);
        h += (h << 5) + this.a().hashCode();
        h += (h << 5) + this.m1().hashCode();
        return h;
    }

    public String toString() {
        return "BaseInputCheckPasswordSRP{identifier=" + this.identifier + ", srpId=" + this.srpId + ", a=" + ByteBufUtil.hexDump((ByteBuf)this.a) + ", m1=" + ByteBufUtil.hexDump((ByteBuf)this.m1) + "}";
    }

    public static ImmutableBaseInputCheckPasswordSRP of(long srpId) {
        return new ImmutableBaseInputCheckPasswordSRP(srpId);
    }

    public static ImmutableBaseInputCheckPasswordSRP copyOf(BaseInputCheckPasswordSRP instance) {
        if (instance instanceof ImmutableBaseInputCheckPasswordSRP) {
            return (ImmutableBaseInputCheckPasswordSRP)instance;
        }
        return ImmutableBaseInputCheckPasswordSRP.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SRP_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private ByteBuf a_value = null;
        private ByteBuf m1_value = null;
        private int identifier;
        private long srpId;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseInputCheckPasswordSRP instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputCheckPasswordSRP instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseInputCheckPasswordSRP) {
                instance = (BaseInputCheckPasswordSRP)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.a(instance.a());
                this.m1(instance.m1());
                this.srpId(instance.srpId());
            }
            if (object instanceof InputCheckPasswordSRP) {
                instance = (InputCheckPasswordSRP)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder srpId(long srpId) {
            this.srpId = srpId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder a(ByteBuf value) {
            this.a_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder m1(ByteBuf value) {
            this.m1_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableBaseInputCheckPasswordSRP build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseInputCheckPasswordSRP(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("srpId");
            }
            return "Cannot build BaseInputCheckPasswordSRP, some of required attributes are not set " + attributes;
        }

        private ByteBuf a_build() {
            return Objects.requireNonNull(this.a_value);
        }

        private ByteBuf m1_build() {
            return Objects.requireNonNull(this.m1_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseInputCheckPasswordSRP.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build BaseInputCheckPasswordSRP, attribute initializers form cycle " + attributes;
        }
    }
}

