/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BaseInputDialogPeer;
import telegram4j.tl.InputDialogPeer;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseInputDialogPeer
implements BaseInputDialogPeer {
    private final int identifier;
    private final InputPeer peer;

    private ImmutableBaseInputDialogPeer(InputPeer peer) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.identifier = BaseInputDialogPeer.super.identifier();
    }

    private ImmutableBaseInputDialogPeer(Builder builder) {
        this.peer = builder.peer;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseInputDialogPeer.super.identifier();
    }

    private ImmutableBaseInputDialogPeer(int identifier, InputPeer peer) {
        this.identifier = identifier;
        this.peer = peer;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    public final ImmutableBaseInputDialogPeer withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseInputDialogPeer(value, this.peer);
    }

    public final ImmutableBaseInputDialogPeer withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableBaseInputDialogPeer(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseInputDialogPeer && this.equalTo(0, (ImmutableBaseInputDialogPeer)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseInputDialogPeer another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        return h;
    }

    public String toString() {
        return "BaseInputDialogPeer{identifier=" + this.identifier + ", peer=" + this.peer + "}";
    }

    public static ImmutableBaseInputDialogPeer of(InputPeer peer) {
        return new ImmutableBaseInputDialogPeer(peer);
    }

    public static ImmutableBaseInputDialogPeer copyOf(BaseInputDialogPeer instance) {
        if (instance instanceof ImmutableBaseInputDialogPeer) {
            return (ImmutableBaseInputDialogPeer)instance;
        }
        return ImmutableBaseInputDialogPeer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputPeer peer;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseInputDialogPeer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputDialogPeer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseInputDialogPeer) {
                instance = (BaseInputDialogPeer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
            }
            if (object instanceof InputDialogPeer) {
                instance = (InputDialogPeer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableBaseInputDialogPeer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseInputDialogPeer(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build BaseInputDialogPeer, some of required attributes are not set " + attributes;
        }
    }
}

