/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BaseInputDocument;
import telegram4j.tl.InputDocument;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseInputDocument
implements BaseInputDocument {
    private final int identifier;
    private final long id;
    private final long accessHash;
    private final ByteBuf fileReference;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseInputDocument(long id, long accessHash) {
        this.id = id;
        this.accessHash = accessHash;
        this.fileReference = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableBaseInputDocument(Builder builder) {
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.fileReference = builder.fileReference_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableBaseInputDocument(int identifier, long id, long accessHash, ByteBuf fileReference) {
        this.identifier = identifier;
        this.id = id;
        this.accessHash = accessHash;
        this.fileReference = fileReference;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseInputDocument.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    @Override
    public ByteBuf fileReference() {
        return this.fileReference.duplicate();
    }

    public final ImmutableBaseInputDocument withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseInputDocument(value, this.id, this.accessHash, this.fileReference);
    }

    public final ImmutableBaseInputDocument withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableBaseInputDocument(this.identifier, value, this.accessHash, this.fileReference);
    }

    public final ImmutableBaseInputDocument withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableBaseInputDocument(this.identifier, this.id, value, this.fileReference);
    }

    public ImmutableBaseInputDocument withFileReference(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.fileReference == newValue) {
            return this;
        }
        return new ImmutableBaseInputDocument(this.identifier, this.id, this.accessHash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseInputDocument && this.equalTo(0, (ImmutableBaseInputDocument)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseInputDocument another) {
        return this.identifier == another.identifier && this.id == another.id && this.accessHash == another.accessHash && this.fileReference().equals((Object)another.fileReference());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + Long.hashCode(this.accessHash);
        h += (h << 5) + this.fileReference().hashCode();
        return h;
    }

    public String toString() {
        return "BaseInputDocument{identifier=" + this.identifier + ", id=" + this.id + ", accessHash=" + this.accessHash + ", fileReference=" + ByteBufUtil.hexDump((ByteBuf)this.fileReference) + "}";
    }

    public static ImmutableBaseInputDocument of(long id, long accessHash) {
        return new ImmutableBaseInputDocument(id, accessHash);
    }

    public static ImmutableBaseInputDocument copyOf(BaseInputDocument instance) {
        if (instance instanceof ImmutableBaseInputDocument) {
            return (ImmutableBaseInputDocument)instance;
        }
        return ImmutableBaseInputDocument.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private ByteBuf fileReference_value = null;
        private int identifier;
        private long id;
        private long accessHash;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputDocument instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseInputDocument instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputDocument) {
                instance = (InputDocument)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseInputDocument) {
                instance = (BaseInputDocument)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.accessHash(instance.accessHash());
                this.id(instance.id());
                this.fileReference(instance.fileReference());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder fileReference(ByteBuf value) {
            this.fileReference_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableBaseInputDocument build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseInputDocument(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            return "Cannot build BaseInputDocument, some of required attributes are not set " + attributes;
        }

        private ByteBuf fileReference_build() {
            return Objects.requireNonNull(this.fileReference_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseInputDocument.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build BaseInputDocument, attribute initializers form cycle " + attributes;
        }
    }
}

