/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BaseInputFileLocation;
import telegram4j.tl.InputFileLocation;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseInputFileLocation
implements BaseInputFileLocation {
    private final int identifier;
    private final long volumeId;
    private final int localId;
    private final long secret;
    private final ByteBuf fileReference;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseInputFileLocation(long volumeId, int localId, long secret) {
        this.volumeId = volumeId;
        this.localId = localId;
        this.secret = secret;
        this.fileReference = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableBaseInputFileLocation(Builder builder) {
        this.volumeId = builder.volumeId;
        this.localId = builder.localId;
        this.secret = builder.secret;
        this.fileReference = builder.fileReference_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableBaseInputFileLocation(int identifier, long volumeId, int localId, long secret, ByteBuf fileReference) {
        this.identifier = identifier;
        this.volumeId = volumeId;
        this.localId = localId;
        this.secret = secret;
        this.fileReference = fileReference;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseInputFileLocation.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public long volumeId() {
        return this.volumeId;
    }

    @Override
    public int localId() {
        return this.localId;
    }

    @Override
    public long secret() {
        return this.secret;
    }

    @Override
    public ByteBuf fileReference() {
        return this.fileReference.duplicate();
    }

    public final ImmutableBaseInputFileLocation withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseInputFileLocation(value, this.volumeId, this.localId, this.secret, this.fileReference);
    }

    public final ImmutableBaseInputFileLocation withVolumeId(long value) {
        if (this.volumeId == value) {
            return this;
        }
        return new ImmutableBaseInputFileLocation(this.identifier, value, this.localId, this.secret, this.fileReference);
    }

    public final ImmutableBaseInputFileLocation withLocalId(int value) {
        if (this.localId == value) {
            return this;
        }
        return new ImmutableBaseInputFileLocation(this.identifier, this.volumeId, value, this.secret, this.fileReference);
    }

    public final ImmutableBaseInputFileLocation withSecret(long value) {
        if (this.secret == value) {
            return this;
        }
        return new ImmutableBaseInputFileLocation(this.identifier, this.volumeId, this.localId, value, this.fileReference);
    }

    public ImmutableBaseInputFileLocation withFileReference(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.fileReference == newValue) {
            return this;
        }
        return new ImmutableBaseInputFileLocation(this.identifier, this.volumeId, this.localId, this.secret, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseInputFileLocation && this.equalTo(0, (ImmutableBaseInputFileLocation)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseInputFileLocation another) {
        return this.identifier == another.identifier && this.volumeId == another.volumeId && this.localId == another.localId && this.secret == another.secret && this.fileReference().equals((Object)another.fileReference());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.volumeId);
        h += (h << 5) + this.localId;
        h += (h << 5) + Long.hashCode(this.secret);
        h += (h << 5) + this.fileReference().hashCode();
        return h;
    }

    public String toString() {
        return "BaseInputFileLocation{identifier=" + this.identifier + ", volumeId=" + this.volumeId + ", localId=" + this.localId + ", secret=" + this.secret + ", fileReference=" + ByteBufUtil.hexDump((ByteBuf)this.fileReference) + "}";
    }

    public static ImmutableBaseInputFileLocation of(long volumeId, int localId, long secret) {
        return new ImmutableBaseInputFileLocation(volumeId, localId, secret);
    }

    public static ImmutableBaseInputFileLocation copyOf(BaseInputFileLocation instance) {
        if (instance instanceof ImmutableBaseInputFileLocation) {
            return (ImmutableBaseInputFileLocation)instance;
        }
        return ImmutableBaseInputFileLocation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_VOLUME_ID = 1L;
        private static final long INIT_BIT_LOCAL_ID = 2L;
        private static final long INIT_BIT_SECRET = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private ByteBuf fileReference_value = null;
        private int identifier;
        private long volumeId;
        private int localId;
        private long secret;

        private Builder() {
        }

        public final Builder from(InputFileLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseInputFileLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputFileLocation instance;
            long bits = 0L;
            if (object instanceof InputFileLocation) {
                instance = (InputFileLocation)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseInputFileLocation) {
                instance = (BaseInputFileLocation)object;
                this.volumeId(instance.volumeId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.secret(instance.secret());
                this.fileReference(instance.fileReference());
                this.localId(instance.localId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder volumeId(long volumeId) {
            this.volumeId = volumeId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder localId(int localId) {
            this.localId = localId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder secret(long secret) {
            this.secret = secret;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder fileReference(ByteBuf value) {
            this.fileReference_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableBaseInputFileLocation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseInputFileLocation(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("volumeId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("localId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("secret");
            }
            return "Cannot build BaseInputFileLocation, some of required attributes are not set " + attributes;
        }

        private ByteBuf fileReference_build() {
            return Objects.requireNonNull(this.fileReference_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseInputFileLocation.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build BaseInputFileLocation, attribute initializers form cycle " + attributes;
        }
    }
}

