/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BaseInputGeoPoint;
import telegram4j.tl.InputGeoPoint;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseInputGeoPoint
implements BaseInputGeoPoint {
    private final int identifier;
    private final int flags;
    private final double lat;
    private final double longitude;
    @Nullable
    private final Integer accuracyRadius;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseInputGeoPoint(double lat, double longitude) {
        this.lat = lat;
        this.longitude = longitude;
        this.accuracyRadius = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableBaseInputGeoPoint(Builder builder) {
        this.lat = builder.lat;
        this.longitude = builder.longitude;
        this.accuracyRadius = builder.accuracyRadius;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableBaseInputGeoPoint(int identifier, int flags, double lat, double longitude, @Nullable Integer accuracyRadius) {
        this.identifier = identifier;
        this.flags = flags;
        this.lat = lat;
        this.longitude = longitude;
        this.accuracyRadius = accuracyRadius;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseInputGeoPoint.super.identifier();
    }

    private int flagsInitialize() {
        return BaseInputGeoPoint.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public double lat() {
        return this.lat;
    }

    @Override
    public double longitude() {
        return this.longitude;
    }

    @Override
    @Nullable
    public Integer accuracyRadius() {
        return this.accuracyRadius;
    }

    public final ImmutableBaseInputGeoPoint withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseInputGeoPoint(value, this.flags, this.lat, this.longitude, this.accuracyRadius);
    }

    public final ImmutableBaseInputGeoPoint withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBaseInputGeoPoint(this.identifier, value, this.lat, this.longitude, this.accuracyRadius);
    }

    public final ImmutableBaseInputGeoPoint withLat(double value) {
        if (Double.doubleToLongBits(this.lat) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableBaseInputGeoPoint(this.identifier, this.flags, value, this.longitude, this.accuracyRadius);
    }

    public final ImmutableBaseInputGeoPoint withLongitude(double value) {
        if (Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableBaseInputGeoPoint(this.identifier, this.flags, this.lat, value, this.accuracyRadius);
    }

    public final ImmutableBaseInputGeoPoint withAccuracyRadius(@Nullable Integer value) {
        if (Objects.equals(this.accuracyRadius, value)) {
            return this;
        }
        return new ImmutableBaseInputGeoPoint(this.identifier, this.flags, this.lat, this.longitude, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseInputGeoPoint && this.equalTo(0, (ImmutableBaseInputGeoPoint)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseInputGeoPoint another) {
        return this.identifier == another.identifier && this.flags == another.flags && Double.doubleToLongBits(this.lat) == Double.doubleToLongBits(another.lat) && Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(another.longitude) && Objects.equals(this.accuracyRadius, another.accuracyRadius);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Double.hashCode(this.lat);
        h += (h << 5) + Double.hashCode(this.longitude);
        h += (h << 5) + Objects.hashCode(this.accuracyRadius);
        return h;
    }

    public String toString() {
        return "BaseInputGeoPoint{identifier=" + this.identifier + ", flags=" + this.flags + ", lat=" + this.lat + ", longitude=" + this.longitude + ", accuracyRadius=" + this.accuracyRadius + "}";
    }

    public static ImmutableBaseInputGeoPoint of(double lat, double longitude) {
        return new ImmutableBaseInputGeoPoint(lat, longitude);
    }

    public static ImmutableBaseInputGeoPoint copyOf(BaseInputGeoPoint instance) {
        if (instance instanceof ImmutableBaseInputGeoPoint) {
            return (ImmutableBaseInputGeoPoint)instance;
        }
        return ImmutableBaseInputGeoPoint.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_LAT = 1L;
        private static final long INIT_BIT_LONGITUDE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private double lat;
        private double longitude;
        private Integer accuracyRadius;

        private Builder() {
        }

        public final Builder from(BaseInputGeoPoint instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputGeoPoint instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputGeoPoint instance;
            long bits = 0L;
            if (object instanceof BaseInputGeoPoint) {
                Integer accuracyRadiusValue;
                instance = (BaseInputGeoPoint)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((accuracyRadiusValue = instance.accuracyRadius()) != null) {
                    this.accuracyRadius(accuracyRadiusValue);
                }
                this.lat(instance.lat());
                this.longitude(instance.longitude());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputGeoPoint) {
                instance = (InputGeoPoint)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder lat(double lat) {
            this.lat = lat;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder longitude(double longitude) {
            this.longitude = longitude;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder accuracyRadius(@Nullable Integer accuracyRadius) {
            this.accuracyRadius = accuracyRadius;
            return this;
        }

        public ImmutableBaseInputGeoPoint build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseInputGeoPoint(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("lat");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("longitude");
            }
            return "Cannot build BaseInputGeoPoint, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseInputGeoPoint.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBaseInputGeoPoint.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build BaseInputGeoPoint, attribute initializers form cycle " + attributes;
        }
    }
}

