/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BaseInputNotifyPeer;
import telegram4j.tl.InputNotifyPeer;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseInputNotifyPeer
implements BaseInputNotifyPeer {
    private final int identifier;
    private final InputPeer peer;

    private ImmutableBaseInputNotifyPeer(InputPeer peer) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.identifier = BaseInputNotifyPeer.super.identifier();
    }

    private ImmutableBaseInputNotifyPeer(Builder builder) {
        this.peer = builder.peer;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseInputNotifyPeer.super.identifier();
    }

    private ImmutableBaseInputNotifyPeer(int identifier, InputPeer peer) {
        this.identifier = identifier;
        this.peer = peer;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    public final ImmutableBaseInputNotifyPeer withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseInputNotifyPeer(value, this.peer);
    }

    public final ImmutableBaseInputNotifyPeer withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableBaseInputNotifyPeer(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseInputNotifyPeer && this.equalTo(0, (ImmutableBaseInputNotifyPeer)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseInputNotifyPeer another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        return h;
    }

    public String toString() {
        return "BaseInputNotifyPeer{identifier=" + this.identifier + ", peer=" + this.peer + "}";
    }

    public static ImmutableBaseInputNotifyPeer of(InputPeer peer) {
        return new ImmutableBaseInputNotifyPeer(peer);
    }

    public static ImmutableBaseInputNotifyPeer copyOf(BaseInputNotifyPeer instance) {
        if (instance instanceof ImmutableBaseInputNotifyPeer) {
            return (ImmutableBaseInputNotifyPeer)instance;
        }
        return ImmutableBaseInputNotifyPeer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputPeer peer;

        private Builder() {
        }

        public final Builder from(InputNotifyPeer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseInputNotifyPeer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputNotifyPeer instance;
            long bits = 0L;
            if (object instanceof InputNotifyPeer) {
                instance = (InputNotifyPeer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseInputNotifyPeer) {
                instance = (BaseInputNotifyPeer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableBaseInputNotifyPeer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseInputNotifyPeer(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build BaseInputNotifyPeer, some of required attributes are not set " + attributes;
        }
    }
}

