/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BaseInputPaymentCredentials;
import telegram4j.tl.DataJSON;
import telegram4j.tl.InputPaymentCredentials;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseInputPaymentCredentials
implements BaseInputPaymentCredentials {
    private final int identifier;
    private final int flags;
    private final boolean save;
    private final DataJSON data;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseInputPaymentCredentials(DataJSON data) {
        this.data = Objects.requireNonNull(data, "data");
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.save = this.initShim.save();
        this.initShim = null;
    }

    private ImmutableBaseInputPaymentCredentials(Builder builder) {
        this.data = builder.data;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.saveIsSet()) {
            this.initShim.save(builder.save);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.save = this.initShim.save();
        this.initShim = null;
    }

    private ImmutableBaseInputPaymentCredentials(int identifier, int flags, boolean save, DataJSON data) {
        this.identifier = identifier;
        this.flags = flags;
        this.save = save;
        this.data = data;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseInputPaymentCredentials.super.identifier();
    }

    private int flagsInitialize() {
        return BaseInputPaymentCredentials.super.flags();
    }

    private boolean saveInitialize() {
        return BaseInputPaymentCredentials.super.save();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean save() {
        InitShim shim = this.initShim;
        return shim != null ? shim.save() : this.save;
    }

    @Override
    public DataJSON data() {
        return this.data;
    }

    public final ImmutableBaseInputPaymentCredentials withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseInputPaymentCredentials(value, this.flags, this.save, this.data);
    }

    public final ImmutableBaseInputPaymentCredentials withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBaseInputPaymentCredentials(this.identifier, value, this.save, this.data);
    }

    public final ImmutableBaseInputPaymentCredentials withSave(boolean value) {
        if (this.save == value) {
            return this;
        }
        return new ImmutableBaseInputPaymentCredentials(this.identifier, this.flags, value, this.data);
    }

    public final ImmutableBaseInputPaymentCredentials withData(DataJSON value) {
        if (this.data == value) {
            return this;
        }
        DataJSON newValue = Objects.requireNonNull(value, "data");
        return new ImmutableBaseInputPaymentCredentials(this.identifier, this.flags, this.save, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseInputPaymentCredentials && this.equalTo(0, (ImmutableBaseInputPaymentCredentials)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseInputPaymentCredentials another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.save == another.save && this.data.equals(another.data);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.save);
        h += (h << 5) + this.data.hashCode();
        return h;
    }

    public String toString() {
        return "BaseInputPaymentCredentials{identifier=" + this.identifier + ", flags=" + this.flags + ", save=" + this.save + ", data=" + this.data + "}";
    }

    public static ImmutableBaseInputPaymentCredentials of(DataJSON data) {
        return new ImmutableBaseInputPaymentCredentials(data);
    }

    public static ImmutableBaseInputPaymentCredentials copyOf(BaseInputPaymentCredentials instance) {
        if (instance instanceof ImmutableBaseInputPaymentCredentials) {
            return (ImmutableBaseInputPaymentCredentials)instance;
        }
        return ImmutableBaseInputPaymentCredentials.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DATA = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_SAVE = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean save;
        private DataJSON data;

        private Builder() {
        }

        public final Builder from(InputPaymentCredentials instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseInputPaymentCredentials instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputPaymentCredentials instance;
            long bits = 0L;
            if (object instanceof InputPaymentCredentials) {
                instance = (InputPaymentCredentials)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseInputPaymentCredentials) {
                instance = (BaseInputPaymentCredentials)object;
                this.flags(instance.flags());
                this.save(instance.save());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.data(instance.data());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder save(boolean save) {
            this.save = save;
            this.optBits |= 4L;
            return this;
        }

        public final Builder data(DataJSON data) {
            this.data = Objects.requireNonNull(data, "data");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableBaseInputPaymentCredentials build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseInputPaymentCredentials(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean saveIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("data");
            }
            return "Cannot build BaseInputPaymentCredentials, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte saveBuildStage = 0;
        private boolean save;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseInputPaymentCredentials.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBaseInputPaymentCredentials.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean save() {
            if (this.saveBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.saveBuildStage == 0) {
                this.saveBuildStage = (byte)-1;
                this.save = ImmutableBaseInputPaymentCredentials.this.saveInitialize();
                this.saveBuildStage = 1;
            }
            return this.save;
        }

        void save(boolean save) {
            this.save = save;
            this.saveBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.saveBuildStage == -1) {
                attributes.add("save");
            }
            return "Cannot build BaseInputPaymentCredentials, attribute initializers form cycle " + attributes;
        }
    }
}

