/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BaseInputSecureFile;
import telegram4j.tl.InputSecureFile;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseInputSecureFile
implements BaseInputSecureFile {
    private final int identifier;
    private final long id;
    private final long accessHash;

    private ImmutableBaseInputSecureFile(long id, long accessHash) {
        this.id = id;
        this.accessHash = accessHash;
        this.identifier = BaseInputSecureFile.super.identifier();
    }

    private ImmutableBaseInputSecureFile(Builder builder) {
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseInputSecureFile.super.identifier();
    }

    private ImmutableBaseInputSecureFile(int identifier, long id, long accessHash) {
        this.identifier = identifier;
        this.id = id;
        this.accessHash = accessHash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    public final ImmutableBaseInputSecureFile withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseInputSecureFile(value, this.id, this.accessHash);
    }

    public final ImmutableBaseInputSecureFile withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableBaseInputSecureFile(this.identifier, value, this.accessHash);
    }

    public final ImmutableBaseInputSecureFile withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableBaseInputSecureFile(this.identifier, this.id, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseInputSecureFile && this.equalTo(0, (ImmutableBaseInputSecureFile)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseInputSecureFile another) {
        return this.identifier == another.identifier && this.id == another.id && this.accessHash == another.accessHash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + Long.hashCode(this.accessHash);
        return h;
    }

    public String toString() {
        return "BaseInputSecureFile{identifier=" + this.identifier + ", id=" + this.id + ", accessHash=" + this.accessHash + "}";
    }

    public static ImmutableBaseInputSecureFile of(long id, long accessHash) {
        return new ImmutableBaseInputSecureFile(id, accessHash);
    }

    public static ImmutableBaseInputSecureFile copyOf(BaseInputSecureFile instance) {
        if (instance instanceof ImmutableBaseInputSecureFile) {
            return (ImmutableBaseInputSecureFile)instance;
        }
        return ImmutableBaseInputSecureFile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long id;
        private long accessHash;

        private Builder() {
        }

        public final Builder from(InputSecureFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseInputSecureFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputSecureFile instance;
            long bits = 0L;
            if (object instanceof InputSecureFile) {
                instance = (InputSecureFile)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseInputSecureFile) {
                instance = (BaseInputSecureFile)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.accessHash(instance.accessHash());
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBaseInputSecureFile build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseInputSecureFile(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            return "Cannot build BaseInputSecureFile, some of required attributes are not set " + attributes;
        }
    }
}

