/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BaseInputWallPaper;
import telegram4j.tl.InputWallPaper;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseInputWallPaper
implements BaseInputWallPaper {
    private final int identifier;
    private final long id;
    private final long accessHash;

    private ImmutableBaseInputWallPaper(long id, long accessHash) {
        this.id = id;
        this.accessHash = accessHash;
        this.identifier = BaseInputWallPaper.super.identifier();
    }

    private ImmutableBaseInputWallPaper(Builder builder) {
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseInputWallPaper.super.identifier();
    }

    private ImmutableBaseInputWallPaper(int identifier, long id, long accessHash) {
        this.identifier = identifier;
        this.id = id;
        this.accessHash = accessHash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    public final ImmutableBaseInputWallPaper withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseInputWallPaper(value, this.id, this.accessHash);
    }

    public final ImmutableBaseInputWallPaper withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableBaseInputWallPaper(this.identifier, value, this.accessHash);
    }

    public final ImmutableBaseInputWallPaper withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableBaseInputWallPaper(this.identifier, this.id, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseInputWallPaper && this.equalTo(0, (ImmutableBaseInputWallPaper)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseInputWallPaper another) {
        return this.identifier == another.identifier && this.id == another.id && this.accessHash == another.accessHash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + Long.hashCode(this.accessHash);
        return h;
    }

    public String toString() {
        return "BaseInputWallPaper{identifier=" + this.identifier + ", id=" + this.id + ", accessHash=" + this.accessHash + "}";
    }

    public static ImmutableBaseInputWallPaper of(long id, long accessHash) {
        return new ImmutableBaseInputWallPaper(id, accessHash);
    }

    public static ImmutableBaseInputWallPaper copyOf(BaseInputWallPaper instance) {
        if (instance instanceof ImmutableBaseInputWallPaper) {
            return (ImmutableBaseInputWallPaper)instance;
        }
        return ImmutableBaseInputWallPaper.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long id;
        private long accessHash;

        private Builder() {
        }

        public final Builder from(BaseInputWallPaper instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputWallPaper instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputWallPaper instance;
            long bits = 0L;
            if (object instanceof BaseInputWallPaper) {
                instance = (BaseInputWallPaper)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.accessHash(instance.accessHash());
                this.id(instance.id());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InputWallPaper) {
                instance = (InputWallPaper)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBaseInputWallPaper build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseInputWallPaper(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            return "Cannot build BaseInputWallPaper, some of required attributes are not set " + attributes;
        }
    }
}

