/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BaseInputWebFileLocation;
import telegram4j.tl.InputWebFileLocation;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseInputWebFileLocation
implements BaseInputWebFileLocation {
    private final int identifier;
    private final String url;
    private final long accessHash;

    private ImmutableBaseInputWebFileLocation(String url, long accessHash) {
        this.url = Objects.requireNonNull(url, "url");
        this.accessHash = accessHash;
        this.identifier = BaseInputWebFileLocation.super.identifier();
    }

    private ImmutableBaseInputWebFileLocation(Builder builder) {
        this.url = builder.url;
        this.accessHash = builder.accessHash;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseInputWebFileLocation.super.identifier();
    }

    private ImmutableBaseInputWebFileLocation(int identifier, String url, long accessHash) {
        this.identifier = identifier;
        this.url = url;
        this.accessHash = accessHash;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    public final ImmutableBaseInputWebFileLocation withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseInputWebFileLocation(value, this.url, this.accessHash);
    }

    public final ImmutableBaseInputWebFileLocation withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableBaseInputWebFileLocation(this.identifier, newValue, this.accessHash);
    }

    public final ImmutableBaseInputWebFileLocation withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableBaseInputWebFileLocation(this.identifier, this.url, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseInputWebFileLocation && this.equalTo(0, (ImmutableBaseInputWebFileLocation)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseInputWebFileLocation another) {
        return this.identifier == another.identifier && this.url.equals(another.url) && this.accessHash == another.accessHash;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + Long.hashCode(this.accessHash);
        return h;
    }

    public String toString() {
        return "BaseInputWebFileLocation{identifier=" + this.identifier + ", url=" + this.url + ", accessHash=" + this.accessHash + "}";
    }

    public static ImmutableBaseInputWebFileLocation of(String url, long accessHash) {
        return new ImmutableBaseInputWebFileLocation(url, accessHash);
    }

    public static ImmutableBaseInputWebFileLocation copyOf(BaseInputWebFileLocation instance) {
        if (instance instanceof ImmutableBaseInputWebFileLocation) {
            return (ImmutableBaseInputWebFileLocation)instance;
        }
        return ImmutableBaseInputWebFileLocation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String url;
        private long accessHash;

        private Builder() {
        }

        public final Builder from(BaseInputWebFileLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InputWebFileLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InputWebFileLocation instance;
            long bits = 0L;
            if (object instanceof BaseInputWebFileLocation) {
                instance = (BaseInputWebFileLocation)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.accessHash(instance.accessHash());
                this.url(instance.url());
            }
            if (object instanceof InputWebFileLocation) {
                instance = (InputWebFileLocation)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBaseInputWebFileLocation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseInputWebFileLocation(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("url");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            return "Cannot build BaseInputWebFileLocation, some of required attributes are not set " + attributes;
        }
    }
}

