/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BaseIpPort;
import telegram4j.tl.IpPort;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseIpPort
implements BaseIpPort {
    private final int identifier;
    private final int ipv4;
    private final int port;

    private ImmutableBaseIpPort(int ipv4, int port) {
        this.ipv4 = ipv4;
        this.port = port;
        this.identifier = BaseIpPort.super.identifier();
    }

    private ImmutableBaseIpPort(Builder builder) {
        this.ipv4 = builder.ipv4;
        this.port = builder.port;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseIpPort.super.identifier();
    }

    private ImmutableBaseIpPort(int identifier, int ipv4, int port) {
        this.identifier = identifier;
        this.ipv4 = ipv4;
        this.port = port;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int ipv4() {
        return this.ipv4;
    }

    @Override
    public int port() {
        return this.port;
    }

    public final ImmutableBaseIpPort withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseIpPort(value, this.ipv4, this.port);
    }

    public final ImmutableBaseIpPort withIpv4(int value) {
        if (this.ipv4 == value) {
            return this;
        }
        return new ImmutableBaseIpPort(this.identifier, value, this.port);
    }

    public final ImmutableBaseIpPort withPort(int value) {
        if (this.port == value) {
            return this;
        }
        return new ImmutableBaseIpPort(this.identifier, this.ipv4, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseIpPort && this.equalTo(0, (ImmutableBaseIpPort)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseIpPort another) {
        return this.identifier == another.identifier && this.ipv4 == another.ipv4 && this.port == another.port;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.ipv4;
        h += (h << 5) + this.port;
        return h;
    }

    public String toString() {
        return "BaseIpPort{identifier=" + this.identifier + ", ipv4=" + this.ipv4 + ", port=" + this.port + "}";
    }

    public static ImmutableBaseIpPort of(int ipv4, int port) {
        return new ImmutableBaseIpPort(ipv4, port);
    }

    public static ImmutableBaseIpPort copyOf(BaseIpPort instance) {
        if (instance instanceof ImmutableBaseIpPort) {
            return (ImmutableBaseIpPort)instance;
        }
        return ImmutableBaseIpPort.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_IPV4 = 1L;
        private static final long INIT_BIT_PORT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int ipv4;
        private int port;

        private Builder() {
        }

        public final Builder from(BaseIpPort instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IpPort instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            IpPort instance;
            long bits = 0L;
            if (object instanceof BaseIpPort) {
                instance = (BaseIpPort)object;
                if ((bits & 2L) == 0L) {
                    this.ipv4(instance.ipv4());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.port(instance.port());
                    bits |= 4L;
                }
            }
            if (object instanceof IpPort) {
                instance = (IpPort)object;
                if ((bits & 2L) == 0L) {
                    this.ipv4(instance.ipv4());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.port(instance.port());
                    bits |= 4L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder ipv4(int ipv4) {
            this.ipv4 = ipv4;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder port(int port) {
            this.port = port;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBaseIpPort build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseIpPort(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("ipv4");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("port");
            }
            return "Cannot build BaseIpPort, some of required attributes are not set " + attributes;
        }
    }
}

