/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BaseKeyboardButton;
import telegram4j.tl.KeyboardButton;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseKeyboardButton
implements BaseKeyboardButton {
    private final int identifier;
    private final String text;

    private ImmutableBaseKeyboardButton(String text) {
        this.text = Objects.requireNonNull(text, "text");
        this.identifier = BaseKeyboardButton.super.identifier();
    }

    private ImmutableBaseKeyboardButton(Builder builder) {
        this.text = builder.text;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseKeyboardButton.super.identifier();
    }

    private ImmutableBaseKeyboardButton(int identifier, String text) {
        this.identifier = identifier;
        this.text = text;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String text() {
        return this.text;
    }

    public final ImmutableBaseKeyboardButton withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseKeyboardButton(value, this.text);
    }

    public final ImmutableBaseKeyboardButton withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableBaseKeyboardButton(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseKeyboardButton && this.equalTo(0, (ImmutableBaseKeyboardButton)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseKeyboardButton another) {
        return this.identifier == another.identifier && this.text.equals(another.text);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.text.hashCode();
        return h;
    }

    public String toString() {
        return "BaseKeyboardButton{identifier=" + this.identifier + ", text=" + this.text + "}";
    }

    public static ImmutableBaseKeyboardButton of(String text) {
        return new ImmutableBaseKeyboardButton(text);
    }

    public static ImmutableBaseKeyboardButton copyOf(BaseKeyboardButton instance) {
        if (instance instanceof ImmutableBaseKeyboardButton) {
            return (ImmutableBaseKeyboardButton)instance;
        }
        return ImmutableBaseKeyboardButton.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String text;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(KeyboardButton instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseKeyboardButton instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof KeyboardButton) {
                instance = (KeyboardButton)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.text(instance.text());
                    bits |= 2L;
                }
            }
            if (object instanceof BaseKeyboardButton) {
                instance = (BaseKeyboardButton)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.text(instance.text());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableBaseKeyboardButton build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseKeyboardButton(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("text");
            }
            return "Cannot build BaseKeyboardButton, some of required attributes are not set " + attributes;
        }
    }
}

