/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BaseLangPackString;
import telegram4j.tl.LangPackString;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseLangPackString
implements BaseLangPackString {
    private final int identifier;
    private final String key;
    private final String value;

    private ImmutableBaseLangPackString(String key, String value) {
        this.key = Objects.requireNonNull(key, "key");
        this.value = Objects.requireNonNull(value, "value");
        this.identifier = BaseLangPackString.super.identifier();
    }

    private ImmutableBaseLangPackString(Builder builder) {
        this.key = builder.key;
        this.value = builder.value;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseLangPackString.super.identifier();
    }

    private ImmutableBaseLangPackString(int identifier, String key, String value) {
        this.identifier = identifier;
        this.key = key;
        this.value = value;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public String value() {
        return this.value;
    }

    public final ImmutableBaseLangPackString withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseLangPackString(value, this.key, this.value);
    }

    public final ImmutableBaseLangPackString withKey(String value) {
        String newValue = Objects.requireNonNull(value, "key");
        if (this.key.equals(newValue)) {
            return this;
        }
        return new ImmutableBaseLangPackString(this.identifier, newValue, this.value);
    }

    public final ImmutableBaseLangPackString withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableBaseLangPackString(this.identifier, this.key, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseLangPackString && this.equalTo(0, (ImmutableBaseLangPackString)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseLangPackString another) {
        return this.identifier == another.identifier && this.key.equals(another.key) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return "BaseLangPackString{identifier=" + this.identifier + ", key=" + this.key + ", value=" + this.value + "}";
    }

    public static ImmutableBaseLangPackString of(String key, String value) {
        return new ImmutableBaseLangPackString(key, value);
    }

    public static ImmutableBaseLangPackString copyOf(BaseLangPackString instance) {
        if (instance instanceof ImmutableBaseLangPackString) {
            return (ImmutableBaseLangPackString)instance;
        }
        return ImmutableBaseLangPackString.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String key;
        private String value;

        private Builder() {
        }

        public final Builder from(LangPackString instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseLangPackString instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            LangPackString instance;
            long bits = 0L;
            if (object instanceof LangPackString) {
                instance = (LangPackString)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.key(instance.key());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseLangPackString) {
                instance = (BaseLangPackString)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.value(instance.value());
                if ((bits & 2L) == 0L) {
                    this.key(instance.key());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBaseLangPackString build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseLangPackString(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build BaseLangPackString, some of required attributes are not set " + attributes;
        }
    }
}

