/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BaseMessage;
import telegram4j.tl.BaseMessageFields;
import telegram4j.tl.Message;
import telegram4j.tl.MessageEntity;
import telegram4j.tl.MessageFwdHeader;
import telegram4j.tl.MessageMedia;
import telegram4j.tl.MessageReactions;
import telegram4j.tl.MessageReplies;
import telegram4j.tl.MessageReplyHeader;
import telegram4j.tl.Peer;
import telegram4j.tl.ReplyMarkup;
import telegram4j.tl.RestrictionReason;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseMessage
implements BaseMessage {
    private final int identifier;
    private final int flags;
    private final boolean out;
    private final boolean mentioned;
    private final boolean mediaUnread;
    private final boolean silent;
    private final boolean post;
    private final boolean fromScheduled;
    private final boolean legacy;
    private final boolean editHide;
    private final boolean pinned;
    private final boolean noforwards;
    private final int id;
    @Nullable
    private final Peer fromId;
    private final Peer peerId;
    @Nullable
    private final MessageFwdHeader fwdFrom;
    @Nullable
    private final Long viaBotId;
    @Nullable
    private final MessageReplyHeader replyTo;
    private final int date;
    private final String message;
    @Nullable
    private final MessageMedia media;
    @Nullable
    private final ReplyMarkup replyMarkup;
    @Nullable
    private final List<MessageEntity> entities;
    @Nullable
    private final Integer views;
    @Nullable
    private final Integer forwards;
    @Nullable
    private final MessageReplies replies;
    @Nullable
    private final Integer editDate;
    @Nullable
    private final String postAuthor;
    @Nullable
    private final Long groupedId;
    @Nullable
    private final MessageReactions reactions;
    @Nullable
    private final List<RestrictionReason> restrictionReason;
    @Nullable
    private final Integer ttlPeriod;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseMessage(int id, Peer peerId, int date, String message) {
        this.id = id;
        this.peerId = Objects.requireNonNull(peerId, "peerId");
        this.date = date;
        this.message = Objects.requireNonNull(message, "message");
        this.fromId = null;
        this.fwdFrom = null;
        this.viaBotId = null;
        this.replyTo = null;
        this.media = null;
        this.replyMarkup = null;
        this.entities = null;
        this.views = null;
        this.forwards = null;
        this.replies = null;
        this.editDate = null;
        this.postAuthor = null;
        this.groupedId = null;
        this.reactions = null;
        this.restrictionReason = null;
        this.ttlPeriod = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.out = this.initShim.out();
        this.mentioned = this.initShim.mentioned();
        this.mediaUnread = this.initShim.mediaUnread();
        this.silent = this.initShim.silent();
        this.post = this.initShim.post();
        this.fromScheduled = this.initShim.fromScheduled();
        this.legacy = this.initShim.legacy();
        this.editHide = this.initShim.editHide();
        this.pinned = this.initShim.pinned();
        this.noforwards = this.initShim.noforwards();
        this.initShim = null;
    }

    private ImmutableBaseMessage(Builder builder) {
        this.id = builder.id;
        this.fromId = builder.fromId;
        this.peerId = builder.peerId;
        this.fwdFrom = builder.fwdFrom;
        this.viaBotId = builder.viaBotId;
        this.replyTo = builder.replyTo;
        this.date = builder.date;
        this.message = builder.message;
        this.media = builder.media;
        this.replyMarkup = builder.replyMarkup;
        this.entities = builder.entities == null ? null : ImmutableBaseMessage.createUnmodifiableList(true, builder.entities);
        this.views = builder.views;
        this.forwards = builder.forwards;
        this.replies = builder.replies;
        this.editDate = builder.editDate;
        this.postAuthor = builder.postAuthor;
        this.groupedId = builder.groupedId;
        this.reactions = builder.reactions;
        this.restrictionReason = builder.restrictionReason == null ? null : ImmutableBaseMessage.createUnmodifiableList(true, builder.restrictionReason);
        this.ttlPeriod = builder.ttlPeriod;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.outIsSet()) {
            this.initShim.out(builder.out);
        }
        if (builder.mentionedIsSet()) {
            this.initShim.mentioned(builder.mentioned);
        }
        if (builder.mediaUnreadIsSet()) {
            this.initShim.mediaUnread(builder.mediaUnread);
        }
        if (builder.silentIsSet()) {
            this.initShim.silent(builder.silent);
        }
        if (builder.postIsSet()) {
            this.initShim.post(builder.post);
        }
        if (builder.fromScheduledIsSet()) {
            this.initShim.fromScheduled(builder.fromScheduled);
        }
        if (builder.legacyIsSet()) {
            this.initShim.legacy(builder.legacy);
        }
        if (builder.editHideIsSet()) {
            this.initShim.editHide(builder.editHide);
        }
        if (builder.pinnedIsSet()) {
            this.initShim.pinned(builder.pinned);
        }
        if (builder.noforwardsIsSet()) {
            this.initShim.noforwards(builder.noforwards);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.out = this.initShim.out();
        this.mentioned = this.initShim.mentioned();
        this.mediaUnread = this.initShim.mediaUnread();
        this.silent = this.initShim.silent();
        this.post = this.initShim.post();
        this.fromScheduled = this.initShim.fromScheduled();
        this.legacy = this.initShim.legacy();
        this.editHide = this.initShim.editHide();
        this.pinned = this.initShim.pinned();
        this.noforwards = this.initShim.noforwards();
        this.initShim = null;
    }

    private ImmutableBaseMessage(int identifier, int flags, boolean out, boolean mentioned, boolean mediaUnread, boolean silent, boolean post, boolean fromScheduled, boolean legacy, boolean editHide, boolean pinned, boolean noforwards, int id, @Nullable Peer fromId, Peer peerId, @Nullable MessageFwdHeader fwdFrom, @Nullable Long viaBotId, @Nullable MessageReplyHeader replyTo, int date, String message, @Nullable MessageMedia media, @Nullable ReplyMarkup replyMarkup, @Nullable List<MessageEntity> entities, @Nullable Integer views, @Nullable Integer forwards, @Nullable MessageReplies replies, @Nullable Integer editDate, @Nullable String postAuthor, @Nullable Long groupedId, @Nullable MessageReactions reactions, @Nullable List<RestrictionReason> restrictionReason, @Nullable Integer ttlPeriod) {
        this.identifier = identifier;
        this.flags = flags;
        this.out = out;
        this.mentioned = mentioned;
        this.mediaUnread = mediaUnread;
        this.silent = silent;
        this.post = post;
        this.fromScheduled = fromScheduled;
        this.legacy = legacy;
        this.editHide = editHide;
        this.pinned = pinned;
        this.noforwards = noforwards;
        this.id = id;
        this.fromId = fromId;
        this.peerId = peerId;
        this.fwdFrom = fwdFrom;
        this.viaBotId = viaBotId;
        this.replyTo = replyTo;
        this.date = date;
        this.message = message;
        this.media = media;
        this.replyMarkup = replyMarkup;
        this.entities = entities;
        this.views = views;
        this.forwards = forwards;
        this.replies = replies;
        this.editDate = editDate;
        this.postAuthor = postAuthor;
        this.groupedId = groupedId;
        this.reactions = reactions;
        this.restrictionReason = restrictionReason;
        this.ttlPeriod = ttlPeriod;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseMessage.super.identifier();
    }

    private int flagsInitialize() {
        return BaseMessage.super.flags();
    }

    private boolean outInitialize() {
        return BaseMessage.super.out();
    }

    private boolean mentionedInitialize() {
        return BaseMessage.super.mentioned();
    }

    private boolean mediaUnreadInitialize() {
        return BaseMessage.super.mediaUnread();
    }

    private boolean silentInitialize() {
        return BaseMessage.super.silent();
    }

    private boolean postInitialize() {
        return BaseMessage.super.post();
    }

    private boolean fromScheduledInitialize() {
        return BaseMessage.super.fromScheduled();
    }

    private boolean legacyInitialize() {
        return BaseMessage.super.legacy();
    }

    private boolean editHideInitialize() {
        return BaseMessage.super.editHide();
    }

    private boolean pinnedInitialize() {
        return BaseMessage.super.pinned();
    }

    private boolean noforwardsInitialize() {
        return BaseMessage.super.noforwards();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean out() {
        InitShim shim = this.initShim;
        return shim != null ? shim.out() : this.out;
    }

    @Override
    public boolean mentioned() {
        InitShim shim = this.initShim;
        return shim != null ? shim.mentioned() : this.mentioned;
    }

    @Override
    public boolean mediaUnread() {
        InitShim shim = this.initShim;
        return shim != null ? shim.mediaUnread() : this.mediaUnread;
    }

    @Override
    public boolean silent() {
        InitShim shim = this.initShim;
        return shim != null ? shim.silent() : this.silent;
    }

    @Override
    public boolean post() {
        InitShim shim = this.initShim;
        return shim != null ? shim.post() : this.post;
    }

    @Override
    public boolean fromScheduled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fromScheduled() : this.fromScheduled;
    }

    @Override
    public boolean legacy() {
        InitShim shim = this.initShim;
        return shim != null ? shim.legacy() : this.legacy;
    }

    @Override
    public boolean editHide() {
        InitShim shim = this.initShim;
        return shim != null ? shim.editHide() : this.editHide;
    }

    @Override
    public boolean pinned() {
        InitShim shim = this.initShim;
        return shim != null ? shim.pinned() : this.pinned;
    }

    @Override
    public boolean noforwards() {
        InitShim shim = this.initShim;
        return shim != null ? shim.noforwards() : this.noforwards;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    @Nullable
    public Peer fromId() {
        return this.fromId;
    }

    @Override
    public Peer peerId() {
        return this.peerId;
    }

    @Override
    @Nullable
    public MessageFwdHeader fwdFrom() {
        return this.fwdFrom;
    }

    @Override
    @Nullable
    public Long viaBotId() {
        return this.viaBotId;
    }

    @Override
    @Nullable
    public MessageReplyHeader replyTo() {
        return this.replyTo;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    @Nullable
    public MessageMedia media() {
        return this.media;
    }

    @Override
    @Nullable
    public ReplyMarkup replyMarkup() {
        return this.replyMarkup;
    }

    @Override
    @Nullable
    public List<MessageEntity> entities() {
        return this.entities;
    }

    @Override
    @Nullable
    public Integer views() {
        return this.views;
    }

    @Override
    @Nullable
    public Integer forwards() {
        return this.forwards;
    }

    @Override
    @Nullable
    public MessageReplies replies() {
        return this.replies;
    }

    @Override
    @Nullable
    public Integer editDate() {
        return this.editDate;
    }

    @Override
    @Nullable
    public String postAuthor() {
        return this.postAuthor;
    }

    @Override
    @Nullable
    public Long groupedId() {
        return this.groupedId;
    }

    @Override
    @Nullable
    public MessageReactions reactions() {
        return this.reactions;
    }

    @Override
    @Nullable
    public List<RestrictionReason> restrictionReason() {
        return this.restrictionReason;
    }

    @Override
    @Nullable
    public Integer ttlPeriod() {
        return this.ttlPeriod;
    }

    public final ImmutableBaseMessage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseMessage(value, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, value, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withOut(boolean value) {
        if (this.out == value) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, value, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withMentioned(boolean value) {
        if (this.mentioned == value) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, value, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withMediaUnread(boolean value) {
        if (this.mediaUnread == value) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, value, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withSilent(boolean value) {
        if (this.silent == value) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, value, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withPost(boolean value) {
        if (this.post == value) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, value, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withFromScheduled(boolean value) {
        if (this.fromScheduled == value) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, value, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withLegacy(boolean value) {
        if (this.legacy == value) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, value, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withEditHide(boolean value) {
        if (this.editHide == value) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, value, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withPinned(boolean value) {
        if (this.pinned == value) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, value, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withNoforwards(boolean value) {
        if (this.noforwards == value) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, value, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, value, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withFromId(@Nullable Peer value) {
        if (this.fromId == value) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, value, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withPeerId(Peer value) {
        if (this.peerId == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peerId");
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, newValue, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withFwdFrom(@Nullable MessageFwdHeader value) {
        if (this.fwdFrom == value) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, value, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withViaBotId(@Nullable Long value) {
        if (Objects.equals(this.viaBotId, value)) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, value, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withReplyTo(@Nullable MessageReplyHeader value) {
        if (this.replyTo == value) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, value, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, value, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, newValue, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withMedia(@Nullable MessageMedia value) {
        if (this.media == value) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, value, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withReplyMarkup(@Nullable ReplyMarkup value) {
        if (this.replyMarkup == value) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, value, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withEntities(MessageEntity ... elements) {
        if (elements == null) {
            return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, null, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
        }
        List<MessageEntity> newValue = Arrays.asList(elements) == null ? null : ImmutableBaseMessage.createUnmodifiableList(false, ImmutableBaseMessage.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, newValue, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withEntities(@Nullable Iterable<? extends MessageEntity> elements) {
        if (this.entities == elements) {
            return this;
        }
        List<MessageEntity> newValue = elements == null ? null : ImmutableBaseMessage.createUnmodifiableList(false, ImmutableBaseMessage.createSafeList(elements, true, false));
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, newValue, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withViews(@Nullable Integer value) {
        if (Objects.equals(this.views, value)) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, value, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withForwards(@Nullable Integer value) {
        if (Objects.equals(this.forwards, value)) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, value, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withReplies(@Nullable MessageReplies value) {
        if (this.replies == value) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, value, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withEditDate(@Nullable Integer value) {
        if (Objects.equals(this.editDate, value)) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, value, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withPostAuthor(@Nullable String value) {
        if (Objects.equals(this.postAuthor, value)) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, value, this.groupedId, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withGroupedId(@Nullable Long value) {
        if (Objects.equals(this.groupedId, value)) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, value, this.reactions, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withReactions(@Nullable MessageReactions value) {
        if (this.reactions == value) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, value, this.restrictionReason, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withRestrictionReason(RestrictionReason ... elements) {
        if (elements == null) {
            return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, null, this.ttlPeriod);
        }
        List<RestrictionReason> newValue = Arrays.asList(elements) == null ? null : ImmutableBaseMessage.createUnmodifiableList(false, ImmutableBaseMessage.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, newValue, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withRestrictionReason(@Nullable Iterable<? extends RestrictionReason> elements) {
        if (this.restrictionReason == elements) {
            return this;
        }
        List<RestrictionReason> newValue = elements == null ? null : ImmutableBaseMessage.createUnmodifiableList(false, ImmutableBaseMessage.createSafeList(elements, true, false));
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, newValue, this.ttlPeriod);
    }

    public final ImmutableBaseMessage withTtlPeriod(@Nullable Integer value) {
        if (Objects.equals(this.ttlPeriod, value)) {
            return this;
        }
        return new ImmutableBaseMessage(this.identifier, this.flags, this.out, this.mentioned, this.mediaUnread, this.silent, this.post, this.fromScheduled, this.legacy, this.editHide, this.pinned, this.noforwards, this.id, this.fromId, this.peerId, this.fwdFrom, this.viaBotId, this.replyTo, this.date, this.message, this.media, this.replyMarkup, this.entities, this.views, this.forwards, this.replies, this.editDate, this.postAuthor, this.groupedId, this.reactions, this.restrictionReason, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseMessage && this.equalTo(0, (ImmutableBaseMessage)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseMessage another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.out == another.out && this.mentioned == another.mentioned && this.mediaUnread == another.mediaUnread && this.silent == another.silent && this.post == another.post && this.fromScheduled == another.fromScheduled && this.legacy == another.legacy && this.editHide == another.editHide && this.pinned == another.pinned && this.noforwards == another.noforwards && this.id == another.id && Objects.equals(this.fromId, another.fromId) && this.peerId.equals(another.peerId) && Objects.equals(this.fwdFrom, another.fwdFrom) && Objects.equals(this.viaBotId, another.viaBotId) && Objects.equals(this.replyTo, another.replyTo) && this.date == another.date && this.message.equals(another.message) && Objects.equals(this.media, another.media) && Objects.equals(this.replyMarkup, another.replyMarkup) && Objects.equals(this.entities, another.entities) && Objects.equals(this.views, another.views) && Objects.equals(this.forwards, another.forwards) && Objects.equals(this.replies, another.replies) && Objects.equals(this.editDate, another.editDate) && Objects.equals(this.postAuthor, another.postAuthor) && Objects.equals(this.groupedId, another.groupedId) && Objects.equals(this.reactions, another.reactions) && Objects.equals(this.restrictionReason, another.restrictionReason) && Objects.equals(this.ttlPeriod, another.ttlPeriod);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.out);
        h += (h << 5) + Boolean.hashCode(this.mentioned);
        h += (h << 5) + Boolean.hashCode(this.mediaUnread);
        h += (h << 5) + Boolean.hashCode(this.silent);
        h += (h << 5) + Boolean.hashCode(this.post);
        h += (h << 5) + Boolean.hashCode(this.fromScheduled);
        h += (h << 5) + Boolean.hashCode(this.legacy);
        h += (h << 5) + Boolean.hashCode(this.editHide);
        h += (h << 5) + Boolean.hashCode(this.pinned);
        h += (h << 5) + Boolean.hashCode(this.noforwards);
        h += (h << 5) + this.id;
        h += (h << 5) + Objects.hashCode(this.fromId);
        h += (h << 5) + this.peerId.hashCode();
        h += (h << 5) + Objects.hashCode(this.fwdFrom);
        h += (h << 5) + Objects.hashCode(this.viaBotId);
        h += (h << 5) + Objects.hashCode(this.replyTo);
        h += (h << 5) + this.date;
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + Objects.hashCode(this.media);
        h += (h << 5) + Objects.hashCode(this.replyMarkup);
        h += (h << 5) + Objects.hashCode(this.entities);
        h += (h << 5) + Objects.hashCode(this.views);
        h += (h << 5) + Objects.hashCode(this.forwards);
        h += (h << 5) + Objects.hashCode(this.replies);
        h += (h << 5) + Objects.hashCode(this.editDate);
        h += (h << 5) + Objects.hashCode(this.postAuthor);
        h += (h << 5) + Objects.hashCode(this.groupedId);
        h += (h << 5) + Objects.hashCode(this.reactions);
        h += (h << 5) + Objects.hashCode(this.restrictionReason);
        h += (h << 5) + Objects.hashCode(this.ttlPeriod);
        return h;
    }

    public String toString() {
        return "BaseMessage{identifier=" + this.identifier + ", flags=" + this.flags + ", out=" + this.out + ", mentioned=" + this.mentioned + ", mediaUnread=" + this.mediaUnread + ", silent=" + this.silent + ", post=" + this.post + ", fromScheduled=" + this.fromScheduled + ", legacy=" + this.legacy + ", editHide=" + this.editHide + ", pinned=" + this.pinned + ", noforwards=" + this.noforwards + ", id=" + this.id + ", fromId=" + this.fromId + ", peerId=" + this.peerId + ", fwdFrom=" + this.fwdFrom + ", viaBotId=" + this.viaBotId + ", replyTo=" + this.replyTo + ", date=" + this.date + ", message=" + this.message + ", media=" + this.media + ", replyMarkup=" + this.replyMarkup + ", entities=" + this.entities + ", views=" + this.views + ", forwards=" + this.forwards + ", replies=" + this.replies + ", editDate=" + this.editDate + ", postAuthor=" + this.postAuthor + ", groupedId=" + this.groupedId + ", reactions=" + this.reactions + ", restrictionReason=" + this.restrictionReason + ", ttlPeriod=" + this.ttlPeriod + "}";
    }

    public static ImmutableBaseMessage of(int id, Peer peerId, int date, String message) {
        return new ImmutableBaseMessage(id, peerId, date, message);
    }

    public static ImmutableBaseMessage copyOf(BaseMessage instance) {
        if (instance instanceof ImmutableBaseMessage) {
            return (ImmutableBaseMessage)instance;
        }
        return ImmutableBaseMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_PEER_ID = 2L;
        private static final long INIT_BIT_DATE = 4L;
        private static final long INIT_BIT_MESSAGE = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_OUT = 4L;
        private static final long OPT_BIT_MENTIONED = 8L;
        private static final long OPT_BIT_MEDIA_UNREAD = 16L;
        private static final long OPT_BIT_SILENT = 32L;
        private static final long OPT_BIT_POST = 64L;
        private static final long OPT_BIT_FROM_SCHEDULED = 128L;
        private static final long OPT_BIT_LEGACY = 256L;
        private static final long OPT_BIT_EDIT_HIDE = 512L;
        private static final long OPT_BIT_PINNED = 1024L;
        private static final long OPT_BIT_NOFORWARDS = 2048L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean out;
        private boolean mentioned;
        private boolean mediaUnread;
        private boolean silent;
        private boolean post;
        private boolean fromScheduled;
        private boolean legacy;
        private boolean editHide;
        private boolean pinned;
        private boolean noforwards;
        private int id;
        private Peer fromId;
        private Peer peerId;
        private MessageFwdHeader fwdFrom;
        private Long viaBotId;
        private MessageReplyHeader replyTo;
        private int date;
        private String message;
        private MessageMedia media;
        private ReplyMarkup replyMarkup;
        private List<MessageEntity> entities = null;
        private Integer views;
        private Integer forwards;
        private MessageReplies replies;
        private Integer editDate;
        private String postAuthor;
        private Long groupedId;
        private MessageReactions reactions;
        private List<RestrictionReason> restrictionReason = null;
        private Integer ttlPeriod;

        private Builder() {
        }

        public final Builder from(Message instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseMessageFields instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Message instance;
            long bits = 0L;
            if (object instanceof Message) {
                instance = (Message)object;
                if ((bits & 8L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 8L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 0x400L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.id(instance.id());
                    bits |= 0x100L;
                }
            }
            if (object instanceof BaseMessage) {
                MessageReactions reactionsValue;
                Long groupedIdValue;
                ReplyMarkup replyMarkupValue;
                List<MessageEntity> entitiesValue;
                MessageReplies repliesValue;
                Integer editDateValue;
                Integer viewsValue;
                String postAuthorValue;
                List<RestrictionReason> restrictionReasonValue;
                MessageMedia mediaValue;
                Long viaBotIdValue;
                Integer forwardsValue;
                instance = (BaseMessage)object;
                if ((bits & 1L) == 0L) {
                    this.peerId(instance.peerId());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.date(instance.date());
                    bits |= 2L;
                }
                if ((forwardsValue = instance.forwards()) != null) {
                    this.forwards(forwardsValue);
                }
                if ((viaBotIdValue = instance.viaBotId()) != null) {
                    this.viaBotId(viaBotIdValue);
                }
                this.pinned(instance.pinned());
                if ((bits & 4L) == 0L) {
                    this.legacy(instance.legacy());
                    bits |= 4L;
                }
                this.noforwards(instance.noforwards());
                if ((bits & 8L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 8L;
                }
                if ((mediaValue = instance.media()) != null) {
                    this.media(mediaValue);
                }
                if ((restrictionReasonValue = instance.restrictionReason()) != null) {
                    this.addAllRestrictionReason(restrictionReasonValue);
                }
                if ((bits & 0x10L) == 0L) {
                    this.out(instance.out());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.mediaUnread(instance.mediaUnread());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    MessageFwdHeader fwdFromValue = instance.fwdFrom();
                    if (fwdFromValue != null) {
                        this.fwdFrom(fwdFromValue);
                    }
                    bits |= 0x40L;
                }
                if ((postAuthorValue = instance.postAuthor()) != null) {
                    this.postAuthor(postAuthorValue);
                }
                if ((bits & 0x80L) == 0L) {
                    this.post(instance.post());
                    bits |= 0x80L;
                }
                this.editHide(instance.editHide());
                if ((bits & 0x100L) == 0L) {
                    this.id(instance.id());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.mentioned(instance.mentioned());
                    bits |= 0x200L;
                }
                if ((viewsValue = instance.views()) != null) {
                    this.views(viewsValue);
                }
                if ((bits & 0x400L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.silent(instance.silent());
                    bits |= 0x800L;
                }
                this.message(instance.message());
                if ((bits & 0x1000L) == 0L) {
                    Peer fromIdValue = instance.fromId();
                    if (fromIdValue != null) {
                        this.fromId(fromIdValue);
                    }
                    bits |= 0x1000L;
                }
                if ((editDateValue = instance.editDate()) != null) {
                    this.editDate(editDateValue);
                }
                if ((repliesValue = instance.replies()) != null) {
                    this.replies(repliesValue);
                }
                if ((entitiesValue = instance.entities()) != null) {
                    this.addAllEntities(entitiesValue);
                }
                if ((replyMarkupValue = instance.replyMarkup()) != null) {
                    this.replyMarkup(replyMarkupValue);
                }
                if ((bits & 0x2000L) == 0L) {
                    MessageReplyHeader replyToValue = instance.replyTo();
                    if (replyToValue != null) {
                        this.replyTo(replyToValue);
                    }
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    Integer ttlPeriodValue = instance.ttlPeriod();
                    if (ttlPeriodValue != null) {
                        this.ttlPeriod(ttlPeriodValue);
                    }
                    bits |= 0x4000L;
                }
                if ((groupedIdValue = instance.groupedId()) != null) {
                    this.groupedId(groupedIdValue);
                }
                if ((reactionsValue = instance.reactions()) != null) {
                    this.reactions(reactionsValue);
                }
                this.fromScheduled(instance.fromScheduled());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 0x400L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 0x400L;
                }
            }
            if (object instanceof BaseMessageFields) {
                instance = (BaseMessageFields)object;
                if ((bits & 1L) == 0L) {
                    this.peerId(instance.peerId());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.date(instance.date());
                    bits |= 2L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.silent(instance.silent());
                    bits |= 0x800L;
                }
                if ((bits & 4L) == 0L) {
                    this.legacy(instance.legacy());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 8L;
                }
                if ((bits & 0x1000L) == 0L) {
                    Peer fromIdValue = instance.fromId();
                    if (fromIdValue != null) {
                        this.fromId(fromIdValue);
                    }
                    bits |= 0x1000L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.out(instance.out());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.mediaUnread(instance.mediaUnread());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    MessageFwdHeader fwdFromValue = instance.fwdFrom();
                    if (fwdFromValue != null) {
                        this.fwdFrom(fwdFromValue);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.post(instance.post());
                    bits |= 0x80L;
                }
                if ((bits & 0x2000L) == 0L) {
                    MessageReplyHeader replyToValue = instance.replyTo();
                    if (replyToValue != null) {
                        this.replyTo(replyToValue);
                    }
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    Integer ttlPeriodValue = instance.ttlPeriod();
                    if (ttlPeriodValue != null) {
                        this.ttlPeriod(ttlPeriodValue);
                    }
                    bits |= 0x4000L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.id(instance.id());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.mentioned(instance.mentioned());
                    bits |= 0x200L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder out(boolean out) {
            this.out = out;
            this.optBits |= 4L;
            return this;
        }

        public final Builder mentioned(boolean mentioned) {
            this.mentioned = mentioned;
            this.optBits |= 8L;
            return this;
        }

        public final Builder mediaUnread(boolean mediaUnread) {
            this.mediaUnread = mediaUnread;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder silent(boolean silent) {
            this.silent = silent;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder post(boolean post) {
            this.post = post;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder fromScheduled(boolean fromScheduled) {
            this.fromScheduled = fromScheduled;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder legacy(boolean legacy) {
            this.legacy = legacy;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder editHide(boolean editHide) {
            this.editHide = editHide;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder pinned(boolean pinned) {
            this.pinned = pinned;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder noforwards(boolean noforwards) {
            this.noforwards = noforwards;
            this.optBits |= 0x800L;
            return this;
        }

        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder fromId(@Nullable Peer fromId) {
            this.fromId = fromId;
            return this;
        }

        public final Builder peerId(Peer peerId) {
            this.peerId = Objects.requireNonNull(peerId, "peerId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder fwdFrom(@Nullable MessageFwdHeader fwdFrom) {
            this.fwdFrom = fwdFrom;
            return this;
        }

        public final Builder viaBotId(@Nullable Long viaBotId) {
            this.viaBotId = viaBotId;
            return this;
        }

        public final Builder replyTo(@Nullable MessageReplyHeader replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder media(@Nullable MessageMedia media) {
            this.media = media;
            return this;
        }

        public final Builder replyMarkup(@Nullable ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public final Builder addEntity(MessageEntity element) {
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            this.entities.add(Objects.requireNonNull(element, "entities element"));
            return this;
        }

        public final Builder addEntities(MessageEntity ... elements) {
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity element : elements) {
                this.entities.add(Objects.requireNonNull(element, "entities element"));
            }
            return this;
        }

        public final Builder entities(@Nullable Iterable<? extends MessageEntity> elements) {
            if (elements == null) {
                this.entities = null;
                return this;
            }
            this.entities = new ArrayList<MessageEntity>();
            return this.addAllEntities(elements);
        }

        public final Builder addAllEntities(Iterable<? extends MessageEntity> elements) {
            Objects.requireNonNull(elements, "entities element");
            if (this.entities == null) {
                this.entities = new ArrayList<MessageEntity>();
            }
            for (MessageEntity messageEntity : elements) {
                this.entities.add(Objects.requireNonNull(messageEntity, "entities element"));
            }
            return this;
        }

        public final Builder views(@Nullable Integer views) {
            this.views = views;
            return this;
        }

        public final Builder forwards(@Nullable Integer forwards) {
            this.forwards = forwards;
            return this;
        }

        public final Builder replies(@Nullable MessageReplies replies) {
            this.replies = replies;
            return this;
        }

        public final Builder editDate(@Nullable Integer editDate) {
            this.editDate = editDate;
            return this;
        }

        public final Builder postAuthor(@Nullable String postAuthor) {
            this.postAuthor = postAuthor;
            return this;
        }

        public final Builder groupedId(@Nullable Long groupedId) {
            this.groupedId = groupedId;
            return this;
        }

        public final Builder reactions(@Nullable MessageReactions reactions) {
            this.reactions = reactions;
            return this;
        }

        public final Builder addRestrictionReason(RestrictionReason element) {
            if (this.restrictionReason == null) {
                this.restrictionReason = new ArrayList<RestrictionReason>();
            }
            this.restrictionReason.add(Objects.requireNonNull(element, "restrictionReason element"));
            return this;
        }

        public final Builder addRestrictionReason(RestrictionReason ... elements) {
            if (this.restrictionReason == null) {
                this.restrictionReason = new ArrayList<RestrictionReason>();
            }
            for (RestrictionReason element : elements) {
                this.restrictionReason.add(Objects.requireNonNull(element, "restrictionReason element"));
            }
            return this;
        }

        public final Builder restrictionReason(@Nullable Iterable<? extends RestrictionReason> elements) {
            if (elements == null) {
                this.restrictionReason = null;
                return this;
            }
            this.restrictionReason = new ArrayList<RestrictionReason>();
            return this.addAllRestrictionReason(elements);
        }

        public final Builder addAllRestrictionReason(Iterable<? extends RestrictionReason> elements) {
            Objects.requireNonNull(elements, "restrictionReason element");
            if (this.restrictionReason == null) {
                this.restrictionReason = new ArrayList<RestrictionReason>();
            }
            for (RestrictionReason restrictionReason : elements) {
                this.restrictionReason.add(Objects.requireNonNull(restrictionReason, "restrictionReason element"));
            }
            return this;
        }

        public final Builder ttlPeriod(@Nullable Integer ttlPeriod) {
            this.ttlPeriod = ttlPeriod;
            return this;
        }

        public ImmutableBaseMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseMessage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean outIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean mentionedIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean mediaUnreadIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean silentIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean postIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean fromScheduledIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean legacyIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean editHideIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean pinnedIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean noforwardsIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("peerId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build BaseMessage, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte outBuildStage = 0;
        private boolean out;
        private byte mentionedBuildStage = 0;
        private boolean mentioned;
        private byte mediaUnreadBuildStage = 0;
        private boolean mediaUnread;
        private byte silentBuildStage = 0;
        private boolean silent;
        private byte postBuildStage = 0;
        private boolean post;
        private byte fromScheduledBuildStage = 0;
        private boolean fromScheduled;
        private byte legacyBuildStage = 0;
        private boolean legacy;
        private byte editHideBuildStage = 0;
        private boolean editHide;
        private byte pinnedBuildStage = 0;
        private boolean pinned;
        private byte noforwardsBuildStage = 0;
        private boolean noforwards;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseMessage.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBaseMessage.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean out() {
            if (this.outBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.outBuildStage == 0) {
                this.outBuildStage = (byte)-1;
                this.out = ImmutableBaseMessage.this.outInitialize();
                this.outBuildStage = 1;
            }
            return this.out;
        }

        void out(boolean out) {
            this.out = out;
            this.outBuildStage = 1;
        }

        boolean mentioned() {
            if (this.mentionedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.mentionedBuildStage == 0) {
                this.mentionedBuildStage = (byte)-1;
                this.mentioned = ImmutableBaseMessage.this.mentionedInitialize();
                this.mentionedBuildStage = 1;
            }
            return this.mentioned;
        }

        void mentioned(boolean mentioned) {
            this.mentioned = mentioned;
            this.mentionedBuildStage = 1;
        }

        boolean mediaUnread() {
            if (this.mediaUnreadBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.mediaUnreadBuildStage == 0) {
                this.mediaUnreadBuildStage = (byte)-1;
                this.mediaUnread = ImmutableBaseMessage.this.mediaUnreadInitialize();
                this.mediaUnreadBuildStage = 1;
            }
            return this.mediaUnread;
        }

        void mediaUnread(boolean mediaUnread) {
            this.mediaUnread = mediaUnread;
            this.mediaUnreadBuildStage = 1;
        }

        boolean silent() {
            if (this.silentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.silentBuildStage == 0) {
                this.silentBuildStage = (byte)-1;
                this.silent = ImmutableBaseMessage.this.silentInitialize();
                this.silentBuildStage = 1;
            }
            return this.silent;
        }

        void silent(boolean silent) {
            this.silent = silent;
            this.silentBuildStage = 1;
        }

        boolean post() {
            if (this.postBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.postBuildStage == 0) {
                this.postBuildStage = (byte)-1;
                this.post = ImmutableBaseMessage.this.postInitialize();
                this.postBuildStage = 1;
            }
            return this.post;
        }

        void post(boolean post) {
            this.post = post;
            this.postBuildStage = 1;
        }

        boolean fromScheduled() {
            if (this.fromScheduledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fromScheduledBuildStage == 0) {
                this.fromScheduledBuildStage = (byte)-1;
                this.fromScheduled = ImmutableBaseMessage.this.fromScheduledInitialize();
                this.fromScheduledBuildStage = 1;
            }
            return this.fromScheduled;
        }

        void fromScheduled(boolean fromScheduled) {
            this.fromScheduled = fromScheduled;
            this.fromScheduledBuildStage = 1;
        }

        boolean legacy() {
            if (this.legacyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.legacyBuildStage == 0) {
                this.legacyBuildStage = (byte)-1;
                this.legacy = ImmutableBaseMessage.this.legacyInitialize();
                this.legacyBuildStage = 1;
            }
            return this.legacy;
        }

        void legacy(boolean legacy) {
            this.legacy = legacy;
            this.legacyBuildStage = 1;
        }

        boolean editHide() {
            if (this.editHideBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.editHideBuildStage == 0) {
                this.editHideBuildStage = (byte)-1;
                this.editHide = ImmutableBaseMessage.this.editHideInitialize();
                this.editHideBuildStage = 1;
            }
            return this.editHide;
        }

        void editHide(boolean editHide) {
            this.editHide = editHide;
            this.editHideBuildStage = 1;
        }

        boolean pinned() {
            if (this.pinnedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pinnedBuildStage == 0) {
                this.pinnedBuildStage = (byte)-1;
                this.pinned = ImmutableBaseMessage.this.pinnedInitialize();
                this.pinnedBuildStage = 1;
            }
            return this.pinned;
        }

        void pinned(boolean pinned) {
            this.pinned = pinned;
            this.pinnedBuildStage = 1;
        }

        boolean noforwards() {
            if (this.noforwardsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.noforwardsBuildStage == 0) {
                this.noforwardsBuildStage = (byte)-1;
                this.noforwards = ImmutableBaseMessage.this.noforwardsInitialize();
                this.noforwardsBuildStage = 1;
            }
            return this.noforwards;
        }

        void noforwards(boolean noforwards) {
            this.noforwards = noforwards;
            this.noforwardsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.outBuildStage == -1) {
                attributes.add("out");
            }
            if (this.mentionedBuildStage == -1) {
                attributes.add("mentioned");
            }
            if (this.mediaUnreadBuildStage == -1) {
                attributes.add("mediaUnread");
            }
            if (this.silentBuildStage == -1) {
                attributes.add("silent");
            }
            if (this.postBuildStage == -1) {
                attributes.add("post");
            }
            if (this.fromScheduledBuildStage == -1) {
                attributes.add("fromScheduled");
            }
            if (this.legacyBuildStage == -1) {
                attributes.add("legacy");
            }
            if (this.editHideBuildStage == -1) {
                attributes.add("editHide");
            }
            if (this.pinnedBuildStage == -1) {
                attributes.add("pinned");
            }
            if (this.noforwardsBuildStage == -1) {
                attributes.add("noforwards");
            }
            return "Cannot build BaseMessage, attribute initializers form cycle " + attributes;
        }
    }
}

