/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BaseMessageUserVote;
import telegram4j.tl.MessageUserVote;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseMessageUserVote
implements BaseMessageUserVote {
    private final int identifier;
    private final long userId;
    private final ByteBuf option;
    private final int date;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseMessageUserVote(long userId, int date) {
        this.userId = userId;
        this.date = date;
        this.option = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableBaseMessageUserVote(Builder builder) {
        this.userId = builder.userId;
        this.option = builder.option_build();
        this.date = builder.date;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableBaseMessageUserVote(int identifier, long userId, ByteBuf option, int date) {
        this.identifier = identifier;
        this.userId = userId;
        this.option = option;
        this.date = date;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseMessageUserVote.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public ByteBuf option() {
        return this.option.duplicate();
    }

    @Override
    public int date() {
        return this.date;
    }

    public final ImmutableBaseMessageUserVote withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseMessageUserVote(value, this.userId, this.option, this.date);
    }

    public final ImmutableBaseMessageUserVote withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableBaseMessageUserVote(this.identifier, value, this.option, this.date);
    }

    public ImmutableBaseMessageUserVote withOption(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.option == newValue) {
            return this;
        }
        return new ImmutableBaseMessageUserVote(this.identifier, this.userId, newValue, this.date);
    }

    public final ImmutableBaseMessageUserVote withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableBaseMessageUserVote(this.identifier, this.userId, this.option, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseMessageUserVote && this.equalTo(0, (ImmutableBaseMessageUserVote)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseMessageUserVote another) {
        return this.identifier == another.identifier && this.userId == another.userId && this.option().equals((Object)another.option()) && this.date == another.date;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + this.option().hashCode();
        h += (h << 5) + this.date;
        return h;
    }

    public String toString() {
        return "BaseMessageUserVote{identifier=" + this.identifier + ", userId=" + this.userId + ", option=" + ByteBufUtil.hexDump((ByteBuf)this.option) + ", date=" + this.date + "}";
    }

    public static ImmutableBaseMessageUserVote of(long userId, int date) {
        return new ImmutableBaseMessageUserVote(userId, date);
    }

    public static ImmutableBaseMessageUserVote copyOf(BaseMessageUserVote instance) {
        if (instance instanceof ImmutableBaseMessageUserVote) {
            return (ImmutableBaseMessageUserVote)instance;
        }
        return ImmutableBaseMessageUserVote.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_DATE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private ByteBuf option_value = null;
        private int identifier;
        private long userId;
        private int date;

        private Builder() {
        }

        public final Builder from(MessageUserVote instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseMessageUserVote instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MessageUserVote instance;
            long bits = 0L;
            if (object instanceof MessageUserVote) {
                instance = (MessageUserVote)object;
                if ((bits & 1L) == 0L) {
                    this.date(instance.date());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.userId(instance.userId());
                    bits |= 4L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
            }
            if (object instanceof BaseMessageUserVote) {
                instance = (BaseMessageUserVote)object;
                if ((bits & 1L) == 0L) {
                    this.date(instance.date());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.userId(instance.userId());
                    bits |= 4L;
                }
                this.option(instance.option());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder option(ByteBuf value) {
            this.option_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBaseMessageUserVote build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseMessageUserVote(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("date");
            }
            return "Cannot build BaseMessageUserVote, some of required attributes are not set " + attributes;
        }

        private ByteBuf option_build() {
            return Objects.requireNonNull(this.option_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseMessageUserVote.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build BaseMessageUserVote, attribute initializers form cycle " + attributes;
        }
    }
}

