/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BasePeerLocated;
import telegram4j.tl.Peer;
import telegram4j.tl.PeerLocated;
import telegram4j.tl.api.TlObject;

public final class ImmutableBasePeerLocated
implements BasePeerLocated {
    private final int identifier;
    private final Peer peer;
    private final int expires;
    private final int distance;

    private ImmutableBasePeerLocated(Peer peer, int expires, int distance) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.expires = expires;
        this.distance = distance;
        this.identifier = BasePeerLocated.super.identifier();
    }

    private ImmutableBasePeerLocated(Builder builder) {
        this.peer = builder.peer;
        this.expires = builder.expires;
        this.distance = builder.distance;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BasePeerLocated.super.identifier();
    }

    private ImmutableBasePeerLocated(int identifier, Peer peer, int expires, int distance) {
        this.identifier = identifier;
        this.peer = peer;
        this.expires = expires;
        this.distance = distance;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Peer peer() {
        return this.peer;
    }

    @Override
    public int expires() {
        return this.expires;
    }

    @Override
    public int distance() {
        return this.distance;
    }

    public final ImmutableBasePeerLocated withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBasePeerLocated(value, this.peer, this.expires, this.distance);
    }

    public final ImmutableBasePeerLocated withPeer(Peer value) {
        if (this.peer == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableBasePeerLocated(this.identifier, newValue, this.expires, this.distance);
    }

    public final ImmutableBasePeerLocated withExpires(int value) {
        if (this.expires == value) {
            return this;
        }
        return new ImmutableBasePeerLocated(this.identifier, this.peer, value, this.distance);
    }

    public final ImmutableBasePeerLocated withDistance(int value) {
        if (this.distance == value) {
            return this;
        }
        return new ImmutableBasePeerLocated(this.identifier, this.peer, this.expires, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBasePeerLocated && this.equalTo(0, (ImmutableBasePeerLocated)another);
    }

    private boolean equalTo(int synthetic, ImmutableBasePeerLocated another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.expires == another.expires && this.distance == another.distance;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.expires;
        h += (h << 5) + this.distance;
        return h;
    }

    public String toString() {
        return "BasePeerLocated{identifier=" + this.identifier + ", peer=" + this.peer + ", expires=" + this.expires + ", distance=" + this.distance + "}";
    }

    public static ImmutableBasePeerLocated of(Peer peer, int expires, int distance) {
        return new ImmutableBasePeerLocated(peer, expires, distance);
    }

    public static ImmutableBasePeerLocated copyOf(BasePeerLocated instance) {
        if (instance instanceof ImmutableBasePeerLocated) {
            return (ImmutableBasePeerLocated)instance;
        }
        return ImmutableBasePeerLocated.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_EXPIRES = 2L;
        private static final long INIT_BIT_DISTANCE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private Peer peer;
        private int expires;
        private int distance;

        private Builder() {
        }

        public final Builder from(PeerLocated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BasePeerLocated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PeerLocated instance;
            long bits = 0L;
            if (object instanceof PeerLocated) {
                instance = (PeerLocated)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.expires(instance.expires());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BasePeerLocated) {
                instance = (BasePeerLocated)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.expires(instance.expires());
                    bits |= 2L;
                }
                this.distance(instance.distance());
                this.peer(instance.peer());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(Peer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder expires(int expires) {
            this.expires = expires;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder distance(int distance) {
            this.distance = distance;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableBasePeerLocated build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBasePeerLocated(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("expires");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("distance");
            }
            return "Cannot build BasePeerLocated, some of required attributes are not set " + attributes;
        }
    }
}

