/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.BasePhoneCall;
import telegram4j.tl.PhoneCall;
import telegram4j.tl.PhoneCallProtocol;
import telegram4j.tl.PhoneConnection;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableBasePhoneCall
implements BasePhoneCall {
    private final int identifier;
    private final int flags;
    private final boolean p2pAllowed;
    private final boolean video;
    private final long id;
    private final long accessHash;
    private final int date;
    private final long adminId;
    private final long participantId;
    private final ByteBuf gAOrB;
    private final long keyFingerprint;
    private final PhoneCallProtocol protocol;
    private final List<PhoneConnection> connections;
    private final int startDate;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBasePhoneCall(long id, long accessHash, int date, long adminId, long participantId, long keyFingerprint, PhoneCallProtocol protocol, int startDate) {
        this.id = id;
        this.accessHash = accessHash;
        this.date = date;
        this.adminId = adminId;
        this.participantId = participantId;
        this.keyFingerprint = keyFingerprint;
        this.protocol = Objects.requireNonNull(protocol, "protocol");
        this.startDate = startDate;
        this.gAOrB = null;
        this.connections = Collections.emptyList();
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.p2pAllowed = this.initShim.p2pAllowed();
        this.video = this.initShim.video();
        this.initShim = null;
    }

    private ImmutableBasePhoneCall(Builder builder) {
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.date = builder.date;
        this.adminId = builder.adminId;
        this.participantId = builder.participantId;
        this.gAOrB = builder.gAOrB_build();
        this.keyFingerprint = builder.keyFingerprint;
        this.protocol = builder.protocol;
        this.connections = ImmutableBasePhoneCall.createUnmodifiableList(true, builder.connections);
        this.startDate = builder.startDate;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.p2pAllowedIsSet()) {
            this.initShim.p2pAllowed(builder.p2pAllowed);
        }
        if (builder.videoIsSet()) {
            this.initShim.video(builder.video);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.p2pAllowed = this.initShim.p2pAllowed();
        this.video = this.initShim.video();
        this.initShim = null;
    }

    private ImmutableBasePhoneCall(int identifier, int flags, boolean p2pAllowed, boolean video, long id, long accessHash, int date, long adminId, long participantId, ByteBuf gAOrB, long keyFingerprint, PhoneCallProtocol protocol, List<PhoneConnection> connections, int startDate) {
        this.identifier = identifier;
        this.flags = flags;
        this.p2pAllowed = p2pAllowed;
        this.video = video;
        this.id = id;
        this.accessHash = accessHash;
        this.date = date;
        this.adminId = adminId;
        this.participantId = participantId;
        this.gAOrB = gAOrB;
        this.keyFingerprint = keyFingerprint;
        this.protocol = protocol;
        this.connections = connections;
        this.startDate = startDate;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BasePhoneCall.super.identifier();
    }

    private int flagsInitialize() {
        return BasePhoneCall.super.flags();
    }

    private boolean p2pAllowedInitialize() {
        return BasePhoneCall.super.p2pAllowed();
    }

    private boolean videoInitialize() {
        return BasePhoneCall.super.video();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean p2pAllowed() {
        InitShim shim = this.initShim;
        return shim != null ? shim.p2pAllowed() : this.p2pAllowed;
    }

    @Override
    public boolean video() {
        InitShim shim = this.initShim;
        return shim != null ? shim.video() : this.video;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public long adminId() {
        return this.adminId;
    }

    @Override
    public long participantId() {
        return this.participantId;
    }

    @Override
    public ByteBuf gAOrB() {
        return this.gAOrB.duplicate();
    }

    @Override
    public long keyFingerprint() {
        return this.keyFingerprint;
    }

    @Override
    public PhoneCallProtocol protocol() {
        return this.protocol;
    }

    @Override
    public List<PhoneConnection> connections() {
        return this.connections;
    }

    @Override
    public int startDate() {
        return this.startDate;
    }

    public final ImmutableBasePhoneCall withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBasePhoneCall(value, this.flags, this.p2pAllowed, this.video, this.id, this.accessHash, this.date, this.adminId, this.participantId, this.gAOrB, this.keyFingerprint, this.protocol, this.connections, this.startDate);
    }

    public final ImmutableBasePhoneCall withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBasePhoneCall(this.identifier, value, this.p2pAllowed, this.video, this.id, this.accessHash, this.date, this.adminId, this.participantId, this.gAOrB, this.keyFingerprint, this.protocol, this.connections, this.startDate);
    }

    public final ImmutableBasePhoneCall withP2pAllowed(boolean value) {
        if (this.p2pAllowed == value) {
            return this;
        }
        return new ImmutableBasePhoneCall(this.identifier, this.flags, value, this.video, this.id, this.accessHash, this.date, this.adminId, this.participantId, this.gAOrB, this.keyFingerprint, this.protocol, this.connections, this.startDate);
    }

    public final ImmutableBasePhoneCall withVideo(boolean value) {
        if (this.video == value) {
            return this;
        }
        return new ImmutableBasePhoneCall(this.identifier, this.flags, this.p2pAllowed, value, this.id, this.accessHash, this.date, this.adminId, this.participantId, this.gAOrB, this.keyFingerprint, this.protocol, this.connections, this.startDate);
    }

    public final ImmutableBasePhoneCall withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableBasePhoneCall(this.identifier, this.flags, this.p2pAllowed, this.video, value, this.accessHash, this.date, this.adminId, this.participantId, this.gAOrB, this.keyFingerprint, this.protocol, this.connections, this.startDate);
    }

    public final ImmutableBasePhoneCall withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableBasePhoneCall(this.identifier, this.flags, this.p2pAllowed, this.video, this.id, value, this.date, this.adminId, this.participantId, this.gAOrB, this.keyFingerprint, this.protocol, this.connections, this.startDate);
    }

    public final ImmutableBasePhoneCall withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableBasePhoneCall(this.identifier, this.flags, this.p2pAllowed, this.video, this.id, this.accessHash, value, this.adminId, this.participantId, this.gAOrB, this.keyFingerprint, this.protocol, this.connections, this.startDate);
    }

    public final ImmutableBasePhoneCall withAdminId(long value) {
        if (this.adminId == value) {
            return this;
        }
        return new ImmutableBasePhoneCall(this.identifier, this.flags, this.p2pAllowed, this.video, this.id, this.accessHash, this.date, value, this.participantId, this.gAOrB, this.keyFingerprint, this.protocol, this.connections, this.startDate);
    }

    public final ImmutableBasePhoneCall withParticipantId(long value) {
        if (this.participantId == value) {
            return this;
        }
        return new ImmutableBasePhoneCall(this.identifier, this.flags, this.p2pAllowed, this.video, this.id, this.accessHash, this.date, this.adminId, value, this.gAOrB, this.keyFingerprint, this.protocol, this.connections, this.startDate);
    }

    public ImmutableBasePhoneCall withGAOrB(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.gAOrB == newValue) {
            return this;
        }
        return new ImmutableBasePhoneCall(this.identifier, this.flags, this.p2pAllowed, this.video, this.id, this.accessHash, this.date, this.adminId, this.participantId, newValue, this.keyFingerprint, this.protocol, this.connections, this.startDate);
    }

    public final ImmutableBasePhoneCall withKeyFingerprint(long value) {
        if (this.keyFingerprint == value) {
            return this;
        }
        return new ImmutableBasePhoneCall(this.identifier, this.flags, this.p2pAllowed, this.video, this.id, this.accessHash, this.date, this.adminId, this.participantId, this.gAOrB, value, this.protocol, this.connections, this.startDate);
    }

    public final ImmutableBasePhoneCall withProtocol(PhoneCallProtocol value) {
        if (this.protocol == value) {
            return this;
        }
        PhoneCallProtocol newValue = Objects.requireNonNull(value, "protocol");
        return new ImmutableBasePhoneCall(this.identifier, this.flags, this.p2pAllowed, this.video, this.id, this.accessHash, this.date, this.adminId, this.participantId, this.gAOrB, this.keyFingerprint, newValue, this.connections, this.startDate);
    }

    public final ImmutableBasePhoneCall withConnections(PhoneConnection ... elements) {
        List<PhoneConnection> newValue = ImmutableBasePhoneCall.createUnmodifiableList(false, ImmutableBasePhoneCall.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBasePhoneCall(this.identifier, this.flags, this.p2pAllowed, this.video, this.id, this.accessHash, this.date, this.adminId, this.participantId, this.gAOrB, this.keyFingerprint, this.protocol, newValue, this.startDate);
    }

    public final ImmutableBasePhoneCall withConnections(Iterable<? extends PhoneConnection> elements) {
        if (this.connections == elements) {
            return this;
        }
        List<PhoneConnection> newValue = ImmutableBasePhoneCall.createUnmodifiableList(false, ImmutableBasePhoneCall.createSafeList(elements, true, false));
        return new ImmutableBasePhoneCall(this.identifier, this.flags, this.p2pAllowed, this.video, this.id, this.accessHash, this.date, this.adminId, this.participantId, this.gAOrB, this.keyFingerprint, this.protocol, newValue, this.startDate);
    }

    public final ImmutableBasePhoneCall withStartDate(int value) {
        if (this.startDate == value) {
            return this;
        }
        return new ImmutableBasePhoneCall(this.identifier, this.flags, this.p2pAllowed, this.video, this.id, this.accessHash, this.date, this.adminId, this.participantId, this.gAOrB, this.keyFingerprint, this.protocol, this.connections, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBasePhoneCall && this.equalTo(0, (ImmutableBasePhoneCall)another);
    }

    private boolean equalTo(int synthetic, ImmutableBasePhoneCall another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.p2pAllowed == another.p2pAllowed && this.video == another.video && this.id == another.id && this.accessHash == another.accessHash && this.date == another.date && this.adminId == another.adminId && this.participantId == another.participantId && this.gAOrB().equals((Object)another.gAOrB()) && this.keyFingerprint == another.keyFingerprint && this.protocol.equals(another.protocol) && this.connections.equals(another.connections) && this.startDate == another.startDate;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.p2pAllowed);
        h += (h << 5) + Boolean.hashCode(this.video);
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + Long.hashCode(this.accessHash);
        h += (h << 5) + this.date;
        h += (h << 5) + Long.hashCode(this.adminId);
        h += (h << 5) + Long.hashCode(this.participantId);
        h += (h << 5) + this.gAOrB().hashCode();
        h += (h << 5) + Long.hashCode(this.keyFingerprint);
        h += (h << 5) + this.protocol.hashCode();
        h += (h << 5) + this.connections.hashCode();
        h += (h << 5) + this.startDate;
        return h;
    }

    public String toString() {
        return "BasePhoneCall{identifier=" + this.identifier + ", flags=" + this.flags + ", p2pAllowed=" + this.p2pAllowed + ", video=" + this.video + ", id=" + this.id + ", accessHash=" + this.accessHash + ", date=" + this.date + ", adminId=" + this.adminId + ", participantId=" + this.participantId + ", gAOrB=" + ByteBufUtil.hexDump((ByteBuf)this.gAOrB) + ", keyFingerprint=" + this.keyFingerprint + ", protocol=" + this.protocol + ", connections=" + this.connections + ", startDate=" + this.startDate + "}";
    }

    public static ImmutableBasePhoneCall of(long id, long accessHash, int date, long adminId, long participantId, long keyFingerprint, PhoneCallProtocol protocol, int startDate) {
        return new ImmutableBasePhoneCall(id, accessHash, date, adminId, participantId, keyFingerprint, protocol, startDate);
    }

    public static ImmutableBasePhoneCall copyOf(BasePhoneCall instance) {
        if (instance instanceof ImmutableBasePhoneCall) {
            return (ImmutableBasePhoneCall)instance;
        }
        return ImmutableBasePhoneCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long INIT_BIT_DATE = 4L;
        private static final long INIT_BIT_ADMIN_ID = 8L;
        private static final long INIT_BIT_PARTICIPANT_ID = 16L;
        private static final long INIT_BIT_KEY_FINGERPRINT = 32L;
        private static final long INIT_BIT_PROTOCOL = 64L;
        private static final long INIT_BIT_START_DATE = 128L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_P2P_ALLOWED = 4L;
        private static final long OPT_BIT_VIDEO = 8L;
        private long initBits = 255L;
        private long optBits;
        private ByteBuf gAOrB_value = null;
        private int identifier;
        private int flags;
        private boolean p2pAllowed;
        private boolean video;
        private long id;
        private long accessHash;
        private int date;
        private long adminId;
        private long participantId;
        private long keyFingerprint;
        private PhoneCallProtocol protocol;
        private List<PhoneConnection> connections = new ArrayList<PhoneConnection>();
        private int startDate;

        private Builder() {
        }

        public final Builder from(PhoneCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BasePhoneCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PhoneCall instance;
            long bits = 0L;
            if (object instanceof PhoneCall) {
                instance = (PhoneCall)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
            if (object instanceof BasePhoneCall) {
                instance = (BasePhoneCall)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.keyFingerprint(instance.keyFingerprint());
                this.flags(instance.flags());
                this.video(instance.video());
                this.gAOrB(instance.gAOrB());
                this.participantId(instance.participantId());
                this.protocol(instance.protocol());
                this.p2pAllowed(instance.p2pAllowed());
                this.adminId(instance.adminId());
                this.accessHash(instance.accessHash());
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
                this.addAllConnections(instance.connections());
                this.startDate(instance.startDate());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder p2pAllowed(boolean p2pAllowed) {
            this.p2pAllowed = p2pAllowed;
            this.optBits |= 4L;
            return this;
        }

        public final Builder video(boolean video) {
            this.video = video;
            this.optBits |= 8L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder adminId(long adminId) {
            this.adminId = adminId;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder participantId(long participantId) {
            this.participantId = participantId;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public Builder gAOrB(ByteBuf value) {
            this.gAOrB_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder keyFingerprint(long keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder protocol(PhoneCallProtocol protocol) {
            this.protocol = Objects.requireNonNull(protocol, "protocol");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder addConnection(PhoneConnection element) {
            this.connections.add(Objects.requireNonNull(element, "connections element"));
            return this;
        }

        public final Builder addConnections(PhoneConnection ... elements) {
            for (PhoneConnection element : elements) {
                this.connections.add(Objects.requireNonNull(element, "connections element"));
            }
            return this;
        }

        public final Builder connections(Iterable<? extends PhoneConnection> elements) {
            this.connections.clear();
            return this.addAllConnections(elements);
        }

        public final Builder addAllConnections(Iterable<? extends PhoneConnection> elements) {
            for (PhoneConnection phoneConnection : elements) {
                this.connections.add(Objects.requireNonNull(phoneConnection, "connections element"));
            }
            return this;
        }

        public final Builder startDate(int startDate) {
            this.startDate = startDate;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public ImmutableBasePhoneCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBasePhoneCall(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean p2pAllowedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean videoIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("adminId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("participantId");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("keyFingerprint");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("protocol");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("startDate");
            }
            return "Cannot build BasePhoneCall, some of required attributes are not set " + attributes;
        }

        private ByteBuf gAOrB_build() {
            return Objects.requireNonNull(this.gAOrB_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte p2pAllowedBuildStage = 0;
        private boolean p2pAllowed;
        private byte videoBuildStage = 0;
        private boolean video;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBasePhoneCall.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBasePhoneCall.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean p2pAllowed() {
            if (this.p2pAllowedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.p2pAllowedBuildStage == 0) {
                this.p2pAllowedBuildStage = (byte)-1;
                this.p2pAllowed = ImmutableBasePhoneCall.this.p2pAllowedInitialize();
                this.p2pAllowedBuildStage = 1;
            }
            return this.p2pAllowed;
        }

        void p2pAllowed(boolean p2pAllowed) {
            this.p2pAllowed = p2pAllowed;
            this.p2pAllowedBuildStage = 1;
        }

        boolean video() {
            if (this.videoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.videoBuildStage == 0) {
                this.videoBuildStage = (byte)-1;
                this.video = ImmutableBasePhoneCall.this.videoInitialize();
                this.videoBuildStage = 1;
            }
            return this.video;
        }

        void video(boolean video) {
            this.video = video;
            this.videoBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.p2pAllowedBuildStage == -1) {
                attributes.add("p2pAllowed");
            }
            if (this.videoBuildStage == -1) {
                attributes.add("video");
            }
            return "Cannot build BasePhoneCall, attribute initializers form cycle " + attributes;
        }
    }
}

