/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BasePhoneConnection;
import telegram4j.tl.PhoneConnection;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableBasePhoneConnection
implements BasePhoneConnection {
    private final int identifier;
    private final int flags;
    private final boolean tcp;
    private final long id;
    private final String ip;
    private final String ipv6;
    private final int port;
    private final ByteBuf peerTag;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBasePhoneConnection(long id, String ip, String ipv6, int port) {
        this.id = id;
        this.ip = Objects.requireNonNull(ip, "ip");
        this.ipv6 = Objects.requireNonNull(ipv6, "ipv6");
        this.port = port;
        this.peerTag = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.tcp = this.initShim.tcp();
        this.initShim = null;
    }

    private ImmutableBasePhoneConnection(Builder builder) {
        this.id = builder.id;
        this.ip = builder.ip;
        this.ipv6 = builder.ipv6;
        this.port = builder.port;
        this.peerTag = builder.peerTag_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.tcpIsSet()) {
            this.initShim.tcp(builder.tcp);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.tcp = this.initShim.tcp();
        this.initShim = null;
    }

    private ImmutableBasePhoneConnection(int identifier, int flags, boolean tcp, long id, String ip, String ipv6, int port, ByteBuf peerTag) {
        this.identifier = identifier;
        this.flags = flags;
        this.tcp = tcp;
        this.id = id;
        this.ip = ip;
        this.ipv6 = ipv6;
        this.port = port;
        this.peerTag = peerTag;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BasePhoneConnection.super.identifier();
    }

    private int flagsInitialize() {
        return BasePhoneConnection.super.flags();
    }

    private boolean tcpInitialize() {
        return BasePhoneConnection.super.tcp();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean tcp() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tcp() : this.tcp;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public String ip() {
        return this.ip;
    }

    @Override
    public String ipv6() {
        return this.ipv6;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public ByteBuf peerTag() {
        return this.peerTag.duplicate();
    }

    public final ImmutableBasePhoneConnection withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBasePhoneConnection(value, this.flags, this.tcp, this.id, this.ip, this.ipv6, this.port, this.peerTag);
    }

    public final ImmutableBasePhoneConnection withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBasePhoneConnection(this.identifier, value, this.tcp, this.id, this.ip, this.ipv6, this.port, this.peerTag);
    }

    public final ImmutableBasePhoneConnection withTcp(boolean value) {
        if (this.tcp == value) {
            return this;
        }
        return new ImmutableBasePhoneConnection(this.identifier, this.flags, value, this.id, this.ip, this.ipv6, this.port, this.peerTag);
    }

    public final ImmutableBasePhoneConnection withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableBasePhoneConnection(this.identifier, this.flags, this.tcp, value, this.ip, this.ipv6, this.port, this.peerTag);
    }

    public final ImmutableBasePhoneConnection withIp(String value) {
        String newValue = Objects.requireNonNull(value, "ip");
        if (this.ip.equals(newValue)) {
            return this;
        }
        return new ImmutableBasePhoneConnection(this.identifier, this.flags, this.tcp, this.id, newValue, this.ipv6, this.port, this.peerTag);
    }

    public final ImmutableBasePhoneConnection withIpv6(String value) {
        String newValue = Objects.requireNonNull(value, "ipv6");
        if (this.ipv6.equals(newValue)) {
            return this;
        }
        return new ImmutableBasePhoneConnection(this.identifier, this.flags, this.tcp, this.id, this.ip, newValue, this.port, this.peerTag);
    }

    public final ImmutableBasePhoneConnection withPort(int value) {
        if (this.port == value) {
            return this;
        }
        return new ImmutableBasePhoneConnection(this.identifier, this.flags, this.tcp, this.id, this.ip, this.ipv6, value, this.peerTag);
    }

    public ImmutableBasePhoneConnection withPeerTag(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.peerTag == newValue) {
            return this;
        }
        return new ImmutableBasePhoneConnection(this.identifier, this.flags, this.tcp, this.id, this.ip, this.ipv6, this.port, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBasePhoneConnection && this.equalTo(0, (ImmutableBasePhoneConnection)another);
    }

    private boolean equalTo(int synthetic, ImmutableBasePhoneConnection another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.tcp == another.tcp && this.id == another.id && this.ip.equals(another.ip) && this.ipv6.equals(another.ipv6) && this.port == another.port && this.peerTag().equals((Object)another.peerTag());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.tcp);
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + this.ip.hashCode();
        h += (h << 5) + this.ipv6.hashCode();
        h += (h << 5) + this.port;
        h += (h << 5) + this.peerTag().hashCode();
        return h;
    }

    public String toString() {
        return "BasePhoneConnection{identifier=" + this.identifier + ", flags=" + this.flags + ", tcp=" + this.tcp + ", id=" + this.id + ", ip=" + this.ip + ", ipv6=" + this.ipv6 + ", port=" + this.port + ", peerTag=" + ByteBufUtil.hexDump((ByteBuf)this.peerTag) + "}";
    }

    public static ImmutableBasePhoneConnection of(long id, String ip, String ipv6, int port) {
        return new ImmutableBasePhoneConnection(id, ip, ipv6, port);
    }

    public static ImmutableBasePhoneConnection copyOf(BasePhoneConnection instance) {
        if (instance instanceof ImmutableBasePhoneConnection) {
            return (ImmutableBasePhoneConnection)instance;
        }
        return ImmutableBasePhoneConnection.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_IP = 2L;
        private static final long INIT_BIT_IPV6 = 4L;
        private static final long INIT_BIT_PORT = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_TCP = 4L;
        private long initBits = 15L;
        private long optBits;
        private ByteBuf peerTag_value = null;
        private int identifier;
        private int flags;
        private boolean tcp;
        private long id;
        private String ip;
        private String ipv6;
        private int port;

        private Builder() {
        }

        public final Builder from(BasePhoneConnection instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PhoneConnection instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PhoneConnection instance;
            long bits = 0L;
            if (object instanceof BasePhoneConnection) {
                instance = (BasePhoneConnection)object;
                this.tcp(instance.tcp());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.port(instance.port());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.ipv6(instance.ipv6());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.ip(instance.ip());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.id(instance.id());
                    bits |= 0x20L;
                }
                this.peerTag(instance.peerTag());
            }
            if (object instanceof PhoneConnection) {
                instance = (PhoneConnection)object;
                if ((bits & 0x10L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.id(instance.id());
                    bits |= 0x20L;
                }
                if ((bits & 2L) == 0L) {
                    this.port(instance.port());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.ipv6(instance.ipv6());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.ip(instance.ip());
                    bits |= 8L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder tcp(boolean tcp) {
            this.tcp = tcp;
            this.optBits |= 4L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder ip(String ip) {
            this.ip = Objects.requireNonNull(ip, "ip");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder ipv6(String ipv6) {
            this.ipv6 = Objects.requireNonNull(ipv6, "ipv6");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder port(int port) {
            this.port = port;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public Builder peerTag(ByteBuf value) {
            this.peerTag_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableBasePhoneConnection build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBasePhoneConnection(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean tcpIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ip");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("ipv6");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("port");
            }
            return "Cannot build BasePhoneConnection, some of required attributes are not set " + attributes;
        }

        private ByteBuf peerTag_build() {
            return Objects.requireNonNull(this.peerTag_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte tcpBuildStage = 0;
        private boolean tcp;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBasePhoneConnection.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBasePhoneConnection.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean tcp() {
            if (this.tcpBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tcpBuildStage == 0) {
                this.tcpBuildStage = (byte)-1;
                this.tcp = ImmutableBasePhoneConnection.this.tcpInitialize();
                this.tcpBuildStage = 1;
            }
            return this.tcp;
        }

        void tcp(boolean tcp) {
            this.tcp = tcp;
            this.tcpBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.tcpBuildStage == -1) {
                attributes.add("tcp");
            }
            return "Cannot build BasePhoneConnection, attribute initializers form cycle " + attributes;
        }
    }
}

