/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BasePhoto;
import telegram4j.tl.Photo;
import telegram4j.tl.PhotoSize;
import telegram4j.tl.VideoSize;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableBasePhoto
implements BasePhoto {
    private final int identifier;
    private final int flags;
    private final boolean hasStickers;
    private final long id;
    private final long accessHash;
    private final ByteBuf fileReference;
    private final int date;
    private final List<PhotoSize> sizes;
    @Nullable
    private final List<VideoSize> videoSizes;
    private final int dcId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBasePhoto(long id, long accessHash, int date, int dcId) {
        this.id = id;
        this.accessHash = accessHash;
        this.date = date;
        this.dcId = dcId;
        this.fileReference = null;
        this.sizes = Collections.emptyList();
        this.videoSizes = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.hasStickers = this.initShim.hasStickers();
        this.initShim = null;
    }

    private ImmutableBasePhoto(Builder builder) {
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.fileReference = builder.fileReference_build();
        this.date = builder.date;
        this.sizes = ImmutableBasePhoto.createUnmodifiableList(true, builder.sizes);
        this.videoSizes = builder.videoSizes == null ? null : ImmutableBasePhoto.createUnmodifiableList(true, builder.videoSizes);
        this.dcId = builder.dcId;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.hasStickersIsSet()) {
            this.initShim.hasStickers(builder.hasStickers);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.hasStickers = this.initShim.hasStickers();
        this.initShim = null;
    }

    private ImmutableBasePhoto(int identifier, int flags, boolean hasStickers, long id, long accessHash, ByteBuf fileReference, int date, List<PhotoSize> sizes, @Nullable List<VideoSize> videoSizes, int dcId) {
        this.identifier = identifier;
        this.flags = flags;
        this.hasStickers = hasStickers;
        this.id = id;
        this.accessHash = accessHash;
        this.fileReference = fileReference;
        this.date = date;
        this.sizes = sizes;
        this.videoSizes = videoSizes;
        this.dcId = dcId;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BasePhoto.super.identifier();
    }

    private int flagsInitialize() {
        return BasePhoto.super.flags();
    }

    private boolean hasStickersInitialize() {
        return BasePhoto.super.hasStickers();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean hasStickers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasStickers() : this.hasStickers;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    @Override
    public ByteBuf fileReference() {
        return this.fileReference.duplicate();
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public List<PhotoSize> sizes() {
        return this.sizes;
    }

    @Override
    @Nullable
    public List<VideoSize> videoSizes() {
        return this.videoSizes;
    }

    @Override
    public int dcId() {
        return this.dcId;
    }

    public final ImmutableBasePhoto withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBasePhoto(value, this.flags, this.hasStickers, this.id, this.accessHash, this.fileReference, this.date, this.sizes, this.videoSizes, this.dcId);
    }

    public final ImmutableBasePhoto withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBasePhoto(this.identifier, value, this.hasStickers, this.id, this.accessHash, this.fileReference, this.date, this.sizes, this.videoSizes, this.dcId);
    }

    public final ImmutableBasePhoto withHasStickers(boolean value) {
        if (this.hasStickers == value) {
            return this;
        }
        return new ImmutableBasePhoto(this.identifier, this.flags, value, this.id, this.accessHash, this.fileReference, this.date, this.sizes, this.videoSizes, this.dcId);
    }

    public final ImmutableBasePhoto withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableBasePhoto(this.identifier, this.flags, this.hasStickers, value, this.accessHash, this.fileReference, this.date, this.sizes, this.videoSizes, this.dcId);
    }

    public final ImmutableBasePhoto withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableBasePhoto(this.identifier, this.flags, this.hasStickers, this.id, value, this.fileReference, this.date, this.sizes, this.videoSizes, this.dcId);
    }

    public ImmutableBasePhoto withFileReference(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.fileReference == newValue) {
            return this;
        }
        return new ImmutableBasePhoto(this.identifier, this.flags, this.hasStickers, this.id, this.accessHash, newValue, this.date, this.sizes, this.videoSizes, this.dcId);
    }

    public final ImmutableBasePhoto withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableBasePhoto(this.identifier, this.flags, this.hasStickers, this.id, this.accessHash, this.fileReference, value, this.sizes, this.videoSizes, this.dcId);
    }

    public final ImmutableBasePhoto withSizes(PhotoSize ... elements) {
        List<PhotoSize> newValue = ImmutableBasePhoto.createUnmodifiableList(false, ImmutableBasePhoto.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBasePhoto(this.identifier, this.flags, this.hasStickers, this.id, this.accessHash, this.fileReference, this.date, newValue, this.videoSizes, this.dcId);
    }

    public final ImmutableBasePhoto withSizes(Iterable<? extends PhotoSize> elements) {
        if (this.sizes == elements) {
            return this;
        }
        List<PhotoSize> newValue = ImmutableBasePhoto.createUnmodifiableList(false, ImmutableBasePhoto.createSafeList(elements, true, false));
        return new ImmutableBasePhoto(this.identifier, this.flags, this.hasStickers, this.id, this.accessHash, this.fileReference, this.date, newValue, this.videoSizes, this.dcId);
    }

    public final ImmutableBasePhoto withVideoSizes(VideoSize ... elements) {
        if (elements == null) {
            return new ImmutableBasePhoto(this.identifier, this.flags, this.hasStickers, this.id, this.accessHash, this.fileReference, this.date, this.sizes, null, this.dcId);
        }
        List<VideoSize> newValue = Arrays.asList(elements) == null ? null : ImmutableBasePhoto.createUnmodifiableList(false, ImmutableBasePhoto.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBasePhoto(this.identifier, this.flags, this.hasStickers, this.id, this.accessHash, this.fileReference, this.date, this.sizes, newValue, this.dcId);
    }

    public final ImmutableBasePhoto withVideoSizes(@Nullable Iterable<? extends VideoSize> elements) {
        if (this.videoSizes == elements) {
            return this;
        }
        List<VideoSize> newValue = elements == null ? null : ImmutableBasePhoto.createUnmodifiableList(false, ImmutableBasePhoto.createSafeList(elements, true, false));
        return new ImmutableBasePhoto(this.identifier, this.flags, this.hasStickers, this.id, this.accessHash, this.fileReference, this.date, this.sizes, newValue, this.dcId);
    }

    public final ImmutableBasePhoto withDcId(int value) {
        if (this.dcId == value) {
            return this;
        }
        return new ImmutableBasePhoto(this.identifier, this.flags, this.hasStickers, this.id, this.accessHash, this.fileReference, this.date, this.sizes, this.videoSizes, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBasePhoto && this.equalTo(0, (ImmutableBasePhoto)another);
    }

    private boolean equalTo(int synthetic, ImmutableBasePhoto another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.hasStickers == another.hasStickers && this.id == another.id && this.accessHash == another.accessHash && this.fileReference().equals((Object)another.fileReference()) && this.date == another.date && this.sizes.equals(another.sizes) && Objects.equals(this.videoSizes, another.videoSizes) && this.dcId == another.dcId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.hasStickers);
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + Long.hashCode(this.accessHash);
        h += (h << 5) + this.fileReference().hashCode();
        h += (h << 5) + this.date;
        h += (h << 5) + this.sizes.hashCode();
        h += (h << 5) + Objects.hashCode(this.videoSizes);
        h += (h << 5) + this.dcId;
        return h;
    }

    public String toString() {
        return "BasePhoto{identifier=" + this.identifier + ", flags=" + this.flags + ", hasStickers=" + this.hasStickers + ", id=" + this.id + ", accessHash=" + this.accessHash + ", fileReference=" + ByteBufUtil.hexDump((ByteBuf)this.fileReference) + ", date=" + this.date + ", sizes=" + this.sizes + ", videoSizes=" + this.videoSizes + ", dcId=" + this.dcId + "}";
    }

    public static ImmutableBasePhoto of(long id, long accessHash, int date, int dcId) {
        return new ImmutableBasePhoto(id, accessHash, date, dcId);
    }

    public static ImmutableBasePhoto copyOf(BasePhoto instance) {
        if (instance instanceof ImmutableBasePhoto) {
            return (ImmutableBasePhoto)instance;
        }
        return ImmutableBasePhoto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long INIT_BIT_DATE = 4L;
        private static final long INIT_BIT_DC_ID = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_HAS_STICKERS = 4L;
        private long initBits = 15L;
        private long optBits;
        private ByteBuf fileReference_value = null;
        private int identifier;
        private int flags;
        private boolean hasStickers;
        private long id;
        private long accessHash;
        private int date;
        private List<PhotoSize> sizes = new ArrayList<PhotoSize>();
        private List<VideoSize> videoSizes = null;
        private int dcId;

        private Builder() {
        }

        public final Builder from(Photo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BasePhoto instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Photo instance;
            long bits = 0L;
            if (object instanceof Photo) {
                instance = (Photo)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BasePhoto) {
                instance = (BasePhoto)object;
                this.hasStickers(instance.hasStickers());
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllSizes(instance.sizes());
                List<VideoSize> videoSizesValue = instance.videoSizes();
                if (videoSizesValue != null) {
                    this.addAllVideoSizes(videoSizesValue);
                }
                this.dcId(instance.dcId());
                this.flags(instance.flags());
                this.accessHash(instance.accessHash());
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
                this.fileReference(instance.fileReference());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder hasStickers(boolean hasStickers) {
            this.hasStickers = hasStickers;
            this.optBits |= 4L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder fileReference(ByteBuf value) {
            this.fileReference_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addSize(PhotoSize element) {
            this.sizes.add(Objects.requireNonNull(element, "sizes element"));
            return this;
        }

        public final Builder addSizes(PhotoSize ... elements) {
            for (PhotoSize element : elements) {
                this.sizes.add(Objects.requireNonNull(element, "sizes element"));
            }
            return this;
        }

        public final Builder sizes(Iterable<? extends PhotoSize> elements) {
            this.sizes.clear();
            return this.addAllSizes(elements);
        }

        public final Builder addAllSizes(Iterable<? extends PhotoSize> elements) {
            for (PhotoSize photoSize : elements) {
                this.sizes.add(Objects.requireNonNull(photoSize, "sizes element"));
            }
            return this;
        }

        public final Builder addVideoSize(VideoSize element) {
            if (this.videoSizes == null) {
                this.videoSizes = new ArrayList<VideoSize>();
            }
            this.videoSizes.add(Objects.requireNonNull(element, "videoSizes element"));
            return this;
        }

        public final Builder addVideoSizes(VideoSize ... elements) {
            if (this.videoSizes == null) {
                this.videoSizes = new ArrayList<VideoSize>();
            }
            for (VideoSize element : elements) {
                this.videoSizes.add(Objects.requireNonNull(element, "videoSizes element"));
            }
            return this;
        }

        public final Builder videoSizes(@Nullable Iterable<? extends VideoSize> elements) {
            if (elements == null) {
                this.videoSizes = null;
                return this;
            }
            this.videoSizes = new ArrayList<VideoSize>();
            return this.addAllVideoSizes(elements);
        }

        public final Builder addAllVideoSizes(Iterable<? extends VideoSize> elements) {
            Objects.requireNonNull(elements, "videoSizes element");
            if (this.videoSizes == null) {
                this.videoSizes = new ArrayList<VideoSize>();
            }
            for (VideoSize videoSize : elements) {
                this.videoSizes.add(Objects.requireNonNull(videoSize, "videoSizes element"));
            }
            return this;
        }

        public final Builder dcId(int dcId) {
            this.dcId = dcId;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableBasePhoto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBasePhoto(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean hasStickersIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("dcId");
            }
            return "Cannot build BasePhoto, some of required attributes are not set " + attributes;
        }

        private ByteBuf fileReference_build() {
            return Objects.requireNonNull(this.fileReference_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte hasStickersBuildStage = 0;
        private boolean hasStickers;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBasePhoto.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBasePhoto.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean hasStickers() {
            if (this.hasStickersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasStickersBuildStage == 0) {
                this.hasStickersBuildStage = (byte)-1;
                this.hasStickers = ImmutableBasePhoto.this.hasStickersInitialize();
                this.hasStickersBuildStage = 1;
            }
            return this.hasStickers;
        }

        void hasStickers(boolean hasStickers) {
            this.hasStickers = hasStickers;
            this.hasStickersBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.hasStickersBuildStage == -1) {
                attributes.add("hasStickers");
            }
            return "Cannot build BasePhoto, attribute initializers form cycle " + attributes;
        }
    }
}

