/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BasePhotoSize;
import telegram4j.tl.PhotoSize;
import telegram4j.tl.api.TlObject;

public final class ImmutableBasePhotoSize
implements BasePhotoSize {
    private final int identifier;
    private final String type;
    private final int w;
    private final int h;
    private final int size;

    private ImmutableBasePhotoSize(String type, int w, int h, int size) {
        this.type = Objects.requireNonNull(type, "type");
        this.w = w;
        this.h = h;
        this.size = size;
        this.identifier = BasePhotoSize.super.identifier();
    }

    private ImmutableBasePhotoSize(Builder builder) {
        this.type = builder.type;
        this.w = builder.w;
        this.h = builder.h;
        this.size = builder.size;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BasePhotoSize.super.identifier();
    }

    private ImmutableBasePhotoSize(int identifier, String type, int w, int h, int size) {
        this.identifier = identifier;
        this.type = type;
        this.w = w;
        this.h = h;
        this.size = size;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public int w() {
        return this.w;
    }

    @Override
    public int h() {
        return this.h;
    }

    @Override
    public int size() {
        return this.size;
    }

    public final ImmutableBasePhotoSize withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBasePhotoSize(value, this.type, this.w, this.h, this.size);
    }

    public final ImmutableBasePhotoSize withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableBasePhotoSize(this.identifier, newValue, this.w, this.h, this.size);
    }

    public final ImmutableBasePhotoSize withW(int value) {
        if (this.w == value) {
            return this;
        }
        return new ImmutableBasePhotoSize(this.identifier, this.type, value, this.h, this.size);
    }

    public final ImmutableBasePhotoSize withH(int value) {
        if (this.h == value) {
            return this;
        }
        return new ImmutableBasePhotoSize(this.identifier, this.type, this.w, value, this.size);
    }

    public final ImmutableBasePhotoSize withSize(int value) {
        if (this.size == value) {
            return this;
        }
        return new ImmutableBasePhotoSize(this.identifier, this.type, this.w, this.h, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBasePhotoSize && this.equalTo(0, (ImmutableBasePhotoSize)another);
    }

    private boolean equalTo(int synthetic, ImmutableBasePhotoSize another) {
        return this.identifier == another.identifier && this.type.equals(another.type) && this.w == another.w && this.h == another.h && this.size == another.size;
    }

    public int hashCode() {
        int h$$ = 5381;
        h$$ += (h$$ << 5) + this.identifier;
        h$$ += (h$$ << 5) + this.type.hashCode();
        h$$ += (h$$ << 5) + this.w;
        h$$ += (h$$ << 5) + this.h;
        h$$ += (h$$ << 5) + this.size;
        return h$$;
    }

    public String toString() {
        return "BasePhotoSize{identifier=" + this.identifier + ", type=" + this.type + ", w=" + this.w + ", h=" + this.h + ", size=" + this.size + "}";
    }

    public static ImmutableBasePhotoSize of(String type, int w, int h, int size) {
        return new ImmutableBasePhotoSize(type, w, h, size);
    }

    public static ImmutableBasePhotoSize copyOf(BasePhotoSize instance) {
        if (instance instanceof ImmutableBasePhotoSize) {
            return (ImmutableBasePhotoSize)instance;
        }
        return ImmutableBasePhotoSize.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_W = 2L;
        private static final long INIT_BIT_H = 4L;
        private static final long INIT_BIT_SIZE = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private String type;
        private int w;
        private int h;
        private int size;

        private Builder() {
        }

        public final Builder from(BasePhotoSize instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PhotoSize instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PhotoSize instance;
            long bits = 0L;
            if (object instanceof BasePhotoSize) {
                instance = (BasePhotoSize)object;
                this.h(instance.h());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.size(instance.size());
                if ((bits & 2L) == 0L) {
                    this.type(instance.type());
                    bits |= 2L;
                }
                this.w(instance.w());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PhotoSize) {
                instance = (PhotoSize)object;
                if ((bits & 2L) == 0L) {
                    this.type(instance.type());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder w(int w) {
            this.w = w;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder h(int h) {
            this.h = h;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder size(int size) {
            this.size = size;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableBasePhotoSize build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBasePhotoSize(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("w");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("h");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("size");
            }
            return "Cannot build BasePhotoSize, some of required attributes are not set " + attributes;
        }
    }
}

