/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BaseSecureFile;
import telegram4j.tl.SecureFile;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseSecureFile
implements BaseSecureFile {
    private final int identifier;
    private final long id;
    private final long accessHash;
    private final long size;
    private final int dcId;
    private final int date;
    private final ByteBuf fileHash;
    private final ByteBuf secret;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseSecureFile(long id, long accessHash, long size, int dcId, int date) {
        this.id = id;
        this.accessHash = accessHash;
        this.size = size;
        this.dcId = dcId;
        this.date = date;
        this.fileHash = null;
        this.secret = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableBaseSecureFile(Builder builder) {
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.size = builder.size;
        this.dcId = builder.dcId;
        this.date = builder.date;
        this.fileHash = builder.fileHash_build();
        this.secret = builder.secret_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableBaseSecureFile(int identifier, long id, long accessHash, long size, int dcId, int date, ByteBuf fileHash, ByteBuf secret) {
        this.identifier = identifier;
        this.id = id;
        this.accessHash = accessHash;
        this.size = size;
        this.dcId = dcId;
        this.date = date;
        this.fileHash = fileHash;
        this.secret = secret;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseSecureFile.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public int dcId() {
        return this.dcId;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public ByteBuf fileHash() {
        return this.fileHash.duplicate();
    }

    @Override
    public ByteBuf secret() {
        return this.secret.duplicate();
    }

    public final ImmutableBaseSecureFile withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseSecureFile(value, this.id, this.accessHash, this.size, this.dcId, this.date, this.fileHash, this.secret);
    }

    public final ImmutableBaseSecureFile withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableBaseSecureFile(this.identifier, value, this.accessHash, this.size, this.dcId, this.date, this.fileHash, this.secret);
    }

    public final ImmutableBaseSecureFile withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableBaseSecureFile(this.identifier, this.id, value, this.size, this.dcId, this.date, this.fileHash, this.secret);
    }

    public final ImmutableBaseSecureFile withSize(long value) {
        if (this.size == value) {
            return this;
        }
        return new ImmutableBaseSecureFile(this.identifier, this.id, this.accessHash, value, this.dcId, this.date, this.fileHash, this.secret);
    }

    public final ImmutableBaseSecureFile withDcId(int value) {
        if (this.dcId == value) {
            return this;
        }
        return new ImmutableBaseSecureFile(this.identifier, this.id, this.accessHash, this.size, value, this.date, this.fileHash, this.secret);
    }

    public final ImmutableBaseSecureFile withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableBaseSecureFile(this.identifier, this.id, this.accessHash, this.size, this.dcId, value, this.fileHash, this.secret);
    }

    public ImmutableBaseSecureFile withFileHash(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.fileHash == newValue) {
            return this;
        }
        return new ImmutableBaseSecureFile(this.identifier, this.id, this.accessHash, this.size, this.dcId, this.date, newValue, this.secret);
    }

    public ImmutableBaseSecureFile withSecret(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.secret == newValue) {
            return this;
        }
        return new ImmutableBaseSecureFile(this.identifier, this.id, this.accessHash, this.size, this.dcId, this.date, this.fileHash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseSecureFile && this.equalTo(0, (ImmutableBaseSecureFile)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseSecureFile another) {
        return this.identifier == another.identifier && this.id == another.id && this.accessHash == another.accessHash && this.size == another.size && this.dcId == another.dcId && this.date == another.date && this.fileHash().equals((Object)another.fileHash()) && this.secret().equals((Object)another.secret());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + Long.hashCode(this.accessHash);
        h += (h << 5) + Long.hashCode(this.size);
        h += (h << 5) + this.dcId;
        h += (h << 5) + this.date;
        h += (h << 5) + this.fileHash().hashCode();
        h += (h << 5) + this.secret().hashCode();
        return h;
    }

    public String toString() {
        return "BaseSecureFile{identifier=" + this.identifier + ", id=" + this.id + ", accessHash=" + this.accessHash + ", size=" + this.size + ", dcId=" + this.dcId + ", date=" + this.date + ", fileHash=" + ByteBufUtil.hexDump((ByteBuf)this.fileHash) + ", secret=" + ByteBufUtil.hexDump((ByteBuf)this.secret) + "}";
    }

    public static ImmutableBaseSecureFile of(long id, long accessHash, long size, int dcId, int date) {
        return new ImmutableBaseSecureFile(id, accessHash, size, dcId, date);
    }

    public static ImmutableBaseSecureFile copyOf(BaseSecureFile instance) {
        if (instance instanceof ImmutableBaseSecureFile) {
            return (ImmutableBaseSecureFile)instance;
        }
        return ImmutableBaseSecureFile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long INIT_BIT_SIZE = 4L;
        private static final long INIT_BIT_DC_ID = 8L;
        private static final long INIT_BIT_DATE = 16L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 31L;
        private long optBits;
        private ByteBuf fileHash_value = null;
        private ByteBuf secret_value = null;
        private int identifier;
        private long id;
        private long accessHash;
        private long size;
        private int dcId;
        private int date;

        private Builder() {
        }

        public final Builder from(BaseSecureFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SecureFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SecureFile instance;
            long bits = 0L;
            if (object instanceof BaseSecureFile) {
                instance = (BaseSecureFile)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.size(instance.size());
                this.dcId(instance.dcId());
                this.fileHash(instance.fileHash());
                this.accessHash(instance.accessHash());
                this.id(instance.id());
                this.secret(instance.secret());
            }
            if (object instanceof SecureFile) {
                instance = (SecureFile)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder size(long size) {
            this.size = size;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder dcId(int dcId) {
            this.dcId = dcId;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public Builder fileHash(ByteBuf value) {
            this.fileHash_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder secret(ByteBuf value) {
            this.secret_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableBaseSecureFile build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseSecureFile(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("size");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("dcId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("date");
            }
            return "Cannot build BaseSecureFile, some of required attributes are not set " + attributes;
        }

        private ByteBuf fileHash_build() {
            return Objects.requireNonNull(this.fileHash_value);
        }

        private ByteBuf secret_build() {
            return Objects.requireNonNull(this.secret_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseSecureFile.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build BaseSecureFile, attribute initializers form cycle " + attributes;
        }
    }
}

