/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BaseSecureRequiredType;
import telegram4j.tl.SecureRequiredType;
import telegram4j.tl.SecureValueType;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseSecureRequiredType
implements BaseSecureRequiredType {
    private final int identifier;
    private final int flags;
    private final boolean nativeNames;
    private final boolean selfieRequired;
    private final boolean translationRequired;
    private final SecureValueType type;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseSecureRequiredType(SecureValueType type) {
        this.type = Objects.requireNonNull(type, "type");
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.nativeNames = this.initShim.nativeNames();
        this.selfieRequired = this.initShim.selfieRequired();
        this.translationRequired = this.initShim.translationRequired();
        this.initShim = null;
    }

    private ImmutableBaseSecureRequiredType(Builder builder) {
        this.type = builder.type;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.nativeNamesIsSet()) {
            this.initShim.nativeNames(builder.nativeNames);
        }
        if (builder.selfieRequiredIsSet()) {
            this.initShim.selfieRequired(builder.selfieRequired);
        }
        if (builder.translationRequiredIsSet()) {
            this.initShim.translationRequired(builder.translationRequired);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.nativeNames = this.initShim.nativeNames();
        this.selfieRequired = this.initShim.selfieRequired();
        this.translationRequired = this.initShim.translationRequired();
        this.initShim = null;
    }

    private ImmutableBaseSecureRequiredType(int identifier, int flags, boolean nativeNames, boolean selfieRequired, boolean translationRequired, SecureValueType type) {
        this.identifier = identifier;
        this.flags = flags;
        this.nativeNames = nativeNames;
        this.selfieRequired = selfieRequired;
        this.translationRequired = translationRequired;
        this.type = type;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseSecureRequiredType.super.identifier();
    }

    private int flagsInitialize() {
        return BaseSecureRequiredType.super.flags();
    }

    private boolean nativeNamesInitialize() {
        return BaseSecureRequiredType.super.nativeNames();
    }

    private boolean selfieRequiredInitialize() {
        return BaseSecureRequiredType.super.selfieRequired();
    }

    private boolean translationRequiredInitialize() {
        return BaseSecureRequiredType.super.translationRequired();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean nativeNames() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nativeNames() : this.nativeNames;
    }

    @Override
    public boolean selfieRequired() {
        InitShim shim = this.initShim;
        return shim != null ? shim.selfieRequired() : this.selfieRequired;
    }

    @Override
    public boolean translationRequired() {
        InitShim shim = this.initShim;
        return shim != null ? shim.translationRequired() : this.translationRequired;
    }

    @Override
    public SecureValueType type() {
        return this.type;
    }

    public final ImmutableBaseSecureRequiredType withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseSecureRequiredType(value, this.flags, this.nativeNames, this.selfieRequired, this.translationRequired, this.type);
    }

    public final ImmutableBaseSecureRequiredType withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBaseSecureRequiredType(this.identifier, value, this.nativeNames, this.selfieRequired, this.translationRequired, this.type);
    }

    public final ImmutableBaseSecureRequiredType withNativeNames(boolean value) {
        if (this.nativeNames == value) {
            return this;
        }
        return new ImmutableBaseSecureRequiredType(this.identifier, this.flags, value, this.selfieRequired, this.translationRequired, this.type);
    }

    public final ImmutableBaseSecureRequiredType withSelfieRequired(boolean value) {
        if (this.selfieRequired == value) {
            return this;
        }
        return new ImmutableBaseSecureRequiredType(this.identifier, this.flags, this.nativeNames, value, this.translationRequired, this.type);
    }

    public final ImmutableBaseSecureRequiredType withTranslationRequired(boolean value) {
        if (this.translationRequired == value) {
            return this;
        }
        return new ImmutableBaseSecureRequiredType(this.identifier, this.flags, this.nativeNames, this.selfieRequired, value, this.type);
    }

    public final ImmutableBaseSecureRequiredType withType(SecureValueType value) {
        SecureValueType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableBaseSecureRequiredType(this.identifier, this.flags, this.nativeNames, this.selfieRequired, this.translationRequired, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseSecureRequiredType && this.equalTo(0, (ImmutableBaseSecureRequiredType)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseSecureRequiredType another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.nativeNames == another.nativeNames && this.selfieRequired == another.selfieRequired && this.translationRequired == another.translationRequired && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.nativeNames);
        h += (h << 5) + Boolean.hashCode(this.selfieRequired);
        h += (h << 5) + Boolean.hashCode(this.translationRequired);
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "BaseSecureRequiredType{identifier=" + this.identifier + ", flags=" + this.flags + ", nativeNames=" + this.nativeNames + ", selfieRequired=" + this.selfieRequired + ", translationRequired=" + this.translationRequired + ", type=" + this.type + "}";
    }

    public static ImmutableBaseSecureRequiredType of(SecureValueType type) {
        return new ImmutableBaseSecureRequiredType(type);
    }

    public static ImmutableBaseSecureRequiredType copyOf(BaseSecureRequiredType instance) {
        if (instance instanceof ImmutableBaseSecureRequiredType) {
            return (ImmutableBaseSecureRequiredType)instance;
        }
        return ImmutableBaseSecureRequiredType.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_NATIVE_NAMES = 4L;
        private static final long OPT_BIT_SELFIE_REQUIRED = 8L;
        private static final long OPT_BIT_TRANSLATION_REQUIRED = 16L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean nativeNames;
        private boolean selfieRequired;
        private boolean translationRequired;
        private SecureValueType type;

        private Builder() {
        }

        public final Builder from(BaseSecureRequiredType instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SecureRequiredType instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SecureRequiredType instance;
            long bits = 0L;
            if (object instanceof BaseSecureRequiredType) {
                instance = (BaseSecureRequiredType)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.nativeNames(instance.nativeNames());
                this.selfieRequired(instance.selfieRequired());
                this.translationRequired(instance.translationRequired());
                this.type(instance.type());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SecureRequiredType) {
                instance = (SecureRequiredType)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder nativeNames(boolean nativeNames) {
            this.nativeNames = nativeNames;
            this.optBits |= 4L;
            return this;
        }

        public final Builder selfieRequired(boolean selfieRequired) {
            this.selfieRequired = selfieRequired;
            this.optBits |= 8L;
            return this;
        }

        public final Builder translationRequired(boolean translationRequired) {
            this.translationRequired = translationRequired;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder type(SecureValueType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableBaseSecureRequiredType build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseSecureRequiredType(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean nativeNamesIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean selfieRequiredIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean translationRequiredIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build BaseSecureRequiredType, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte nativeNamesBuildStage = 0;
        private boolean nativeNames;
        private byte selfieRequiredBuildStage = 0;
        private boolean selfieRequired;
        private byte translationRequiredBuildStage = 0;
        private boolean translationRequired;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseSecureRequiredType.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBaseSecureRequiredType.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean nativeNames() {
            if (this.nativeNamesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nativeNamesBuildStage == 0) {
                this.nativeNamesBuildStage = (byte)-1;
                this.nativeNames = ImmutableBaseSecureRequiredType.this.nativeNamesInitialize();
                this.nativeNamesBuildStage = 1;
            }
            return this.nativeNames;
        }

        void nativeNames(boolean nativeNames) {
            this.nativeNames = nativeNames;
            this.nativeNamesBuildStage = 1;
        }

        boolean selfieRequired() {
            if (this.selfieRequiredBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.selfieRequiredBuildStage == 0) {
                this.selfieRequiredBuildStage = (byte)-1;
                this.selfieRequired = ImmutableBaseSecureRequiredType.this.selfieRequiredInitialize();
                this.selfieRequiredBuildStage = 1;
            }
            return this.selfieRequired;
        }

        void selfieRequired(boolean selfieRequired) {
            this.selfieRequired = selfieRequired;
            this.selfieRequiredBuildStage = 1;
        }

        boolean translationRequired() {
            if (this.translationRequiredBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.translationRequiredBuildStage == 0) {
                this.translationRequiredBuildStage = (byte)-1;
                this.translationRequired = ImmutableBaseSecureRequiredType.this.translationRequiredInitialize();
                this.translationRequiredBuildStage = 1;
            }
            return this.translationRequired;
        }

        void translationRequired(boolean translationRequired) {
            this.translationRequired = translationRequired;
            this.translationRequiredBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.nativeNamesBuildStage == -1) {
                attributes.add("nativeNames");
            }
            if (this.selfieRequiredBuildStage == -1) {
                attributes.add("selfieRequired");
            }
            if (this.translationRequiredBuildStage == -1) {
                attributes.add("translationRequired");
            }
            return "Cannot build BaseSecureRequiredType, attribute initializers form cycle " + attributes;
        }
    }
}

