/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BaseSecureValueError;
import telegram4j.tl.SecureValueError;
import telegram4j.tl.SecureValueType;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseSecureValueError
implements BaseSecureValueError {
    private final int identifier;
    private final SecureValueType type;
    private final ByteBuf hash;
    private final String text;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseSecureValueError(SecureValueType type, String text) {
        this.type = Objects.requireNonNull(type, "type");
        this.text = Objects.requireNonNull(text, "text");
        this.hash = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableBaseSecureValueError(Builder builder) {
        this.type = builder.type;
        this.hash = builder.hash_build();
        this.text = builder.text;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableBaseSecureValueError(int identifier, SecureValueType type, ByteBuf hash, String text) {
        this.identifier = identifier;
        this.type = type;
        this.hash = hash;
        this.text = text;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseSecureValueError.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public SecureValueType type() {
        return this.type;
    }

    @Override
    public ByteBuf hash() {
        return this.hash.duplicate();
    }

    @Override
    public String text() {
        return this.text;
    }

    public final ImmutableBaseSecureValueError withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseSecureValueError(value, this.type, this.hash, this.text);
    }

    public final ImmutableBaseSecureValueError withType(SecureValueType value) {
        SecureValueType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableBaseSecureValueError(this.identifier, newValue, this.hash, this.text);
    }

    public ImmutableBaseSecureValueError withHash(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.hash == newValue) {
            return this;
        }
        return new ImmutableBaseSecureValueError(this.identifier, this.type, newValue, this.text);
    }

    public final ImmutableBaseSecureValueError withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableBaseSecureValueError(this.identifier, this.type, this.hash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseSecureValueError && this.equalTo(0, (ImmutableBaseSecureValueError)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseSecureValueError another) {
        return this.identifier == another.identifier && this.type.equals((Object)another.type) && this.hash().equals((Object)another.hash()) && this.text.equals(another.text);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.hash().hashCode();
        h += (h << 5) + this.text.hashCode();
        return h;
    }

    public String toString() {
        return "BaseSecureValueError{identifier=" + this.identifier + ", type=" + this.type + ", hash=" + ByteBufUtil.hexDump((ByteBuf)this.hash) + ", text=" + this.text + "}";
    }

    public static ImmutableBaseSecureValueError of(SecureValueType type, String text) {
        return new ImmutableBaseSecureValueError(type, text);
    }

    public static ImmutableBaseSecureValueError copyOf(BaseSecureValueError instance) {
        if (instance instanceof ImmutableBaseSecureValueError) {
            return (ImmutableBaseSecureValueError)instance;
        }
        return ImmutableBaseSecureValueError.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_TEXT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private ByteBuf hash_value = null;
        private int identifier;
        private SecureValueType type;
        private String text;

        private Builder() {
        }

        public final Builder from(SecureValueError instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseSecureValueError instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SecureValueError instance;
            long bits = 0L;
            if (object instanceof SecureValueError) {
                instance = (SecureValueError)object;
                if ((bits & 4L) == 0L) {
                    this.type(instance.type());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.text(instance.text());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseSecureValueError) {
                instance = (BaseSecureValueError)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.text(instance.text());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.type(instance.type());
                    bits |= 4L;
                }
                this.hash(instance.hash());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder type(SecureValueType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder hash(ByteBuf value) {
            this.hash_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBaseSecureValueError build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseSecureValueError(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("text");
            }
            return "Cannot build BaseSecureValueError, some of required attributes are not set " + attributes;
        }

        private ByteBuf hash_build() {
            return Objects.requireNonNull(this.hash_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseSecureValueError.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build BaseSecureValueError, attribute initializers form cycle " + attributes;
        }
    }
}

