/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BaseStatsGraph;
import telegram4j.tl.DataJSON;
import telegram4j.tl.StatsGraph;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseStatsGraph
implements BaseStatsGraph {
    private final int identifier;
    private final int flags;
    private final DataJSON json;
    @Nullable
    private final String zoomToken;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseStatsGraph(DataJSON json) {
        this.json = Objects.requireNonNull(json, "json");
        this.zoomToken = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableBaseStatsGraph(Builder builder) {
        this.json = builder.json;
        this.zoomToken = builder.zoomToken;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableBaseStatsGraph(int identifier, int flags, DataJSON json, @Nullable String zoomToken) {
        this.identifier = identifier;
        this.flags = flags;
        this.json = json;
        this.zoomToken = zoomToken;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseStatsGraph.super.identifier();
    }

    private int flagsInitialize() {
        return BaseStatsGraph.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public DataJSON json() {
        return this.json;
    }

    @Override
    @Nullable
    public String zoomToken() {
        return this.zoomToken;
    }

    public final ImmutableBaseStatsGraph withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseStatsGraph(value, this.flags, this.json, this.zoomToken);
    }

    public final ImmutableBaseStatsGraph withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBaseStatsGraph(this.identifier, value, this.json, this.zoomToken);
    }

    public final ImmutableBaseStatsGraph withJson(DataJSON value) {
        if (this.json == value) {
            return this;
        }
        DataJSON newValue = Objects.requireNonNull(value, "json");
        return new ImmutableBaseStatsGraph(this.identifier, this.flags, newValue, this.zoomToken);
    }

    public final ImmutableBaseStatsGraph withZoomToken(@Nullable String value) {
        if (Objects.equals(this.zoomToken, value)) {
            return this;
        }
        return new ImmutableBaseStatsGraph(this.identifier, this.flags, this.json, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseStatsGraph && this.equalTo(0, (ImmutableBaseStatsGraph)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseStatsGraph another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.json.equals(another.json) && Objects.equals(this.zoomToken, another.zoomToken);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.json.hashCode();
        h += (h << 5) + Objects.hashCode(this.zoomToken);
        return h;
    }

    public String toString() {
        return "BaseStatsGraph{identifier=" + this.identifier + ", flags=" + this.flags + ", json=" + this.json + ", zoomToken=" + this.zoomToken + "}";
    }

    public static ImmutableBaseStatsGraph of(DataJSON json) {
        return new ImmutableBaseStatsGraph(json);
    }

    public static ImmutableBaseStatsGraph copyOf(BaseStatsGraph instance) {
        if (instance instanceof ImmutableBaseStatsGraph) {
            return (ImmutableBaseStatsGraph)instance;
        }
        return ImmutableBaseStatsGraph.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_JSON = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private DataJSON json;
        private String zoomToken;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseStatsGraph instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(StatsGraph instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseStatsGraph) {
                String zoomTokenValue;
                instance = (BaseStatsGraph)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((zoomTokenValue = instance.zoomToken()) != null) {
                    this.zoomToken(zoomTokenValue);
                }
                this.json(instance.json());
            }
            if (object instanceof StatsGraph) {
                instance = (StatsGraph)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder json(DataJSON json) {
            this.json = Objects.requireNonNull(json, "json");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder zoomToken(@Nullable String zoomToken) {
            this.zoomToken = zoomToken;
            return this;
        }

        public ImmutableBaseStatsGraph build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseStatsGraph(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("json");
            }
            return "Cannot build BaseStatsGraph, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseStatsGraph.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBaseStatsGraph.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build BaseStatsGraph, attribute initializers form cycle " + attributes;
        }
    }
}

