/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BaseStickerSetCovered;
import telegram4j.tl.Document;
import telegram4j.tl.StickerSet;
import telegram4j.tl.StickerSetCovered;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseStickerSetCovered
implements BaseStickerSetCovered {
    private final int identifier;
    private final StickerSet set;
    private final Document cover;

    private ImmutableBaseStickerSetCovered(StickerSet set, Document cover) {
        this.set = Objects.requireNonNull(set, "set");
        this.cover = Objects.requireNonNull(cover, "cover");
        this.identifier = BaseStickerSetCovered.super.identifier();
    }

    private ImmutableBaseStickerSetCovered(Builder builder) {
        this.set = builder.set;
        this.cover = builder.cover;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseStickerSetCovered.super.identifier();
    }

    private ImmutableBaseStickerSetCovered(int identifier, StickerSet set, Document cover) {
        this.identifier = identifier;
        this.set = set;
        this.cover = cover;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public StickerSet set() {
        return this.set;
    }

    @Override
    public Document cover() {
        return this.cover;
    }

    public final ImmutableBaseStickerSetCovered withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseStickerSetCovered(value, this.set, this.cover);
    }

    public final ImmutableBaseStickerSetCovered withSet(StickerSet value) {
        if (this.set == value) {
            return this;
        }
        StickerSet newValue = Objects.requireNonNull(value, "set");
        return new ImmutableBaseStickerSetCovered(this.identifier, newValue, this.cover);
    }

    public final ImmutableBaseStickerSetCovered withCover(Document value) {
        if (this.cover == value) {
            return this;
        }
        Document newValue = Objects.requireNonNull(value, "cover");
        return new ImmutableBaseStickerSetCovered(this.identifier, this.set, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseStickerSetCovered && this.equalTo(0, (ImmutableBaseStickerSetCovered)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseStickerSetCovered another) {
        return this.identifier == another.identifier && this.set.equals(another.set) && this.cover.equals(another.cover);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.set.hashCode();
        h += (h << 5) + this.cover.hashCode();
        return h;
    }

    public String toString() {
        return "BaseStickerSetCovered{identifier=" + this.identifier + ", set=" + this.set + ", cover=" + this.cover + "}";
    }

    public static ImmutableBaseStickerSetCovered of(StickerSet set, Document cover) {
        return new ImmutableBaseStickerSetCovered(set, cover);
    }

    public static ImmutableBaseStickerSetCovered copyOf(BaseStickerSetCovered instance) {
        if (instance instanceof ImmutableBaseStickerSetCovered) {
            return (ImmutableBaseStickerSetCovered)instance;
        }
        return ImmutableBaseStickerSetCovered.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SET = 1L;
        private static final long INIT_BIT_COVER = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private StickerSet set;
        private Document cover;

        private Builder() {
        }

        public final Builder from(StickerSetCovered instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseStickerSetCovered instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StickerSetCovered instance;
            long bits = 0L;
            if (object instanceof StickerSetCovered) {
                instance = (StickerSetCovered)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.set(instance.set());
                    bits |= 2L;
                }
            }
            if (object instanceof BaseStickerSetCovered) {
                instance = (BaseStickerSetCovered)object;
                this.cover(instance.cover());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.set(instance.set());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder set(StickerSet set) {
            this.set = Objects.requireNonNull(set, "set");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder cover(Document cover) {
            this.cover = Objects.requireNonNull(cover, "cover");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBaseStickerSetCovered build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseStickerSetCovered(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("set");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("cover");
            }
            return "Cannot build BaseStickerSetCovered, some of required attributes are not set " + attributes;
        }
    }
}

