/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.BaseUpdates;
import telegram4j.tl.Chat;
import telegram4j.tl.Update;
import telegram4j.tl.Updates;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseUpdates
implements BaseUpdates {
    private final int identifier;
    private final List<Update> updates;
    private final List<User> users;
    private final List<Chat> chats;
    private final int date;
    private final int seq;

    private ImmutableBaseUpdates(int date, int seq) {
        this.date = date;
        this.seq = seq;
        this.updates = Collections.emptyList();
        this.users = Collections.emptyList();
        this.chats = Collections.emptyList();
        this.identifier = BaseUpdates.super.identifier();
    }

    private ImmutableBaseUpdates(Builder builder) {
        this.updates = ImmutableBaseUpdates.createUnmodifiableList(true, builder.updates);
        this.users = ImmutableBaseUpdates.createUnmodifiableList(true, builder.users);
        this.chats = ImmutableBaseUpdates.createUnmodifiableList(true, builder.chats);
        this.date = builder.date;
        this.seq = builder.seq;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseUpdates.super.identifier();
    }

    private ImmutableBaseUpdates(int identifier, List<Update> updates, List<User> users, List<Chat> chats, int date, int seq) {
        this.identifier = identifier;
        this.updates = updates;
        this.users = users;
        this.chats = chats;
        this.date = date;
        this.seq = seq;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<Update> updates() {
        return this.updates;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public int seq() {
        return this.seq;
    }

    public final ImmutableBaseUpdates withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseUpdates(value, this.updates, this.users, this.chats, this.date, this.seq);
    }

    public final ImmutableBaseUpdates withUpdates(Update ... elements) {
        List<Update> newValue = ImmutableBaseUpdates.createUnmodifiableList(false, ImmutableBaseUpdates.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseUpdates(this.identifier, newValue, this.users, this.chats, this.date, this.seq);
    }

    public final ImmutableBaseUpdates withUpdates(Iterable<? extends Update> elements) {
        if (this.updates == elements) {
            return this;
        }
        List<Update> newValue = ImmutableBaseUpdates.createUnmodifiableList(false, ImmutableBaseUpdates.createSafeList(elements, true, false));
        return new ImmutableBaseUpdates(this.identifier, newValue, this.users, this.chats, this.date, this.seq);
    }

    public final ImmutableBaseUpdates withUsers(User ... elements) {
        List<User> newValue = ImmutableBaseUpdates.createUnmodifiableList(false, ImmutableBaseUpdates.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseUpdates(this.identifier, this.updates, newValue, this.chats, this.date, this.seq);
    }

    public final ImmutableBaseUpdates withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableBaseUpdates.createUnmodifiableList(false, ImmutableBaseUpdates.createSafeList(elements, true, false));
        return new ImmutableBaseUpdates(this.identifier, this.updates, newValue, this.chats, this.date, this.seq);
    }

    public final ImmutableBaseUpdates withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableBaseUpdates.createUnmodifiableList(false, ImmutableBaseUpdates.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseUpdates(this.identifier, this.updates, this.users, newValue, this.date, this.seq);
    }

    public final ImmutableBaseUpdates withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableBaseUpdates.createUnmodifiableList(false, ImmutableBaseUpdates.createSafeList(elements, true, false));
        return new ImmutableBaseUpdates(this.identifier, this.updates, this.users, newValue, this.date, this.seq);
    }

    public final ImmutableBaseUpdates withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableBaseUpdates(this.identifier, this.updates, this.users, this.chats, value, this.seq);
    }

    public final ImmutableBaseUpdates withSeq(int value) {
        if (this.seq == value) {
            return this;
        }
        return new ImmutableBaseUpdates(this.identifier, this.updates, this.users, this.chats, this.date, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseUpdates && this.equalTo(0, (ImmutableBaseUpdates)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseUpdates another) {
        return this.identifier == another.identifier && this.updates.equals(another.updates) && this.users.equals(another.users) && this.chats.equals(another.chats) && this.date == another.date && this.seq == another.seq;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.updates.hashCode();
        h += (h << 5) + this.users.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.date;
        h += (h << 5) + this.seq;
        return h;
    }

    public String toString() {
        return "BaseUpdates{identifier=" + this.identifier + ", updates=" + this.updates + ", users=" + this.users + ", chats=" + this.chats + ", date=" + this.date + ", seq=" + this.seq + "}";
    }

    public static ImmutableBaseUpdates of(int date, int seq) {
        return new ImmutableBaseUpdates(date, seq);
    }

    public static ImmutableBaseUpdates copyOf(BaseUpdates instance) {
        if (instance instanceof ImmutableBaseUpdates) {
            return (ImmutableBaseUpdates)instance;
        }
        return ImmutableBaseUpdates.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_DATE = 1L;
        private static final long INIT_BIT_SEQ = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private List<Update> updates = new ArrayList<Update>();
        private List<User> users = new ArrayList<User>();
        private List<Chat> chats = new ArrayList<Chat>();
        private int date;
        private int seq;

        private Builder() {
        }

        public final Builder from(BaseUpdates instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Updates instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Updates instance;
            long bits = 0L;
            if (object instanceof BaseUpdates) {
                instance = (BaseUpdates)object;
                this.date(instance.date());
                this.addAllChats(instance.chats());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllUpdates(instance.updates());
                this.addAllUsers(instance.users());
                this.seq(instance.seq());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Updates) {
                instance = (Updates)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addUpdate(Update element) {
            this.updates.add(Objects.requireNonNull(element, "updates element"));
            return this;
        }

        public final Builder addUpdates(Update ... elements) {
            for (Update element : elements) {
                this.updates.add(Objects.requireNonNull(element, "updates element"));
            }
            return this;
        }

        public final Builder updates(Iterable<? extends Update> elements) {
            this.updates.clear();
            return this.addAllUpdates(elements);
        }

        public final Builder addAllUpdates(Iterable<? extends Update> elements) {
            for (Update update : elements) {
                this.updates.add(Objects.requireNonNull(update, "updates element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder seq(int seq) {
            this.seq = seq;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBaseUpdates build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseUpdates(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("seq");
            }
            return "Cannot build BaseUpdates, some of required attributes are not set " + attributes;
        }
    }
}

