/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BaseUser;
import telegram4j.tl.RestrictionReason;
import telegram4j.tl.User;
import telegram4j.tl.UserProfilePhoto;
import telegram4j.tl.UserStatus;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseUser
implements BaseUser {
    private final int identifier;
    private final int flags;
    private final boolean self;
    private final boolean contact;
    private final boolean mutualContact;
    private final boolean deleted;
    private final boolean bot;
    private final boolean botChatHistory;
    private final boolean botNochats;
    private final boolean verified;
    private final boolean restricted;
    private final boolean min;
    private final boolean botInlineGeo;
    private final boolean support;
    private final boolean scam;
    private final boolean applyMinPhoto;
    private final boolean fake;
    private final boolean botAttachMenu;
    private final boolean premium;
    private final boolean attachMenuEnabled;
    private final long id;
    @Nullable
    private final Long accessHash;
    @Nullable
    private final String firstName;
    @Nullable
    private final String lastName;
    @Nullable
    private final String username;
    @Nullable
    private final String phone;
    @Nullable
    private final UserProfilePhoto photo;
    @Nullable
    private final UserStatus status;
    @Nullable
    private final Integer botInfoVersion;
    @Nullable
    private final List<RestrictionReason> restrictionReason;
    @Nullable
    private final String botInlinePlaceholder;
    @Nullable
    private final String langCode;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseUser(long id) {
        this.id = id;
        this.accessHash = null;
        this.firstName = null;
        this.lastName = null;
        this.username = null;
        this.phone = null;
        this.photo = null;
        this.status = null;
        this.botInfoVersion = null;
        this.restrictionReason = null;
        this.botInlinePlaceholder = null;
        this.langCode = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.self = this.initShim.self();
        this.contact = this.initShim.contact();
        this.mutualContact = this.initShim.mutualContact();
        this.deleted = this.initShim.deleted();
        this.bot = this.initShim.bot();
        this.botChatHistory = this.initShim.botChatHistory();
        this.botNochats = this.initShim.botNochats();
        this.verified = this.initShim.verified();
        this.restricted = this.initShim.restricted();
        this.min = this.initShim.min();
        this.botInlineGeo = this.initShim.botInlineGeo();
        this.support = this.initShim.support();
        this.scam = this.initShim.scam();
        this.applyMinPhoto = this.initShim.applyMinPhoto();
        this.fake = this.initShim.fake();
        this.botAttachMenu = this.initShim.botAttachMenu();
        this.premium = this.initShim.premium();
        this.attachMenuEnabled = this.initShim.attachMenuEnabled();
        this.initShim = null;
    }

    private ImmutableBaseUser(Builder builder) {
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.username = builder.username;
        this.phone = builder.phone;
        this.photo = builder.photo;
        this.status = builder.status;
        this.botInfoVersion = builder.botInfoVersion;
        this.restrictionReason = builder.restrictionReason == null ? null : ImmutableBaseUser.createUnmodifiableList(true, builder.restrictionReason);
        this.botInlinePlaceholder = builder.botInlinePlaceholder;
        this.langCode = builder.langCode;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.selfIsSet()) {
            this.initShim.self(builder.self);
        }
        if (builder.contactIsSet()) {
            this.initShim.contact(builder.contact);
        }
        if (builder.mutualContactIsSet()) {
            this.initShim.mutualContact(builder.mutualContact);
        }
        if (builder.deletedIsSet()) {
            this.initShim.deleted(builder.deleted);
        }
        if (builder.botIsSet()) {
            this.initShim.bot(builder.bot);
        }
        if (builder.botChatHistoryIsSet()) {
            this.initShim.botChatHistory(builder.botChatHistory);
        }
        if (builder.botNochatsIsSet()) {
            this.initShim.botNochats(builder.botNochats);
        }
        if (builder.verifiedIsSet()) {
            this.initShim.verified(builder.verified);
        }
        if (builder.restrictedIsSet()) {
            this.initShim.restricted(builder.restricted);
        }
        if (builder.minIsSet()) {
            this.initShim.min(builder.min);
        }
        if (builder.botInlineGeoIsSet()) {
            this.initShim.botInlineGeo(builder.botInlineGeo);
        }
        if (builder.supportIsSet()) {
            this.initShim.support(builder.support);
        }
        if (builder.scamIsSet()) {
            this.initShim.scam(builder.scam);
        }
        if (builder.applyMinPhotoIsSet()) {
            this.initShim.applyMinPhoto(builder.applyMinPhoto);
        }
        if (builder.fakeIsSet()) {
            this.initShim.fake(builder.fake);
        }
        if (builder.botAttachMenuIsSet()) {
            this.initShim.botAttachMenu(builder.botAttachMenu);
        }
        if (builder.premiumIsSet()) {
            this.initShim.premium(builder.premium);
        }
        if (builder.attachMenuEnabledIsSet()) {
            this.initShim.attachMenuEnabled(builder.attachMenuEnabled);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.self = this.initShim.self();
        this.contact = this.initShim.contact();
        this.mutualContact = this.initShim.mutualContact();
        this.deleted = this.initShim.deleted();
        this.bot = this.initShim.bot();
        this.botChatHistory = this.initShim.botChatHistory();
        this.botNochats = this.initShim.botNochats();
        this.verified = this.initShim.verified();
        this.restricted = this.initShim.restricted();
        this.min = this.initShim.min();
        this.botInlineGeo = this.initShim.botInlineGeo();
        this.support = this.initShim.support();
        this.scam = this.initShim.scam();
        this.applyMinPhoto = this.initShim.applyMinPhoto();
        this.fake = this.initShim.fake();
        this.botAttachMenu = this.initShim.botAttachMenu();
        this.premium = this.initShim.premium();
        this.attachMenuEnabled = this.initShim.attachMenuEnabled();
        this.initShim = null;
    }

    private ImmutableBaseUser(int identifier, int flags, boolean self, boolean contact, boolean mutualContact, boolean deleted, boolean bot, boolean botChatHistory, boolean botNochats, boolean verified, boolean restricted, boolean min, boolean botInlineGeo, boolean support, boolean scam, boolean applyMinPhoto, boolean fake, boolean botAttachMenu, boolean premium, boolean attachMenuEnabled, long id, @Nullable Long accessHash, @Nullable String firstName, @Nullable String lastName, @Nullable String username, @Nullable String phone, @Nullable UserProfilePhoto photo, @Nullable UserStatus status, @Nullable Integer botInfoVersion, @Nullable List<RestrictionReason> restrictionReason, @Nullable String botInlinePlaceholder, @Nullable String langCode) {
        this.identifier = identifier;
        this.flags = flags;
        this.self = self;
        this.contact = contact;
        this.mutualContact = mutualContact;
        this.deleted = deleted;
        this.bot = bot;
        this.botChatHistory = botChatHistory;
        this.botNochats = botNochats;
        this.verified = verified;
        this.restricted = restricted;
        this.min = min;
        this.botInlineGeo = botInlineGeo;
        this.support = support;
        this.scam = scam;
        this.applyMinPhoto = applyMinPhoto;
        this.fake = fake;
        this.botAttachMenu = botAttachMenu;
        this.premium = premium;
        this.attachMenuEnabled = attachMenuEnabled;
        this.id = id;
        this.accessHash = accessHash;
        this.firstName = firstName;
        this.lastName = lastName;
        this.username = username;
        this.phone = phone;
        this.photo = photo;
        this.status = status;
        this.botInfoVersion = botInfoVersion;
        this.restrictionReason = restrictionReason;
        this.botInlinePlaceholder = botInlinePlaceholder;
        this.langCode = langCode;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseUser.super.identifier();
    }

    private int flagsInitialize() {
        return BaseUser.super.flags();
    }

    private boolean selfInitialize() {
        return BaseUser.super.self();
    }

    private boolean contactInitialize() {
        return BaseUser.super.contact();
    }

    private boolean mutualContactInitialize() {
        return BaseUser.super.mutualContact();
    }

    private boolean deletedInitialize() {
        return BaseUser.super.deleted();
    }

    private boolean botInitialize() {
        return BaseUser.super.bot();
    }

    private boolean botChatHistoryInitialize() {
        return BaseUser.super.botChatHistory();
    }

    private boolean botNochatsInitialize() {
        return BaseUser.super.botNochats();
    }

    private boolean verifiedInitialize() {
        return BaseUser.super.verified();
    }

    private boolean restrictedInitialize() {
        return BaseUser.super.restricted();
    }

    private boolean minInitialize() {
        return BaseUser.super.min();
    }

    private boolean botInlineGeoInitialize() {
        return BaseUser.super.botInlineGeo();
    }

    private boolean supportInitialize() {
        return BaseUser.super.support();
    }

    private boolean scamInitialize() {
        return BaseUser.super.scam();
    }

    private boolean applyMinPhotoInitialize() {
        return BaseUser.super.applyMinPhoto();
    }

    private boolean fakeInitialize() {
        return BaseUser.super.fake();
    }

    private boolean botAttachMenuInitialize() {
        return BaseUser.super.botAttachMenu();
    }

    private boolean premiumInitialize() {
        return BaseUser.super.premium();
    }

    private boolean attachMenuEnabledInitialize() {
        return BaseUser.super.attachMenuEnabled();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean self() {
        InitShim shim = this.initShim;
        return shim != null ? shim.self() : this.self;
    }

    @Override
    public boolean contact() {
        InitShim shim = this.initShim;
        return shim != null ? shim.contact() : this.contact;
    }

    @Override
    public boolean mutualContact() {
        InitShim shim = this.initShim;
        return shim != null ? shim.mutualContact() : this.mutualContact;
    }

    @Override
    public boolean deleted() {
        InitShim shim = this.initShim;
        return shim != null ? shim.deleted() : this.deleted;
    }

    @Override
    public boolean bot() {
        InitShim shim = this.initShim;
        return shim != null ? shim.bot() : this.bot;
    }

    @Override
    public boolean botChatHistory() {
        InitShim shim = this.initShim;
        return shim != null ? shim.botChatHistory() : this.botChatHistory;
    }

    @Override
    public boolean botNochats() {
        InitShim shim = this.initShim;
        return shim != null ? shim.botNochats() : this.botNochats;
    }

    @Override
    public boolean verified() {
        InitShim shim = this.initShim;
        return shim != null ? shim.verified() : this.verified;
    }

    @Override
    public boolean restricted() {
        InitShim shim = this.initShim;
        return shim != null ? shim.restricted() : this.restricted;
    }

    @Override
    public boolean min() {
        InitShim shim = this.initShim;
        return shim != null ? shim.min() : this.min;
    }

    @Override
    public boolean botInlineGeo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.botInlineGeo() : this.botInlineGeo;
    }

    @Override
    public boolean support() {
        InitShim shim = this.initShim;
        return shim != null ? shim.support() : this.support;
    }

    @Override
    public boolean scam() {
        InitShim shim = this.initShim;
        return shim != null ? shim.scam() : this.scam;
    }

    @Override
    public boolean applyMinPhoto() {
        InitShim shim = this.initShim;
        return shim != null ? shim.applyMinPhoto() : this.applyMinPhoto;
    }

    @Override
    public boolean fake() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fake() : this.fake;
    }

    @Override
    public boolean botAttachMenu() {
        InitShim shim = this.initShim;
        return shim != null ? shim.botAttachMenu() : this.botAttachMenu;
    }

    @Override
    public boolean premium() {
        InitShim shim = this.initShim;
        return shim != null ? shim.premium() : this.premium;
    }

    @Override
    public boolean attachMenuEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.attachMenuEnabled() : this.attachMenuEnabled;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    @Nullable
    public Long accessHash() {
        return this.accessHash;
    }

    @Override
    @Nullable
    public String firstName() {
        return this.firstName;
    }

    @Override
    @Nullable
    public String lastName() {
        return this.lastName;
    }

    @Override
    @Nullable
    public String username() {
        return this.username;
    }

    @Override
    @Nullable
    public String phone() {
        return this.phone;
    }

    @Override
    @Nullable
    public UserProfilePhoto photo() {
        return this.photo;
    }

    @Override
    @Nullable
    public UserStatus status() {
        return this.status;
    }

    @Override
    @Nullable
    public Integer botInfoVersion() {
        return this.botInfoVersion;
    }

    @Override
    @Nullable
    public List<RestrictionReason> restrictionReason() {
        return this.restrictionReason;
    }

    @Override
    @Nullable
    public String botInlinePlaceholder() {
        return this.botInlinePlaceholder;
    }

    @Override
    @Nullable
    public String langCode() {
        return this.langCode;
    }

    public final ImmutableBaseUser withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseUser(value, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, value, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withSelf(boolean value) {
        if (this.self == value) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, value, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withContact(boolean value) {
        if (this.contact == value) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, value, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withMutualContact(boolean value) {
        if (this.mutualContact == value) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, value, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withDeleted(boolean value) {
        if (this.deleted == value) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, value, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withBot(boolean value) {
        if (this.bot == value) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, value, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withBotChatHistory(boolean value) {
        if (this.botChatHistory == value) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, value, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withBotNochats(boolean value) {
        if (this.botNochats == value) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, value, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withVerified(boolean value) {
        if (this.verified == value) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, value, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withRestricted(boolean value) {
        if (this.restricted == value) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, value, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withMin(boolean value) {
        if (this.min == value) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, value, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withBotInlineGeo(boolean value) {
        if (this.botInlineGeo == value) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, value, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withSupport(boolean value) {
        if (this.support == value) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, value, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withScam(boolean value) {
        if (this.scam == value) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, value, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withApplyMinPhoto(boolean value) {
        if (this.applyMinPhoto == value) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, value, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withFake(boolean value) {
        if (this.fake == value) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, value, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withBotAttachMenu(boolean value) {
        if (this.botAttachMenu == value) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, value, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withPremium(boolean value) {
        if (this.premium == value) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, value, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withAttachMenuEnabled(boolean value) {
        if (this.attachMenuEnabled == value) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, value, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, value, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withAccessHash(@Nullable Long value) {
        if (Objects.equals(this.accessHash, value)) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, value, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withFirstName(@Nullable String value) {
        if (Objects.equals(this.firstName, value)) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, value, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withLastName(@Nullable String value) {
        if (Objects.equals(this.lastName, value)) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, value, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withUsername(@Nullable String value) {
        if (Objects.equals(this.username, value)) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, value, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withPhone(@Nullable String value) {
        if (Objects.equals(this.phone, value)) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, value, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withPhoto(@Nullable UserProfilePhoto value) {
        if (this.photo == value) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, value, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withStatus(@Nullable UserStatus value) {
        if (this.status == value) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, value, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withBotInfoVersion(@Nullable Integer value) {
        if (Objects.equals(this.botInfoVersion, value)) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, value, this.restrictionReason, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withRestrictionReason(RestrictionReason ... elements) {
        if (elements == null) {
            return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, null, this.botInlinePlaceholder, this.langCode);
        }
        List<RestrictionReason> newValue = Arrays.asList(elements) == null ? null : ImmutableBaseUser.createUnmodifiableList(false, ImmutableBaseUser.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, newValue, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withRestrictionReason(@Nullable Iterable<? extends RestrictionReason> elements) {
        if (this.restrictionReason == elements) {
            return this;
        }
        List<RestrictionReason> newValue = elements == null ? null : ImmutableBaseUser.createUnmodifiableList(false, ImmutableBaseUser.createSafeList(elements, true, false));
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, newValue, this.botInlinePlaceholder, this.langCode);
    }

    public final ImmutableBaseUser withBotInlinePlaceholder(@Nullable String value) {
        if (Objects.equals(this.botInlinePlaceholder, value)) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, value, this.langCode);
    }

    public final ImmutableBaseUser withLangCode(@Nullable String value) {
        if (Objects.equals(this.langCode, value)) {
            return this;
        }
        return new ImmutableBaseUser(this.identifier, this.flags, this.self, this.contact, this.mutualContact, this.deleted, this.bot, this.botChatHistory, this.botNochats, this.verified, this.restricted, this.min, this.botInlineGeo, this.support, this.scam, this.applyMinPhoto, this.fake, this.botAttachMenu, this.premium, this.attachMenuEnabled, this.id, this.accessHash, this.firstName, this.lastName, this.username, this.phone, this.photo, this.status, this.botInfoVersion, this.restrictionReason, this.botInlinePlaceholder, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseUser && this.equalTo(0, (ImmutableBaseUser)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseUser another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.self == another.self && this.contact == another.contact && this.mutualContact == another.mutualContact && this.deleted == another.deleted && this.bot == another.bot && this.botChatHistory == another.botChatHistory && this.botNochats == another.botNochats && this.verified == another.verified && this.restricted == another.restricted && this.min == another.min && this.botInlineGeo == another.botInlineGeo && this.support == another.support && this.scam == another.scam && this.applyMinPhoto == another.applyMinPhoto && this.fake == another.fake && this.botAttachMenu == another.botAttachMenu && this.premium == another.premium && this.attachMenuEnabled == another.attachMenuEnabled && this.id == another.id && Objects.equals(this.accessHash, another.accessHash) && Objects.equals(this.firstName, another.firstName) && Objects.equals(this.lastName, another.lastName) && Objects.equals(this.username, another.username) && Objects.equals(this.phone, another.phone) && Objects.equals(this.photo, another.photo) && Objects.equals(this.status, another.status) && Objects.equals(this.botInfoVersion, another.botInfoVersion) && Objects.equals(this.restrictionReason, another.restrictionReason) && Objects.equals(this.botInlinePlaceholder, another.botInlinePlaceholder) && Objects.equals(this.langCode, another.langCode);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.self);
        h += (h << 5) + Boolean.hashCode(this.contact);
        h += (h << 5) + Boolean.hashCode(this.mutualContact);
        h += (h << 5) + Boolean.hashCode(this.deleted);
        h += (h << 5) + Boolean.hashCode(this.bot);
        h += (h << 5) + Boolean.hashCode(this.botChatHistory);
        h += (h << 5) + Boolean.hashCode(this.botNochats);
        h += (h << 5) + Boolean.hashCode(this.verified);
        h += (h << 5) + Boolean.hashCode(this.restricted);
        h += (h << 5) + Boolean.hashCode(this.min);
        h += (h << 5) + Boolean.hashCode(this.botInlineGeo);
        h += (h << 5) + Boolean.hashCode(this.support);
        h += (h << 5) + Boolean.hashCode(this.scam);
        h += (h << 5) + Boolean.hashCode(this.applyMinPhoto);
        h += (h << 5) + Boolean.hashCode(this.fake);
        h += (h << 5) + Boolean.hashCode(this.botAttachMenu);
        h += (h << 5) + Boolean.hashCode(this.premium);
        h += (h << 5) + Boolean.hashCode(this.attachMenuEnabled);
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.accessHash);
        h += (h << 5) + Objects.hashCode(this.firstName);
        h += (h << 5) + Objects.hashCode(this.lastName);
        h += (h << 5) + Objects.hashCode(this.username);
        h += (h << 5) + Objects.hashCode(this.phone);
        h += (h << 5) + Objects.hashCode(this.photo);
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + Objects.hashCode(this.botInfoVersion);
        h += (h << 5) + Objects.hashCode(this.restrictionReason);
        h += (h << 5) + Objects.hashCode(this.botInlinePlaceholder);
        h += (h << 5) + Objects.hashCode(this.langCode);
        return h;
    }

    public String toString() {
        return "BaseUser{identifier=" + this.identifier + ", flags=" + this.flags + ", self=" + this.self + ", contact=" + this.contact + ", mutualContact=" + this.mutualContact + ", deleted=" + this.deleted + ", bot=" + this.bot + ", botChatHistory=" + this.botChatHistory + ", botNochats=" + this.botNochats + ", verified=" + this.verified + ", restricted=" + this.restricted + ", min=" + this.min + ", botInlineGeo=" + this.botInlineGeo + ", support=" + this.support + ", scam=" + this.scam + ", applyMinPhoto=" + this.applyMinPhoto + ", fake=" + this.fake + ", botAttachMenu=" + this.botAttachMenu + ", premium=" + this.premium + ", attachMenuEnabled=" + this.attachMenuEnabled + ", id=" + this.id + ", accessHash=" + this.accessHash + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", username=" + this.username + ", phone=" + this.phone + ", photo=" + this.photo + ", status=" + this.status + ", botInfoVersion=" + this.botInfoVersion + ", restrictionReason=" + this.restrictionReason + ", botInlinePlaceholder=" + this.botInlinePlaceholder + ", langCode=" + this.langCode + "}";
    }

    public static ImmutableBaseUser of(long id) {
        return new ImmutableBaseUser(id);
    }

    public static ImmutableBaseUser copyOf(BaseUser instance) {
        if (instance instanceof ImmutableBaseUser) {
            return (ImmutableBaseUser)instance;
        }
        return ImmutableBaseUser.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_SELF = 4L;
        private static final long OPT_BIT_CONTACT = 8L;
        private static final long OPT_BIT_MUTUAL_CONTACT = 16L;
        private static final long OPT_BIT_DELETED = 32L;
        private static final long OPT_BIT_BOT = 64L;
        private static final long OPT_BIT_BOT_CHAT_HISTORY = 128L;
        private static final long OPT_BIT_BOT_NOCHATS = 256L;
        private static final long OPT_BIT_VERIFIED = 512L;
        private static final long OPT_BIT_RESTRICTED = 1024L;
        private static final long OPT_BIT_MIN = 2048L;
        private static final long OPT_BIT_BOT_INLINE_GEO = 4096L;
        private static final long OPT_BIT_SUPPORT = 8192L;
        private static final long OPT_BIT_SCAM = 16384L;
        private static final long OPT_BIT_APPLY_MIN_PHOTO = 32768L;
        private static final long OPT_BIT_FAKE = 65536L;
        private static final long OPT_BIT_BOT_ATTACH_MENU = 131072L;
        private static final long OPT_BIT_PREMIUM = 262144L;
        private static final long OPT_BIT_ATTACH_MENU_ENABLED = 524288L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean self;
        private boolean contact;
        private boolean mutualContact;
        private boolean deleted;
        private boolean bot;
        private boolean botChatHistory;
        private boolean botNochats;
        private boolean verified;
        private boolean restricted;
        private boolean min;
        private boolean botInlineGeo;
        private boolean support;
        private boolean scam;
        private boolean applyMinPhoto;
        private boolean fake;
        private boolean botAttachMenu;
        private boolean premium;
        private boolean attachMenuEnabled;
        private long id;
        private Long accessHash;
        private String firstName;
        private String lastName;
        private String username;
        private String phone;
        private UserProfilePhoto photo;
        private UserStatus status;
        private Integer botInfoVersion;
        private List<RestrictionReason> restrictionReason = null;
        private String botInlinePlaceholder;
        private String langCode;

        private Builder() {
        }

        public final Builder from(BaseUser instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(User instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            User instance;
            long bits = 0L;
            if (object instanceof BaseUser) {
                UserStatus statusValue;
                Integer botInfoVersionValue;
                instance = (BaseUser)object;
                this.botChatHistory(instance.botChatHistory());
                String lastNameValue = instance.lastName();
                if (lastNameValue != null) {
                    this.lastName(lastNameValue);
                }
                this.attachMenuEnabled(instance.attachMenuEnabled());
                this.bot(instance.bot());
                String langCodeValue = instance.langCode();
                if (langCodeValue != null) {
                    this.langCode(langCodeValue);
                }
                this.flags(instance.flags());
                this.scam(instance.scam());
                List<RestrictionReason> restrictionReasonValue = instance.restrictionReason();
                if (restrictionReasonValue != null) {
                    this.addAllRestrictionReason(restrictionReasonValue);
                }
                if ((botInfoVersionValue = instance.botInfoVersion()) != null) {
                    this.botInfoVersion(botInfoVersionValue);
                }
                this.min(instance.min());
                this.premium(instance.premium());
                this.contact(instance.contact());
                String botInlinePlaceholderValue = instance.botInlinePlaceholder();
                if (botInlinePlaceholderValue != null) {
                    this.botInlinePlaceholder(botInlinePlaceholderValue);
                }
                if ((bits & 1L) == 0L) {
                    this.id(instance.id());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
                this.botAttachMenu(instance.botAttachMenu());
                this.mutualContact(instance.mutualContact());
                this.verified(instance.verified());
                UserProfilePhoto photoValue = instance.photo();
                if (photoValue != null) {
                    this.photo(photoValue);
                }
                this.botInlineGeo(instance.botInlineGeo());
                String firstNameValue = instance.firstName();
                if (firstNameValue != null) {
                    this.firstName(firstNameValue);
                }
                this.deleted(instance.deleted());
                String phoneValue = instance.phone();
                if (phoneValue != null) {
                    this.phone(phoneValue);
                }
                this.botNochats(instance.botNochats());
                this.restricted(instance.restricted());
                this.applyMinPhoto(instance.applyMinPhoto());
                this.self(instance.self());
                this.fake(instance.fake());
                Long accessHashValue = instance.accessHash();
                if (accessHashValue != null) {
                    this.accessHash(accessHashValue);
                }
                this.support(instance.support());
                String usernameValue = instance.username();
                if (usernameValue != null) {
                    this.username(usernameValue);
                }
                if ((statusValue = instance.status()) != null) {
                    this.status(statusValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
            }
            if (object instanceof User) {
                instance = (User)object;
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.id(instance.id());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder self(boolean self) {
            this.self = self;
            this.optBits |= 4L;
            return this;
        }

        public final Builder contact(boolean contact) {
            this.contact = contact;
            this.optBits |= 8L;
            return this;
        }

        public final Builder mutualContact(boolean mutualContact) {
            this.mutualContact = mutualContact;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder deleted(boolean deleted) {
            this.deleted = deleted;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder bot(boolean bot) {
            this.bot = bot;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder botChatHistory(boolean botChatHistory) {
            this.botChatHistory = botChatHistory;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder botNochats(boolean botNochats) {
            this.botNochats = botNochats;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder verified(boolean verified) {
            this.verified = verified;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder restricted(boolean restricted) {
            this.restricted = restricted;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder min(boolean min) {
            this.min = min;
            this.optBits |= 0x800L;
            return this;
        }

        public final Builder botInlineGeo(boolean botInlineGeo) {
            this.botInlineGeo = botInlineGeo;
            this.optBits |= 0x1000L;
            return this;
        }

        public final Builder support(boolean support) {
            this.support = support;
            this.optBits |= 0x2000L;
            return this;
        }

        public final Builder scam(boolean scam) {
            this.scam = scam;
            this.optBits |= 0x4000L;
            return this;
        }

        public final Builder applyMinPhoto(boolean applyMinPhoto) {
            this.applyMinPhoto = applyMinPhoto;
            this.optBits |= 0x8000L;
            return this;
        }

        public final Builder fake(boolean fake) {
            this.fake = fake;
            this.optBits |= 0x10000L;
            return this;
        }

        public final Builder botAttachMenu(boolean botAttachMenu) {
            this.botAttachMenu = botAttachMenu;
            this.optBits |= 0x20000L;
            return this;
        }

        public final Builder premium(boolean premium) {
            this.premium = premium;
            this.optBits |= 0x40000L;
            return this;
        }

        public final Builder attachMenuEnabled(boolean attachMenuEnabled) {
            this.attachMenuEnabled = attachMenuEnabled;
            this.optBits |= 0x80000L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(@Nullable Long accessHash) {
            this.accessHash = accessHash;
            return this;
        }

        public final Builder firstName(@Nullable String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final Builder lastName(@Nullable String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final Builder username(@Nullable String username) {
            this.username = username;
            return this;
        }

        public final Builder phone(@Nullable String phone) {
            this.phone = phone;
            return this;
        }

        public final Builder photo(@Nullable UserProfilePhoto photo) {
            this.photo = photo;
            return this;
        }

        public final Builder status(@Nullable UserStatus status) {
            this.status = status;
            return this;
        }

        public final Builder botInfoVersion(@Nullable Integer botInfoVersion) {
            this.botInfoVersion = botInfoVersion;
            return this;
        }

        public final Builder addRestrictionReason(RestrictionReason element) {
            if (this.restrictionReason == null) {
                this.restrictionReason = new ArrayList<RestrictionReason>();
            }
            this.restrictionReason.add(Objects.requireNonNull(element, "restrictionReason element"));
            return this;
        }

        public final Builder addRestrictionReason(RestrictionReason ... elements) {
            if (this.restrictionReason == null) {
                this.restrictionReason = new ArrayList<RestrictionReason>();
            }
            for (RestrictionReason element : elements) {
                this.restrictionReason.add(Objects.requireNonNull(element, "restrictionReason element"));
            }
            return this;
        }

        public final Builder restrictionReason(@Nullable Iterable<? extends RestrictionReason> elements) {
            if (elements == null) {
                this.restrictionReason = null;
                return this;
            }
            this.restrictionReason = new ArrayList<RestrictionReason>();
            return this.addAllRestrictionReason(elements);
        }

        public final Builder addAllRestrictionReason(Iterable<? extends RestrictionReason> elements) {
            Objects.requireNonNull(elements, "restrictionReason element");
            if (this.restrictionReason == null) {
                this.restrictionReason = new ArrayList<RestrictionReason>();
            }
            for (RestrictionReason restrictionReason : elements) {
                this.restrictionReason.add(Objects.requireNonNull(restrictionReason, "restrictionReason element"));
            }
            return this;
        }

        public final Builder botInlinePlaceholder(@Nullable String botInlinePlaceholder) {
            this.botInlinePlaceholder = botInlinePlaceholder;
            return this;
        }

        public final Builder langCode(@Nullable String langCode) {
            this.langCode = langCode;
            return this;
        }

        public ImmutableBaseUser build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseUser(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean selfIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean contactIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean mutualContactIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean deletedIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean botIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean botChatHistoryIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean botNochatsIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean verifiedIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean restrictedIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean minIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private boolean botInlineGeoIsSet() {
            return (this.optBits & 0x1000L) != 0L;
        }

        private boolean supportIsSet() {
            return (this.optBits & 0x2000L) != 0L;
        }

        private boolean scamIsSet() {
            return (this.optBits & 0x4000L) != 0L;
        }

        private boolean applyMinPhotoIsSet() {
            return (this.optBits & 0x8000L) != 0L;
        }

        private boolean fakeIsSet() {
            return (this.optBits & 0x10000L) != 0L;
        }

        private boolean botAttachMenuIsSet() {
            return (this.optBits & 0x20000L) != 0L;
        }

        private boolean premiumIsSet() {
            return (this.optBits & 0x40000L) != 0L;
        }

        private boolean attachMenuEnabledIsSet() {
            return (this.optBits & 0x80000L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build BaseUser, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte selfBuildStage = 0;
        private boolean self;
        private byte contactBuildStage = 0;
        private boolean contact;
        private byte mutualContactBuildStage = 0;
        private boolean mutualContact;
        private byte deletedBuildStage = 0;
        private boolean deleted;
        private byte botBuildStage = 0;
        private boolean bot;
        private byte botChatHistoryBuildStage = 0;
        private boolean botChatHistory;
        private byte botNochatsBuildStage = 0;
        private boolean botNochats;
        private byte verifiedBuildStage = 0;
        private boolean verified;
        private byte restrictedBuildStage = 0;
        private boolean restricted;
        private byte minBuildStage = 0;
        private boolean min;
        private byte botInlineGeoBuildStage = 0;
        private boolean botInlineGeo;
        private byte supportBuildStage = 0;
        private boolean support;
        private byte scamBuildStage = 0;
        private boolean scam;
        private byte applyMinPhotoBuildStage = 0;
        private boolean applyMinPhoto;
        private byte fakeBuildStage = 0;
        private boolean fake;
        private byte botAttachMenuBuildStage = 0;
        private boolean botAttachMenu;
        private byte premiumBuildStage = 0;
        private boolean premium;
        private byte attachMenuEnabledBuildStage = 0;
        private boolean attachMenuEnabled;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseUser.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBaseUser.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean self() {
            if (this.selfBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.selfBuildStage == 0) {
                this.selfBuildStage = (byte)-1;
                this.self = ImmutableBaseUser.this.selfInitialize();
                this.selfBuildStage = 1;
            }
            return this.self;
        }

        void self(boolean self) {
            this.self = self;
            this.selfBuildStage = 1;
        }

        boolean contact() {
            if (this.contactBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.contactBuildStage == 0) {
                this.contactBuildStage = (byte)-1;
                this.contact = ImmutableBaseUser.this.contactInitialize();
                this.contactBuildStage = 1;
            }
            return this.contact;
        }

        void contact(boolean contact) {
            this.contact = contact;
            this.contactBuildStage = 1;
        }

        boolean mutualContact() {
            if (this.mutualContactBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.mutualContactBuildStage == 0) {
                this.mutualContactBuildStage = (byte)-1;
                this.mutualContact = ImmutableBaseUser.this.mutualContactInitialize();
                this.mutualContactBuildStage = 1;
            }
            return this.mutualContact;
        }

        void mutualContact(boolean mutualContact) {
            this.mutualContact = mutualContact;
            this.mutualContactBuildStage = 1;
        }

        boolean deleted() {
            if (this.deletedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.deletedBuildStage == 0) {
                this.deletedBuildStage = (byte)-1;
                this.deleted = ImmutableBaseUser.this.deletedInitialize();
                this.deletedBuildStage = 1;
            }
            return this.deleted;
        }

        void deleted(boolean deleted) {
            this.deleted = deleted;
            this.deletedBuildStage = 1;
        }

        boolean bot() {
            if (this.botBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.botBuildStage == 0) {
                this.botBuildStage = (byte)-1;
                this.bot = ImmutableBaseUser.this.botInitialize();
                this.botBuildStage = 1;
            }
            return this.bot;
        }

        void bot(boolean bot) {
            this.bot = bot;
            this.botBuildStage = 1;
        }

        boolean botChatHistory() {
            if (this.botChatHistoryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.botChatHistoryBuildStage == 0) {
                this.botChatHistoryBuildStage = (byte)-1;
                this.botChatHistory = ImmutableBaseUser.this.botChatHistoryInitialize();
                this.botChatHistoryBuildStage = 1;
            }
            return this.botChatHistory;
        }

        void botChatHistory(boolean botChatHistory) {
            this.botChatHistory = botChatHistory;
            this.botChatHistoryBuildStage = 1;
        }

        boolean botNochats() {
            if (this.botNochatsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.botNochatsBuildStage == 0) {
                this.botNochatsBuildStage = (byte)-1;
                this.botNochats = ImmutableBaseUser.this.botNochatsInitialize();
                this.botNochatsBuildStage = 1;
            }
            return this.botNochats;
        }

        void botNochats(boolean botNochats) {
            this.botNochats = botNochats;
            this.botNochatsBuildStage = 1;
        }

        boolean verified() {
            if (this.verifiedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.verifiedBuildStage == 0) {
                this.verifiedBuildStage = (byte)-1;
                this.verified = ImmutableBaseUser.this.verifiedInitialize();
                this.verifiedBuildStage = 1;
            }
            return this.verified;
        }

        void verified(boolean verified) {
            this.verified = verified;
            this.verifiedBuildStage = 1;
        }

        boolean restricted() {
            if (this.restrictedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.restrictedBuildStage == 0) {
                this.restrictedBuildStage = (byte)-1;
                this.restricted = ImmutableBaseUser.this.restrictedInitialize();
                this.restrictedBuildStage = 1;
            }
            return this.restricted;
        }

        void restricted(boolean restricted) {
            this.restricted = restricted;
            this.restrictedBuildStage = 1;
        }

        boolean min() {
            if (this.minBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBuildStage == 0) {
                this.minBuildStage = (byte)-1;
                this.min = ImmutableBaseUser.this.minInitialize();
                this.minBuildStage = 1;
            }
            return this.min;
        }

        void min(boolean min) {
            this.min = min;
            this.minBuildStage = 1;
        }

        boolean botInlineGeo() {
            if (this.botInlineGeoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.botInlineGeoBuildStage == 0) {
                this.botInlineGeoBuildStage = (byte)-1;
                this.botInlineGeo = ImmutableBaseUser.this.botInlineGeoInitialize();
                this.botInlineGeoBuildStage = 1;
            }
            return this.botInlineGeo;
        }

        void botInlineGeo(boolean botInlineGeo) {
            this.botInlineGeo = botInlineGeo;
            this.botInlineGeoBuildStage = 1;
        }

        boolean support() {
            if (this.supportBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.supportBuildStage == 0) {
                this.supportBuildStage = (byte)-1;
                this.support = ImmutableBaseUser.this.supportInitialize();
                this.supportBuildStage = 1;
            }
            return this.support;
        }

        void support(boolean support) {
            this.support = support;
            this.supportBuildStage = 1;
        }

        boolean scam() {
            if (this.scamBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.scamBuildStage == 0) {
                this.scamBuildStage = (byte)-1;
                this.scam = ImmutableBaseUser.this.scamInitialize();
                this.scamBuildStage = 1;
            }
            return this.scam;
        }

        void scam(boolean scam) {
            this.scam = scam;
            this.scamBuildStage = 1;
        }

        boolean applyMinPhoto() {
            if (this.applyMinPhotoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.applyMinPhotoBuildStage == 0) {
                this.applyMinPhotoBuildStage = (byte)-1;
                this.applyMinPhoto = ImmutableBaseUser.this.applyMinPhotoInitialize();
                this.applyMinPhotoBuildStage = 1;
            }
            return this.applyMinPhoto;
        }

        void applyMinPhoto(boolean applyMinPhoto) {
            this.applyMinPhoto = applyMinPhoto;
            this.applyMinPhotoBuildStage = 1;
        }

        boolean fake() {
            if (this.fakeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fakeBuildStage == 0) {
                this.fakeBuildStage = (byte)-1;
                this.fake = ImmutableBaseUser.this.fakeInitialize();
                this.fakeBuildStage = 1;
            }
            return this.fake;
        }

        void fake(boolean fake) {
            this.fake = fake;
            this.fakeBuildStage = 1;
        }

        boolean botAttachMenu() {
            if (this.botAttachMenuBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.botAttachMenuBuildStage == 0) {
                this.botAttachMenuBuildStage = (byte)-1;
                this.botAttachMenu = ImmutableBaseUser.this.botAttachMenuInitialize();
                this.botAttachMenuBuildStage = 1;
            }
            return this.botAttachMenu;
        }

        void botAttachMenu(boolean botAttachMenu) {
            this.botAttachMenu = botAttachMenu;
            this.botAttachMenuBuildStage = 1;
        }

        boolean premium() {
            if (this.premiumBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.premiumBuildStage == 0) {
                this.premiumBuildStage = (byte)-1;
                this.premium = ImmutableBaseUser.this.premiumInitialize();
                this.premiumBuildStage = 1;
            }
            return this.premium;
        }

        void premium(boolean premium) {
            this.premium = premium;
            this.premiumBuildStage = 1;
        }

        boolean attachMenuEnabled() {
            if (this.attachMenuEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.attachMenuEnabledBuildStage == 0) {
                this.attachMenuEnabledBuildStage = (byte)-1;
                this.attachMenuEnabled = ImmutableBaseUser.this.attachMenuEnabledInitialize();
                this.attachMenuEnabledBuildStage = 1;
            }
            return this.attachMenuEnabled;
        }

        void attachMenuEnabled(boolean attachMenuEnabled) {
            this.attachMenuEnabled = attachMenuEnabled;
            this.attachMenuEnabledBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.selfBuildStage == -1) {
                attributes.add("self");
            }
            if (this.contactBuildStage == -1) {
                attributes.add("contact");
            }
            if (this.mutualContactBuildStage == -1) {
                attributes.add("mutualContact");
            }
            if (this.deletedBuildStage == -1) {
                attributes.add("deleted");
            }
            if (this.botBuildStage == -1) {
                attributes.add("bot");
            }
            if (this.botChatHistoryBuildStage == -1) {
                attributes.add("botChatHistory");
            }
            if (this.botNochatsBuildStage == -1) {
                attributes.add("botNochats");
            }
            if (this.verifiedBuildStage == -1) {
                attributes.add("verified");
            }
            if (this.restrictedBuildStage == -1) {
                attributes.add("restricted");
            }
            if (this.minBuildStage == -1) {
                attributes.add("min");
            }
            if (this.botInlineGeoBuildStage == -1) {
                attributes.add("botInlineGeo");
            }
            if (this.supportBuildStage == -1) {
                attributes.add("support");
            }
            if (this.scamBuildStage == -1) {
                attributes.add("scam");
            }
            if (this.applyMinPhotoBuildStage == -1) {
                attributes.add("applyMinPhoto");
            }
            if (this.fakeBuildStage == -1) {
                attributes.add("fake");
            }
            if (this.botAttachMenuBuildStage == -1) {
                attributes.add("botAttachMenu");
            }
            if (this.premiumBuildStage == -1) {
                attributes.add("premium");
            }
            if (this.attachMenuEnabledBuildStage == -1) {
                attributes.add("attachMenuEnabled");
            }
            return "Cannot build BaseUser, attribute initializers form cycle " + attributes;
        }
    }
}

