/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BaseUserProfilePhoto;
import telegram4j.tl.ChatPhotoFields;
import telegram4j.tl.UserProfilePhoto;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseUserProfilePhoto
implements BaseUserProfilePhoto {
    private final int identifier;
    private final int flags;
    private final boolean hasVideo;
    private final long photoId;
    private final ByteBuf strippedThumb;
    private final int dcId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseUserProfilePhoto(long photoId, int dcId) {
        this.photoId = photoId;
        this.dcId = dcId;
        this.strippedThumb = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.hasVideo = this.initShim.hasVideo();
        this.initShim = null;
    }

    private ImmutableBaseUserProfilePhoto(Builder builder) {
        this.photoId = builder.photoId;
        this.strippedThumb = builder.strippedThumb_build();
        this.dcId = builder.dcId;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.hasVideoIsSet()) {
            this.initShim.hasVideo(builder.hasVideo);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.hasVideo = this.initShim.hasVideo();
        this.initShim = null;
    }

    private ImmutableBaseUserProfilePhoto(int identifier, int flags, boolean hasVideo, long photoId, ByteBuf strippedThumb, int dcId) {
        this.identifier = identifier;
        this.flags = flags;
        this.hasVideo = hasVideo;
        this.photoId = photoId;
        this.strippedThumb = strippedThumb;
        this.dcId = dcId;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseUserProfilePhoto.super.identifier();
    }

    private int flagsInitialize() {
        return BaseUserProfilePhoto.super.flags();
    }

    private boolean hasVideoInitialize() {
        return BaseUserProfilePhoto.super.hasVideo();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean hasVideo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasVideo() : this.hasVideo;
    }

    @Override
    public long photoId() {
        return this.photoId;
    }

    @Override
    public Optional<ByteBuf> strippedThumb() {
        return Optional.ofNullable(this.strippedThumb).map(ByteBuf::duplicate);
    }

    @Override
    public int dcId() {
        return this.dcId;
    }

    public final ImmutableBaseUserProfilePhoto withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseUserProfilePhoto(value, this.flags, this.hasVideo, this.photoId, this.strippedThumb, this.dcId);
    }

    public final ImmutableBaseUserProfilePhoto withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBaseUserProfilePhoto(this.identifier, value, this.hasVideo, this.photoId, this.strippedThumb, this.dcId);
    }

    public final ImmutableBaseUserProfilePhoto withHasVideo(boolean value) {
        if (this.hasVideo == value) {
            return this;
        }
        return new ImmutableBaseUserProfilePhoto(this.identifier, this.flags, value, this.photoId, this.strippedThumb, this.dcId);
    }

    public final ImmutableBaseUserProfilePhoto withPhotoId(long value) {
        if (this.photoId == value) {
            return this;
        }
        return new ImmutableBaseUserProfilePhoto(this.identifier, this.flags, this.hasVideo, value, this.strippedThumb, this.dcId);
    }

    public ImmutableBaseUserProfilePhoto withStrippedThumb(Optional<ByteBuf> value) {
        ByteBuf newValue = value.map(TlEncodingUtil::copyAsUnpooled).orElse(null);
        if (this.strippedThumb == newValue) {
            return this;
        }
        return new ImmutableBaseUserProfilePhoto(this.identifier, this.flags, this.hasVideo, this.photoId, newValue, this.dcId);
    }

    public ImmutableBaseUserProfilePhoto withStrippedThumb(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.strippedThumb == newValue) {
            return this;
        }
        return new ImmutableBaseUserProfilePhoto(this.identifier, this.flags, this.hasVideo, this.photoId, newValue, this.dcId);
    }

    public final ImmutableBaseUserProfilePhoto withDcId(int value) {
        if (this.dcId == value) {
            return this;
        }
        return new ImmutableBaseUserProfilePhoto(this.identifier, this.flags, this.hasVideo, this.photoId, this.strippedThumb, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseUserProfilePhoto && this.equalTo(0, (ImmutableBaseUserProfilePhoto)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseUserProfilePhoto another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.hasVideo == another.hasVideo && this.photoId == another.photoId && this.strippedThumb().equals(another.strippedThumb()) && this.dcId == another.dcId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.hasVideo);
        h += (h << 5) + Long.hashCode(this.photoId);
        h += (h << 5) + this.strippedThumb().hashCode();
        h += (h << 5) + this.dcId;
        return h;
    }

    public String toString() {
        return "BaseUserProfilePhoto{identifier=" + this.identifier + ", flags=" + this.flags + ", hasVideo=" + this.hasVideo + ", photoId=" + this.photoId + ", strippedThumb=" + this.strippedThumb().map(ByteBufUtil::hexDump).toString() + ", dcId=" + this.dcId + "}";
    }

    public static ImmutableBaseUserProfilePhoto of(long photoId, int dcId) {
        return new ImmutableBaseUserProfilePhoto(photoId, dcId);
    }

    public static ImmutableBaseUserProfilePhoto copyOf(BaseUserProfilePhoto instance) {
        if (instance instanceof ImmutableBaseUserProfilePhoto) {
            return (ImmutableBaseUserProfilePhoto)instance;
        }
        return ImmutableBaseUserProfilePhoto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PHOTO_ID = 1L;
        private static final long INIT_BIT_DC_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_HAS_VIDEO = 4L;
        private long initBits = 3L;
        private long optBits;
        private ByteBuf strippedThumb_value = null;
        private int identifier;
        private int flags;
        private boolean hasVideo;
        private long photoId;
        private int dcId;

        private Builder() {
        }

        public final Builder from(ChatPhotoFields instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseUserProfilePhoto instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UserProfilePhoto instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof ChatPhotoFields) {
                instance = (ChatPhotoFields)object;
                if ((bits & 1L) == 0L) {
                    this.hasVideo(instance.hasVideo());
                    bits |= 1L;
                }
                if ((bits & 8L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 8L;
                }
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.photoId(instance.photoId());
                    bits |= 0x10L;
                }
                if ((bits & 4L) == 0L) {
                    this.dcId(instance.dcId());
                    bits |= 4L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.strippedThumb(instance.strippedThumb());
                    bits |= 0x20L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
            }
            if (object instanceof BaseUserProfilePhoto) {
                instance = (BaseUserProfilePhoto)object;
                if ((bits & 1L) == 0L) {
                    this.hasVideo(instance.hasVideo());
                    bits |= 1L;
                }
                if ((bits & 8L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 8L;
                }
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.photoId(instance.photoId());
                    bits |= 0x10L;
                }
                if ((bits & 4L) == 0L) {
                    this.dcId(instance.dcId());
                    bits |= 4L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.strippedThumb(instance.strippedThumb());
                    bits |= 0x20L;
                }
            }
            if (object instanceof UserProfilePhoto) {
                instance = (UserProfilePhoto)object;
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder hasVideo(boolean hasVideo) {
            this.hasVideo = hasVideo;
            this.optBits |= 4L;
            return this;
        }

        public final Builder photoId(long photoId) {
            this.photoId = photoId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder strippedThumb(@Nullable ByteBuf value) {
            this.strippedThumb_value = value != null ? TlEncodingUtil.copyAsUnpooled((ByteBuf)value) : null;
            return this;
        }

        public Builder strippedThumb(Optional<ByteBuf> value) {
            this.strippedThumb_value = value.map(TlEncodingUtil::copyAsUnpooled).orElse(null);
            return this;
        }

        public final Builder dcId(int dcId) {
            this.dcId = dcId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBaseUserProfilePhoto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseUserProfilePhoto(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean hasVideoIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("photoId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("dcId");
            }
            return "Cannot build BaseUserProfilePhoto, some of required attributes are not set " + attributes;
        }

        private ByteBuf strippedThumb_build() {
            return this.strippedThumb_value;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte hasVideoBuildStage = 0;
        private boolean hasVideo;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseUserProfilePhoto.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBaseUserProfilePhoto.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean hasVideo() {
            if (this.hasVideoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasVideoBuildStage == 0) {
                this.hasVideoBuildStage = (byte)-1;
                this.hasVideo = ImmutableBaseUserProfilePhoto.this.hasVideoInitialize();
                this.hasVideoBuildStage = 1;
            }
            return this.hasVideo;
        }

        void hasVideo(boolean hasVideo) {
            this.hasVideo = hasVideo;
            this.hasVideoBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.hasVideoBuildStage == -1) {
                attributes.add("hasVideo");
            }
            return "Cannot build BaseUserProfilePhoto, attribute initializers form cycle " + attributes;
        }
    }
}

