/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BaseWallPaper;
import telegram4j.tl.Document;
import telegram4j.tl.WallPaper;
import telegram4j.tl.WallPaperSettings;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseWallPaper
implements BaseWallPaper {
    private final int identifier;
    private final long id;
    private final int flags;
    private final boolean creator;
    private final boolean isDefault;
    private final boolean pattern;
    private final boolean dark;
    private final long accessHash;
    private final String slug;
    private final Document document;
    @Nullable
    private final WallPaperSettings settings;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseWallPaper(long id, long accessHash, String slug, Document document) {
        this.id = id;
        this.accessHash = accessHash;
        this.slug = Objects.requireNonNull(slug, "slug");
        this.document = Objects.requireNonNull(document, "document");
        this.settings = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.creator = this.initShim.creator();
        this.isDefault = this.initShim.isDefault();
        this.pattern = this.initShim.pattern();
        this.dark = this.initShim.dark();
        this.initShim = null;
    }

    private ImmutableBaseWallPaper(Builder builder) {
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.slug = builder.slug;
        this.document = builder.document;
        this.settings = builder.settings;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.creatorIsSet()) {
            this.initShim.creator(builder.creator);
        }
        if (builder.isDefaultIsSet()) {
            this.initShim.isDefault(builder.isDefault);
        }
        if (builder.patternIsSet()) {
            this.initShim.pattern(builder.pattern);
        }
        if (builder.darkIsSet()) {
            this.initShim.dark(builder.dark);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.creator = this.initShim.creator();
        this.isDefault = this.initShim.isDefault();
        this.pattern = this.initShim.pattern();
        this.dark = this.initShim.dark();
        this.initShim = null;
    }

    private ImmutableBaseWallPaper(int identifier, long id, int flags, boolean creator, boolean isDefault, boolean pattern, boolean dark, long accessHash, String slug, Document document, @Nullable WallPaperSettings settings) {
        this.identifier = identifier;
        this.id = id;
        this.flags = flags;
        this.creator = creator;
        this.isDefault = isDefault;
        this.pattern = pattern;
        this.dark = dark;
        this.accessHash = accessHash;
        this.slug = slug;
        this.document = document;
        this.settings = settings;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseWallPaper.super.identifier();
    }

    private int flagsInitialize() {
        return BaseWallPaper.super.flags();
    }

    private boolean creatorInitialize() {
        return BaseWallPaper.super.creator();
    }

    private boolean isDefaultInitialize() {
        return BaseWallPaper.super.isDefault();
    }

    private boolean patternInitialize() {
        return BaseWallPaper.super.pattern();
    }

    private boolean darkInitialize() {
        return BaseWallPaper.super.dark();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean creator() {
        InitShim shim = this.initShim;
        return shim != null ? shim.creator() : this.creator;
    }

    @Override
    public boolean isDefault() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isDefault() : this.isDefault;
    }

    @Override
    public boolean pattern() {
        InitShim shim = this.initShim;
        return shim != null ? shim.pattern() : this.pattern;
    }

    @Override
    public boolean dark() {
        InitShim shim = this.initShim;
        return shim != null ? shim.dark() : this.dark;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    @Override
    public String slug() {
        return this.slug;
    }

    @Override
    public Document document() {
        return this.document;
    }

    @Override
    @Nullable
    public WallPaperSettings settings() {
        return this.settings;
    }

    public final ImmutableBaseWallPaper withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseWallPaper(value, this.id, this.flags, this.creator, this.isDefault, this.pattern, this.dark, this.accessHash, this.slug, this.document, this.settings);
    }

    public final ImmutableBaseWallPaper withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableBaseWallPaper(this.identifier, value, this.flags, this.creator, this.isDefault, this.pattern, this.dark, this.accessHash, this.slug, this.document, this.settings);
    }

    public final ImmutableBaseWallPaper withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBaseWallPaper(this.identifier, this.id, value, this.creator, this.isDefault, this.pattern, this.dark, this.accessHash, this.slug, this.document, this.settings);
    }

    public final ImmutableBaseWallPaper withCreator(boolean value) {
        if (this.creator == value) {
            return this;
        }
        return new ImmutableBaseWallPaper(this.identifier, this.id, this.flags, value, this.isDefault, this.pattern, this.dark, this.accessHash, this.slug, this.document, this.settings);
    }

    public final ImmutableBaseWallPaper withIsDefault(boolean value) {
        if (this.isDefault == value) {
            return this;
        }
        return new ImmutableBaseWallPaper(this.identifier, this.id, this.flags, this.creator, value, this.pattern, this.dark, this.accessHash, this.slug, this.document, this.settings);
    }

    public final ImmutableBaseWallPaper withPattern(boolean value) {
        if (this.pattern == value) {
            return this;
        }
        return new ImmutableBaseWallPaper(this.identifier, this.id, this.flags, this.creator, this.isDefault, value, this.dark, this.accessHash, this.slug, this.document, this.settings);
    }

    public final ImmutableBaseWallPaper withDark(boolean value) {
        if (this.dark == value) {
            return this;
        }
        return new ImmutableBaseWallPaper(this.identifier, this.id, this.flags, this.creator, this.isDefault, this.pattern, value, this.accessHash, this.slug, this.document, this.settings);
    }

    public final ImmutableBaseWallPaper withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableBaseWallPaper(this.identifier, this.id, this.flags, this.creator, this.isDefault, this.pattern, this.dark, value, this.slug, this.document, this.settings);
    }

    public final ImmutableBaseWallPaper withSlug(String value) {
        String newValue = Objects.requireNonNull(value, "slug");
        if (this.slug.equals(newValue)) {
            return this;
        }
        return new ImmutableBaseWallPaper(this.identifier, this.id, this.flags, this.creator, this.isDefault, this.pattern, this.dark, this.accessHash, newValue, this.document, this.settings);
    }

    public final ImmutableBaseWallPaper withDocument(Document value) {
        if (this.document == value) {
            return this;
        }
        Document newValue = Objects.requireNonNull(value, "document");
        return new ImmutableBaseWallPaper(this.identifier, this.id, this.flags, this.creator, this.isDefault, this.pattern, this.dark, this.accessHash, this.slug, newValue, this.settings);
    }

    public final ImmutableBaseWallPaper withSettings(@Nullable WallPaperSettings value) {
        if (this.settings == value) {
            return this;
        }
        return new ImmutableBaseWallPaper(this.identifier, this.id, this.flags, this.creator, this.isDefault, this.pattern, this.dark, this.accessHash, this.slug, this.document, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseWallPaper && this.equalTo(0, (ImmutableBaseWallPaper)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseWallPaper another) {
        return this.identifier == another.identifier && this.id == another.id && this.flags == another.flags && this.creator == another.creator && this.isDefault == another.isDefault && this.pattern == another.pattern && this.dark == another.dark && this.accessHash == another.accessHash && this.slug.equals(another.slug) && this.document.equals(another.document) && Objects.equals(this.settings, another.settings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.creator);
        h += (h << 5) + Boolean.hashCode(this.isDefault);
        h += (h << 5) + Boolean.hashCode(this.pattern);
        h += (h << 5) + Boolean.hashCode(this.dark);
        h += (h << 5) + Long.hashCode(this.accessHash);
        h += (h << 5) + this.slug.hashCode();
        h += (h << 5) + this.document.hashCode();
        h += (h << 5) + Objects.hashCode(this.settings);
        return h;
    }

    public String toString() {
        return "BaseWallPaper{identifier=" + this.identifier + ", id=" + this.id + ", flags=" + this.flags + ", creator=" + this.creator + ", isDefault=" + this.isDefault + ", pattern=" + this.pattern + ", dark=" + this.dark + ", accessHash=" + this.accessHash + ", slug=" + this.slug + ", document=" + this.document + ", settings=" + this.settings + "}";
    }

    public static ImmutableBaseWallPaper of(long id, long accessHash, String slug, Document document) {
        return new ImmutableBaseWallPaper(id, accessHash, slug, document);
    }

    public static ImmutableBaseWallPaper copyOf(BaseWallPaper instance) {
        if (instance instanceof ImmutableBaseWallPaper) {
            return (ImmutableBaseWallPaper)instance;
        }
        return ImmutableBaseWallPaper.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long INIT_BIT_SLUG = 4L;
        private static final long INIT_BIT_DOCUMENT = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_CREATOR = 4L;
        private static final long OPT_BIT_IS_DEFAULT = 8L;
        private static final long OPT_BIT_PATTERN = 16L;
        private static final long OPT_BIT_DARK = 32L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private long id;
        private int flags;
        private boolean creator;
        private boolean isDefault;
        private boolean pattern;
        private boolean dark;
        private long accessHash;
        private String slug;
        private Document document;
        private WallPaperSettings settings;

        private Builder() {
        }

        public final Builder from(BaseWallPaper instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WallPaper instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            WallPaperSettings settingsValue;
            WallPaper instance;
            long bits = 0L;
            if (object instanceof BaseWallPaper) {
                instance = (BaseWallPaper)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    settingsValue = instance.settings();
                    if (settingsValue != null) {
                        this.settings(settingsValue);
                    }
                    bits |= 2L;
                }
                this.creator(instance.creator());
                if ((bits & 4L) == 0L) {
                    this.isDefault(instance.isDefault());
                    bits |= 4L;
                }
                this.document(instance.document());
                if ((bits & 8L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 8L;
                }
                this.pattern(instance.pattern());
                if ((bits & 0x10L) == 0L) {
                    this.dark(instance.dark());
                    bits |= 0x10L;
                }
                this.accessHash(instance.accessHash());
                if ((bits & 0x20L) == 0L) {
                    this.id(instance.id());
                    bits |= 0x20L;
                }
                this.slug(instance.slug());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof WallPaper) {
                instance = (WallPaper)object;
                if ((bits & 8L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.dark(instance.dark());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    settingsValue = instance.settings();
                    if (settingsValue != null) {
                        this.settings(settingsValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.isDefault(instance.isDefault());
                    bits |= 4L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.id(instance.id());
                    bits |= 0x20L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder creator(boolean creator) {
            this.creator = creator;
            this.optBits |= 4L;
            return this;
        }

        public final Builder isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            this.optBits |= 8L;
            return this;
        }

        public final Builder pattern(boolean pattern) {
            this.pattern = pattern;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder dark(boolean dark) {
            this.dark = dark;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder slug(String slug) {
            this.slug = Objects.requireNonNull(slug, "slug");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder document(Document document) {
            this.document = Objects.requireNonNull(document, "document");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder settings(@Nullable WallPaperSettings settings) {
            this.settings = settings;
            return this;
        }

        public ImmutableBaseWallPaper build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseWallPaper(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean creatorIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean isDefaultIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean patternIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean darkIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("slug");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("document");
            }
            return "Cannot build BaseWallPaper, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte creatorBuildStage = 0;
        private boolean creator;
        private byte isDefaultBuildStage = 0;
        private boolean isDefault;
        private byte patternBuildStage = 0;
        private boolean pattern;
        private byte darkBuildStage = 0;
        private boolean dark;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseWallPaper.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBaseWallPaper.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean creator() {
            if (this.creatorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.creatorBuildStage == 0) {
                this.creatorBuildStage = (byte)-1;
                this.creator = ImmutableBaseWallPaper.this.creatorInitialize();
                this.creatorBuildStage = 1;
            }
            return this.creator;
        }

        void creator(boolean creator) {
            this.creator = creator;
            this.creatorBuildStage = 1;
        }

        boolean isDefault() {
            if (this.isDefaultBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isDefaultBuildStage == 0) {
                this.isDefaultBuildStage = (byte)-1;
                this.isDefault = ImmutableBaseWallPaper.this.isDefaultInitialize();
                this.isDefaultBuildStage = 1;
            }
            return this.isDefault;
        }

        void isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            this.isDefaultBuildStage = 1;
        }

        boolean pattern() {
            if (this.patternBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.patternBuildStage == 0) {
                this.patternBuildStage = (byte)-1;
                this.pattern = ImmutableBaseWallPaper.this.patternInitialize();
                this.patternBuildStage = 1;
            }
            return this.pattern;
        }

        void pattern(boolean pattern) {
            this.pattern = pattern;
            this.patternBuildStage = 1;
        }

        boolean dark() {
            if (this.darkBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.darkBuildStage == 0) {
                this.darkBuildStage = (byte)-1;
                this.dark = ImmutableBaseWallPaper.this.darkInitialize();
                this.darkBuildStage = 1;
            }
            return this.dark;
        }

        void dark(boolean dark) {
            this.dark = dark;
            this.darkBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.creatorBuildStage == -1) {
                attributes.add("creator");
            }
            if (this.isDefaultBuildStage == -1) {
                attributes.add("isDefault");
            }
            if (this.patternBuildStage == -1) {
                attributes.add("pattern");
            }
            if (this.darkBuildStage == -1) {
                attributes.add("dark");
            }
            return "Cannot build BaseWallPaper, attribute initializers form cycle " + attributes;
        }
    }
}

