/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BaseWebPage;
import telegram4j.tl.Document;
import telegram4j.tl.Page;
import telegram4j.tl.Photo;
import telegram4j.tl.WebPage;
import telegram4j.tl.WebPageAttribute;
import telegram4j.tl.api.TlObject;

public final class ImmutableBaseWebPage
implements BaseWebPage {
    private final int identifier;
    private final int flags;
    private final long id;
    private final String url;
    private final String displayUrl;
    private final int hash;
    @Nullable
    private final String type;
    @Nullable
    private final String siteName;
    @Nullable
    private final String title;
    @Nullable
    private final String description;
    @Nullable
    private final Photo photo;
    @Nullable
    private final String embedUrl;
    @Nullable
    private final String embedType;
    @Nullable
    private final Integer embedWidth;
    @Nullable
    private final Integer embedHeight;
    @Nullable
    private final Integer duration;
    @Nullable
    private final String author;
    @Nullable
    private final Document document;
    @Nullable
    private final Page cachedPage;
    @Nullable
    private final List<WebPageAttribute> attributes;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseWebPage(long id, String url, String displayUrl, int hash) {
        this.id = id;
        this.url = Objects.requireNonNull(url, "url");
        this.displayUrl = Objects.requireNonNull(displayUrl, "displayUrl");
        this.hash = hash;
        this.type = null;
        this.siteName = null;
        this.title = null;
        this.description = null;
        this.photo = null;
        this.embedUrl = null;
        this.embedType = null;
        this.embedWidth = null;
        this.embedHeight = null;
        this.duration = null;
        this.author = null;
        this.document = null;
        this.cachedPage = null;
        this.attributes = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableBaseWebPage(Builder builder) {
        this.id = builder.id;
        this.url = builder.url;
        this.displayUrl = builder.displayUrl;
        this.hash = builder.hash;
        this.type = builder.type;
        this.siteName = builder.siteName;
        this.title = builder.title;
        this.description = builder.description;
        this.photo = builder.photo;
        this.embedUrl = builder.embedUrl;
        this.embedType = builder.embedType;
        this.embedWidth = builder.embedWidth;
        this.embedHeight = builder.embedHeight;
        this.duration = builder.duration;
        this.author = builder.author;
        this.document = builder.document;
        this.cachedPage = builder.cachedPage;
        List<WebPageAttribute> list = this.attributes = builder.attributes == null ? null : ImmutableBaseWebPage.createUnmodifiableList(true, builder.attributes);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableBaseWebPage(int identifier, int flags, long id, String url, String displayUrl, int hash, @Nullable String type, @Nullable String siteName, @Nullable String title, @Nullable String description, @Nullable Photo photo, @Nullable String embedUrl, @Nullable String embedType, @Nullable Integer embedWidth, @Nullable Integer embedHeight, @Nullable Integer duration, @Nullable String author, @Nullable Document document, @Nullable Page cachedPage, @Nullable List<WebPageAttribute> attributes) {
        this.identifier = identifier;
        this.flags = flags;
        this.id = id;
        this.url = url;
        this.displayUrl = displayUrl;
        this.hash = hash;
        this.type = type;
        this.siteName = siteName;
        this.title = title;
        this.description = description;
        this.photo = photo;
        this.embedUrl = embedUrl;
        this.embedType = embedType;
        this.embedWidth = embedWidth;
        this.embedHeight = embedHeight;
        this.duration = duration;
        this.author = author;
        this.document = document;
        this.cachedPage = cachedPage;
        this.attributes = attributes;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseWebPage.super.identifier();
    }

    private int flagsInitialize() {
        return BaseWebPage.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public String displayUrl() {
        return this.displayUrl;
    }

    @Override
    public int hash() {
        return this.hash;
    }

    @Override
    @Nullable
    public String type() {
        return this.type;
    }

    @Override
    @Nullable
    public String siteName() {
        return this.siteName;
    }

    @Override
    @Nullable
    public String title() {
        return this.title;
    }

    @Override
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    @Nullable
    public Photo photo() {
        return this.photo;
    }

    @Override
    @Nullable
    public String embedUrl() {
        return this.embedUrl;
    }

    @Override
    @Nullable
    public String embedType() {
        return this.embedType;
    }

    @Override
    @Nullable
    public Integer embedWidth() {
        return this.embedWidth;
    }

    @Override
    @Nullable
    public Integer embedHeight() {
        return this.embedHeight;
    }

    @Override
    @Nullable
    public Integer duration() {
        return this.duration;
    }

    @Override
    @Nullable
    public String author() {
        return this.author;
    }

    @Override
    @Nullable
    public Document document() {
        return this.document;
    }

    @Override
    @Nullable
    public Page cachedPage() {
        return this.cachedPage;
    }

    @Override
    @Nullable
    public List<WebPageAttribute> attributes() {
        return this.attributes;
    }

    public final ImmutableBaseWebPage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseWebPage(value, this.flags, this.id, this.url, this.displayUrl, this.hash, this.type, this.siteName, this.title, this.description, this.photo, this.embedUrl, this.embedType, this.embedWidth, this.embedHeight, this.duration, this.author, this.document, this.cachedPage, this.attributes);
    }

    public final ImmutableBaseWebPage withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBaseWebPage(this.identifier, value, this.id, this.url, this.displayUrl, this.hash, this.type, this.siteName, this.title, this.description, this.photo, this.embedUrl, this.embedType, this.embedWidth, this.embedHeight, this.duration, this.author, this.document, this.cachedPage, this.attributes);
    }

    public final ImmutableBaseWebPage withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableBaseWebPage(this.identifier, this.flags, value, this.url, this.displayUrl, this.hash, this.type, this.siteName, this.title, this.description, this.photo, this.embedUrl, this.embedType, this.embedWidth, this.embedHeight, this.duration, this.author, this.document, this.cachedPage, this.attributes);
    }

    public final ImmutableBaseWebPage withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableBaseWebPage(this.identifier, this.flags, this.id, newValue, this.displayUrl, this.hash, this.type, this.siteName, this.title, this.description, this.photo, this.embedUrl, this.embedType, this.embedWidth, this.embedHeight, this.duration, this.author, this.document, this.cachedPage, this.attributes);
    }

    public final ImmutableBaseWebPage withDisplayUrl(String value) {
        String newValue = Objects.requireNonNull(value, "displayUrl");
        if (this.displayUrl.equals(newValue)) {
            return this;
        }
        return new ImmutableBaseWebPage(this.identifier, this.flags, this.id, this.url, newValue, this.hash, this.type, this.siteName, this.title, this.description, this.photo, this.embedUrl, this.embedType, this.embedWidth, this.embedHeight, this.duration, this.author, this.document, this.cachedPage, this.attributes);
    }

    public final ImmutableBaseWebPage withHash(int value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableBaseWebPage(this.identifier, this.flags, this.id, this.url, this.displayUrl, value, this.type, this.siteName, this.title, this.description, this.photo, this.embedUrl, this.embedType, this.embedWidth, this.embedHeight, this.duration, this.author, this.document, this.cachedPage, this.attributes);
    }

    public final ImmutableBaseWebPage withType(@Nullable String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return new ImmutableBaseWebPage(this.identifier, this.flags, this.id, this.url, this.displayUrl, this.hash, value, this.siteName, this.title, this.description, this.photo, this.embedUrl, this.embedType, this.embedWidth, this.embedHeight, this.duration, this.author, this.document, this.cachedPage, this.attributes);
    }

    public final ImmutableBaseWebPage withSiteName(@Nullable String value) {
        if (Objects.equals(this.siteName, value)) {
            return this;
        }
        return new ImmutableBaseWebPage(this.identifier, this.flags, this.id, this.url, this.displayUrl, this.hash, this.type, value, this.title, this.description, this.photo, this.embedUrl, this.embedType, this.embedWidth, this.embedHeight, this.duration, this.author, this.document, this.cachedPage, this.attributes);
    }

    public final ImmutableBaseWebPage withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableBaseWebPage(this.identifier, this.flags, this.id, this.url, this.displayUrl, this.hash, this.type, this.siteName, value, this.description, this.photo, this.embedUrl, this.embedType, this.embedWidth, this.embedHeight, this.duration, this.author, this.document, this.cachedPage, this.attributes);
    }

    public final ImmutableBaseWebPage withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableBaseWebPage(this.identifier, this.flags, this.id, this.url, this.displayUrl, this.hash, this.type, this.siteName, this.title, value, this.photo, this.embedUrl, this.embedType, this.embedWidth, this.embedHeight, this.duration, this.author, this.document, this.cachedPage, this.attributes);
    }

    public final ImmutableBaseWebPage withPhoto(@Nullable Photo value) {
        if (this.photo == value) {
            return this;
        }
        return new ImmutableBaseWebPage(this.identifier, this.flags, this.id, this.url, this.displayUrl, this.hash, this.type, this.siteName, this.title, this.description, value, this.embedUrl, this.embedType, this.embedWidth, this.embedHeight, this.duration, this.author, this.document, this.cachedPage, this.attributes);
    }

    public final ImmutableBaseWebPage withEmbedUrl(@Nullable String value) {
        if (Objects.equals(this.embedUrl, value)) {
            return this;
        }
        return new ImmutableBaseWebPage(this.identifier, this.flags, this.id, this.url, this.displayUrl, this.hash, this.type, this.siteName, this.title, this.description, this.photo, value, this.embedType, this.embedWidth, this.embedHeight, this.duration, this.author, this.document, this.cachedPage, this.attributes);
    }

    public final ImmutableBaseWebPage withEmbedType(@Nullable String value) {
        if (Objects.equals(this.embedType, value)) {
            return this;
        }
        return new ImmutableBaseWebPage(this.identifier, this.flags, this.id, this.url, this.displayUrl, this.hash, this.type, this.siteName, this.title, this.description, this.photo, this.embedUrl, value, this.embedWidth, this.embedHeight, this.duration, this.author, this.document, this.cachedPage, this.attributes);
    }

    public final ImmutableBaseWebPage withEmbedWidth(@Nullable Integer value) {
        if (Objects.equals(this.embedWidth, value)) {
            return this;
        }
        return new ImmutableBaseWebPage(this.identifier, this.flags, this.id, this.url, this.displayUrl, this.hash, this.type, this.siteName, this.title, this.description, this.photo, this.embedUrl, this.embedType, value, this.embedHeight, this.duration, this.author, this.document, this.cachedPage, this.attributes);
    }

    public final ImmutableBaseWebPage withEmbedHeight(@Nullable Integer value) {
        if (Objects.equals(this.embedHeight, value)) {
            return this;
        }
        return new ImmutableBaseWebPage(this.identifier, this.flags, this.id, this.url, this.displayUrl, this.hash, this.type, this.siteName, this.title, this.description, this.photo, this.embedUrl, this.embedType, this.embedWidth, value, this.duration, this.author, this.document, this.cachedPage, this.attributes);
    }

    public final ImmutableBaseWebPage withDuration(@Nullable Integer value) {
        if (Objects.equals(this.duration, value)) {
            return this;
        }
        return new ImmutableBaseWebPage(this.identifier, this.flags, this.id, this.url, this.displayUrl, this.hash, this.type, this.siteName, this.title, this.description, this.photo, this.embedUrl, this.embedType, this.embedWidth, this.embedHeight, value, this.author, this.document, this.cachedPage, this.attributes);
    }

    public final ImmutableBaseWebPage withAuthor(@Nullable String value) {
        if (Objects.equals(this.author, value)) {
            return this;
        }
        return new ImmutableBaseWebPage(this.identifier, this.flags, this.id, this.url, this.displayUrl, this.hash, this.type, this.siteName, this.title, this.description, this.photo, this.embedUrl, this.embedType, this.embedWidth, this.embedHeight, this.duration, value, this.document, this.cachedPage, this.attributes);
    }

    public final ImmutableBaseWebPage withDocument(@Nullable Document value) {
        if (this.document == value) {
            return this;
        }
        return new ImmutableBaseWebPage(this.identifier, this.flags, this.id, this.url, this.displayUrl, this.hash, this.type, this.siteName, this.title, this.description, this.photo, this.embedUrl, this.embedType, this.embedWidth, this.embedHeight, this.duration, this.author, value, this.cachedPage, this.attributes);
    }

    public final ImmutableBaseWebPage withCachedPage(@Nullable Page value) {
        if (this.cachedPage == value) {
            return this;
        }
        return new ImmutableBaseWebPage(this.identifier, this.flags, this.id, this.url, this.displayUrl, this.hash, this.type, this.siteName, this.title, this.description, this.photo, this.embedUrl, this.embedType, this.embedWidth, this.embedHeight, this.duration, this.author, this.document, value, this.attributes);
    }

    public final ImmutableBaseWebPage withAttributes(WebPageAttribute ... elements) {
        if (elements == null) {
            return new ImmutableBaseWebPage(this.identifier, this.flags, this.id, this.url, this.displayUrl, this.hash, this.type, this.siteName, this.title, this.description, this.photo, this.embedUrl, this.embedType, this.embedWidth, this.embedHeight, this.duration, this.author, this.document, this.cachedPage, null);
        }
        List<WebPageAttribute> newValue = Arrays.asList(elements) == null ? null : ImmutableBaseWebPage.createUnmodifiableList(false, ImmutableBaseWebPage.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseWebPage(this.identifier, this.flags, this.id, this.url, this.displayUrl, this.hash, this.type, this.siteName, this.title, this.description, this.photo, this.embedUrl, this.embedType, this.embedWidth, this.embedHeight, this.duration, this.author, this.document, this.cachedPage, newValue);
    }

    public final ImmutableBaseWebPage withAttributes(@Nullable Iterable<? extends WebPageAttribute> elements) {
        if (this.attributes == elements) {
            return this;
        }
        List<WebPageAttribute> newValue = elements == null ? null : ImmutableBaseWebPage.createUnmodifiableList(false, ImmutableBaseWebPage.createSafeList(elements, true, false));
        return new ImmutableBaseWebPage(this.identifier, this.flags, this.id, this.url, this.displayUrl, this.hash, this.type, this.siteName, this.title, this.description, this.photo, this.embedUrl, this.embedType, this.embedWidth, this.embedHeight, this.duration, this.author, this.document, this.cachedPage, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseWebPage && this.equalTo(0, (ImmutableBaseWebPage)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseWebPage another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.id == another.id && this.url.equals(another.url) && this.displayUrl.equals(another.displayUrl) && this.hash == another.hash && Objects.equals(this.type, another.type) && Objects.equals(this.siteName, another.siteName) && Objects.equals(this.title, another.title) && Objects.equals(this.description, another.description) && Objects.equals(this.photo, another.photo) && Objects.equals(this.embedUrl, another.embedUrl) && Objects.equals(this.embedType, another.embedType) && Objects.equals(this.embedWidth, another.embedWidth) && Objects.equals(this.embedHeight, another.embedHeight) && Objects.equals(this.duration, another.duration) && Objects.equals(this.author, another.author) && Objects.equals(this.document, another.document) && Objects.equals(this.cachedPage, another.cachedPage) && Objects.equals(this.attributes, another.attributes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.displayUrl.hashCode();
        h += (h << 5) + this.hash;
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode(this.siteName);
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.photo);
        h += (h << 5) + Objects.hashCode(this.embedUrl);
        h += (h << 5) + Objects.hashCode(this.embedType);
        h += (h << 5) + Objects.hashCode(this.embedWidth);
        h += (h << 5) + Objects.hashCode(this.embedHeight);
        h += (h << 5) + Objects.hashCode(this.duration);
        h += (h << 5) + Objects.hashCode(this.author);
        h += (h << 5) + Objects.hashCode(this.document);
        h += (h << 5) + Objects.hashCode(this.cachedPage);
        h += (h << 5) + Objects.hashCode(this.attributes);
        return h;
    }

    public String toString() {
        return "BaseWebPage{identifier=" + this.identifier + ", flags=" + this.flags + ", id=" + this.id + ", url=" + this.url + ", displayUrl=" + this.displayUrl + ", hash=" + this.hash + ", type=" + this.type + ", siteName=" + this.siteName + ", title=" + this.title + ", description=" + this.description + ", photo=" + this.photo + ", embedUrl=" + this.embedUrl + ", embedType=" + this.embedType + ", embedWidth=" + this.embedWidth + ", embedHeight=" + this.embedHeight + ", duration=" + this.duration + ", author=" + this.author + ", document=" + this.document + ", cachedPage=" + this.cachedPage + ", attributes=" + this.attributes + "}";
    }

    public static ImmutableBaseWebPage of(long id, String url, String displayUrl, int hash) {
        return new ImmutableBaseWebPage(id, url, displayUrl, hash);
    }

    public static ImmutableBaseWebPage copyOf(BaseWebPage instance) {
        if (instance instanceof ImmutableBaseWebPage) {
            return (ImmutableBaseWebPage)instance;
        }
        return ImmutableBaseWebPage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_URL = 2L;
        private static final long INIT_BIT_DISPLAY_URL = 4L;
        private static final long INIT_BIT_HASH = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int flags;
        private long id;
        private String url;
        private String displayUrl;
        private int hash;
        private String type;
        private String siteName;
        private String title;
        private String description;
        private Photo photo;
        private String embedUrl;
        private String embedType;
        private Integer embedWidth;
        private Integer embedHeight;
        private Integer duration;
        private String author;
        private Document document;
        private Page cachedPage;
        private List<WebPageAttribute> attributes = null;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseWebPage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WebPage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseWebPage) {
                List<WebPageAttribute> attributesValue;
                String embedTypeValue;
                Integer embedHeightValue;
                String titleValue;
                String typeValue;
                Photo photoValue;
                String descriptionValue;
                String siteNameValue;
                Document documentValue;
                String authorValue;
                Page cachedPageValue;
                instance = (BaseWebPage)object;
                String embedUrlValue = instance.embedUrl();
                if (embedUrlValue != null) {
                    this.embedUrl(embedUrlValue);
                }
                if ((cachedPageValue = instance.cachedPage()) != null) {
                    this.cachedPage(cachedPageValue);
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((authorValue = instance.author()) != null) {
                    this.author(authorValue);
                }
                if ((documentValue = instance.document()) != null) {
                    this.document(documentValue);
                }
                this.flags(instance.flags());
                Integer embedWidthValue = instance.embedWidth();
                if (embedWidthValue != null) {
                    this.embedWidth(embedWidthValue);
                }
                if ((siteNameValue = instance.siteName()) != null) {
                    this.siteName(siteNameValue);
                }
                if ((descriptionValue = instance.description()) != null) {
                    this.description(descriptionValue);
                }
                if ((photoValue = instance.photo()) != null) {
                    this.photo(photoValue);
                }
                if ((typeValue = instance.type()) != null) {
                    this.type(typeValue);
                }
                if ((titleValue = instance.title()) != null) {
                    this.title(titleValue);
                }
                this.url(instance.url());
                this.displayUrl(instance.displayUrl());
                Integer durationValue = instance.duration();
                if (durationValue != null) {
                    this.duration(durationValue);
                }
                if ((embedHeightValue = instance.embedHeight()) != null) {
                    this.embedHeight(embedHeightValue);
                }
                if ((embedTypeValue = instance.embedType()) != null) {
                    this.embedType(embedTypeValue);
                }
                if ((attributesValue = instance.attributes()) != null) {
                    this.addAllAttributes(attributesValue);
                }
                this.id(instance.id());
                this.hash(instance.hash());
            }
            if (object instanceof WebPage) {
                instance = (WebPage)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder displayUrl(String displayUrl) {
            this.displayUrl = Objects.requireNonNull(displayUrl, "displayUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder hash(int hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        public final Builder siteName(@Nullable String siteName) {
            this.siteName = siteName;
            return this;
        }

        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder photo(@Nullable Photo photo) {
            this.photo = photo;
            return this;
        }

        public final Builder embedUrl(@Nullable String embedUrl) {
            this.embedUrl = embedUrl;
            return this;
        }

        public final Builder embedType(@Nullable String embedType) {
            this.embedType = embedType;
            return this;
        }

        public final Builder embedWidth(@Nullable Integer embedWidth) {
            this.embedWidth = embedWidth;
            return this;
        }

        public final Builder embedHeight(@Nullable Integer embedHeight) {
            this.embedHeight = embedHeight;
            return this;
        }

        public final Builder duration(@Nullable Integer duration) {
            this.duration = duration;
            return this;
        }

        public final Builder author(@Nullable String author) {
            this.author = author;
            return this;
        }

        public final Builder document(@Nullable Document document) {
            this.document = document;
            return this;
        }

        public final Builder cachedPage(@Nullable Page cachedPage) {
            this.cachedPage = cachedPage;
            return this;
        }

        public final Builder addAttribute(WebPageAttribute element) {
            if (this.attributes == null) {
                this.attributes = new ArrayList<WebPageAttribute>();
            }
            this.attributes.add(Objects.requireNonNull(element, "attributes element"));
            return this;
        }

        public final Builder addAttributes(WebPageAttribute ... elements) {
            if (this.attributes == null) {
                this.attributes = new ArrayList<WebPageAttribute>();
            }
            for (WebPageAttribute element : elements) {
                this.attributes.add(Objects.requireNonNull(element, "attributes element"));
            }
            return this;
        }

        public final Builder attributes(@Nullable Iterable<? extends WebPageAttribute> elements) {
            if (elements == null) {
                this.attributes = null;
                return this;
            }
            this.attributes = new ArrayList<WebPageAttribute>();
            return this.addAllAttributes(elements);
        }

        public final Builder addAllAttributes(Iterable<? extends WebPageAttribute> elements) {
            Objects.requireNonNull(elements, "attributes element");
            if (this.attributes == null) {
                this.attributes = new ArrayList<WebPageAttribute>();
            }
            for (WebPageAttribute webPageAttribute : elements) {
                this.attributes.add(Objects.requireNonNull(webPageAttribute, "attributes element"));
            }
            return this;
        }

        public ImmutableBaseWebPage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseWebPage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("url");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("displayUrl");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build BaseWebPage, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseWebPage.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBaseWebPage.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build BaseWebPage, attribute initializers form cycle " + attributes;
        }
    }
}

