/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BotCommand;
import telegram4j.tl.api.TlObject;

public final class ImmutableBotCommand
implements BotCommand {
    private final int identifier;
    private final String command;
    private final String description;

    private ImmutableBotCommand(String command, String description) {
        this.command = Objects.requireNonNull(command, "command");
        this.description = Objects.requireNonNull(description, "description");
        this.identifier = BotCommand.super.identifier();
    }

    private ImmutableBotCommand(Builder builder) {
        this.command = builder.command;
        this.description = builder.description;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BotCommand.super.identifier();
    }

    private ImmutableBotCommand(int identifier, String command, String description) {
        this.identifier = identifier;
        this.command = command;
        this.description = description;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String command() {
        return this.command;
    }

    @Override
    public String description() {
        return this.description;
    }

    public final ImmutableBotCommand withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBotCommand(value, this.command, this.description);
    }

    public final ImmutableBotCommand withCommand(String value) {
        String newValue = Objects.requireNonNull(value, "command");
        if (this.command.equals(newValue)) {
            return this;
        }
        return new ImmutableBotCommand(this.identifier, newValue, this.description);
    }

    public final ImmutableBotCommand withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableBotCommand(this.identifier, this.command, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBotCommand && this.equalTo(0, (ImmutableBotCommand)another);
    }

    private boolean equalTo(int synthetic, ImmutableBotCommand another) {
        return this.identifier == another.identifier && this.command.equals(another.command) && this.description.equals(another.description);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.command.hashCode();
        h += (h << 5) + this.description.hashCode();
        return h;
    }

    public String toString() {
        return "BotCommand{identifier=" + this.identifier + ", command=" + this.command + ", description=" + this.description + "}";
    }

    public static ImmutableBotCommand of(String command, String description) {
        return new ImmutableBotCommand(command, description);
    }

    public static ImmutableBotCommand copyOf(BotCommand instance) {
        if (instance instanceof ImmutableBotCommand) {
            return (ImmutableBotCommand)instance;
        }
        return ImmutableBotCommand.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_COMMAND = 1L;
        private static final long INIT_BIT_DESCRIPTION = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String command;
        private String description;

        private Builder() {
        }

        public final Builder from(BotCommand instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BotCommand instance;
            long bits = 0L;
            if (object instanceof BotCommand) {
                instance = (BotCommand)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.description(instance.description());
                this.command(instance.command());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder command(String command) {
            this.command = Objects.requireNonNull(command, "command");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBotCommand build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBotCommand(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("command");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("description");
            }
            return "Cannot build BotCommand, some of required attributes are not set " + attributes;
        }
    }
}

