/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.BotCommandScope;
import telegram4j.tl.BotCommandScopeChats;
import telegram4j.tl.api.TlObject;

public final class ImmutableBotCommandScopeChats
implements BotCommandScopeChats {
    private final int identifier;
    private static final ImmutableBotCommandScopeChats INSTANCE = ImmutableBotCommandScopeChats.validate(new ImmutableBotCommandScopeChats());

    private ImmutableBotCommandScopeChats() {
        this.identifier = BotCommandScopeChats.super.identifier();
    }

    private ImmutableBotCommandScopeChats(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : BotCommandScopeChats.super.identifier();
    }

    private ImmutableBotCommandScopeChats(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableBotCommandScopeChats withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableBotCommandScopeChats.validate(new ImmutableBotCommandScopeChats(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBotCommandScopeChats && this.equalTo(0, (ImmutableBotCommandScopeChats)another);
    }

    private boolean equalTo(int synthetic, ImmutableBotCommandScopeChats another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "BotCommandScopeChats{identifier=" + this.identifier + "}";
    }

    public static ImmutableBotCommandScopeChats of() {
        return INSTANCE;
    }

    private static ImmutableBotCommandScopeChats validate(ImmutableBotCommandScopeChats instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableBotCommandScopeChats copyOf(BotCommandScopeChats instance) {
        if (instance instanceof ImmutableBotCommandScopeChats) {
            return (ImmutableBotCommandScopeChats)instance;
        }
        return ImmutableBotCommandScopeChats.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(BotCommandScope instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BotCommandScopeChats instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BotCommandScope instance;
            long bits = 0L;
            if (object instanceof BotCommandScope) {
                instance = (BotCommandScope)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BotCommandScopeChats) {
                instance = (BotCommandScopeChats)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableBotCommandScopeChats build() {
            return ImmutableBotCommandScopeChats.validate(new ImmutableBotCommandScopeChats(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

