/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.BotCommandScope;
import telegram4j.tl.BotCommandScopeDefault;
import telegram4j.tl.api.TlObject;

public final class ImmutableBotCommandScopeDefault
implements BotCommandScopeDefault {
    private final int identifier;
    private static final ImmutableBotCommandScopeDefault INSTANCE = ImmutableBotCommandScopeDefault.validate(new ImmutableBotCommandScopeDefault());

    private ImmutableBotCommandScopeDefault() {
        this.identifier = BotCommandScopeDefault.super.identifier();
    }

    private ImmutableBotCommandScopeDefault(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : BotCommandScopeDefault.super.identifier();
    }

    private ImmutableBotCommandScopeDefault(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableBotCommandScopeDefault withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableBotCommandScopeDefault.validate(new ImmutableBotCommandScopeDefault(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBotCommandScopeDefault && this.equalTo(0, (ImmutableBotCommandScopeDefault)another);
    }

    private boolean equalTo(int synthetic, ImmutableBotCommandScopeDefault another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "BotCommandScopeDefault{identifier=" + this.identifier + "}";
    }

    public static ImmutableBotCommandScopeDefault of() {
        return INSTANCE;
    }

    private static ImmutableBotCommandScopeDefault validate(ImmutableBotCommandScopeDefault instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableBotCommandScopeDefault copyOf(BotCommandScopeDefault instance) {
        if (instance instanceof ImmutableBotCommandScopeDefault) {
            return (ImmutableBotCommandScopeDefault)instance;
        }
        return ImmutableBotCommandScopeDefault.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(BotCommandScope instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BotCommandScopeDefault instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BotCommandScope instance;
            long bits = 0L;
            if (object instanceof BotCommandScope) {
                instance = (BotCommandScope)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BotCommandScopeDefault) {
                instance = (BotCommandScopeDefault)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableBotCommandScopeDefault build() {
            return ImmutableBotCommandScopeDefault.validate(new ImmutableBotCommandScopeDefault(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

