/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BotCommandScope;
import telegram4j.tl.BotCommandScopePeerAdmins;
import telegram4j.tl.InputPeer;
import telegram4j.tl.api.TlObject;

public final class ImmutableBotCommandScopePeerAdmins
implements BotCommandScopePeerAdmins {
    private final int identifier;
    private final InputPeer peer;

    private ImmutableBotCommandScopePeerAdmins(InputPeer peer) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.identifier = BotCommandScopePeerAdmins.super.identifier();
    }

    private ImmutableBotCommandScopePeerAdmins(Builder builder) {
        this.peer = builder.peer;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BotCommandScopePeerAdmins.super.identifier();
    }

    private ImmutableBotCommandScopePeerAdmins(int identifier, InputPeer peer) {
        this.identifier = identifier;
        this.peer = peer;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    public final ImmutableBotCommandScopePeerAdmins withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBotCommandScopePeerAdmins(value, this.peer);
    }

    public final ImmutableBotCommandScopePeerAdmins withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableBotCommandScopePeerAdmins(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBotCommandScopePeerAdmins && this.equalTo(0, (ImmutableBotCommandScopePeerAdmins)another);
    }

    private boolean equalTo(int synthetic, ImmutableBotCommandScopePeerAdmins another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        return h;
    }

    public String toString() {
        return "BotCommandScopePeerAdmins{identifier=" + this.identifier + ", peer=" + this.peer + "}";
    }

    public static ImmutableBotCommandScopePeerAdmins of(InputPeer peer) {
        return new ImmutableBotCommandScopePeerAdmins(peer);
    }

    public static ImmutableBotCommandScopePeerAdmins copyOf(BotCommandScopePeerAdmins instance) {
        if (instance instanceof ImmutableBotCommandScopePeerAdmins) {
            return (ImmutableBotCommandScopePeerAdmins)instance;
        }
        return ImmutableBotCommandScopePeerAdmins.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private InputPeer peer;

        private Builder() {
        }

        public final Builder from(BotCommandScope instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BotCommandScopePeerAdmins instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BotCommandScope instance;
            long bits = 0L;
            if (object instanceof BotCommandScope) {
                instance = (BotCommandScope)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BotCommandScopePeerAdmins) {
                instance = (BotCommandScopePeerAdmins)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableBotCommandScopePeerAdmins build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBotCommandScopePeerAdmins(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            return "Cannot build BotCommandScopePeerAdmins, some of required attributes are not set " + attributes;
        }
    }
}

