/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.BotCommandScope;
import telegram4j.tl.BotCommandScopePeerUser;
import telegram4j.tl.InputPeer;
import telegram4j.tl.InputUser;
import telegram4j.tl.api.TlObject;

public final class ImmutableBotCommandScopePeerUser
implements BotCommandScopePeerUser {
    private final int identifier;
    private final InputPeer peer;
    private final InputUser userId;

    private ImmutableBotCommandScopePeerUser(InputPeer peer, InputUser userId) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.userId = Objects.requireNonNull(userId, "userId");
        this.identifier = BotCommandScopePeerUser.super.identifier();
    }

    private ImmutableBotCommandScopePeerUser(Builder builder) {
        this.peer = builder.peer;
        this.userId = builder.userId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BotCommandScopePeerUser.super.identifier();
    }

    private ImmutableBotCommandScopePeerUser(int identifier, InputPeer peer, InputUser userId) {
        this.identifier = identifier;
        this.peer = peer;
        this.userId = userId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public InputPeer peer() {
        return this.peer;
    }

    @Override
    public InputUser userId() {
        return this.userId;
    }

    public final ImmutableBotCommandScopePeerUser withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBotCommandScopePeerUser(value, this.peer, this.userId);
    }

    public final ImmutableBotCommandScopePeerUser withPeer(InputPeer value) {
        if (this.peer == value) {
            return this;
        }
        InputPeer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableBotCommandScopePeerUser(this.identifier, newValue, this.userId);
    }

    public final ImmutableBotCommandScopePeerUser withUserId(InputUser value) {
        if (this.userId == value) {
            return this;
        }
        InputUser newValue = Objects.requireNonNull(value, "userId");
        return new ImmutableBotCommandScopePeerUser(this.identifier, this.peer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBotCommandScopePeerUser && this.equalTo(0, (ImmutableBotCommandScopePeerUser)another);
    }

    private boolean equalTo(int synthetic, ImmutableBotCommandScopePeerUser another) {
        return this.identifier == another.identifier && this.peer.equals(another.peer) && this.userId.equals(another.userId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + this.userId.hashCode();
        return h;
    }

    public String toString() {
        return "BotCommandScopePeerUser{identifier=" + this.identifier + ", peer=" + this.peer + ", userId=" + this.userId + "}";
    }

    public static ImmutableBotCommandScopePeerUser of(InputPeer peer, InputUser userId) {
        return new ImmutableBotCommandScopePeerUser(peer, userId);
    }

    public static ImmutableBotCommandScopePeerUser copyOf(BotCommandScopePeerUser instance) {
        if (instance instanceof ImmutableBotCommandScopePeerUser) {
            return (ImmutableBotCommandScopePeerUser)instance;
        }
        return ImmutableBotCommandScopePeerUser.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_USER_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private InputPeer peer;
        private InputUser userId;

        private Builder() {
        }

        public final Builder from(BotCommandScope instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BotCommandScopePeerUser instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BotCommandScope instance;
            long bits = 0L;
            if (object instanceof BotCommandScope) {
                instance = (BotCommandScope)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BotCommandScopePeerUser) {
                instance = (BotCommandScopePeerUser)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.userId(instance.userId());
                this.peer(instance.peer());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder peer(InputPeer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder userId(InputUser userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBotCommandScopePeerUser build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBotCommandScopePeerUser(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("userId");
            }
            return "Cannot build BotCommandScopePeerUser, some of required attributes are not set " + attributes;
        }
    }
}

