/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BotCommand;
import telegram4j.tl.BotInfo;
import telegram4j.tl.BotMenuButton;
import telegram4j.tl.Document;
import telegram4j.tl.Photo;
import telegram4j.tl.api.TlObject;

public final class ImmutableBotInfo
implements BotInfo {
    private final int identifier;
    private final int flags;
    @Nullable
    private final Long userId;
    @Nullable
    private final String description;
    @Nullable
    private final Photo descriptionPhoto;
    @Nullable
    private final Document descriptionDocument;
    @Nullable
    private final List<BotCommand> commands;
    @Nullable
    private final BotMenuButton menuButton;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableBotInfo INSTANCE = ImmutableBotInfo.validate(new ImmutableBotInfo());

    private ImmutableBotInfo() {
        this.userId = null;
        this.description = null;
        this.descriptionPhoto = null;
        this.descriptionDocument = null;
        this.commands = null;
        this.menuButton = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableBotInfo(Builder builder) {
        this.userId = builder.userId;
        this.description = builder.description;
        this.descriptionPhoto = builder.descriptionPhoto;
        this.descriptionDocument = builder.descriptionDocument;
        this.commands = builder.commands == null ? null : ImmutableBotInfo.createUnmodifiableList(true, builder.commands);
        this.menuButton = builder.menuButton;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableBotInfo(int identifier, int flags, @Nullable Long userId, @Nullable String description, @Nullable Photo descriptionPhoto, @Nullable Document descriptionDocument, @Nullable List<BotCommand> commands, @Nullable BotMenuButton menuButton) {
        this.identifier = identifier;
        this.flags = flags;
        this.userId = userId;
        this.description = description;
        this.descriptionPhoto = descriptionPhoto;
        this.descriptionDocument = descriptionDocument;
        this.commands = commands;
        this.menuButton = menuButton;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BotInfo.super.identifier();
    }

    private int flagsInitialize() {
        return BotInfo.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public Long userId() {
        return this.userId;
    }

    @Override
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    @Nullable
    public Photo descriptionPhoto() {
        return this.descriptionPhoto;
    }

    @Override
    @Nullable
    public Document descriptionDocument() {
        return this.descriptionDocument;
    }

    @Override
    @Nullable
    public List<BotCommand> commands() {
        return this.commands;
    }

    @Override
    @Nullable
    public BotMenuButton menuButton() {
        return this.menuButton;
    }

    public final ImmutableBotInfo withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableBotInfo.validate(new ImmutableBotInfo(value, this.flags, this.userId, this.description, this.descriptionPhoto, this.descriptionDocument, this.commands, this.menuButton));
    }

    public final ImmutableBotInfo withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableBotInfo.validate(new ImmutableBotInfo(this.identifier, value, this.userId, this.description, this.descriptionPhoto, this.descriptionDocument, this.commands, this.menuButton));
    }

    public final ImmutableBotInfo withUserId(@Nullable Long value) {
        if (Objects.equals(this.userId, value)) {
            return this;
        }
        return ImmutableBotInfo.validate(new ImmutableBotInfo(this.identifier, this.flags, value, this.description, this.descriptionPhoto, this.descriptionDocument, this.commands, this.menuButton));
    }

    public final ImmutableBotInfo withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return ImmutableBotInfo.validate(new ImmutableBotInfo(this.identifier, this.flags, this.userId, value, this.descriptionPhoto, this.descriptionDocument, this.commands, this.menuButton));
    }

    public final ImmutableBotInfo withDescriptionPhoto(@Nullable Photo value) {
        if (this.descriptionPhoto == value) {
            return this;
        }
        return ImmutableBotInfo.validate(new ImmutableBotInfo(this.identifier, this.flags, this.userId, this.description, value, this.descriptionDocument, this.commands, this.menuButton));
    }

    public final ImmutableBotInfo withDescriptionDocument(@Nullable Document value) {
        if (this.descriptionDocument == value) {
            return this;
        }
        return ImmutableBotInfo.validate(new ImmutableBotInfo(this.identifier, this.flags, this.userId, this.description, this.descriptionPhoto, value, this.commands, this.menuButton));
    }

    public final ImmutableBotInfo withCommands(BotCommand ... elements) {
        if (elements == null) {
            return ImmutableBotInfo.validate(new ImmutableBotInfo(this.identifier, this.flags, this.userId, this.description, this.descriptionPhoto, this.descriptionDocument, null, this.menuButton));
        }
        List<BotCommand> newValue = Arrays.asList(elements) == null ? null : ImmutableBotInfo.createUnmodifiableList(false, ImmutableBotInfo.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableBotInfo.validate(new ImmutableBotInfo(this.identifier, this.flags, this.userId, this.description, this.descriptionPhoto, this.descriptionDocument, newValue, this.menuButton));
    }

    public final ImmutableBotInfo withCommands(@Nullable Iterable<? extends BotCommand> elements) {
        if (this.commands == elements) {
            return this;
        }
        List<BotCommand> newValue = elements == null ? null : ImmutableBotInfo.createUnmodifiableList(false, ImmutableBotInfo.createSafeList(elements, true, false));
        return ImmutableBotInfo.validate(new ImmutableBotInfo(this.identifier, this.flags, this.userId, this.description, this.descriptionPhoto, this.descriptionDocument, newValue, this.menuButton));
    }

    public final ImmutableBotInfo withMenuButton(@Nullable BotMenuButton value) {
        if (this.menuButton == value) {
            return this;
        }
        return ImmutableBotInfo.validate(new ImmutableBotInfo(this.identifier, this.flags, this.userId, this.description, this.descriptionPhoto, this.descriptionDocument, this.commands, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBotInfo && this.equalTo(0, (ImmutableBotInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableBotInfo another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.userId, another.userId) && Objects.equals(this.description, another.description) && Objects.equals(this.descriptionPhoto, another.descriptionPhoto) && Objects.equals(this.descriptionDocument, another.descriptionDocument) && Objects.equals(this.commands, another.commands) && Objects.equals(this.menuButton, another.menuButton);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.userId);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.descriptionPhoto);
        h += (h << 5) + Objects.hashCode(this.descriptionDocument);
        h += (h << 5) + Objects.hashCode(this.commands);
        h += (h << 5) + Objects.hashCode(this.menuButton);
        return h;
    }

    public String toString() {
        return "BotInfo{identifier=" + this.identifier + ", flags=" + this.flags + ", userId=" + this.userId + ", description=" + this.description + ", descriptionPhoto=" + this.descriptionPhoto + ", descriptionDocument=" + this.descriptionDocument + ", commands=" + this.commands + ", menuButton=" + this.menuButton + "}";
    }

    public static ImmutableBotInfo of() {
        return INSTANCE;
    }

    private static ImmutableBotInfo validate(ImmutableBotInfo instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableBotInfo copyOf(BotInfo instance) {
        if (instance instanceof ImmutableBotInfo) {
            return (ImmutableBotInfo)instance;
        }
        return ImmutableBotInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long optBits;
        private int identifier;
        private int flags;
        private Long userId;
        private String description;
        private Photo descriptionPhoto;
        private Document descriptionDocument;
        private List<BotCommand> commands = null;
        private BotMenuButton menuButton;

        private Builder() {
        }

        public final Builder from(BotInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BotInfo instance;
            long bits = 0L;
            if (object instanceof BotInfo) {
                List<BotCommand> commandsValue;
                Long userIdValue;
                BotMenuButton menuButtonValue;
                Photo descriptionPhotoValue;
                Document descriptionDocumentValue;
                instance = (BotInfo)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((descriptionDocumentValue = instance.descriptionDocument()) != null) {
                    this.descriptionDocument(descriptionDocumentValue);
                }
                if ((descriptionPhotoValue = instance.descriptionPhoto()) != null) {
                    this.descriptionPhoto(descriptionPhotoValue);
                }
                if ((menuButtonValue = instance.menuButton()) != null) {
                    this.menuButton(menuButtonValue);
                }
                this.flags(instance.flags());
                String descriptionValue = instance.description();
                if (descriptionValue != null) {
                    this.description(descriptionValue);
                }
                if ((userIdValue = instance.userId()) != null) {
                    this.userId(userIdValue);
                }
                if ((commandsValue = instance.commands()) != null) {
                    this.addAllCommands(commandsValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder userId(@Nullable Long userId) {
            this.userId = userId;
            return this;
        }

        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder descriptionPhoto(@Nullable Photo descriptionPhoto) {
            this.descriptionPhoto = descriptionPhoto;
            return this;
        }

        public final Builder descriptionDocument(@Nullable Document descriptionDocument) {
            this.descriptionDocument = descriptionDocument;
            return this;
        }

        public final Builder addCommand(BotCommand element) {
            if (this.commands == null) {
                this.commands = new ArrayList<BotCommand>();
            }
            this.commands.add(Objects.requireNonNull(element, "commands element"));
            return this;
        }

        public final Builder addCommands(BotCommand ... elements) {
            if (this.commands == null) {
                this.commands = new ArrayList<BotCommand>();
            }
            for (BotCommand element : elements) {
                this.commands.add(Objects.requireNonNull(element, "commands element"));
            }
            return this;
        }

        public final Builder commands(@Nullable Iterable<? extends BotCommand> elements) {
            if (elements == null) {
                this.commands = null;
                return this;
            }
            this.commands = new ArrayList<BotCommand>();
            return this.addAllCommands(elements);
        }

        public final Builder addAllCommands(Iterable<? extends BotCommand> elements) {
            Objects.requireNonNull(elements, "commands element");
            if (this.commands == null) {
                this.commands = new ArrayList<BotCommand>();
            }
            for (BotCommand botCommand : elements) {
                this.commands.add(Objects.requireNonNull(botCommand, "commands element"));
            }
            return this;
        }

        public final Builder menuButton(@Nullable BotMenuButton menuButton) {
            this.menuButton = menuButton;
            return this;
        }

        public ImmutableBotInfo build() {
            return ImmutableBotInfo.validate(new ImmutableBotInfo(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBotInfo.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBotInfo.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build BotInfo, attribute initializers form cycle " + attributes;
        }
    }
}

