/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BotInlineMediaResult;
import telegram4j.tl.BotInlineMessage;
import telegram4j.tl.BotInlineResult;
import telegram4j.tl.Document;
import telegram4j.tl.Photo;
import telegram4j.tl.api.TlObject;

public final class ImmutableBotInlineMediaResult
implements BotInlineMediaResult {
    private final int identifier;
    private final int flags;
    private final String id;
    private final String type;
    @Nullable
    private final Photo photo;
    @Nullable
    private final Document document;
    @Nullable
    private final String title;
    @Nullable
    private final String description;
    private final BotInlineMessage sendMessage;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBotInlineMediaResult(String id, String type, BotInlineMessage sendMessage) {
        this.id = Objects.requireNonNull(id, "id");
        this.type = Objects.requireNonNull(type, "type");
        this.sendMessage = Objects.requireNonNull(sendMessage, "sendMessage");
        this.photo = null;
        this.document = null;
        this.title = null;
        this.description = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableBotInlineMediaResult(Builder builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.photo = builder.photo;
        this.document = builder.document;
        this.title = builder.title;
        this.description = builder.description;
        this.sendMessage = builder.sendMessage;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableBotInlineMediaResult(int identifier, int flags, String id, String type, @Nullable Photo photo, @Nullable Document document, @Nullable String title, @Nullable String description, BotInlineMessage sendMessage) {
        this.identifier = identifier;
        this.flags = flags;
        this.id = id;
        this.type = type;
        this.photo = photo;
        this.document = document;
        this.title = title;
        this.description = description;
        this.sendMessage = sendMessage;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BotInlineMediaResult.super.identifier();
    }

    private int flagsInitialize() {
        return BotInlineMediaResult.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    @Nullable
    public Photo photo() {
        return this.photo;
    }

    @Override
    @Nullable
    public Document document() {
        return this.document;
    }

    @Override
    @Nullable
    public String title() {
        return this.title;
    }

    @Override
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    public BotInlineMessage sendMessage() {
        return this.sendMessage;
    }

    public final ImmutableBotInlineMediaResult withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBotInlineMediaResult(value, this.flags, this.id, this.type, this.photo, this.document, this.title, this.description, this.sendMessage);
    }

    public final ImmutableBotInlineMediaResult withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBotInlineMediaResult(this.identifier, value, this.id, this.type, this.photo, this.document, this.title, this.description, this.sendMessage);
    }

    public final ImmutableBotInlineMediaResult withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableBotInlineMediaResult(this.identifier, this.flags, newValue, this.type, this.photo, this.document, this.title, this.description, this.sendMessage);
    }

    public final ImmutableBotInlineMediaResult withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableBotInlineMediaResult(this.identifier, this.flags, this.id, newValue, this.photo, this.document, this.title, this.description, this.sendMessage);
    }

    public final ImmutableBotInlineMediaResult withPhoto(@Nullable Photo value) {
        if (this.photo == value) {
            return this;
        }
        return new ImmutableBotInlineMediaResult(this.identifier, this.flags, this.id, this.type, value, this.document, this.title, this.description, this.sendMessage);
    }

    public final ImmutableBotInlineMediaResult withDocument(@Nullable Document value) {
        if (this.document == value) {
            return this;
        }
        return new ImmutableBotInlineMediaResult(this.identifier, this.flags, this.id, this.type, this.photo, value, this.title, this.description, this.sendMessage);
    }

    public final ImmutableBotInlineMediaResult withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableBotInlineMediaResult(this.identifier, this.flags, this.id, this.type, this.photo, this.document, value, this.description, this.sendMessage);
    }

    public final ImmutableBotInlineMediaResult withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableBotInlineMediaResult(this.identifier, this.flags, this.id, this.type, this.photo, this.document, this.title, value, this.sendMessage);
    }

    public final ImmutableBotInlineMediaResult withSendMessage(BotInlineMessage value) {
        if (this.sendMessage == value) {
            return this;
        }
        BotInlineMessage newValue = Objects.requireNonNull(value, "sendMessage");
        return new ImmutableBotInlineMediaResult(this.identifier, this.flags, this.id, this.type, this.photo, this.document, this.title, this.description, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBotInlineMediaResult && this.equalTo(0, (ImmutableBotInlineMediaResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableBotInlineMediaResult another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.id.equals(another.id) && this.type.equals(another.type) && Objects.equals(this.photo, another.photo) && Objects.equals(this.document, another.document) && Objects.equals(this.title, another.title) && Objects.equals(this.description, another.description) && this.sendMessage.equals(another.sendMessage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.photo);
        h += (h << 5) + Objects.hashCode(this.document);
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.sendMessage.hashCode();
        return h;
    }

    public String toString() {
        return "BotInlineMediaResult{identifier=" + this.identifier + ", flags=" + this.flags + ", id=" + this.id + ", type=" + this.type + ", photo=" + this.photo + ", document=" + this.document + ", title=" + this.title + ", description=" + this.description + ", sendMessage=" + this.sendMessage + "}";
    }

    public static ImmutableBotInlineMediaResult of(String id, String type, BotInlineMessage sendMessage) {
        return new ImmutableBotInlineMediaResult(id, type, sendMessage);
    }

    public static ImmutableBotInlineMediaResult copyOf(BotInlineMediaResult instance) {
        if (instance instanceof ImmutableBotInlineMediaResult) {
            return (ImmutableBotInlineMediaResult)instance;
        }
        return ImmutableBotInlineMediaResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_SEND_MESSAGE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private String id;
        private String type;
        private Photo photo;
        private Document document;
        private String title;
        private String description;
        private BotInlineMessage sendMessage;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BotInlineMediaResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BotInlineResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BotInlineMediaResult) {
                Photo photoValue;
                Document documentValue;
                instance = (BotInlineMediaResult)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((documentValue = instance.document()) != null) {
                    this.document(documentValue);
                }
                if ((bits & 2L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 2L;
                }
                if ((photoValue = instance.photo()) != null) {
                    this.photo(photoValue);
                }
                if ((bits & 4L) == 0L) {
                    String descriptionValue = instance.description();
                    if (descriptionValue != null) {
                        this.description(descriptionValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.sendMessage(instance.sendMessage());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.id(instance.id());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.type(instance.type());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    String titleValue = instance.title();
                    if (titleValue != null) {
                        this.title(titleValue);
                    }
                    bits |= 0x40L;
                }
            }
            if (object instanceof BotInlineResult) {
                instance = (BotInlineResult)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    String descriptionValue = instance.description();
                    if (descriptionValue != null) {
                        this.description(descriptionValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.sendMessage(instance.sendMessage());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.id(instance.id());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.type(instance.type());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    String titleValue = instance.title();
                    if (titleValue != null) {
                        this.title(titleValue);
                    }
                    bits |= 0x40L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder photo(@Nullable Photo photo) {
            this.photo = photo;
            return this;
        }

        public final Builder document(@Nullable Document document) {
            this.document = document;
            return this;
        }

        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder sendMessage(BotInlineMessage sendMessage) {
            this.sendMessage = Objects.requireNonNull(sendMessage, "sendMessage");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableBotInlineMediaResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBotInlineMediaResult(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("sendMessage");
            }
            return "Cannot build BotInlineMediaResult, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBotInlineMediaResult.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBotInlineMediaResult.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build BotInlineMediaResult, attribute initializers form cycle " + attributes;
        }
    }
}

