/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BotInlineMessage;
import telegram4j.tl.BotInlineMessageMediaContact;
import telegram4j.tl.ReplyMarkup;
import telegram4j.tl.api.TlObject;

public final class ImmutableBotInlineMessageMediaContact
implements BotInlineMessageMediaContact {
    private final int identifier;
    private final int flags;
    private final String phoneNumber;
    private final String firstName;
    private final String lastName;
    private final String vcard;
    @Nullable
    private final ReplyMarkup replyMarkup;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBotInlineMessageMediaContact(String phoneNumber, String firstName, String lastName, String vcard) {
        this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber");
        this.firstName = Objects.requireNonNull(firstName, "firstName");
        this.lastName = Objects.requireNonNull(lastName, "lastName");
        this.vcard = Objects.requireNonNull(vcard, "vcard");
        this.replyMarkup = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableBotInlineMessageMediaContact(Builder builder) {
        this.phoneNumber = builder.phoneNumber;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.vcard = builder.vcard;
        this.replyMarkup = builder.replyMarkup;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableBotInlineMessageMediaContact(int identifier, int flags, String phoneNumber, String firstName, String lastName, String vcard, @Nullable ReplyMarkup replyMarkup) {
        this.identifier = identifier;
        this.flags = flags;
        this.phoneNumber = phoneNumber;
        this.firstName = firstName;
        this.lastName = lastName;
        this.vcard = vcard;
        this.replyMarkup = replyMarkup;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BotInlineMessageMediaContact.super.identifier();
    }

    private int flagsInitialize() {
        return BotInlineMessageMediaContact.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public String phoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public String firstName() {
        return this.firstName;
    }

    @Override
    public String lastName() {
        return this.lastName;
    }

    @Override
    public String vcard() {
        return this.vcard;
    }

    @Override
    @Nullable
    public ReplyMarkup replyMarkup() {
        return this.replyMarkup;
    }

    public final ImmutableBotInlineMessageMediaContact withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBotInlineMessageMediaContact(value, this.flags, this.phoneNumber, this.firstName, this.lastName, this.vcard, this.replyMarkup);
    }

    public final ImmutableBotInlineMessageMediaContact withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBotInlineMessageMediaContact(this.identifier, value, this.phoneNumber, this.firstName, this.lastName, this.vcard, this.replyMarkup);
    }

    public final ImmutableBotInlineMessageMediaContact withPhoneNumber(String value) {
        String newValue = Objects.requireNonNull(value, "phoneNumber");
        if (this.phoneNumber.equals(newValue)) {
            return this;
        }
        return new ImmutableBotInlineMessageMediaContact(this.identifier, this.flags, newValue, this.firstName, this.lastName, this.vcard, this.replyMarkup);
    }

    public final ImmutableBotInlineMessageMediaContact withFirstName(String value) {
        String newValue = Objects.requireNonNull(value, "firstName");
        if (this.firstName.equals(newValue)) {
            return this;
        }
        return new ImmutableBotInlineMessageMediaContact(this.identifier, this.flags, this.phoneNumber, newValue, this.lastName, this.vcard, this.replyMarkup);
    }

    public final ImmutableBotInlineMessageMediaContact withLastName(String value) {
        String newValue = Objects.requireNonNull(value, "lastName");
        if (this.lastName.equals(newValue)) {
            return this;
        }
        return new ImmutableBotInlineMessageMediaContact(this.identifier, this.flags, this.phoneNumber, this.firstName, newValue, this.vcard, this.replyMarkup);
    }

    public final ImmutableBotInlineMessageMediaContact withVcard(String value) {
        String newValue = Objects.requireNonNull(value, "vcard");
        if (this.vcard.equals(newValue)) {
            return this;
        }
        return new ImmutableBotInlineMessageMediaContact(this.identifier, this.flags, this.phoneNumber, this.firstName, this.lastName, newValue, this.replyMarkup);
    }

    public final ImmutableBotInlineMessageMediaContact withReplyMarkup(@Nullable ReplyMarkup value) {
        if (this.replyMarkup == value) {
            return this;
        }
        return new ImmutableBotInlineMessageMediaContact(this.identifier, this.flags, this.phoneNumber, this.firstName, this.lastName, this.vcard, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBotInlineMessageMediaContact && this.equalTo(0, (ImmutableBotInlineMessageMediaContact)another);
    }

    private boolean equalTo(int synthetic, ImmutableBotInlineMessageMediaContact another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.phoneNumber.equals(another.phoneNumber) && this.firstName.equals(another.firstName) && this.lastName.equals(another.lastName) && this.vcard.equals(another.vcard) && Objects.equals(this.replyMarkup, another.replyMarkup);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.phoneNumber.hashCode();
        h += (h << 5) + this.firstName.hashCode();
        h += (h << 5) + this.lastName.hashCode();
        h += (h << 5) + this.vcard.hashCode();
        h += (h << 5) + Objects.hashCode(this.replyMarkup);
        return h;
    }

    public String toString() {
        return "BotInlineMessageMediaContact{identifier=" + this.identifier + ", flags=" + this.flags + ", phoneNumber=" + this.phoneNumber + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", vcard=" + this.vcard + ", replyMarkup=" + this.replyMarkup + "}";
    }

    public static ImmutableBotInlineMessageMediaContact of(String phoneNumber, String firstName, String lastName, String vcard) {
        return new ImmutableBotInlineMessageMediaContact(phoneNumber, firstName, lastName, vcard);
    }

    public static ImmutableBotInlineMessageMediaContact copyOf(BotInlineMessageMediaContact instance) {
        if (instance instanceof ImmutableBotInlineMessageMediaContact) {
            return (ImmutableBotInlineMessageMediaContact)instance;
        }
        return ImmutableBotInlineMessageMediaContact.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PHONE_NUMBER = 1L;
        private static final long INIT_BIT_FIRST_NAME = 2L;
        private static final long INIT_BIT_LAST_NAME = 4L;
        private static final long INIT_BIT_VCARD = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int flags;
        private String phoneNumber;
        private String firstName;
        private String lastName;
        private String vcard;
        private ReplyMarkup replyMarkup;

        private Builder() {
        }

        public final Builder from(BotInlineMessageMediaContact instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BotInlineMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ReplyMarkup replyMarkupValue;
            BotInlineMessage instance;
            long bits = 0L;
            if (object instanceof BotInlineMessageMediaContact) {
                instance = (BotInlineMessageMediaContact)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.firstName(instance.firstName());
                this.lastName(instance.lastName());
                this.phoneNumber(instance.phoneNumber());
                if ((bits & 2L) == 0L) {
                    replyMarkupValue = instance.replyMarkup();
                    if (replyMarkupValue != null) {
                        this.replyMarkup(replyMarkupValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 4L;
                }
                this.vcard(instance.vcard());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BotInlineMessage) {
                instance = (BotInlineMessage)object;
                if ((bits & 4L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    replyMarkupValue = instance.replyMarkup();
                    if (replyMarkupValue != null) {
                        this.replyMarkup(replyMarkupValue);
                    }
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder firstName(String firstName) {
            this.firstName = Objects.requireNonNull(firstName, "firstName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder lastName(String lastName) {
            this.lastName = Objects.requireNonNull(lastName, "lastName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder vcard(String vcard) {
            this.vcard = Objects.requireNonNull(vcard, "vcard");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder replyMarkup(@Nullable ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public ImmutableBotInlineMessageMediaContact build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBotInlineMessageMediaContact(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("phoneNumber");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("firstName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("lastName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("vcard");
            }
            return "Cannot build BotInlineMessageMediaContact, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBotInlineMessageMediaContact.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBotInlineMessageMediaContact.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build BotInlineMessageMediaContact, attribute initializers form cycle " + attributes;
        }
    }
}

