/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.CdnConfig;
import telegram4j.tl.CdnPublicKey;
import telegram4j.tl.api.TlObject;

public final class ImmutableCdnConfig
implements CdnConfig {
    private final int identifier;
    private final List<CdnPublicKey> publicKeys;

    private ImmutableCdnConfig(Builder builder) {
        this.publicKeys = ImmutableCdnConfig.createUnmodifiableList(true, builder.publicKeys);
        this.identifier = builder.identifierIsSet() ? builder.identifier : CdnConfig.super.identifier();
    }

    private ImmutableCdnConfig(int identifier, List<CdnPublicKey> publicKeys) {
        this.identifier = identifier;
        this.publicKeys = publicKeys;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<CdnPublicKey> publicKeys() {
        return this.publicKeys;
    }

    public final ImmutableCdnConfig withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableCdnConfig(value, this.publicKeys);
    }

    public final ImmutableCdnConfig withPublicKeys(CdnPublicKey ... elements) {
        List<CdnPublicKey> newValue = ImmutableCdnConfig.createUnmodifiableList(false, ImmutableCdnConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCdnConfig(this.identifier, newValue);
    }

    public final ImmutableCdnConfig withPublicKeys(Iterable<? extends CdnPublicKey> elements) {
        if (this.publicKeys == elements) {
            return this;
        }
        List<CdnPublicKey> newValue = ImmutableCdnConfig.createUnmodifiableList(false, ImmutableCdnConfig.createSafeList(elements, true, false));
        return new ImmutableCdnConfig(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCdnConfig && this.equalTo(0, (ImmutableCdnConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableCdnConfig another) {
        return this.identifier == another.identifier && this.publicKeys.equals(another.publicKeys);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.publicKeys.hashCode();
        return h;
    }

    public String toString() {
        return "CdnConfig{identifier=" + this.identifier + ", publicKeys=" + this.publicKeys + "}";
    }

    public static ImmutableCdnConfig copyOf(CdnConfig instance) {
        if (instance instanceof ImmutableCdnConfig) {
            return (ImmutableCdnConfig)instance;
        }
        return ImmutableCdnConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<CdnPublicKey> publicKeys = new ArrayList<CdnPublicKey>();

        private Builder() {
        }

        public final Builder from(CdnConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            CdnConfig instance;
            long bits = 0L;
            if (object instanceof CdnConfig) {
                instance = (CdnConfig)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllPublicKeys(instance.publicKeys());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addPublicKey(CdnPublicKey element) {
            this.publicKeys.add(Objects.requireNonNull(element, "publicKeys element"));
            return this;
        }

        public final Builder addPublicKeys(CdnPublicKey ... elements) {
            for (CdnPublicKey element : elements) {
                this.publicKeys.add(Objects.requireNonNull(element, "publicKeys element"));
            }
            return this;
        }

        public final Builder publicKeys(Iterable<? extends CdnPublicKey> elements) {
            this.publicKeys.clear();
            return this.addAllPublicKeys(elements);
        }

        public final Builder addAllPublicKeys(Iterable<? extends CdnPublicKey> elements) {
            for (CdnPublicKey cdnPublicKey : elements) {
                this.publicKeys.add(Objects.requireNonNull(cdnPublicKey, "publicKeys element"));
            }
            return this;
        }

        public ImmutableCdnConfig build() {
            return new ImmutableCdnConfig(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

