/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.CdnPublicKey;
import telegram4j.tl.api.TlObject;

public final class ImmutableCdnPublicKey
implements CdnPublicKey {
    private final int identifier;
    private final int dcId;
    private final String publicKey;

    private ImmutableCdnPublicKey(int dcId, String publicKey) {
        this.dcId = dcId;
        this.publicKey = Objects.requireNonNull(publicKey, "publicKey");
        this.identifier = CdnPublicKey.super.identifier();
    }

    private ImmutableCdnPublicKey(Builder builder) {
        this.dcId = builder.dcId;
        this.publicKey = builder.publicKey;
        this.identifier = builder.identifierIsSet() ? builder.identifier : CdnPublicKey.super.identifier();
    }

    private ImmutableCdnPublicKey(int identifier, int dcId, String publicKey) {
        this.identifier = identifier;
        this.dcId = dcId;
        this.publicKey = publicKey;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int dcId() {
        return this.dcId;
    }

    @Override
    public String publicKey() {
        return this.publicKey;
    }

    public final ImmutableCdnPublicKey withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableCdnPublicKey(value, this.dcId, this.publicKey);
    }

    public final ImmutableCdnPublicKey withDcId(int value) {
        if (this.dcId == value) {
            return this;
        }
        return new ImmutableCdnPublicKey(this.identifier, value, this.publicKey);
    }

    public final ImmutableCdnPublicKey withPublicKey(String value) {
        String newValue = Objects.requireNonNull(value, "publicKey");
        if (this.publicKey.equals(newValue)) {
            return this;
        }
        return new ImmutableCdnPublicKey(this.identifier, this.dcId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCdnPublicKey && this.equalTo(0, (ImmutableCdnPublicKey)another);
    }

    private boolean equalTo(int synthetic, ImmutableCdnPublicKey another) {
        return this.identifier == another.identifier && this.dcId == another.dcId && this.publicKey.equals(another.publicKey);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.dcId;
        h += (h << 5) + this.publicKey.hashCode();
        return h;
    }

    public String toString() {
        return "CdnPublicKey{identifier=" + this.identifier + ", dcId=" + this.dcId + ", publicKey=" + this.publicKey + "}";
    }

    public static ImmutableCdnPublicKey of(int dcId, String publicKey) {
        return new ImmutableCdnPublicKey(dcId, publicKey);
    }

    public static ImmutableCdnPublicKey copyOf(CdnPublicKey instance) {
        if (instance instanceof ImmutableCdnPublicKey) {
            return (ImmutableCdnPublicKey)instance;
        }
        return ImmutableCdnPublicKey.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DC_ID = 1L;
        private static final long INIT_BIT_PUBLIC_KEY = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int dcId;
        private String publicKey;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(CdnPublicKey instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof CdnPublicKey) {
                instance = (CdnPublicKey)object;
                this.dcId(instance.dcId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.publicKey(instance.publicKey());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder dcId(int dcId) {
            this.dcId = dcId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder publicKey(String publicKey) {
            this.publicKey = Objects.requireNonNull(publicKey, "publicKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableCdnPublicKey build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCdnPublicKey(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("dcId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("publicKey");
            }
            return "Cannot build CdnPublicKey, some of required attributes are not set " + attributes;
        }
    }
}

