/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Channel;
import telegram4j.tl.Chat;
import telegram4j.tl.ChatAdminRights;
import telegram4j.tl.ChatBannedRights;
import telegram4j.tl.ChatPhoto;
import telegram4j.tl.RestrictionReason;
import telegram4j.tl.api.TlObject;

public final class ImmutableChannel
implements Channel {
    private final int identifier;
    private final int flags;
    private final boolean creator;
    private final boolean left;
    private final boolean broadcast;
    private final boolean verified;
    private final boolean megagroup;
    private final boolean restricted;
    private final boolean signatures;
    private final boolean min;
    private final boolean scam;
    private final boolean hasLink;
    private final boolean hasGeo;
    private final boolean slowmodeEnabled;
    private final boolean callActive;
    private final boolean callNotEmpty;
    private final boolean fake;
    private final boolean gigagroup;
    private final boolean noforwards;
    private final boolean joinToSend;
    private final boolean joinRequest;
    private final long id;
    @Nullable
    private final Long accessHash;
    private final String title;
    @Nullable
    private final String username;
    private final ChatPhoto photo;
    private final int date;
    @Nullable
    private final List<RestrictionReason> restrictionReason;
    @Nullable
    private final ChatAdminRights adminRights;
    @Nullable
    private final ChatBannedRights bannedRights;
    @Nullable
    private final ChatBannedRights defaultBannedRights;
    @Nullable
    private final Integer participantsCount;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableChannel(long id, String title, ChatPhoto photo, int date) {
        this.id = id;
        this.title = Objects.requireNonNull(title, "title");
        this.photo = Objects.requireNonNull(photo, "photo");
        this.date = date;
        this.accessHash = null;
        this.username = null;
        this.restrictionReason = null;
        this.adminRights = null;
        this.bannedRights = null;
        this.defaultBannedRights = null;
        this.participantsCount = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.creator = this.initShim.creator();
        this.left = this.initShim.left();
        this.broadcast = this.initShim.broadcast();
        this.verified = this.initShim.verified();
        this.megagroup = this.initShim.megagroup();
        this.restricted = this.initShim.restricted();
        this.signatures = this.initShim.signatures();
        this.min = this.initShim.min();
        this.scam = this.initShim.scam();
        this.hasLink = this.initShim.hasLink();
        this.hasGeo = this.initShim.hasGeo();
        this.slowmodeEnabled = this.initShim.slowmodeEnabled();
        this.callActive = this.initShim.callActive();
        this.callNotEmpty = this.initShim.callNotEmpty();
        this.fake = this.initShim.fake();
        this.gigagroup = this.initShim.gigagroup();
        this.noforwards = this.initShim.noforwards();
        this.joinToSend = this.initShim.joinToSend();
        this.joinRequest = this.initShim.joinRequest();
        this.initShim = null;
    }

    private ImmutableChannel(Builder builder) {
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.title = builder.title;
        this.username = builder.username;
        this.photo = builder.photo;
        this.date = builder.date;
        this.restrictionReason = builder.restrictionReason == null ? null : ImmutableChannel.createUnmodifiableList(true, builder.restrictionReason);
        this.adminRights = builder.adminRights;
        this.bannedRights = builder.bannedRights;
        this.defaultBannedRights = builder.defaultBannedRights;
        this.participantsCount = builder.participantsCount;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.creatorIsSet()) {
            this.initShim.creator(builder.creator);
        }
        if (builder.leftIsSet()) {
            this.initShim.left(builder.left);
        }
        if (builder.broadcastIsSet()) {
            this.initShim.broadcast(builder.broadcast);
        }
        if (builder.verifiedIsSet()) {
            this.initShim.verified(builder.verified);
        }
        if (builder.megagroupIsSet()) {
            this.initShim.megagroup(builder.megagroup);
        }
        if (builder.restrictedIsSet()) {
            this.initShim.restricted(builder.restricted);
        }
        if (builder.signaturesIsSet()) {
            this.initShim.signatures(builder.signatures);
        }
        if (builder.minIsSet()) {
            this.initShim.min(builder.min);
        }
        if (builder.scamIsSet()) {
            this.initShim.scam(builder.scam);
        }
        if (builder.hasLinkIsSet()) {
            this.initShim.hasLink(builder.hasLink);
        }
        if (builder.hasGeoIsSet()) {
            this.initShim.hasGeo(builder.hasGeo);
        }
        if (builder.slowmodeEnabledIsSet()) {
            this.initShim.slowmodeEnabled(builder.slowmodeEnabled);
        }
        if (builder.callActiveIsSet()) {
            this.initShim.callActive(builder.callActive);
        }
        if (builder.callNotEmptyIsSet()) {
            this.initShim.callNotEmpty(builder.callNotEmpty);
        }
        if (builder.fakeIsSet()) {
            this.initShim.fake(builder.fake);
        }
        if (builder.gigagroupIsSet()) {
            this.initShim.gigagroup(builder.gigagroup);
        }
        if (builder.noforwardsIsSet()) {
            this.initShim.noforwards(builder.noforwards);
        }
        if (builder.joinToSendIsSet()) {
            this.initShim.joinToSend(builder.joinToSend);
        }
        if (builder.joinRequestIsSet()) {
            this.initShim.joinRequest(builder.joinRequest);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.creator = this.initShim.creator();
        this.left = this.initShim.left();
        this.broadcast = this.initShim.broadcast();
        this.verified = this.initShim.verified();
        this.megagroup = this.initShim.megagroup();
        this.restricted = this.initShim.restricted();
        this.signatures = this.initShim.signatures();
        this.min = this.initShim.min();
        this.scam = this.initShim.scam();
        this.hasLink = this.initShim.hasLink();
        this.hasGeo = this.initShim.hasGeo();
        this.slowmodeEnabled = this.initShim.slowmodeEnabled();
        this.callActive = this.initShim.callActive();
        this.callNotEmpty = this.initShim.callNotEmpty();
        this.fake = this.initShim.fake();
        this.gigagroup = this.initShim.gigagroup();
        this.noforwards = this.initShim.noforwards();
        this.joinToSend = this.initShim.joinToSend();
        this.joinRequest = this.initShim.joinRequest();
        this.initShim = null;
    }

    private ImmutableChannel(int identifier, int flags, boolean creator, boolean left, boolean broadcast, boolean verified, boolean megagroup, boolean restricted, boolean signatures, boolean min, boolean scam, boolean hasLink, boolean hasGeo, boolean slowmodeEnabled, boolean callActive, boolean callNotEmpty, boolean fake, boolean gigagroup, boolean noforwards, boolean joinToSend, boolean joinRequest, long id, @Nullable Long accessHash, String title, @Nullable String username, ChatPhoto photo, int date, @Nullable List<RestrictionReason> restrictionReason, @Nullable ChatAdminRights adminRights, @Nullable ChatBannedRights bannedRights, @Nullable ChatBannedRights defaultBannedRights, @Nullable Integer participantsCount) {
        this.identifier = identifier;
        this.flags = flags;
        this.creator = creator;
        this.left = left;
        this.broadcast = broadcast;
        this.verified = verified;
        this.megagroup = megagroup;
        this.restricted = restricted;
        this.signatures = signatures;
        this.min = min;
        this.scam = scam;
        this.hasLink = hasLink;
        this.hasGeo = hasGeo;
        this.slowmodeEnabled = slowmodeEnabled;
        this.callActive = callActive;
        this.callNotEmpty = callNotEmpty;
        this.fake = fake;
        this.gigagroup = gigagroup;
        this.noforwards = noforwards;
        this.joinToSend = joinToSend;
        this.joinRequest = joinRequest;
        this.id = id;
        this.accessHash = accessHash;
        this.title = title;
        this.username = username;
        this.photo = photo;
        this.date = date;
        this.restrictionReason = restrictionReason;
        this.adminRights = adminRights;
        this.bannedRights = bannedRights;
        this.defaultBannedRights = defaultBannedRights;
        this.participantsCount = participantsCount;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return Channel.super.identifier();
    }

    private int flagsInitialize() {
        return Channel.super.flags();
    }

    private boolean creatorInitialize() {
        return Channel.super.creator();
    }

    private boolean leftInitialize() {
        return Channel.super.left();
    }

    private boolean broadcastInitialize() {
        return Channel.super.broadcast();
    }

    private boolean verifiedInitialize() {
        return Channel.super.verified();
    }

    private boolean megagroupInitialize() {
        return Channel.super.megagroup();
    }

    private boolean restrictedInitialize() {
        return Channel.super.restricted();
    }

    private boolean signaturesInitialize() {
        return Channel.super.signatures();
    }

    private boolean minInitialize() {
        return Channel.super.min();
    }

    private boolean scamInitialize() {
        return Channel.super.scam();
    }

    private boolean hasLinkInitialize() {
        return Channel.super.hasLink();
    }

    private boolean hasGeoInitialize() {
        return Channel.super.hasGeo();
    }

    private boolean slowmodeEnabledInitialize() {
        return Channel.super.slowmodeEnabled();
    }

    private boolean callActiveInitialize() {
        return Channel.super.callActive();
    }

    private boolean callNotEmptyInitialize() {
        return Channel.super.callNotEmpty();
    }

    private boolean fakeInitialize() {
        return Channel.super.fake();
    }

    private boolean gigagroupInitialize() {
        return Channel.super.gigagroup();
    }

    private boolean noforwardsInitialize() {
        return Channel.super.noforwards();
    }

    private boolean joinToSendInitialize() {
        return Channel.super.joinToSend();
    }

    private boolean joinRequestInitialize() {
        return Channel.super.joinRequest();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean creator() {
        InitShim shim = this.initShim;
        return shim != null ? shim.creator() : this.creator;
    }

    @Override
    public boolean left() {
        InitShim shim = this.initShim;
        return shim != null ? shim.left() : this.left;
    }

    @Override
    public boolean broadcast() {
        InitShim shim = this.initShim;
        return shim != null ? shim.broadcast() : this.broadcast;
    }

    @Override
    public boolean verified() {
        InitShim shim = this.initShim;
        return shim != null ? shim.verified() : this.verified;
    }

    @Override
    public boolean megagroup() {
        InitShim shim = this.initShim;
        return shim != null ? shim.megagroup() : this.megagroup;
    }

    @Override
    public boolean restricted() {
        InitShim shim = this.initShim;
        return shim != null ? shim.restricted() : this.restricted;
    }

    @Override
    public boolean signatures() {
        InitShim shim = this.initShim;
        return shim != null ? shim.signatures() : this.signatures;
    }

    @Override
    public boolean min() {
        InitShim shim = this.initShim;
        return shim != null ? shim.min() : this.min;
    }

    @Override
    public boolean scam() {
        InitShim shim = this.initShim;
        return shim != null ? shim.scam() : this.scam;
    }

    @Override
    public boolean hasLink() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasLink() : this.hasLink;
    }

    @Override
    public boolean hasGeo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasGeo() : this.hasGeo;
    }

    @Override
    public boolean slowmodeEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.slowmodeEnabled() : this.slowmodeEnabled;
    }

    @Override
    public boolean callActive() {
        InitShim shim = this.initShim;
        return shim != null ? shim.callActive() : this.callActive;
    }

    @Override
    public boolean callNotEmpty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.callNotEmpty() : this.callNotEmpty;
    }

    @Override
    public boolean fake() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fake() : this.fake;
    }

    @Override
    public boolean gigagroup() {
        InitShim shim = this.initShim;
        return shim != null ? shim.gigagroup() : this.gigagroup;
    }

    @Override
    public boolean noforwards() {
        InitShim shim = this.initShim;
        return shim != null ? shim.noforwards() : this.noforwards;
    }

    @Override
    public boolean joinToSend() {
        InitShim shim = this.initShim;
        return shim != null ? shim.joinToSend() : this.joinToSend;
    }

    @Override
    public boolean joinRequest() {
        InitShim shim = this.initShim;
        return shim != null ? shim.joinRequest() : this.joinRequest;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    @Nullable
    public Long accessHash() {
        return this.accessHash;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    @Nullable
    public String username() {
        return this.username;
    }

    @Override
    public ChatPhoto photo() {
        return this.photo;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    @Nullable
    public List<RestrictionReason> restrictionReason() {
        return this.restrictionReason;
    }

    @Override
    @Nullable
    public ChatAdminRights adminRights() {
        return this.adminRights;
    }

    @Override
    @Nullable
    public ChatBannedRights bannedRights() {
        return this.bannedRights;
    }

    @Override
    @Nullable
    public ChatBannedRights defaultBannedRights() {
        return this.defaultBannedRights;
    }

    @Override
    @Nullable
    public Integer participantsCount() {
        return this.participantsCount;
    }

    public final ImmutableChannel withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChannel(value, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableChannel(this.identifier, value, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withCreator(boolean value) {
        if (this.creator == value) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, value, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withLeft(boolean value) {
        if (this.left == value) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, value, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withBroadcast(boolean value) {
        if (this.broadcast == value) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, value, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withVerified(boolean value) {
        if (this.verified == value) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, value, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withMegagroup(boolean value) {
        if (this.megagroup == value) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, value, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withRestricted(boolean value) {
        if (this.restricted == value) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, value, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withSignatures(boolean value) {
        if (this.signatures == value) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, value, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withMin(boolean value) {
        if (this.min == value) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, value, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withScam(boolean value) {
        if (this.scam == value) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, value, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withHasLink(boolean value) {
        if (this.hasLink == value) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, value, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withHasGeo(boolean value) {
        if (this.hasGeo == value) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, value, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withSlowmodeEnabled(boolean value) {
        if (this.slowmodeEnabled == value) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, value, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withCallActive(boolean value) {
        if (this.callActive == value) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, value, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withCallNotEmpty(boolean value) {
        if (this.callNotEmpty == value) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, value, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withFake(boolean value) {
        if (this.fake == value) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, value, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withGigagroup(boolean value) {
        if (this.gigagroup == value) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, value, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withNoforwards(boolean value) {
        if (this.noforwards == value) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, value, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withJoinToSend(boolean value) {
        if (this.joinToSend == value) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, value, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withJoinRequest(boolean value) {
        if (this.joinRequest == value) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, value, this.id, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, value, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withAccessHash(@Nullable Long value) {
        if (Objects.equals(this.accessHash, value)) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, value, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, newValue, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withUsername(@Nullable String value) {
        if (Objects.equals(this.username, value)) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, value, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withPhoto(ChatPhoto value) {
        if (this.photo == value) {
            return this;
        }
        ChatPhoto newValue = Objects.requireNonNull(value, "photo");
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, newValue, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, value, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withRestrictionReason(RestrictionReason ... elements) {
        if (elements == null) {
            return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, null, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
        }
        List<RestrictionReason> newValue = Arrays.asList(elements) == null ? null : ImmutableChannel.createUnmodifiableList(false, ImmutableChannel.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, newValue, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withRestrictionReason(@Nullable Iterable<? extends RestrictionReason> elements) {
        if (this.restrictionReason == elements) {
            return this;
        }
        List<RestrictionReason> newValue = elements == null ? null : ImmutableChannel.createUnmodifiableList(false, ImmutableChannel.createSafeList(elements, true, false));
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, newValue, this.adminRights, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withAdminRights(@Nullable ChatAdminRights value) {
        if (this.adminRights == value) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, value, this.bannedRights, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withBannedRights(@Nullable ChatBannedRights value) {
        if (this.bannedRights == value) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, value, this.defaultBannedRights, this.participantsCount);
    }

    public final ImmutableChannel withDefaultBannedRights(@Nullable ChatBannedRights value) {
        if (this.defaultBannedRights == value) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, value, this.participantsCount);
    }

    public final ImmutableChannel withParticipantsCount(@Nullable Integer value) {
        if (Objects.equals(this.participantsCount, value)) {
            return this;
        }
        return new ImmutableChannel(this.identifier, this.flags, this.creator, this.left, this.broadcast, this.verified, this.megagroup, this.restricted, this.signatures, this.min, this.scam, this.hasLink, this.hasGeo, this.slowmodeEnabled, this.callActive, this.callNotEmpty, this.fake, this.gigagroup, this.noforwards, this.joinToSend, this.joinRequest, this.id, this.accessHash, this.title, this.username, this.photo, this.date, this.restrictionReason, this.adminRights, this.bannedRights, this.defaultBannedRights, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannel && this.equalTo(0, (ImmutableChannel)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannel another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.creator == another.creator && this.left == another.left && this.broadcast == another.broadcast && this.verified == another.verified && this.megagroup == another.megagroup && this.restricted == another.restricted && this.signatures == another.signatures && this.min == another.min && this.scam == another.scam && this.hasLink == another.hasLink && this.hasGeo == another.hasGeo && this.slowmodeEnabled == another.slowmodeEnabled && this.callActive == another.callActive && this.callNotEmpty == another.callNotEmpty && this.fake == another.fake && this.gigagroup == another.gigagroup && this.noforwards == another.noforwards && this.joinToSend == another.joinToSend && this.joinRequest == another.joinRequest && this.id == another.id && Objects.equals(this.accessHash, another.accessHash) && this.title.equals(another.title) && Objects.equals(this.username, another.username) && this.photo.equals(another.photo) && this.date == another.date && Objects.equals(this.restrictionReason, another.restrictionReason) && Objects.equals(this.adminRights, another.adminRights) && Objects.equals(this.bannedRights, another.bannedRights) && Objects.equals(this.defaultBannedRights, another.defaultBannedRights) && Objects.equals(this.participantsCount, another.participantsCount);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.creator);
        h += (h << 5) + Boolean.hashCode(this.left);
        h += (h << 5) + Boolean.hashCode(this.broadcast);
        h += (h << 5) + Boolean.hashCode(this.verified);
        h += (h << 5) + Boolean.hashCode(this.megagroup);
        h += (h << 5) + Boolean.hashCode(this.restricted);
        h += (h << 5) + Boolean.hashCode(this.signatures);
        h += (h << 5) + Boolean.hashCode(this.min);
        h += (h << 5) + Boolean.hashCode(this.scam);
        h += (h << 5) + Boolean.hashCode(this.hasLink);
        h += (h << 5) + Boolean.hashCode(this.hasGeo);
        h += (h << 5) + Boolean.hashCode(this.slowmodeEnabled);
        h += (h << 5) + Boolean.hashCode(this.callActive);
        h += (h << 5) + Boolean.hashCode(this.callNotEmpty);
        h += (h << 5) + Boolean.hashCode(this.fake);
        h += (h << 5) + Boolean.hashCode(this.gigagroup);
        h += (h << 5) + Boolean.hashCode(this.noforwards);
        h += (h << 5) + Boolean.hashCode(this.joinToSend);
        h += (h << 5) + Boolean.hashCode(this.joinRequest);
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.accessHash);
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + Objects.hashCode(this.username);
        h += (h << 5) + this.photo.hashCode();
        h += (h << 5) + this.date;
        h += (h << 5) + Objects.hashCode(this.restrictionReason);
        h += (h << 5) + Objects.hashCode(this.adminRights);
        h += (h << 5) + Objects.hashCode(this.bannedRights);
        h += (h << 5) + Objects.hashCode(this.defaultBannedRights);
        h += (h << 5) + Objects.hashCode(this.participantsCount);
        return h;
    }

    public String toString() {
        return "Channel{identifier=" + this.identifier + ", flags=" + this.flags + ", creator=" + this.creator + ", left=" + this.left + ", broadcast=" + this.broadcast + ", verified=" + this.verified + ", megagroup=" + this.megagroup + ", restricted=" + this.restricted + ", signatures=" + this.signatures + ", min=" + this.min + ", scam=" + this.scam + ", hasLink=" + this.hasLink + ", hasGeo=" + this.hasGeo + ", slowmodeEnabled=" + this.slowmodeEnabled + ", callActive=" + this.callActive + ", callNotEmpty=" + this.callNotEmpty + ", fake=" + this.fake + ", gigagroup=" + this.gigagroup + ", noforwards=" + this.noforwards + ", joinToSend=" + this.joinToSend + ", joinRequest=" + this.joinRequest + ", id=" + this.id + ", accessHash=" + this.accessHash + ", title=" + this.title + ", username=" + this.username + ", photo=" + this.photo + ", date=" + this.date + ", restrictionReason=" + this.restrictionReason + ", adminRights=" + this.adminRights + ", bannedRights=" + this.bannedRights + ", defaultBannedRights=" + this.defaultBannedRights + ", participantsCount=" + this.participantsCount + "}";
    }

    public static ImmutableChannel of(long id, String title, ChatPhoto photo, int date) {
        return new ImmutableChannel(id, title, photo, date);
    }

    public static ImmutableChannel copyOf(Channel instance) {
        if (instance instanceof ImmutableChannel) {
            return (ImmutableChannel)instance;
        }
        return ImmutableChannel.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private static final long INIT_BIT_PHOTO = 4L;
        private static final long INIT_BIT_DATE = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_CREATOR = 4L;
        private static final long OPT_BIT_LEFT = 8L;
        private static final long OPT_BIT_BROADCAST = 16L;
        private static final long OPT_BIT_VERIFIED = 32L;
        private static final long OPT_BIT_MEGAGROUP = 64L;
        private static final long OPT_BIT_RESTRICTED = 128L;
        private static final long OPT_BIT_SIGNATURES = 256L;
        private static final long OPT_BIT_MIN = 512L;
        private static final long OPT_BIT_SCAM = 1024L;
        private static final long OPT_BIT_HAS_LINK = 2048L;
        private static final long OPT_BIT_HAS_GEO = 4096L;
        private static final long OPT_BIT_SLOWMODE_ENABLED = 8192L;
        private static final long OPT_BIT_CALL_ACTIVE = 16384L;
        private static final long OPT_BIT_CALL_NOT_EMPTY = 32768L;
        private static final long OPT_BIT_FAKE = 65536L;
        private static final long OPT_BIT_GIGAGROUP = 131072L;
        private static final long OPT_BIT_NOFORWARDS = 262144L;
        private static final long OPT_BIT_JOIN_TO_SEND = 524288L;
        private static final long OPT_BIT_JOIN_REQUEST = 0x100000L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean creator;
        private boolean left;
        private boolean broadcast;
        private boolean verified;
        private boolean megagroup;
        private boolean restricted;
        private boolean signatures;
        private boolean min;
        private boolean scam;
        private boolean hasLink;
        private boolean hasGeo;
        private boolean slowmodeEnabled;
        private boolean callActive;
        private boolean callNotEmpty;
        private boolean fake;
        private boolean gigagroup;
        private boolean noforwards;
        private boolean joinToSend;
        private boolean joinRequest;
        private long id;
        private Long accessHash;
        private String title;
        private String username;
        private ChatPhoto photo;
        private int date;
        private List<RestrictionReason> restrictionReason = null;
        private ChatAdminRights adminRights;
        private ChatBannedRights bannedRights;
        private ChatBannedRights defaultBannedRights;
        private Integer participantsCount;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Chat instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Channel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
            }
            if (object instanceof Chat) {
                instance = (Chat)object;
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.id(instance.id());
                    bits |= 1L;
                }
            }
            if (object instanceof Channel) {
                String usernameValue;
                ChatBannedRights bannedRightsValue;
                instance = (Channel)object;
                this.broadcast(instance.broadcast());
                this.date(instance.date());
                Integer participantsCountValue = instance.participantsCount();
                if (participantsCountValue != null) {
                    this.participantsCount(participantsCountValue);
                }
                this.noforwards(instance.noforwards());
                this.flags(instance.flags());
                this.scam(instance.scam());
                List<RestrictionReason> restrictionReasonValue = instance.restrictionReason();
                if (restrictionReasonValue != null) {
                    this.addAllRestrictionReason(restrictionReasonValue);
                }
                this.title(instance.title());
                this.callActive(instance.callActive());
                this.signatures(instance.signatures());
                this.megagroup(instance.megagroup());
                this.min(instance.min());
                this.hasGeo(instance.hasGeo());
                this.joinToSend(instance.joinToSend());
                if ((bits & 1L) == 0L) {
                    this.id(instance.id());
                    bits |= 1L;
                }
                if ((bannedRightsValue = instance.bannedRights()) != null) {
                    this.bannedRights(bannedRightsValue);
                }
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
                this.joinRequest(instance.joinRequest());
                this.creator(instance.creator());
                this.verified(instance.verified());
                this.photo(instance.photo());
                this.slowmodeEnabled(instance.slowmodeEnabled());
                ChatBannedRights defaultBannedRightsValue = instance.defaultBannedRights();
                if (defaultBannedRightsValue != null) {
                    this.defaultBannedRights(defaultBannedRightsValue);
                }
                this.callNotEmpty(instance.callNotEmpty());
                this.gigagroup(instance.gigagroup());
                ChatAdminRights adminRightsValue = instance.adminRights();
                if (adminRightsValue != null) {
                    this.adminRights(adminRightsValue);
                }
                this.hasLink(instance.hasLink());
                this.left(instance.left());
                this.restricted(instance.restricted());
                this.fake(instance.fake());
                Long accessHashValue = instance.accessHash();
                if (accessHashValue != null) {
                    this.accessHash(accessHashValue);
                }
                if ((usernameValue = instance.username()) != null) {
                    this.username(usernameValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder creator(boolean creator) {
            this.creator = creator;
            this.optBits |= 4L;
            return this;
        }

        public final Builder left(boolean left) {
            this.left = left;
            this.optBits |= 8L;
            return this;
        }

        public final Builder broadcast(boolean broadcast) {
            this.broadcast = broadcast;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder verified(boolean verified) {
            this.verified = verified;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder megagroup(boolean megagroup) {
            this.megagroup = megagroup;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder restricted(boolean restricted) {
            this.restricted = restricted;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder signatures(boolean signatures) {
            this.signatures = signatures;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder min(boolean min) {
            this.min = min;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder scam(boolean scam) {
            this.scam = scam;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder hasLink(boolean hasLink) {
            this.hasLink = hasLink;
            this.optBits |= 0x800L;
            return this;
        }

        public final Builder hasGeo(boolean hasGeo) {
            this.hasGeo = hasGeo;
            this.optBits |= 0x1000L;
            return this;
        }

        public final Builder slowmodeEnabled(boolean slowmodeEnabled) {
            this.slowmodeEnabled = slowmodeEnabled;
            this.optBits |= 0x2000L;
            return this;
        }

        public final Builder callActive(boolean callActive) {
            this.callActive = callActive;
            this.optBits |= 0x4000L;
            return this;
        }

        public final Builder callNotEmpty(boolean callNotEmpty) {
            this.callNotEmpty = callNotEmpty;
            this.optBits |= 0x8000L;
            return this;
        }

        public final Builder fake(boolean fake) {
            this.fake = fake;
            this.optBits |= 0x10000L;
            return this;
        }

        public final Builder gigagroup(boolean gigagroup) {
            this.gigagroup = gigagroup;
            this.optBits |= 0x20000L;
            return this;
        }

        public final Builder noforwards(boolean noforwards) {
            this.noforwards = noforwards;
            this.optBits |= 0x40000L;
            return this;
        }

        public final Builder joinToSend(boolean joinToSend) {
            this.joinToSend = joinToSend;
            this.optBits |= 0x80000L;
            return this;
        }

        public final Builder joinRequest(boolean joinRequest) {
            this.joinRequest = joinRequest;
            this.optBits |= 0x100000L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(@Nullable Long accessHash) {
            this.accessHash = accessHash;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder username(@Nullable String username) {
            this.username = username;
            return this;
        }

        public final Builder photo(ChatPhoto photo) {
            this.photo = Objects.requireNonNull(photo, "photo");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder addRestrictionReason(RestrictionReason element) {
            if (this.restrictionReason == null) {
                this.restrictionReason = new ArrayList<RestrictionReason>();
            }
            this.restrictionReason.add(Objects.requireNonNull(element, "restrictionReason element"));
            return this;
        }

        public final Builder addRestrictionReason(RestrictionReason ... elements) {
            if (this.restrictionReason == null) {
                this.restrictionReason = new ArrayList<RestrictionReason>();
            }
            for (RestrictionReason element : elements) {
                this.restrictionReason.add(Objects.requireNonNull(element, "restrictionReason element"));
            }
            return this;
        }

        public final Builder restrictionReason(@Nullable Iterable<? extends RestrictionReason> elements) {
            if (elements == null) {
                this.restrictionReason = null;
                return this;
            }
            this.restrictionReason = new ArrayList<RestrictionReason>();
            return this.addAllRestrictionReason(elements);
        }

        public final Builder addAllRestrictionReason(Iterable<? extends RestrictionReason> elements) {
            Objects.requireNonNull(elements, "restrictionReason element");
            if (this.restrictionReason == null) {
                this.restrictionReason = new ArrayList<RestrictionReason>();
            }
            for (RestrictionReason restrictionReason : elements) {
                this.restrictionReason.add(Objects.requireNonNull(restrictionReason, "restrictionReason element"));
            }
            return this;
        }

        public final Builder adminRights(@Nullable ChatAdminRights adminRights) {
            this.adminRights = adminRights;
            return this;
        }

        public final Builder bannedRights(@Nullable ChatBannedRights bannedRights) {
            this.bannedRights = bannedRights;
            return this;
        }

        public final Builder defaultBannedRights(@Nullable ChatBannedRights defaultBannedRights) {
            this.defaultBannedRights = defaultBannedRights;
            return this;
        }

        public final Builder participantsCount(@Nullable Integer participantsCount) {
            this.participantsCount = participantsCount;
            return this;
        }

        public ImmutableChannel build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChannel(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean creatorIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean leftIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean broadcastIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean verifiedIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean megagroupIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean restrictedIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean signaturesIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean minIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean scamIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean hasLinkIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private boolean hasGeoIsSet() {
            return (this.optBits & 0x1000L) != 0L;
        }

        private boolean slowmodeEnabledIsSet() {
            return (this.optBits & 0x2000L) != 0L;
        }

        private boolean callActiveIsSet() {
            return (this.optBits & 0x4000L) != 0L;
        }

        private boolean callNotEmptyIsSet() {
            return (this.optBits & 0x8000L) != 0L;
        }

        private boolean fakeIsSet() {
            return (this.optBits & 0x10000L) != 0L;
        }

        private boolean gigagroupIsSet() {
            return (this.optBits & 0x20000L) != 0L;
        }

        private boolean noforwardsIsSet() {
            return (this.optBits & 0x40000L) != 0L;
        }

        private boolean joinToSendIsSet() {
            return (this.optBits & 0x80000L) != 0L;
        }

        private boolean joinRequestIsSet() {
            return (this.optBits & 0x100000L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("photo");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("date");
            }
            return "Cannot build Channel, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte creatorBuildStage = 0;
        private boolean creator;
        private byte leftBuildStage = 0;
        private boolean left;
        private byte broadcastBuildStage = 0;
        private boolean broadcast;
        private byte verifiedBuildStage = 0;
        private boolean verified;
        private byte megagroupBuildStage = 0;
        private boolean megagroup;
        private byte restrictedBuildStage = 0;
        private boolean restricted;
        private byte signaturesBuildStage = 0;
        private boolean signatures;
        private byte minBuildStage = 0;
        private boolean min;
        private byte scamBuildStage = 0;
        private boolean scam;
        private byte hasLinkBuildStage = 0;
        private boolean hasLink;
        private byte hasGeoBuildStage = 0;
        private boolean hasGeo;
        private byte slowmodeEnabledBuildStage = 0;
        private boolean slowmodeEnabled;
        private byte callActiveBuildStage = 0;
        private boolean callActive;
        private byte callNotEmptyBuildStage = 0;
        private boolean callNotEmpty;
        private byte fakeBuildStage = 0;
        private boolean fake;
        private byte gigagroupBuildStage = 0;
        private boolean gigagroup;
        private byte noforwardsBuildStage = 0;
        private boolean noforwards;
        private byte joinToSendBuildStage = 0;
        private boolean joinToSend;
        private byte joinRequestBuildStage = 0;
        private boolean joinRequest;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableChannel.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableChannel.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean creator() {
            if (this.creatorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.creatorBuildStage == 0) {
                this.creatorBuildStage = (byte)-1;
                this.creator = ImmutableChannel.this.creatorInitialize();
                this.creatorBuildStage = 1;
            }
            return this.creator;
        }

        void creator(boolean creator) {
            this.creator = creator;
            this.creatorBuildStage = 1;
        }

        boolean left() {
            if (this.leftBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.leftBuildStage == 0) {
                this.leftBuildStage = (byte)-1;
                this.left = ImmutableChannel.this.leftInitialize();
                this.leftBuildStage = 1;
            }
            return this.left;
        }

        void left(boolean left) {
            this.left = left;
            this.leftBuildStage = 1;
        }

        boolean broadcast() {
            if (this.broadcastBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.broadcastBuildStage == 0) {
                this.broadcastBuildStage = (byte)-1;
                this.broadcast = ImmutableChannel.this.broadcastInitialize();
                this.broadcastBuildStage = 1;
            }
            return this.broadcast;
        }

        void broadcast(boolean broadcast) {
            this.broadcast = broadcast;
            this.broadcastBuildStage = 1;
        }

        boolean verified() {
            if (this.verifiedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.verifiedBuildStage == 0) {
                this.verifiedBuildStage = (byte)-1;
                this.verified = ImmutableChannel.this.verifiedInitialize();
                this.verifiedBuildStage = 1;
            }
            return this.verified;
        }

        void verified(boolean verified) {
            this.verified = verified;
            this.verifiedBuildStage = 1;
        }

        boolean megagroup() {
            if (this.megagroupBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.megagroupBuildStage == 0) {
                this.megagroupBuildStage = (byte)-1;
                this.megagroup = ImmutableChannel.this.megagroupInitialize();
                this.megagroupBuildStage = 1;
            }
            return this.megagroup;
        }

        void megagroup(boolean megagroup) {
            this.megagroup = megagroup;
            this.megagroupBuildStage = 1;
        }

        boolean restricted() {
            if (this.restrictedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.restrictedBuildStage == 0) {
                this.restrictedBuildStage = (byte)-1;
                this.restricted = ImmutableChannel.this.restrictedInitialize();
                this.restrictedBuildStage = 1;
            }
            return this.restricted;
        }

        void restricted(boolean restricted) {
            this.restricted = restricted;
            this.restrictedBuildStage = 1;
        }

        boolean signatures() {
            if (this.signaturesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.signaturesBuildStage == 0) {
                this.signaturesBuildStage = (byte)-1;
                this.signatures = ImmutableChannel.this.signaturesInitialize();
                this.signaturesBuildStage = 1;
            }
            return this.signatures;
        }

        void signatures(boolean signatures) {
            this.signatures = signatures;
            this.signaturesBuildStage = 1;
        }

        boolean min() {
            if (this.minBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBuildStage == 0) {
                this.minBuildStage = (byte)-1;
                this.min = ImmutableChannel.this.minInitialize();
                this.minBuildStage = 1;
            }
            return this.min;
        }

        void min(boolean min) {
            this.min = min;
            this.minBuildStage = 1;
        }

        boolean scam() {
            if (this.scamBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.scamBuildStage == 0) {
                this.scamBuildStage = (byte)-1;
                this.scam = ImmutableChannel.this.scamInitialize();
                this.scamBuildStage = 1;
            }
            return this.scam;
        }

        void scam(boolean scam) {
            this.scam = scam;
            this.scamBuildStage = 1;
        }

        boolean hasLink() {
            if (this.hasLinkBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasLinkBuildStage == 0) {
                this.hasLinkBuildStage = (byte)-1;
                this.hasLink = ImmutableChannel.this.hasLinkInitialize();
                this.hasLinkBuildStage = 1;
            }
            return this.hasLink;
        }

        void hasLink(boolean hasLink) {
            this.hasLink = hasLink;
            this.hasLinkBuildStage = 1;
        }

        boolean hasGeo() {
            if (this.hasGeoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasGeoBuildStage == 0) {
                this.hasGeoBuildStage = (byte)-1;
                this.hasGeo = ImmutableChannel.this.hasGeoInitialize();
                this.hasGeoBuildStage = 1;
            }
            return this.hasGeo;
        }

        void hasGeo(boolean hasGeo) {
            this.hasGeo = hasGeo;
            this.hasGeoBuildStage = 1;
        }

        boolean slowmodeEnabled() {
            if (this.slowmodeEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.slowmodeEnabledBuildStage == 0) {
                this.slowmodeEnabledBuildStage = (byte)-1;
                this.slowmodeEnabled = ImmutableChannel.this.slowmodeEnabledInitialize();
                this.slowmodeEnabledBuildStage = 1;
            }
            return this.slowmodeEnabled;
        }

        void slowmodeEnabled(boolean slowmodeEnabled) {
            this.slowmodeEnabled = slowmodeEnabled;
            this.slowmodeEnabledBuildStage = 1;
        }

        boolean callActive() {
            if (this.callActiveBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.callActiveBuildStage == 0) {
                this.callActiveBuildStage = (byte)-1;
                this.callActive = ImmutableChannel.this.callActiveInitialize();
                this.callActiveBuildStage = 1;
            }
            return this.callActive;
        }

        void callActive(boolean callActive) {
            this.callActive = callActive;
            this.callActiveBuildStage = 1;
        }

        boolean callNotEmpty() {
            if (this.callNotEmptyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.callNotEmptyBuildStage == 0) {
                this.callNotEmptyBuildStage = (byte)-1;
                this.callNotEmpty = ImmutableChannel.this.callNotEmptyInitialize();
                this.callNotEmptyBuildStage = 1;
            }
            return this.callNotEmpty;
        }

        void callNotEmpty(boolean callNotEmpty) {
            this.callNotEmpty = callNotEmpty;
            this.callNotEmptyBuildStage = 1;
        }

        boolean fake() {
            if (this.fakeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fakeBuildStage == 0) {
                this.fakeBuildStage = (byte)-1;
                this.fake = ImmutableChannel.this.fakeInitialize();
                this.fakeBuildStage = 1;
            }
            return this.fake;
        }

        void fake(boolean fake) {
            this.fake = fake;
            this.fakeBuildStage = 1;
        }

        boolean gigagroup() {
            if (this.gigagroupBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.gigagroupBuildStage == 0) {
                this.gigagroupBuildStage = (byte)-1;
                this.gigagroup = ImmutableChannel.this.gigagroupInitialize();
                this.gigagroupBuildStage = 1;
            }
            return this.gigagroup;
        }

        void gigagroup(boolean gigagroup) {
            this.gigagroup = gigagroup;
            this.gigagroupBuildStage = 1;
        }

        boolean noforwards() {
            if (this.noforwardsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.noforwardsBuildStage == 0) {
                this.noforwardsBuildStage = (byte)-1;
                this.noforwards = ImmutableChannel.this.noforwardsInitialize();
                this.noforwardsBuildStage = 1;
            }
            return this.noforwards;
        }

        void noforwards(boolean noforwards) {
            this.noforwards = noforwards;
            this.noforwardsBuildStage = 1;
        }

        boolean joinToSend() {
            if (this.joinToSendBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.joinToSendBuildStage == 0) {
                this.joinToSendBuildStage = (byte)-1;
                this.joinToSend = ImmutableChannel.this.joinToSendInitialize();
                this.joinToSendBuildStage = 1;
            }
            return this.joinToSend;
        }

        void joinToSend(boolean joinToSend) {
            this.joinToSend = joinToSend;
            this.joinToSendBuildStage = 1;
        }

        boolean joinRequest() {
            if (this.joinRequestBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.joinRequestBuildStage == 0) {
                this.joinRequestBuildStage = (byte)-1;
                this.joinRequest = ImmutableChannel.this.joinRequestInitialize();
                this.joinRequestBuildStage = 1;
            }
            return this.joinRequest;
        }

        void joinRequest(boolean joinRequest) {
            this.joinRequest = joinRequest;
            this.joinRequestBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.creatorBuildStage == -1) {
                attributes.add("creator");
            }
            if (this.leftBuildStage == -1) {
                attributes.add("left");
            }
            if (this.broadcastBuildStage == -1) {
                attributes.add("broadcast");
            }
            if (this.verifiedBuildStage == -1) {
                attributes.add("verified");
            }
            if (this.megagroupBuildStage == -1) {
                attributes.add("megagroup");
            }
            if (this.restrictedBuildStage == -1) {
                attributes.add("restricted");
            }
            if (this.signaturesBuildStage == -1) {
                attributes.add("signatures");
            }
            if (this.minBuildStage == -1) {
                attributes.add("min");
            }
            if (this.scamBuildStage == -1) {
                attributes.add("scam");
            }
            if (this.hasLinkBuildStage == -1) {
                attributes.add("hasLink");
            }
            if (this.hasGeoBuildStage == -1) {
                attributes.add("hasGeo");
            }
            if (this.slowmodeEnabledBuildStage == -1) {
                attributes.add("slowmodeEnabled");
            }
            if (this.callActiveBuildStage == -1) {
                attributes.add("callActive");
            }
            if (this.callNotEmptyBuildStage == -1) {
                attributes.add("callNotEmpty");
            }
            if (this.fakeBuildStage == -1) {
                attributes.add("fake");
            }
            if (this.gigagroupBuildStage == -1) {
                attributes.add("gigagroup");
            }
            if (this.noforwardsBuildStage == -1) {
                attributes.add("noforwards");
            }
            if (this.joinToSendBuildStage == -1) {
                attributes.add("joinToSend");
            }
            if (this.joinRequestBuildStage == -1) {
                attributes.add("joinRequest");
            }
            return "Cannot build Channel, attribute initializers form cycle " + attributes;
        }
    }
}

