/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ChannelAdminLogEvent;
import telegram4j.tl.ChannelAdminLogEventAction;
import telegram4j.tl.api.TlObject;

public final class ImmutableChannelAdminLogEvent
implements ChannelAdminLogEvent {
    private final int identifier;
    private final long id;
    private final int date;
    private final long userId;
    private final ChannelAdminLogEventAction action;

    private ImmutableChannelAdminLogEvent(long id, int date, long userId, ChannelAdminLogEventAction action) {
        this.id = id;
        this.date = date;
        this.userId = userId;
        this.action = Objects.requireNonNull(action, "action");
        this.identifier = ChannelAdminLogEvent.super.identifier();
    }

    private ImmutableChannelAdminLogEvent(Builder builder) {
        this.id = builder.id;
        this.date = builder.date;
        this.userId = builder.userId;
        this.action = builder.action;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ChannelAdminLogEvent.super.identifier();
    }

    private ImmutableChannelAdminLogEvent(int identifier, long id, int date, long userId, ChannelAdminLogEventAction action) {
        this.identifier = identifier;
        this.id = id;
        this.date = date;
        this.userId = userId;
        this.action = action;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public ChannelAdminLogEventAction action() {
        return this.action;
    }

    public final ImmutableChannelAdminLogEvent withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChannelAdminLogEvent(value, this.id, this.date, this.userId, this.action);
    }

    public final ImmutableChannelAdminLogEvent withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableChannelAdminLogEvent(this.identifier, value, this.date, this.userId, this.action);
    }

    public final ImmutableChannelAdminLogEvent withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableChannelAdminLogEvent(this.identifier, this.id, value, this.userId, this.action);
    }

    public final ImmutableChannelAdminLogEvent withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableChannelAdminLogEvent(this.identifier, this.id, this.date, value, this.action);
    }

    public final ImmutableChannelAdminLogEvent withAction(ChannelAdminLogEventAction value) {
        if (this.action == value) {
            return this;
        }
        ChannelAdminLogEventAction newValue = Objects.requireNonNull(value, "action");
        return new ImmutableChannelAdminLogEvent(this.identifier, this.id, this.date, this.userId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannelAdminLogEvent && this.equalTo(0, (ImmutableChannelAdminLogEvent)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannelAdminLogEvent another) {
        return this.identifier == another.identifier && this.id == another.id && this.date == another.date && this.userId == another.userId && this.action.equals(another.action);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + this.date;
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + this.action.hashCode();
        return h;
    }

    public String toString() {
        return "ChannelAdminLogEvent{identifier=" + this.identifier + ", id=" + this.id + ", date=" + this.date + ", userId=" + this.userId + ", action=" + this.action + "}";
    }

    public static ImmutableChannelAdminLogEvent of(long id, int date, long userId, ChannelAdminLogEventAction action) {
        return new ImmutableChannelAdminLogEvent(id, date, userId, action);
    }

    public static ImmutableChannelAdminLogEvent copyOf(ChannelAdminLogEvent instance) {
        if (instance instanceof ImmutableChannelAdminLogEvent) {
            return (ImmutableChannelAdminLogEvent)instance;
        }
        return ImmutableChannelAdminLogEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_DATE = 2L;
        private static final long INIT_BIT_USER_ID = 4L;
        private static final long INIT_BIT_ACTION = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private long id;
        private int date;
        private long userId;
        private ChannelAdminLogEventAction action;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChannelAdminLogEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChannelAdminLogEvent) {
                instance = (ChannelAdminLogEvent)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.action(instance.action());
                this.id(instance.id());
                this.userId(instance.userId());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder action(ChannelAdminLogEventAction action) {
            this.action = Objects.requireNonNull(action, "action");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableChannelAdminLogEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChannelAdminLogEvent(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("action");
            }
            return "Cannot build ChannelAdminLogEvent, some of required attributes are not set " + attributes;
        }
    }
}

