/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ChannelAdminLogEventAction;
import telegram4j.tl.ChannelAdminLogEventActionChangeLocation;
import telegram4j.tl.ChannelLocation;
import telegram4j.tl.api.TlObject;

public final class ImmutableChannelAdminLogEventActionChangeLocation
implements ChannelAdminLogEventActionChangeLocation {
    private final int identifier;
    private final ChannelLocation prevValue;
    private final ChannelLocation newValue;

    private ImmutableChannelAdminLogEventActionChangeLocation(ChannelLocation prevValue, ChannelLocation newValue) {
        this.prevValue = Objects.requireNonNull(prevValue, "prevValue");
        this.newValue = Objects.requireNonNull(newValue, "newValue");
        this.identifier = ChannelAdminLogEventActionChangeLocation.super.identifier();
    }

    private ImmutableChannelAdminLogEventActionChangeLocation(Builder builder) {
        this.prevValue = builder.prevValue;
        this.newValue = builder.newValue;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ChannelAdminLogEventActionChangeLocation.super.identifier();
    }

    private ImmutableChannelAdminLogEventActionChangeLocation(int identifier, ChannelLocation prevValue, ChannelLocation newValue) {
        this.identifier = identifier;
        this.prevValue = prevValue;
        this.newValue = newValue;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public ChannelLocation prevValue() {
        return this.prevValue;
    }

    @Override
    public ChannelLocation newValue() {
        return this.newValue;
    }

    public final ImmutableChannelAdminLogEventActionChangeLocation withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChannelAdminLogEventActionChangeLocation(value, this.prevValue, this.newValue);
    }

    public final ImmutableChannelAdminLogEventActionChangeLocation withPrevValue(ChannelLocation value) {
        if (this.prevValue == value) {
            return this;
        }
        ChannelLocation newValue = Objects.requireNonNull(value, "prevValue");
        return new ImmutableChannelAdminLogEventActionChangeLocation(this.identifier, newValue, this.newValue);
    }

    public final ImmutableChannelAdminLogEventActionChangeLocation withNewValue(ChannelLocation value) {
        if (this.newValue == value) {
            return this;
        }
        ChannelLocation newValue = Objects.requireNonNull(value, "newValue");
        return new ImmutableChannelAdminLogEventActionChangeLocation(this.identifier, this.prevValue, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannelAdminLogEventActionChangeLocation && this.equalTo(0, (ImmutableChannelAdminLogEventActionChangeLocation)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannelAdminLogEventActionChangeLocation another) {
        return this.identifier == another.identifier && this.prevValue.equals(another.prevValue) && this.newValue.equals(another.newValue);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.prevValue.hashCode();
        h += (h << 5) + this.newValue.hashCode();
        return h;
    }

    public String toString() {
        return "ChannelAdminLogEventActionChangeLocation{identifier=" + this.identifier + ", prevValue=" + this.prevValue + ", newValue=" + this.newValue + "}";
    }

    public static ImmutableChannelAdminLogEventActionChangeLocation of(ChannelLocation prevValue, ChannelLocation newValue) {
        return new ImmutableChannelAdminLogEventActionChangeLocation(prevValue, newValue);
    }

    public static ImmutableChannelAdminLogEventActionChangeLocation copyOf(ChannelAdminLogEventActionChangeLocation instance) {
        if (instance instanceof ImmutableChannelAdminLogEventActionChangeLocation) {
            return (ImmutableChannelAdminLogEventActionChangeLocation)instance;
        }
        return ImmutableChannelAdminLogEventActionChangeLocation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PREV_VALUE = 1L;
        private static final long INIT_BIT_NEW_VALUE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private ChannelLocation prevValue;
        private ChannelLocation newValue;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChannelAdminLogEventActionChangeLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChannelAdminLogEventAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChannelAdminLogEventActionChangeLocation) {
                instance = (ChannelAdminLogEventActionChangeLocation)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.newValue(instance.newValue());
                this.prevValue(instance.prevValue());
            }
            if (object instanceof ChannelAdminLogEventAction) {
                instance = (ChannelAdminLogEventAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder prevValue(ChannelLocation prevValue) {
            this.prevValue = Objects.requireNonNull(prevValue, "prevValue");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder newValue(ChannelLocation newValue) {
            this.newValue = Objects.requireNonNull(newValue, "newValue");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableChannelAdminLogEventActionChangeLocation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChannelAdminLogEventActionChangeLocation(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("prevValue");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("newValue");
            }
            return "Cannot build ChannelAdminLogEventActionChangeLocation, some of required attributes are not set " + attributes;
        }
    }
}

