/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ChannelAdminLogEventAction;
import telegram4j.tl.ChannelAdminLogEventActionEditMessage;
import telegram4j.tl.Message;
import telegram4j.tl.api.TlObject;

public final class ImmutableChannelAdminLogEventActionEditMessage
implements ChannelAdminLogEventActionEditMessage {
    private final int identifier;
    private final Message prevMessage;
    private final Message newMessage;

    private ImmutableChannelAdminLogEventActionEditMessage(Message prevMessage, Message newMessage) {
        this.prevMessage = Objects.requireNonNull(prevMessage, "prevMessage");
        this.newMessage = Objects.requireNonNull(newMessage, "newMessage");
        this.identifier = ChannelAdminLogEventActionEditMessage.super.identifier();
    }

    private ImmutableChannelAdminLogEventActionEditMessage(Builder builder) {
        this.prevMessage = builder.prevMessage;
        this.newMessage = builder.newMessage;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ChannelAdminLogEventActionEditMessage.super.identifier();
    }

    private ImmutableChannelAdminLogEventActionEditMessage(int identifier, Message prevMessage, Message newMessage) {
        this.identifier = identifier;
        this.prevMessage = prevMessage;
        this.newMessage = newMessage;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Message prevMessage() {
        return this.prevMessage;
    }

    @Override
    public Message newMessage() {
        return this.newMessage;
    }

    public final ImmutableChannelAdminLogEventActionEditMessage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChannelAdminLogEventActionEditMessage(value, this.prevMessage, this.newMessage);
    }

    public final ImmutableChannelAdminLogEventActionEditMessage withPrevMessage(Message value) {
        if (this.prevMessage == value) {
            return this;
        }
        Message newValue = Objects.requireNonNull(value, "prevMessage");
        return new ImmutableChannelAdminLogEventActionEditMessage(this.identifier, newValue, this.newMessage);
    }

    public final ImmutableChannelAdminLogEventActionEditMessage withNewMessage(Message value) {
        if (this.newMessage == value) {
            return this;
        }
        Message newValue = Objects.requireNonNull(value, "newMessage");
        return new ImmutableChannelAdminLogEventActionEditMessage(this.identifier, this.prevMessage, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannelAdminLogEventActionEditMessage && this.equalTo(0, (ImmutableChannelAdminLogEventActionEditMessage)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannelAdminLogEventActionEditMessage another) {
        return this.identifier == another.identifier && this.prevMessage.equals(another.prevMessage) && this.newMessage.equals(another.newMessage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.prevMessage.hashCode();
        h += (h << 5) + this.newMessage.hashCode();
        return h;
    }

    public String toString() {
        return "ChannelAdminLogEventActionEditMessage{identifier=" + this.identifier + ", prevMessage=" + this.prevMessage + ", newMessage=" + this.newMessage + "}";
    }

    public static ImmutableChannelAdminLogEventActionEditMessage of(Message prevMessage, Message newMessage) {
        return new ImmutableChannelAdminLogEventActionEditMessage(prevMessage, newMessage);
    }

    public static ImmutableChannelAdminLogEventActionEditMessage copyOf(ChannelAdminLogEventActionEditMessage instance) {
        if (instance instanceof ImmutableChannelAdminLogEventActionEditMessage) {
            return (ImmutableChannelAdminLogEventActionEditMessage)instance;
        }
        return ImmutableChannelAdminLogEventActionEditMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PREV_MESSAGE = 1L;
        private static final long INIT_BIT_NEW_MESSAGE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private Message prevMessage;
        private Message newMessage;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChannelAdminLogEventActionEditMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChannelAdminLogEventAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChannelAdminLogEventActionEditMessage) {
                instance = (ChannelAdminLogEventActionEditMessage)object;
                this.prevMessage(instance.prevMessage());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.newMessage(instance.newMessage());
            }
            if (object instanceof ChannelAdminLogEventAction) {
                instance = (ChannelAdminLogEventAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder prevMessage(Message prevMessage) {
            this.prevMessage = Objects.requireNonNull(prevMessage, "prevMessage");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder newMessage(Message newMessage) {
            this.newMessage = Objects.requireNonNull(newMessage, "newMessage");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableChannelAdminLogEventActionEditMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChannelAdminLogEventActionEditMessage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("prevMessage");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("newMessage");
            }
            return "Cannot build ChannelAdminLogEventActionEditMessage, some of required attributes are not set " + attributes;
        }
    }
}

