/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ChannelAdminLogEventAction;
import telegram4j.tl.ChannelAdminLogEventActionParticipantJoinByRequest;
import telegram4j.tl.ExportedChatInvite;
import telegram4j.tl.api.TlObject;

public final class ImmutableChannelAdminLogEventActionParticipantJoinByRequest
implements ChannelAdminLogEventActionParticipantJoinByRequest {
    private final int identifier;
    private final ExportedChatInvite invite;
    private final long approvedBy;

    private ImmutableChannelAdminLogEventActionParticipantJoinByRequest(ExportedChatInvite invite, long approvedBy) {
        this.invite = Objects.requireNonNull(invite, "invite");
        this.approvedBy = approvedBy;
        this.identifier = ChannelAdminLogEventActionParticipantJoinByRequest.super.identifier();
    }

    private ImmutableChannelAdminLogEventActionParticipantJoinByRequest(Builder builder) {
        this.invite = builder.invite;
        this.approvedBy = builder.approvedBy;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ChannelAdminLogEventActionParticipantJoinByRequest.super.identifier();
    }

    private ImmutableChannelAdminLogEventActionParticipantJoinByRequest(int identifier, ExportedChatInvite invite, long approvedBy) {
        this.identifier = identifier;
        this.invite = invite;
        this.approvedBy = approvedBy;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public ExportedChatInvite invite() {
        return this.invite;
    }

    @Override
    public long approvedBy() {
        return this.approvedBy;
    }

    public final ImmutableChannelAdminLogEventActionParticipantJoinByRequest withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChannelAdminLogEventActionParticipantJoinByRequest(value, this.invite, this.approvedBy);
    }

    public final ImmutableChannelAdminLogEventActionParticipantJoinByRequest withInvite(ExportedChatInvite value) {
        if (this.invite == value) {
            return this;
        }
        ExportedChatInvite newValue = Objects.requireNonNull(value, "invite");
        return new ImmutableChannelAdminLogEventActionParticipantJoinByRequest(this.identifier, newValue, this.approvedBy);
    }

    public final ImmutableChannelAdminLogEventActionParticipantJoinByRequest withApprovedBy(long value) {
        if (this.approvedBy == value) {
            return this;
        }
        return new ImmutableChannelAdminLogEventActionParticipantJoinByRequest(this.identifier, this.invite, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannelAdminLogEventActionParticipantJoinByRequest && this.equalTo(0, (ImmutableChannelAdminLogEventActionParticipantJoinByRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannelAdminLogEventActionParticipantJoinByRequest another) {
        return this.identifier == another.identifier && this.invite.equals(another.invite) && this.approvedBy == another.approvedBy;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.invite.hashCode();
        h += (h << 5) + Long.hashCode(this.approvedBy);
        return h;
    }

    public String toString() {
        return "ChannelAdminLogEventActionParticipantJoinByRequest{identifier=" + this.identifier + ", invite=" + this.invite + ", approvedBy=" + this.approvedBy + "}";
    }

    public static ImmutableChannelAdminLogEventActionParticipantJoinByRequest of(ExportedChatInvite invite, long approvedBy) {
        return new ImmutableChannelAdminLogEventActionParticipantJoinByRequest(invite, approvedBy);
    }

    public static ImmutableChannelAdminLogEventActionParticipantJoinByRequest copyOf(ChannelAdminLogEventActionParticipantJoinByRequest instance) {
        if (instance instanceof ImmutableChannelAdminLogEventActionParticipantJoinByRequest) {
            return (ImmutableChannelAdminLogEventActionParticipantJoinByRequest)instance;
        }
        return ImmutableChannelAdminLogEventActionParticipantJoinByRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_INVITE = 1L;
        private static final long INIT_BIT_APPROVED_BY = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private ExportedChatInvite invite;
        private long approvedBy;

        private Builder() {
        }

        public final Builder from(ChannelAdminLogEventActionParticipantJoinByRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChannelAdminLogEventAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChannelAdminLogEventAction instance;
            long bits = 0L;
            if (object instanceof ChannelAdminLogEventActionParticipantJoinByRequest) {
                instance = (ChannelAdminLogEventActionParticipantJoinByRequest)object;
                this.approvedBy(instance.approvedBy());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.invite(instance.invite());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChannelAdminLogEventAction) {
                instance = (ChannelAdminLogEventAction)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder invite(ExportedChatInvite invite) {
            this.invite = Objects.requireNonNull(invite, "invite");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder approvedBy(long approvedBy) {
            this.approvedBy = approvedBy;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableChannelAdminLogEventActionParticipantJoinByRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChannelAdminLogEventActionParticipantJoinByRequest(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("invite");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("approvedBy");
            }
            return "Cannot build ChannelAdminLogEventActionParticipantJoinByRequest, some of required attributes are not set " + attributes;
        }
    }
}

