/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.ChannelForbidden;
import telegram4j.tl.Chat;
import telegram4j.tl.api.TlObject;

public final class ImmutableChannelForbidden
implements ChannelForbidden {
    private final int identifier;
    private final int flags;
    private final boolean broadcast;
    private final boolean megagroup;
    private final long id;
    private final long accessHash;
    private final String title;
    @Nullable
    private final Integer untilDate;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableChannelForbidden(long id, long accessHash, String title) {
        this.id = id;
        this.accessHash = accessHash;
        this.title = Objects.requireNonNull(title, "title");
        this.untilDate = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.broadcast = this.initShim.broadcast();
        this.megagroup = this.initShim.megagroup();
        this.initShim = null;
    }

    private ImmutableChannelForbidden(Builder builder) {
        this.id = builder.id;
        this.accessHash = builder.accessHash;
        this.title = builder.title;
        this.untilDate = builder.untilDate;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.broadcastIsSet()) {
            this.initShim.broadcast(builder.broadcast);
        }
        if (builder.megagroupIsSet()) {
            this.initShim.megagroup(builder.megagroup);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.broadcast = this.initShim.broadcast();
        this.megagroup = this.initShim.megagroup();
        this.initShim = null;
    }

    private ImmutableChannelForbidden(int identifier, int flags, boolean broadcast, boolean megagroup, long id, long accessHash, String title, @Nullable Integer untilDate) {
        this.identifier = identifier;
        this.flags = flags;
        this.broadcast = broadcast;
        this.megagroup = megagroup;
        this.id = id;
        this.accessHash = accessHash;
        this.title = title;
        this.untilDate = untilDate;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ChannelForbidden.super.identifier();
    }

    private int flagsInitialize() {
        return ChannelForbidden.super.flags();
    }

    private boolean broadcastInitialize() {
        return ChannelForbidden.super.broadcast();
    }

    private boolean megagroupInitialize() {
        return ChannelForbidden.super.megagroup();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean broadcast() {
        InitShim shim = this.initShim;
        return shim != null ? shim.broadcast() : this.broadcast;
    }

    @Override
    public boolean megagroup() {
        InitShim shim = this.initShim;
        return shim != null ? shim.megagroup() : this.megagroup;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public long accessHash() {
        return this.accessHash;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    @Nullable
    public Integer untilDate() {
        return this.untilDate;
    }

    public final ImmutableChannelForbidden withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChannelForbidden(value, this.flags, this.broadcast, this.megagroup, this.id, this.accessHash, this.title, this.untilDate);
    }

    public final ImmutableChannelForbidden withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableChannelForbidden(this.identifier, value, this.broadcast, this.megagroup, this.id, this.accessHash, this.title, this.untilDate);
    }

    public final ImmutableChannelForbidden withBroadcast(boolean value) {
        if (this.broadcast == value) {
            return this;
        }
        return new ImmutableChannelForbidden(this.identifier, this.flags, value, this.megagroup, this.id, this.accessHash, this.title, this.untilDate);
    }

    public final ImmutableChannelForbidden withMegagroup(boolean value) {
        if (this.megagroup == value) {
            return this;
        }
        return new ImmutableChannelForbidden(this.identifier, this.flags, this.broadcast, value, this.id, this.accessHash, this.title, this.untilDate);
    }

    public final ImmutableChannelForbidden withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableChannelForbidden(this.identifier, this.flags, this.broadcast, this.megagroup, value, this.accessHash, this.title, this.untilDate);
    }

    public final ImmutableChannelForbidden withAccessHash(long value) {
        if (this.accessHash == value) {
            return this;
        }
        return new ImmutableChannelForbidden(this.identifier, this.flags, this.broadcast, this.megagroup, this.id, value, this.title, this.untilDate);
    }

    public final ImmutableChannelForbidden withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableChannelForbidden(this.identifier, this.flags, this.broadcast, this.megagroup, this.id, this.accessHash, newValue, this.untilDate);
    }

    public final ImmutableChannelForbidden withUntilDate(@Nullable Integer value) {
        if (Objects.equals(this.untilDate, value)) {
            return this;
        }
        return new ImmutableChannelForbidden(this.identifier, this.flags, this.broadcast, this.megagroup, this.id, this.accessHash, this.title, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannelForbidden && this.equalTo(0, (ImmutableChannelForbidden)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannelForbidden another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.broadcast == another.broadcast && this.megagroup == another.megagroup && this.id == another.id && this.accessHash == another.accessHash && this.title.equals(another.title) && Objects.equals(this.untilDate, another.untilDate);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.broadcast);
        h += (h << 5) + Boolean.hashCode(this.megagroup);
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + Long.hashCode(this.accessHash);
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + Objects.hashCode(this.untilDate);
        return h;
    }

    public String toString() {
        return "ChannelForbidden{identifier=" + this.identifier + ", flags=" + this.flags + ", broadcast=" + this.broadcast + ", megagroup=" + this.megagroup + ", id=" + this.id + ", accessHash=" + this.accessHash + ", title=" + this.title + ", untilDate=" + this.untilDate + "}";
    }

    public static ImmutableChannelForbidden of(long id, long accessHash, String title) {
        return new ImmutableChannelForbidden(id, accessHash, title);
    }

    public static ImmutableChannelForbidden copyOf(ChannelForbidden instance) {
        if (instance instanceof ImmutableChannelForbidden) {
            return (ImmutableChannelForbidden)instance;
        }
        return ImmutableChannelForbidden.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ACCESS_HASH = 2L;
        private static final long INIT_BIT_TITLE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_BROADCAST = 4L;
        private static final long OPT_BIT_MEGAGROUP = 8L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean broadcast;
        private boolean megagroup;
        private long id;
        private long accessHash;
        private String title;
        private Integer untilDate;

        private Builder() {
        }

        public final Builder from(ChannelForbidden instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Chat instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Chat instance;
            long bits = 0L;
            if (object instanceof ChannelForbidden) {
                Integer untilDateValue;
                instance = (ChannelForbidden)object;
                this.broadcast(instance.broadcast());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((untilDateValue = instance.untilDate()) != null) {
                    this.untilDate(untilDateValue);
                }
                this.flags(instance.flags());
                this.accessHash(instance.accessHash());
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
                this.title(instance.title());
                this.megagroup(instance.megagroup());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Chat) {
                instance = (Chat)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder broadcast(boolean broadcast) {
            this.broadcast = broadcast;
            this.optBits |= 4L;
            return this;
        }

        public final Builder megagroup(boolean megagroup) {
            this.megagroup = megagroup;
            this.optBits |= 8L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder accessHash(long accessHash) {
            this.accessHash = accessHash;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder untilDate(@Nullable Integer untilDate) {
            this.untilDate = untilDate;
            return this;
        }

        public ImmutableChannelForbidden build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChannelForbidden(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean broadcastIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean megagroupIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build ChannelForbidden, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte broadcastBuildStage = 0;
        private boolean broadcast;
        private byte megagroupBuildStage = 0;
        private boolean megagroup;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableChannelForbidden.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableChannelForbidden.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean broadcast() {
            if (this.broadcastBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.broadcastBuildStage == 0) {
                this.broadcastBuildStage = (byte)-1;
                this.broadcast = ImmutableChannelForbidden.this.broadcastInitialize();
                this.broadcastBuildStage = 1;
            }
            return this.broadcast;
        }

        void broadcast(boolean broadcast) {
            this.broadcast = broadcast;
            this.broadcastBuildStage = 1;
        }

        boolean megagroup() {
            if (this.megagroupBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.megagroupBuildStage == 0) {
                this.megagroupBuildStage = (byte)-1;
                this.megagroup = ImmutableChannelForbidden.this.megagroupInitialize();
                this.megagroupBuildStage = 1;
            }
            return this.megagroup;
        }

        void megagroup(boolean megagroup) {
            this.megagroup = megagroup;
            this.megagroupBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.broadcastBuildStage == -1) {
                attributes.add("broadcast");
            }
            if (this.megagroupBuildStage == -1) {
                attributes.add("megagroup");
            }
            return "Cannot build ChannelForbidden, attribute initializers form cycle " + attributes;
        }
    }
}

