/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BotInfo;
import telegram4j.tl.ChannelFull;
import telegram4j.tl.ChannelLocation;
import telegram4j.tl.ChatFull;
import telegram4j.tl.ExportedChatInvite;
import telegram4j.tl.InputGroupCall;
import telegram4j.tl.Peer;
import telegram4j.tl.PeerNotifySettings;
import telegram4j.tl.Photo;
import telegram4j.tl.StickerSet;
import telegram4j.tl.api.TlObject;

public final class ImmutableChannelFull
implements ChannelFull {
    private final int identifier;
    private final int flags;
    private final boolean canViewParticipants;
    private final boolean canSetUsername;
    private final boolean canSetStickers;
    private final boolean hiddenPrehistory;
    private final boolean canSetLocation;
    private final boolean hasScheduled;
    private final boolean canViewStats;
    private final boolean blocked;
    private final int flags2;
    private final boolean canDeleteChannel;
    private final long id;
    private final String about;
    @Nullable
    private final Integer participantsCount;
    @Nullable
    private final Integer adminsCount;
    @Nullable
    private final Integer kickedCount;
    @Nullable
    private final Integer bannedCount;
    @Nullable
    private final Integer onlineCount;
    private final int readInboxMaxId;
    private final int readOutboxMaxId;
    private final int unreadCount;
    private final Photo chatPhoto;
    private final PeerNotifySettings notifySettings;
    @Nullable
    private final ExportedChatInvite exportedInvite;
    private final List<BotInfo> botInfo;
    @Nullable
    private final Long migratedFromChatId;
    @Nullable
    private final Integer migratedFromMaxId;
    @Nullable
    private final Integer pinnedMsgId;
    @Nullable
    private final StickerSet stickerset;
    @Nullable
    private final Integer availableMinId;
    @Nullable
    private final Integer folderId;
    @Nullable
    private final Long linkedChatId;
    @Nullable
    private final ChannelLocation location;
    @Nullable
    private final Integer slowmodeSeconds;
    @Nullable
    private final Integer slowmodeNextSendDate;
    @Nullable
    private final Integer statsDc;
    private final int pts;
    @Nullable
    private final InputGroupCall call;
    @Nullable
    private final Integer ttlPeriod;
    @Nullable
    private final List<String> pendingSuggestions;
    @Nullable
    private final Peer groupcallDefaultJoinAs;
    @Nullable
    private final String themeEmoticon;
    @Nullable
    private final Integer requestsPending;
    @Nullable
    private final List<Long> recentRequesters;
    @Nullable
    private final Peer defaultSendAs;
    @Nullable
    private final List<String> availableReactions;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableChannelFull(long id, String about, int readInboxMaxId, int readOutboxMaxId, int unreadCount, Photo chatPhoto, PeerNotifySettings notifySettings, int pts) {
        this.id = id;
        this.about = Objects.requireNonNull(about, "about");
        this.readInboxMaxId = readInboxMaxId;
        this.readOutboxMaxId = readOutboxMaxId;
        this.unreadCount = unreadCount;
        this.chatPhoto = Objects.requireNonNull(chatPhoto, "chatPhoto");
        this.notifySettings = Objects.requireNonNull(notifySettings, "notifySettings");
        this.pts = pts;
        this.participantsCount = null;
        this.adminsCount = null;
        this.kickedCount = null;
        this.bannedCount = null;
        this.onlineCount = null;
        this.exportedInvite = null;
        this.botInfo = Collections.emptyList();
        this.migratedFromChatId = null;
        this.migratedFromMaxId = null;
        this.pinnedMsgId = null;
        this.stickerset = null;
        this.availableMinId = null;
        this.folderId = null;
        this.linkedChatId = null;
        this.location = null;
        this.slowmodeSeconds = null;
        this.slowmodeNextSendDate = null;
        this.statsDc = null;
        this.call = null;
        this.ttlPeriod = null;
        this.pendingSuggestions = null;
        this.groupcallDefaultJoinAs = null;
        this.themeEmoticon = null;
        this.requestsPending = null;
        this.recentRequesters = null;
        this.defaultSendAs = null;
        this.availableReactions = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.canViewParticipants = this.initShim.canViewParticipants();
        this.canSetUsername = this.initShim.canSetUsername();
        this.canSetStickers = this.initShim.canSetStickers();
        this.hiddenPrehistory = this.initShim.hiddenPrehistory();
        this.canSetLocation = this.initShim.canSetLocation();
        this.hasScheduled = this.initShim.hasScheduled();
        this.canViewStats = this.initShim.canViewStats();
        this.blocked = this.initShim.blocked();
        this.flags2 = this.initShim.flags2();
        this.canDeleteChannel = this.initShim.canDeleteChannel();
        this.initShim = null;
    }

    private ImmutableChannelFull(Builder builder) {
        this.id = builder.id;
        this.about = builder.about;
        this.participantsCount = builder.participantsCount;
        this.adminsCount = builder.adminsCount;
        this.kickedCount = builder.kickedCount;
        this.bannedCount = builder.bannedCount;
        this.onlineCount = builder.onlineCount;
        this.readInboxMaxId = builder.readInboxMaxId;
        this.readOutboxMaxId = builder.readOutboxMaxId;
        this.unreadCount = builder.unreadCount;
        this.chatPhoto = builder.chatPhoto;
        this.notifySettings = builder.notifySettings;
        this.exportedInvite = builder.exportedInvite;
        this.botInfo = ImmutableChannelFull.createUnmodifiableList(true, builder.botInfo);
        this.migratedFromChatId = builder.migratedFromChatId;
        this.migratedFromMaxId = builder.migratedFromMaxId;
        this.pinnedMsgId = builder.pinnedMsgId;
        this.stickerset = builder.stickerset;
        this.availableMinId = builder.availableMinId;
        this.folderId = builder.folderId;
        this.linkedChatId = builder.linkedChatId;
        this.location = builder.location;
        this.slowmodeSeconds = builder.slowmodeSeconds;
        this.slowmodeNextSendDate = builder.slowmodeNextSendDate;
        this.statsDc = builder.statsDc;
        this.pts = builder.pts;
        this.call = builder.call;
        this.ttlPeriod = builder.ttlPeriod;
        this.pendingSuggestions = builder.pendingSuggestions == null ? null : ImmutableChannelFull.createUnmodifiableList(true, builder.pendingSuggestions);
        this.groupcallDefaultJoinAs = builder.groupcallDefaultJoinAs;
        this.themeEmoticon = builder.themeEmoticon;
        this.requestsPending = builder.requestsPending;
        this.recentRequesters = builder.recentRequesters == null ? null : ImmutableChannelFull.createUnmodifiableList(true, builder.recentRequesters);
        this.defaultSendAs = builder.defaultSendAs;
        List<String> list = this.availableReactions = builder.availableReactions == null ? null : ImmutableChannelFull.createUnmodifiableList(true, builder.availableReactions);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.canViewParticipantsIsSet()) {
            this.initShim.canViewParticipants(builder.canViewParticipants);
        }
        if (builder.canSetUsernameIsSet()) {
            this.initShim.canSetUsername(builder.canSetUsername);
        }
        if (builder.canSetStickersIsSet()) {
            this.initShim.canSetStickers(builder.canSetStickers);
        }
        if (builder.hiddenPrehistoryIsSet()) {
            this.initShim.hiddenPrehistory(builder.hiddenPrehistory);
        }
        if (builder.canSetLocationIsSet()) {
            this.initShim.canSetLocation(builder.canSetLocation);
        }
        if (builder.hasScheduledIsSet()) {
            this.initShim.hasScheduled(builder.hasScheduled);
        }
        if (builder.canViewStatsIsSet()) {
            this.initShim.canViewStats(builder.canViewStats);
        }
        if (builder.blockedIsSet()) {
            this.initShim.blocked(builder.blocked);
        }
        if (builder.flags2IsSet()) {
            this.initShim.flags2(builder.flags2);
        }
        if (builder.canDeleteChannelIsSet()) {
            this.initShim.canDeleteChannel(builder.canDeleteChannel);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.canViewParticipants = this.initShim.canViewParticipants();
        this.canSetUsername = this.initShim.canSetUsername();
        this.canSetStickers = this.initShim.canSetStickers();
        this.hiddenPrehistory = this.initShim.hiddenPrehistory();
        this.canSetLocation = this.initShim.canSetLocation();
        this.hasScheduled = this.initShim.hasScheduled();
        this.canViewStats = this.initShim.canViewStats();
        this.blocked = this.initShim.blocked();
        this.flags2 = this.initShim.flags2();
        this.canDeleteChannel = this.initShim.canDeleteChannel();
        this.initShim = null;
    }

    private ImmutableChannelFull(int identifier, int flags, boolean canViewParticipants, boolean canSetUsername, boolean canSetStickers, boolean hiddenPrehistory, boolean canSetLocation, boolean hasScheduled, boolean canViewStats, boolean blocked, int flags2, boolean canDeleteChannel, long id, String about, @Nullable Integer participantsCount, @Nullable Integer adminsCount, @Nullable Integer kickedCount, @Nullable Integer bannedCount, @Nullable Integer onlineCount, int readInboxMaxId, int readOutboxMaxId, int unreadCount, Photo chatPhoto, PeerNotifySettings notifySettings, @Nullable ExportedChatInvite exportedInvite, List<BotInfo> botInfo, @Nullable Long migratedFromChatId, @Nullable Integer migratedFromMaxId, @Nullable Integer pinnedMsgId, @Nullable StickerSet stickerset, @Nullable Integer availableMinId, @Nullable Integer folderId, @Nullable Long linkedChatId, @Nullable ChannelLocation location, @Nullable Integer slowmodeSeconds, @Nullable Integer slowmodeNextSendDate, @Nullable Integer statsDc, int pts, @Nullable InputGroupCall call, @Nullable Integer ttlPeriod, @Nullable List<String> pendingSuggestions, @Nullable Peer groupcallDefaultJoinAs, @Nullable String themeEmoticon, @Nullable Integer requestsPending, @Nullable List<Long> recentRequesters, @Nullable Peer defaultSendAs, @Nullable List<String> availableReactions) {
        this.identifier = identifier;
        this.flags = flags;
        this.canViewParticipants = canViewParticipants;
        this.canSetUsername = canSetUsername;
        this.canSetStickers = canSetStickers;
        this.hiddenPrehistory = hiddenPrehistory;
        this.canSetLocation = canSetLocation;
        this.hasScheduled = hasScheduled;
        this.canViewStats = canViewStats;
        this.blocked = blocked;
        this.flags2 = flags2;
        this.canDeleteChannel = canDeleteChannel;
        this.id = id;
        this.about = about;
        this.participantsCount = participantsCount;
        this.adminsCount = adminsCount;
        this.kickedCount = kickedCount;
        this.bannedCount = bannedCount;
        this.onlineCount = onlineCount;
        this.readInboxMaxId = readInboxMaxId;
        this.readOutboxMaxId = readOutboxMaxId;
        this.unreadCount = unreadCount;
        this.chatPhoto = chatPhoto;
        this.notifySettings = notifySettings;
        this.exportedInvite = exportedInvite;
        this.botInfo = botInfo;
        this.migratedFromChatId = migratedFromChatId;
        this.migratedFromMaxId = migratedFromMaxId;
        this.pinnedMsgId = pinnedMsgId;
        this.stickerset = stickerset;
        this.availableMinId = availableMinId;
        this.folderId = folderId;
        this.linkedChatId = linkedChatId;
        this.location = location;
        this.slowmodeSeconds = slowmodeSeconds;
        this.slowmodeNextSendDate = slowmodeNextSendDate;
        this.statsDc = statsDc;
        this.pts = pts;
        this.call = call;
        this.ttlPeriod = ttlPeriod;
        this.pendingSuggestions = pendingSuggestions;
        this.groupcallDefaultJoinAs = groupcallDefaultJoinAs;
        this.themeEmoticon = themeEmoticon;
        this.requestsPending = requestsPending;
        this.recentRequesters = recentRequesters;
        this.defaultSendAs = defaultSendAs;
        this.availableReactions = availableReactions;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ChannelFull.super.identifier();
    }

    private int flagsInitialize() {
        return ChannelFull.super.flags();
    }

    private boolean canViewParticipantsInitialize() {
        return ChannelFull.super.canViewParticipants();
    }

    private boolean canSetUsernameInitialize() {
        return ChannelFull.super.canSetUsername();
    }

    private boolean canSetStickersInitialize() {
        return ChannelFull.super.canSetStickers();
    }

    private boolean hiddenPrehistoryInitialize() {
        return ChannelFull.super.hiddenPrehistory();
    }

    private boolean canSetLocationInitialize() {
        return ChannelFull.super.canSetLocation();
    }

    private boolean hasScheduledInitialize() {
        return ChannelFull.super.hasScheduled();
    }

    private boolean canViewStatsInitialize() {
        return ChannelFull.super.canViewStats();
    }

    private boolean blockedInitialize() {
        return ChannelFull.super.blocked();
    }

    private int flags2Initialize() {
        return ChannelFull.super.flags2();
    }

    private boolean canDeleteChannelInitialize() {
        return ChannelFull.super.canDeleteChannel();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean canViewParticipants() {
        InitShim shim = this.initShim;
        return shim != null ? shim.canViewParticipants() : this.canViewParticipants;
    }

    @Override
    public boolean canSetUsername() {
        InitShim shim = this.initShim;
        return shim != null ? shim.canSetUsername() : this.canSetUsername;
    }

    @Override
    public boolean canSetStickers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.canSetStickers() : this.canSetStickers;
    }

    @Override
    public boolean hiddenPrehistory() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hiddenPrehistory() : this.hiddenPrehistory;
    }

    @Override
    public boolean canSetLocation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.canSetLocation() : this.canSetLocation;
    }

    @Override
    public boolean hasScheduled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasScheduled() : this.hasScheduled;
    }

    @Override
    public boolean canViewStats() {
        InitShim shim = this.initShim;
        return shim != null ? shim.canViewStats() : this.canViewStats;
    }

    @Override
    public boolean blocked() {
        InitShim shim = this.initShim;
        return shim != null ? shim.blocked() : this.blocked;
    }

    @Override
    public int flags2() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags2() : this.flags2;
    }

    @Override
    public boolean canDeleteChannel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.canDeleteChannel() : this.canDeleteChannel;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public String about() {
        return this.about;
    }

    @Override
    @Nullable
    public Integer participantsCount() {
        return this.participantsCount;
    }

    @Override
    @Nullable
    public Integer adminsCount() {
        return this.adminsCount;
    }

    @Override
    @Nullable
    public Integer kickedCount() {
        return this.kickedCount;
    }

    @Override
    @Nullable
    public Integer bannedCount() {
        return this.bannedCount;
    }

    @Override
    @Nullable
    public Integer onlineCount() {
        return this.onlineCount;
    }

    @Override
    public int readInboxMaxId() {
        return this.readInboxMaxId;
    }

    @Override
    public int readOutboxMaxId() {
        return this.readOutboxMaxId;
    }

    @Override
    public int unreadCount() {
        return this.unreadCount;
    }

    @Override
    public Photo chatPhoto() {
        return this.chatPhoto;
    }

    @Override
    public PeerNotifySettings notifySettings() {
        return this.notifySettings;
    }

    @Override
    @Nullable
    public ExportedChatInvite exportedInvite() {
        return this.exportedInvite;
    }

    @Override
    public List<BotInfo> botInfo() {
        return this.botInfo;
    }

    @Override
    @Nullable
    public Long migratedFromChatId() {
        return this.migratedFromChatId;
    }

    @Override
    @Nullable
    public Integer migratedFromMaxId() {
        return this.migratedFromMaxId;
    }

    @Override
    @Nullable
    public Integer pinnedMsgId() {
        return this.pinnedMsgId;
    }

    @Override
    @Nullable
    public StickerSet stickerset() {
        return this.stickerset;
    }

    @Override
    @Nullable
    public Integer availableMinId() {
        return this.availableMinId;
    }

    @Override
    @Nullable
    public Integer folderId() {
        return this.folderId;
    }

    @Override
    @Nullable
    public Long linkedChatId() {
        return this.linkedChatId;
    }

    @Override
    @Nullable
    public ChannelLocation location() {
        return this.location;
    }

    @Override
    @Nullable
    public Integer slowmodeSeconds() {
        return this.slowmodeSeconds;
    }

    @Override
    @Nullable
    public Integer slowmodeNextSendDate() {
        return this.slowmodeNextSendDate;
    }

    @Override
    @Nullable
    public Integer statsDc() {
        return this.statsDc;
    }

    @Override
    public int pts() {
        return this.pts;
    }

    @Override
    @Nullable
    public InputGroupCall call() {
        return this.call;
    }

    @Override
    @Nullable
    public Integer ttlPeriod() {
        return this.ttlPeriod;
    }

    @Override
    @Nullable
    public List<String> pendingSuggestions() {
        return this.pendingSuggestions;
    }

    @Override
    @Nullable
    public Peer groupcallDefaultJoinAs() {
        return this.groupcallDefaultJoinAs;
    }

    @Override
    @Nullable
    public String themeEmoticon() {
        return this.themeEmoticon;
    }

    @Override
    @Nullable
    public Integer requestsPending() {
        return this.requestsPending;
    }

    @Override
    @Nullable
    public List<Long> recentRequesters() {
        return this.recentRequesters;
    }

    @Override
    @Nullable
    public Peer defaultSendAs() {
        return this.defaultSendAs;
    }

    @Override
    @Nullable
    public List<String> availableReactions() {
        return this.availableReactions;
    }

    public final ImmutableChannelFull withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChannelFull(value, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, value, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withCanViewParticipants(boolean value) {
        if (this.canViewParticipants == value) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, value, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withCanSetUsername(boolean value) {
        if (this.canSetUsername == value) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, value, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withCanSetStickers(boolean value) {
        if (this.canSetStickers == value) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, value, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withHiddenPrehistory(boolean value) {
        if (this.hiddenPrehistory == value) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, value, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withCanSetLocation(boolean value) {
        if (this.canSetLocation == value) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, value, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withHasScheduled(boolean value) {
        if (this.hasScheduled == value) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, value, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withCanViewStats(boolean value) {
        if (this.canViewStats == value) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, value, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withBlocked(boolean value) {
        if (this.blocked == value) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, value, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withFlags2(int value) {
        if (this.flags2 == value) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, value, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withCanDeleteChannel(boolean value) {
        if (this.canDeleteChannel == value) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, value, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, value, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withAbout(String value) {
        String newValue = Objects.requireNonNull(value, "about");
        if (this.about.equals(newValue)) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, newValue, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withParticipantsCount(@Nullable Integer value) {
        if (Objects.equals(this.participantsCount, value)) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, value, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withAdminsCount(@Nullable Integer value) {
        if (Objects.equals(this.adminsCount, value)) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, value, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withKickedCount(@Nullable Integer value) {
        if (Objects.equals(this.kickedCount, value)) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, value, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withBannedCount(@Nullable Integer value) {
        if (Objects.equals(this.bannedCount, value)) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, value, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withOnlineCount(@Nullable Integer value) {
        if (Objects.equals(this.onlineCount, value)) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, value, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withReadInboxMaxId(int value) {
        if (this.readInboxMaxId == value) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, value, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withReadOutboxMaxId(int value) {
        if (this.readOutboxMaxId == value) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, value, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withUnreadCount(int value) {
        if (this.unreadCount == value) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, value, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withChatPhoto(Photo value) {
        if (this.chatPhoto == value) {
            return this;
        }
        Photo newValue = Objects.requireNonNull(value, "chatPhoto");
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, newValue, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withNotifySettings(PeerNotifySettings value) {
        if (this.notifySettings == value) {
            return this;
        }
        PeerNotifySettings newValue = Objects.requireNonNull(value, "notifySettings");
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, newValue, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withExportedInvite(@Nullable ExportedChatInvite value) {
        if (this.exportedInvite == value) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, value, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withBotInfo(BotInfo ... elements) {
        List<BotInfo> newValue = ImmutableChannelFull.createUnmodifiableList(false, ImmutableChannelFull.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, newValue, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withBotInfo(Iterable<? extends BotInfo> elements) {
        if (this.botInfo == elements) {
            return this;
        }
        List<BotInfo> newValue = ImmutableChannelFull.createUnmodifiableList(false, ImmutableChannelFull.createSafeList(elements, true, false));
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, newValue, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withMigratedFromChatId(@Nullable Long value) {
        if (Objects.equals(this.migratedFromChatId, value)) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, value, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withMigratedFromMaxId(@Nullable Integer value) {
        if (Objects.equals(this.migratedFromMaxId, value)) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, value, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withPinnedMsgId(@Nullable Integer value) {
        if (Objects.equals(this.pinnedMsgId, value)) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, value, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withStickerset(@Nullable StickerSet value) {
        if (this.stickerset == value) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, value, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withAvailableMinId(@Nullable Integer value) {
        if (Objects.equals(this.availableMinId, value)) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, value, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withFolderId(@Nullable Integer value) {
        if (Objects.equals(this.folderId, value)) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, value, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withLinkedChatId(@Nullable Long value) {
        if (Objects.equals(this.linkedChatId, value)) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, value, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withLocation(@Nullable ChannelLocation value) {
        if (this.location == value) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, value, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withSlowmodeSeconds(@Nullable Integer value) {
        if (Objects.equals(this.slowmodeSeconds, value)) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, value, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withSlowmodeNextSendDate(@Nullable Integer value) {
        if (Objects.equals(this.slowmodeNextSendDate, value)) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, value, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withStatsDc(@Nullable Integer value) {
        if (Objects.equals(this.statsDc, value)) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, value, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withPts(int value) {
        if (this.pts == value) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, value, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withCall(@Nullable InputGroupCall value) {
        if (this.call == value) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, value, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withTtlPeriod(@Nullable Integer value) {
        if (Objects.equals(this.ttlPeriod, value)) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, value, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withPendingSuggestions(String ... elements) {
        if (elements == null) {
            return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, null, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableChannelFull.createUnmodifiableList(false, ImmutableChannelFull.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, newValue, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withPendingSuggestions(@Nullable Iterable<String> elements) {
        if (this.pendingSuggestions == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableChannelFull.createUnmodifiableList(false, ImmutableChannelFull.createSafeList(elements, true, false));
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, newValue, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withGroupcallDefaultJoinAs(@Nullable Peer value) {
        if (this.groupcallDefaultJoinAs == value) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, value, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withThemeEmoticon(@Nullable String value) {
        if (Objects.equals(this.themeEmoticon, value)) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, value, this.requestsPending, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withRequestsPending(@Nullable Integer value) {
        if (Objects.equals(this.requestsPending, value)) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, value, this.recentRequesters, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withRecentRequesters(long ... elements) {
        if (elements == null) {
            return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, null, this.defaultSendAs, this.availableReactions);
        }
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableChannelFull.createUnmodifiableList(false, wrappedList);
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, newValue, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withRecentRequesters(@Nullable Iterable<Long> elements) {
        if (this.recentRequesters == elements) {
            return this;
        }
        List<Long> newValue = elements == null ? null : ImmutableChannelFull.createUnmodifiableList(false, ImmutableChannelFull.createSafeList(elements, true, false));
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, newValue, this.defaultSendAs, this.availableReactions);
    }

    public final ImmutableChannelFull withDefaultSendAs(@Nullable Peer value) {
        if (this.defaultSendAs == value) {
            return this;
        }
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, value, this.availableReactions);
    }

    public final ImmutableChannelFull withAvailableReactions(String ... elements) {
        if (elements == null) {
            return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, null);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableChannelFull.createUnmodifiableList(false, ImmutableChannelFull.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, newValue);
    }

    public final ImmutableChannelFull withAvailableReactions(@Nullable Iterable<String> elements) {
        if (this.availableReactions == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableChannelFull.createUnmodifiableList(false, ImmutableChannelFull.createSafeList(elements, true, false));
        return new ImmutableChannelFull(this.identifier, this.flags, this.canViewParticipants, this.canSetUsername, this.canSetStickers, this.hiddenPrehistory, this.canSetLocation, this.hasScheduled, this.canViewStats, this.blocked, this.flags2, this.canDeleteChannel, this.id, this.about, this.participantsCount, this.adminsCount, this.kickedCount, this.bannedCount, this.onlineCount, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chatPhoto, this.notifySettings, this.exportedInvite, this.botInfo, this.migratedFromChatId, this.migratedFromMaxId, this.pinnedMsgId, this.stickerset, this.availableMinId, this.folderId, this.linkedChatId, this.location, this.slowmodeSeconds, this.slowmodeNextSendDate, this.statsDc, this.pts, this.call, this.ttlPeriod, this.pendingSuggestions, this.groupcallDefaultJoinAs, this.themeEmoticon, this.requestsPending, this.recentRequesters, this.defaultSendAs, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannelFull && this.equalTo(0, (ImmutableChannelFull)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannelFull another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.canViewParticipants == another.canViewParticipants && this.canSetUsername == another.canSetUsername && this.canSetStickers == another.canSetStickers && this.hiddenPrehistory == another.hiddenPrehistory && this.canSetLocation == another.canSetLocation && this.hasScheduled == another.hasScheduled && this.canViewStats == another.canViewStats && this.blocked == another.blocked && this.flags2 == another.flags2 && this.canDeleteChannel == another.canDeleteChannel && this.id == another.id && this.about.equals(another.about) && Objects.equals(this.participantsCount, another.participantsCount) && Objects.equals(this.adminsCount, another.adminsCount) && Objects.equals(this.kickedCount, another.kickedCount) && Objects.equals(this.bannedCount, another.bannedCount) && Objects.equals(this.onlineCount, another.onlineCount) && this.readInboxMaxId == another.readInboxMaxId && this.readOutboxMaxId == another.readOutboxMaxId && this.unreadCount == another.unreadCount && this.chatPhoto.equals(another.chatPhoto) && this.notifySettings.equals(another.notifySettings) && Objects.equals(this.exportedInvite, another.exportedInvite) && this.botInfo.equals(another.botInfo) && Objects.equals(this.migratedFromChatId, another.migratedFromChatId) && Objects.equals(this.migratedFromMaxId, another.migratedFromMaxId) && Objects.equals(this.pinnedMsgId, another.pinnedMsgId) && Objects.equals(this.stickerset, another.stickerset) && Objects.equals(this.availableMinId, another.availableMinId) && Objects.equals(this.folderId, another.folderId) && Objects.equals(this.linkedChatId, another.linkedChatId) && Objects.equals(this.location, another.location) && Objects.equals(this.slowmodeSeconds, another.slowmodeSeconds) && Objects.equals(this.slowmodeNextSendDate, another.slowmodeNextSendDate) && Objects.equals(this.statsDc, another.statsDc) && this.pts == another.pts && Objects.equals(this.call, another.call) && Objects.equals(this.ttlPeriod, another.ttlPeriod) && Objects.equals(this.pendingSuggestions, another.pendingSuggestions) && Objects.equals(this.groupcallDefaultJoinAs, another.groupcallDefaultJoinAs) && Objects.equals(this.themeEmoticon, another.themeEmoticon) && Objects.equals(this.requestsPending, another.requestsPending) && Objects.equals(this.recentRequesters, another.recentRequesters) && Objects.equals(this.defaultSendAs, another.defaultSendAs) && Objects.equals(this.availableReactions, another.availableReactions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.canViewParticipants);
        h += (h << 5) + Boolean.hashCode(this.canSetUsername);
        h += (h << 5) + Boolean.hashCode(this.canSetStickers);
        h += (h << 5) + Boolean.hashCode(this.hiddenPrehistory);
        h += (h << 5) + Boolean.hashCode(this.canSetLocation);
        h += (h << 5) + Boolean.hashCode(this.hasScheduled);
        h += (h << 5) + Boolean.hashCode(this.canViewStats);
        h += (h << 5) + Boolean.hashCode(this.blocked);
        h += (h << 5) + this.flags2;
        h += (h << 5) + Boolean.hashCode(this.canDeleteChannel);
        h += (h << 5) + Long.hashCode(this.id);
        h += (h << 5) + this.about.hashCode();
        h += (h << 5) + Objects.hashCode(this.participantsCount);
        h += (h << 5) + Objects.hashCode(this.adminsCount);
        h += (h << 5) + Objects.hashCode(this.kickedCount);
        h += (h << 5) + Objects.hashCode(this.bannedCount);
        h += (h << 5) + Objects.hashCode(this.onlineCount);
        h += (h << 5) + this.readInboxMaxId;
        h += (h << 5) + this.readOutboxMaxId;
        h += (h << 5) + this.unreadCount;
        h += (h << 5) + this.chatPhoto.hashCode();
        h += (h << 5) + this.notifySettings.hashCode();
        h += (h << 5) + Objects.hashCode(this.exportedInvite);
        h += (h << 5) + this.botInfo.hashCode();
        h += (h << 5) + Objects.hashCode(this.migratedFromChatId);
        h += (h << 5) + Objects.hashCode(this.migratedFromMaxId);
        h += (h << 5) + Objects.hashCode(this.pinnedMsgId);
        h += (h << 5) + Objects.hashCode(this.stickerset);
        h += (h << 5) + Objects.hashCode(this.availableMinId);
        h += (h << 5) + Objects.hashCode(this.folderId);
        h += (h << 5) + Objects.hashCode(this.linkedChatId);
        h += (h << 5) + Objects.hashCode(this.location);
        h += (h << 5) + Objects.hashCode(this.slowmodeSeconds);
        h += (h << 5) + Objects.hashCode(this.slowmodeNextSendDate);
        h += (h << 5) + Objects.hashCode(this.statsDc);
        h += (h << 5) + this.pts;
        h += (h << 5) + Objects.hashCode(this.call);
        h += (h << 5) + Objects.hashCode(this.ttlPeriod);
        h += (h << 5) + Objects.hashCode(this.pendingSuggestions);
        h += (h << 5) + Objects.hashCode(this.groupcallDefaultJoinAs);
        h += (h << 5) + Objects.hashCode(this.themeEmoticon);
        h += (h << 5) + Objects.hashCode(this.requestsPending);
        h += (h << 5) + Objects.hashCode(this.recentRequesters);
        h += (h << 5) + Objects.hashCode(this.defaultSendAs);
        h += (h << 5) + Objects.hashCode(this.availableReactions);
        return h;
    }

    public String toString() {
        return "ChannelFull{identifier=" + this.identifier + ", flags=" + this.flags + ", canViewParticipants=" + this.canViewParticipants + ", canSetUsername=" + this.canSetUsername + ", canSetStickers=" + this.canSetStickers + ", hiddenPrehistory=" + this.hiddenPrehistory + ", canSetLocation=" + this.canSetLocation + ", hasScheduled=" + this.hasScheduled + ", canViewStats=" + this.canViewStats + ", blocked=" + this.blocked + ", flags2=" + this.flags2 + ", canDeleteChannel=" + this.canDeleteChannel + ", id=" + this.id + ", about=" + this.about + ", participantsCount=" + this.participantsCount + ", adminsCount=" + this.adminsCount + ", kickedCount=" + this.kickedCount + ", bannedCount=" + this.bannedCount + ", onlineCount=" + this.onlineCount + ", readInboxMaxId=" + this.readInboxMaxId + ", readOutboxMaxId=" + this.readOutboxMaxId + ", unreadCount=" + this.unreadCount + ", chatPhoto=" + this.chatPhoto + ", notifySettings=" + this.notifySettings + ", exportedInvite=" + this.exportedInvite + ", botInfo=" + this.botInfo + ", migratedFromChatId=" + this.migratedFromChatId + ", migratedFromMaxId=" + this.migratedFromMaxId + ", pinnedMsgId=" + this.pinnedMsgId + ", stickerset=" + this.stickerset + ", availableMinId=" + this.availableMinId + ", folderId=" + this.folderId + ", linkedChatId=" + this.linkedChatId + ", location=" + this.location + ", slowmodeSeconds=" + this.slowmodeSeconds + ", slowmodeNextSendDate=" + this.slowmodeNextSendDate + ", statsDc=" + this.statsDc + ", pts=" + this.pts + ", call=" + this.call + ", ttlPeriod=" + this.ttlPeriod + ", pendingSuggestions=" + this.pendingSuggestions + ", groupcallDefaultJoinAs=" + this.groupcallDefaultJoinAs + ", themeEmoticon=" + this.themeEmoticon + ", requestsPending=" + this.requestsPending + ", recentRequesters=" + this.recentRequesters + ", defaultSendAs=" + this.defaultSendAs + ", availableReactions=" + this.availableReactions + "}";
    }

    public static ImmutableChannelFull of(long id, String about, int readInboxMaxId, int readOutboxMaxId, int unreadCount, Photo chatPhoto, PeerNotifySettings notifySettings, int pts) {
        return new ImmutableChannelFull(id, about, readInboxMaxId, readOutboxMaxId, unreadCount, chatPhoto, notifySettings, pts);
    }

    public static ImmutableChannelFull copyOf(ChannelFull instance) {
        if (instance instanceof ImmutableChannelFull) {
            return (ImmutableChannelFull)instance;
        }
        return ImmutableChannelFull.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_ABOUT = 2L;
        private static final long INIT_BIT_READ_INBOX_MAX_ID = 4L;
        private static final long INIT_BIT_READ_OUTBOX_MAX_ID = 8L;
        private static final long INIT_BIT_UNREAD_COUNT = 16L;
        private static final long INIT_BIT_CHAT_PHOTO = 32L;
        private static final long INIT_BIT_NOTIFY_SETTINGS = 64L;
        private static final long INIT_BIT_PTS = 128L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_CAN_VIEW_PARTICIPANTS = 4L;
        private static final long OPT_BIT_CAN_SET_USERNAME = 8L;
        private static final long OPT_BIT_CAN_SET_STICKERS = 16L;
        private static final long OPT_BIT_HIDDEN_PREHISTORY = 32L;
        private static final long OPT_BIT_CAN_SET_LOCATION = 64L;
        private static final long OPT_BIT_HAS_SCHEDULED = 128L;
        private static final long OPT_BIT_CAN_VIEW_STATS = 256L;
        private static final long OPT_BIT_BLOCKED = 512L;
        private static final long OPT_BIT_FLAGS2 = 1024L;
        private static final long OPT_BIT_CAN_DELETE_CHANNEL = 2048L;
        private long initBits = 255L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean canViewParticipants;
        private boolean canSetUsername;
        private boolean canSetStickers;
        private boolean hiddenPrehistory;
        private boolean canSetLocation;
        private boolean hasScheduled;
        private boolean canViewStats;
        private boolean blocked;
        private int flags2;
        private boolean canDeleteChannel;
        private long id;
        private String about;
        private Integer participantsCount;
        private Integer adminsCount;
        private Integer kickedCount;
        private Integer bannedCount;
        private Integer onlineCount;
        private int readInboxMaxId;
        private int readOutboxMaxId;
        private int unreadCount;
        private Photo chatPhoto;
        private PeerNotifySettings notifySettings;
        private ExportedChatInvite exportedInvite;
        private List<BotInfo> botInfo = new ArrayList<BotInfo>();
        private Long migratedFromChatId;
        private Integer migratedFromMaxId;
        private Integer pinnedMsgId;
        private StickerSet stickerset;
        private Integer availableMinId;
        private Integer folderId;
        private Long linkedChatId;
        private ChannelLocation location;
        private Integer slowmodeSeconds;
        private Integer slowmodeNextSendDate;
        private Integer statsDc;
        private int pts;
        private InputGroupCall call;
        private Integer ttlPeriod;
        private List<String> pendingSuggestions = null;
        private Peer groupcallDefaultJoinAs;
        private String themeEmoticon;
        private Integer requestsPending;
        private List<Long> recentRequesters = null;
        private Peer defaultSendAs;
        private List<String> availableReactions = null;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChannelFull instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChatFull instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 0x400L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 0x400L;
                }
            }
            if (object instanceof ChannelFull) {
                Integer slowmodeNextSendDateValue;
                ChannelLocation locationValue;
                StickerSet stickersetValue;
                Long migratedFromChatIdValue;
                Integer onlineCountValue;
                Integer availableMinIdValue;
                Integer statsDcValue;
                Peer defaultSendAsValue;
                Integer slowmodeSecondsValue;
                Integer adminsCountValue;
                Integer migratedFromMaxIdValue;
                instance = (ChannelFull)object;
                Integer participantsCountValue = instance.participantsCount();
                if (participantsCountValue != null) {
                    this.participantsCount(participantsCountValue);
                }
                if ((migratedFromMaxIdValue = instance.migratedFromMaxId()) != null) {
                    this.migratedFromMaxId(migratedFromMaxIdValue);
                }
                this.chatPhoto(instance.chatPhoto());
                Integer kickedCountValue = instance.kickedCount();
                if (kickedCountValue != null) {
                    this.kickedCount(kickedCountValue);
                }
                this.readInboxMaxId(instance.readInboxMaxId());
                this.addAllBotInfo(instance.botInfo());
                if ((bits & 1L) == 0L) {
                    Integer pinnedMsgIdValue = instance.pinnedMsgId();
                    if (pinnedMsgIdValue != null) {
                        this.pinnedMsgId(pinnedMsgIdValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.about(instance.about());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    List<Long> recentRequestersValue = instance.recentRequesters();
                    if (recentRequestersValue != null) {
                        this.addAllRecentRequesters(recentRequestersValue);
                    }
                    bits |= 8L;
                }
                this.unreadCount(instance.unreadCount());
                this.canSetLocation(instance.canSetLocation());
                if ((bits & 0x10L) == 0L) {
                    this.canSetUsername(instance.canSetUsername());
                    bits |= 0x10L;
                }
                if ((adminsCountValue = instance.adminsCount()) != null) {
                    this.adminsCount(adminsCountValue);
                }
                if ((slowmodeSecondsValue = instance.slowmodeSeconds()) != null) {
                    this.slowmodeSeconds(slowmodeSecondsValue);
                }
                if ((defaultSendAsValue = instance.defaultSendAs()) != null) {
                    this.defaultSendAs(defaultSendAsValue);
                }
                this.canViewParticipants(instance.canViewParticipants());
                if ((bits & 0x20L) == 0L) {
                    String themeEmoticonValue = instance.themeEmoticon();
                    if (themeEmoticonValue != null) {
                        this.themeEmoticon(themeEmoticonValue);
                    }
                    bits |= 0x20L;
                }
                if ((statsDcValue = instance.statsDc()) != null) {
                    this.statsDc(statsDcValue);
                }
                this.blocked(instance.blocked());
                if ((bits & 0x40L) == 0L) {
                    Integer requestsPendingValue = instance.requestsPending();
                    if (requestsPendingValue != null) {
                        this.requestsPending(requestsPendingValue);
                    }
                    bits |= 0x40L;
                }
                if ((availableMinIdValue = instance.availableMinId()) != null) {
                    this.availableMinId(availableMinIdValue);
                }
                if ((bits & 0x80L) == 0L) {
                    this.id(instance.id());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.hasScheduled(instance.hasScheduled());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    ExportedChatInvite exportedInviteValue = instance.exportedInvite();
                    if (exportedInviteValue != null) {
                        this.exportedInvite(exportedInviteValue);
                    }
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 0x400L;
                }
                if ((onlineCountValue = instance.onlineCount()) != null) {
                    this.onlineCount(onlineCountValue);
                }
                if ((migratedFromChatIdValue = instance.migratedFromChatId()) != null) {
                    this.migratedFromChatId(migratedFromChatIdValue);
                }
                if ((bits & 0x800L) == 0L) {
                    Peer groupcallDefaultJoinAsValue = instance.groupcallDefaultJoinAs();
                    if (groupcallDefaultJoinAsValue != null) {
                        this.groupcallDefaultJoinAs(groupcallDefaultJoinAsValue);
                    }
                    bits |= 0x800L;
                }
                this.canViewStats(instance.canViewStats());
                this.flags2(instance.flags2());
                this.canDeleteChannel(instance.canDeleteChannel());
                Long linkedChatIdValue = instance.linkedChatId();
                if (linkedChatIdValue != null) {
                    this.linkedChatId(linkedChatIdValue);
                }
                if ((bits & 0x1000L) == 0L) {
                    List<String> availableReactionsValue = instance.availableReactions();
                    if (availableReactionsValue != null) {
                        this.addAllAvailableReactions(availableReactionsValue);
                    }
                    bits |= 0x1000L;
                }
                this.hiddenPrehistory(instance.hiddenPrehistory());
                if ((bits & 0x2000L) == 0L) {
                    this.notifySettings(instance.notifySettings());
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    Integer folderIdValue = instance.folderId();
                    if (folderIdValue != null) {
                        this.folderId(folderIdValue);
                    }
                    bits |= 0x4000L;
                }
                this.pts(instance.pts());
                this.canSetStickers(instance.canSetStickers());
                List<String> pendingSuggestionsValue = instance.pendingSuggestions();
                if (pendingSuggestionsValue != null) {
                    this.addAllPendingSuggestions(pendingSuggestionsValue);
                }
                if ((bits & 0x8000L) == 0L) {
                    InputGroupCall callValue = instance.call();
                    if (callValue != null) {
                        this.call(callValue);
                    }
                    bits |= 0x8000L;
                }
                this.readOutboxMaxId(instance.readOutboxMaxId());
                Integer bannedCountValue = instance.bannedCount();
                if (bannedCountValue != null) {
                    this.bannedCount(bannedCountValue);
                }
                if ((bits & 0x10000L) == 0L) {
                    Integer ttlPeriodValue = instance.ttlPeriod();
                    if (ttlPeriodValue != null) {
                        this.ttlPeriod(ttlPeriodValue);
                    }
                    bits |= 0x10000L;
                }
                if ((stickersetValue = instance.stickerset()) != null) {
                    this.stickerset(stickersetValue);
                }
                if ((locationValue = instance.location()) != null) {
                    this.location(locationValue);
                }
                if ((slowmodeNextSendDateValue = instance.slowmodeNextSendDate()) != null) {
                    this.slowmodeNextSendDate(slowmodeNextSendDateValue);
                }
            }
            if (object instanceof ChatFull) {
                instance = (ChatFull)object;
                if ((bits & 0x400L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    Peer groupcallDefaultJoinAsValue = instance.groupcallDefaultJoinAs();
                    if (groupcallDefaultJoinAsValue != null) {
                        this.groupcallDefaultJoinAs(groupcallDefaultJoinAsValue);
                    }
                    bits |= 0x800L;
                }
                if ((bits & 1L) == 0L) {
                    Integer pinnedMsgIdValue = instance.pinnedMsgId();
                    if (pinnedMsgIdValue != null) {
                        this.pinnedMsgId(pinnedMsgIdValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 0x1000L) == 0L) {
                    List<String> availableReactionsValue = instance.availableReactions();
                    if (availableReactionsValue != null) {
                        this.addAllAvailableReactions(availableReactionsValue);
                    }
                    bits |= 0x1000L;
                }
                if ((bits & 2L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.about(instance.about());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    List<Long> recentRequestersValue = instance.recentRequesters();
                    if (recentRequestersValue != null) {
                        this.addAllRecentRequesters(recentRequestersValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.canSetUsername(instance.canSetUsername());
                    bits |= 0x10L;
                }
                if ((bits & 0x2000L) == 0L) {
                    this.notifySettings(instance.notifySettings());
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    Integer folderIdValue = instance.folderId();
                    if (folderIdValue != null) {
                        this.folderId(folderIdValue);
                    }
                    bits |= 0x4000L;
                }
                if ((bits & 0x20L) == 0L) {
                    String themeEmoticonValue = instance.themeEmoticon();
                    if (themeEmoticonValue != null) {
                        this.themeEmoticon(themeEmoticonValue);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x8000L) == 0L) {
                    InputGroupCall callValue = instance.call();
                    if (callValue != null) {
                        this.call(callValue);
                    }
                    bits |= 0x8000L;
                }
                if ((bits & 0x40L) == 0L) {
                    Integer requestsPendingValue = instance.requestsPending();
                    if (requestsPendingValue != null) {
                        this.requestsPending(requestsPendingValue);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x10000L) == 0L) {
                    Integer ttlPeriodValue = instance.ttlPeriod();
                    if (ttlPeriodValue != null) {
                        this.ttlPeriod(ttlPeriodValue);
                    }
                    bits |= 0x10000L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.id(instance.id());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.hasScheduled(instance.hasScheduled());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    ExportedChatInvite exportedInviteValue = instance.exportedInvite();
                    if (exportedInviteValue != null) {
                        this.exportedInvite(exportedInviteValue);
                    }
                    bits |= 0x200L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder canViewParticipants(boolean canViewParticipants) {
            this.canViewParticipants = canViewParticipants;
            this.optBits |= 4L;
            return this;
        }

        public final Builder canSetUsername(boolean canSetUsername) {
            this.canSetUsername = canSetUsername;
            this.optBits |= 8L;
            return this;
        }

        public final Builder canSetStickers(boolean canSetStickers) {
            this.canSetStickers = canSetStickers;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder hiddenPrehistory(boolean hiddenPrehistory) {
            this.hiddenPrehistory = hiddenPrehistory;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder canSetLocation(boolean canSetLocation) {
            this.canSetLocation = canSetLocation;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder hasScheduled(boolean hasScheduled) {
            this.hasScheduled = hasScheduled;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder canViewStats(boolean canViewStats) {
            this.canViewStats = canViewStats;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder blocked(boolean blocked) {
            this.blocked = blocked;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder flags2(int flags2) {
            this.flags2 = flags2;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder canDeleteChannel(boolean canDeleteChannel) {
            this.canDeleteChannel = canDeleteChannel;
            this.optBits |= 0x800L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder about(String about) {
            this.about = Objects.requireNonNull(about, "about");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder participantsCount(@Nullable Integer participantsCount) {
            this.participantsCount = participantsCount;
            return this;
        }

        public final Builder adminsCount(@Nullable Integer adminsCount) {
            this.adminsCount = adminsCount;
            return this;
        }

        public final Builder kickedCount(@Nullable Integer kickedCount) {
            this.kickedCount = kickedCount;
            return this;
        }

        public final Builder bannedCount(@Nullable Integer bannedCount) {
            this.bannedCount = bannedCount;
            return this;
        }

        public final Builder onlineCount(@Nullable Integer onlineCount) {
            this.onlineCount = onlineCount;
            return this;
        }

        public final Builder readInboxMaxId(int readInboxMaxId) {
            this.readInboxMaxId = readInboxMaxId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder readOutboxMaxId(int readOutboxMaxId) {
            this.readOutboxMaxId = readOutboxMaxId;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder unreadCount(int unreadCount) {
            this.unreadCount = unreadCount;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder chatPhoto(Photo chatPhoto) {
            this.chatPhoto = Objects.requireNonNull(chatPhoto, "chatPhoto");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder notifySettings(PeerNotifySettings notifySettings) {
            this.notifySettings = Objects.requireNonNull(notifySettings, "notifySettings");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder exportedInvite(@Nullable ExportedChatInvite exportedInvite) {
            this.exportedInvite = exportedInvite;
            return this;
        }

        public final Builder addBotInfo(BotInfo element) {
            this.botInfo.add(Objects.requireNonNull(element, "botInfo element"));
            return this;
        }

        public final Builder addBotInfo(BotInfo ... elements) {
            for (BotInfo element : elements) {
                this.botInfo.add(Objects.requireNonNull(element, "botInfo element"));
            }
            return this;
        }

        public final Builder botInfo(Iterable<? extends BotInfo> elements) {
            this.botInfo.clear();
            return this.addAllBotInfo(elements);
        }

        public final Builder addAllBotInfo(Iterable<? extends BotInfo> elements) {
            for (BotInfo botInfo : elements) {
                this.botInfo.add(Objects.requireNonNull(botInfo, "botInfo element"));
            }
            return this;
        }

        public final Builder migratedFromChatId(@Nullable Long migratedFromChatId) {
            this.migratedFromChatId = migratedFromChatId;
            return this;
        }

        public final Builder migratedFromMaxId(@Nullable Integer migratedFromMaxId) {
            this.migratedFromMaxId = migratedFromMaxId;
            return this;
        }

        public final Builder pinnedMsgId(@Nullable Integer pinnedMsgId) {
            this.pinnedMsgId = pinnedMsgId;
            return this;
        }

        public final Builder stickerset(@Nullable StickerSet stickerset) {
            this.stickerset = stickerset;
            return this;
        }

        public final Builder availableMinId(@Nullable Integer availableMinId) {
            this.availableMinId = availableMinId;
            return this;
        }

        public final Builder folderId(@Nullable Integer folderId) {
            this.folderId = folderId;
            return this;
        }

        public final Builder linkedChatId(@Nullable Long linkedChatId) {
            this.linkedChatId = linkedChatId;
            return this;
        }

        public final Builder location(@Nullable ChannelLocation location) {
            this.location = location;
            return this;
        }

        public final Builder slowmodeSeconds(@Nullable Integer slowmodeSeconds) {
            this.slowmodeSeconds = slowmodeSeconds;
            return this;
        }

        public final Builder slowmodeNextSendDate(@Nullable Integer slowmodeNextSendDate) {
            this.slowmodeNextSendDate = slowmodeNextSendDate;
            return this;
        }

        public final Builder statsDc(@Nullable Integer statsDc) {
            this.statsDc = statsDc;
            return this;
        }

        public final Builder pts(int pts) {
            this.pts = pts;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder call(@Nullable InputGroupCall call) {
            this.call = call;
            return this;
        }

        public final Builder ttlPeriod(@Nullable Integer ttlPeriod) {
            this.ttlPeriod = ttlPeriod;
            return this;
        }

        public final Builder addPendingSuggestion(String element) {
            if (this.pendingSuggestions == null) {
                this.pendingSuggestions = new ArrayList<String>();
            }
            this.pendingSuggestions.add(Objects.requireNonNull(element, "pendingSuggestions element"));
            return this;
        }

        public final Builder addPendingSuggestions(String ... elements) {
            if (this.pendingSuggestions == null) {
                this.pendingSuggestions = new ArrayList<String>();
            }
            for (String element : elements) {
                this.pendingSuggestions.add(Objects.requireNonNull(element, "pendingSuggestions element"));
            }
            return this;
        }

        public final Builder pendingSuggestions(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.pendingSuggestions = null;
                return this;
            }
            this.pendingSuggestions = new ArrayList<String>();
            return this.addAllPendingSuggestions(elements);
        }

        public final Builder addAllPendingSuggestions(Iterable<String> elements) {
            Objects.requireNonNull(elements, "pendingSuggestions element");
            if (this.pendingSuggestions == null) {
                this.pendingSuggestions = new ArrayList<String>();
            }
            for (String element : elements) {
                this.pendingSuggestions.add(Objects.requireNonNull(element, "pendingSuggestions element"));
            }
            return this;
        }

        public final Builder groupcallDefaultJoinAs(@Nullable Peer groupcallDefaultJoinAs) {
            this.groupcallDefaultJoinAs = groupcallDefaultJoinAs;
            return this;
        }

        public final Builder themeEmoticon(@Nullable String themeEmoticon) {
            this.themeEmoticon = themeEmoticon;
            return this;
        }

        public final Builder requestsPending(@Nullable Integer requestsPending) {
            this.requestsPending = requestsPending;
            return this;
        }

        public final Builder addRecentRequester(long element) {
            if (this.recentRequesters == null) {
                this.recentRequesters = new ArrayList<Long>();
            }
            this.recentRequesters.add(element);
            return this;
        }

        public final Builder addRecentRequesters(long ... elements) {
            if (this.recentRequesters == null) {
                this.recentRequesters = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.recentRequesters.add(element);
            }
            return this;
        }

        public final Builder recentRequesters(@Nullable Iterable<Long> elements) {
            if (elements == null) {
                this.recentRequesters = null;
                return this;
            }
            this.recentRequesters = new ArrayList<Long>();
            return this.addAllRecentRequesters(elements);
        }

        public final Builder addAllRecentRequesters(Iterable<Long> elements) {
            Objects.requireNonNull(elements, "recentRequesters element");
            if (this.recentRequesters == null) {
                this.recentRequesters = new ArrayList<Long>();
            }
            for (Long element : elements) {
                this.recentRequesters.add(Objects.requireNonNull(element, "recentRequesters element"));
            }
            return this;
        }

        public final Builder defaultSendAs(@Nullable Peer defaultSendAs) {
            this.defaultSendAs = defaultSendAs;
            return this;
        }

        public final Builder addAvailableReaction(String element) {
            if (this.availableReactions == null) {
                this.availableReactions = new ArrayList<String>();
            }
            this.availableReactions.add(Objects.requireNonNull(element, "availableReactions element"));
            return this;
        }

        public final Builder addAvailableReactions(String ... elements) {
            if (this.availableReactions == null) {
                this.availableReactions = new ArrayList<String>();
            }
            for (String element : elements) {
                this.availableReactions.add(Objects.requireNonNull(element, "availableReactions element"));
            }
            return this;
        }

        public final Builder availableReactions(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.availableReactions = null;
                return this;
            }
            this.availableReactions = new ArrayList<String>();
            return this.addAllAvailableReactions(elements);
        }

        public final Builder addAllAvailableReactions(Iterable<String> elements) {
            Objects.requireNonNull(elements, "availableReactions element");
            if (this.availableReactions == null) {
                this.availableReactions = new ArrayList<String>();
            }
            for (String element : elements) {
                this.availableReactions.add(Objects.requireNonNull(element, "availableReactions element"));
            }
            return this;
        }

        public ImmutableChannelFull build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChannelFull(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean canViewParticipantsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean canSetUsernameIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean canSetStickersIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean hiddenPrehistoryIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean canSetLocationIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean hasScheduledIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean canViewStatsIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean blockedIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean flags2IsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean canDeleteChannelIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("about");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("readInboxMaxId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("readOutboxMaxId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("unreadCount");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("chatPhoto");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("notifySettings");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("pts");
            }
            return "Cannot build ChannelFull, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte canViewParticipantsBuildStage = 0;
        private boolean canViewParticipants;
        private byte canSetUsernameBuildStage = 0;
        private boolean canSetUsername;
        private byte canSetStickersBuildStage = 0;
        private boolean canSetStickers;
        private byte hiddenPrehistoryBuildStage = 0;
        private boolean hiddenPrehistory;
        private byte canSetLocationBuildStage = 0;
        private boolean canSetLocation;
        private byte hasScheduledBuildStage = 0;
        private boolean hasScheduled;
        private byte canViewStatsBuildStage = 0;
        private boolean canViewStats;
        private byte blockedBuildStage = 0;
        private boolean blocked;
        private byte flags2BuildStage = 0;
        private int flags2;
        private byte canDeleteChannelBuildStage = 0;
        private boolean canDeleteChannel;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableChannelFull.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableChannelFull.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean canViewParticipants() {
            if (this.canViewParticipantsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.canViewParticipantsBuildStage == 0) {
                this.canViewParticipantsBuildStage = (byte)-1;
                this.canViewParticipants = ImmutableChannelFull.this.canViewParticipantsInitialize();
                this.canViewParticipantsBuildStage = 1;
            }
            return this.canViewParticipants;
        }

        void canViewParticipants(boolean canViewParticipants) {
            this.canViewParticipants = canViewParticipants;
            this.canViewParticipantsBuildStage = 1;
        }

        boolean canSetUsername() {
            if (this.canSetUsernameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.canSetUsernameBuildStage == 0) {
                this.canSetUsernameBuildStage = (byte)-1;
                this.canSetUsername = ImmutableChannelFull.this.canSetUsernameInitialize();
                this.canSetUsernameBuildStage = 1;
            }
            return this.canSetUsername;
        }

        void canSetUsername(boolean canSetUsername) {
            this.canSetUsername = canSetUsername;
            this.canSetUsernameBuildStage = 1;
        }

        boolean canSetStickers() {
            if (this.canSetStickersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.canSetStickersBuildStage == 0) {
                this.canSetStickersBuildStage = (byte)-1;
                this.canSetStickers = ImmutableChannelFull.this.canSetStickersInitialize();
                this.canSetStickersBuildStage = 1;
            }
            return this.canSetStickers;
        }

        void canSetStickers(boolean canSetStickers) {
            this.canSetStickers = canSetStickers;
            this.canSetStickersBuildStage = 1;
        }

        boolean hiddenPrehistory() {
            if (this.hiddenPrehistoryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hiddenPrehistoryBuildStage == 0) {
                this.hiddenPrehistoryBuildStage = (byte)-1;
                this.hiddenPrehistory = ImmutableChannelFull.this.hiddenPrehistoryInitialize();
                this.hiddenPrehistoryBuildStage = 1;
            }
            return this.hiddenPrehistory;
        }

        void hiddenPrehistory(boolean hiddenPrehistory) {
            this.hiddenPrehistory = hiddenPrehistory;
            this.hiddenPrehistoryBuildStage = 1;
        }

        boolean canSetLocation() {
            if (this.canSetLocationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.canSetLocationBuildStage == 0) {
                this.canSetLocationBuildStage = (byte)-1;
                this.canSetLocation = ImmutableChannelFull.this.canSetLocationInitialize();
                this.canSetLocationBuildStage = 1;
            }
            return this.canSetLocation;
        }

        void canSetLocation(boolean canSetLocation) {
            this.canSetLocation = canSetLocation;
            this.canSetLocationBuildStage = 1;
        }

        boolean hasScheduled() {
            if (this.hasScheduledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasScheduledBuildStage == 0) {
                this.hasScheduledBuildStage = (byte)-1;
                this.hasScheduled = ImmutableChannelFull.this.hasScheduledInitialize();
                this.hasScheduledBuildStage = 1;
            }
            return this.hasScheduled;
        }

        void hasScheduled(boolean hasScheduled) {
            this.hasScheduled = hasScheduled;
            this.hasScheduledBuildStage = 1;
        }

        boolean canViewStats() {
            if (this.canViewStatsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.canViewStatsBuildStage == 0) {
                this.canViewStatsBuildStage = (byte)-1;
                this.canViewStats = ImmutableChannelFull.this.canViewStatsInitialize();
                this.canViewStatsBuildStage = 1;
            }
            return this.canViewStats;
        }

        void canViewStats(boolean canViewStats) {
            this.canViewStats = canViewStats;
            this.canViewStatsBuildStage = 1;
        }

        boolean blocked() {
            if (this.blockedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.blockedBuildStage == 0) {
                this.blockedBuildStage = (byte)-1;
                this.blocked = ImmutableChannelFull.this.blockedInitialize();
                this.blockedBuildStage = 1;
            }
            return this.blocked;
        }

        void blocked(boolean blocked) {
            this.blocked = blocked;
            this.blockedBuildStage = 1;
        }

        int flags2() {
            if (this.flags2BuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flags2BuildStage == 0) {
                this.flags2BuildStage = (byte)-1;
                this.flags2 = ImmutableChannelFull.this.flags2Initialize();
                this.flags2BuildStage = 1;
            }
            return this.flags2;
        }

        void flags2(int flags2) {
            this.flags2 = flags2;
            this.flags2BuildStage = 1;
        }

        boolean canDeleteChannel() {
            if (this.canDeleteChannelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.canDeleteChannelBuildStage == 0) {
                this.canDeleteChannelBuildStage = (byte)-1;
                this.canDeleteChannel = ImmutableChannelFull.this.canDeleteChannelInitialize();
                this.canDeleteChannelBuildStage = 1;
            }
            return this.canDeleteChannel;
        }

        void canDeleteChannel(boolean canDeleteChannel) {
            this.canDeleteChannel = canDeleteChannel;
            this.canDeleteChannelBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.canViewParticipantsBuildStage == -1) {
                attributes.add("canViewParticipants");
            }
            if (this.canSetUsernameBuildStage == -1) {
                attributes.add("canSetUsername");
            }
            if (this.canSetStickersBuildStage == -1) {
                attributes.add("canSetStickers");
            }
            if (this.hiddenPrehistoryBuildStage == -1) {
                attributes.add("hiddenPrehistory");
            }
            if (this.canSetLocationBuildStage == -1) {
                attributes.add("canSetLocation");
            }
            if (this.hasScheduledBuildStage == -1) {
                attributes.add("hasScheduled");
            }
            if (this.canViewStatsBuildStage == -1) {
                attributes.add("canViewStats");
            }
            if (this.blockedBuildStage == -1) {
                attributes.add("blocked");
            }
            if (this.flags2BuildStage == -1) {
                attributes.add("flags2");
            }
            if (this.canDeleteChannelBuildStage == -1) {
                attributes.add("canDeleteChannel");
            }
            return "Cannot build ChannelFull, attribute initializers form cycle " + attributes;
        }
    }
}

