/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.Objects;
import telegram4j.tl.ChannelLocation;
import telegram4j.tl.ChannelLocationEmpty;
import telegram4j.tl.api.EmptyObject;
import telegram4j.tl.api.TlObject;

public final class ImmutableChannelLocationEmpty
implements ChannelLocationEmpty {
    private final int identifier;
    private static final ImmutableChannelLocationEmpty INSTANCE = ImmutableChannelLocationEmpty.validate(new ImmutableChannelLocationEmpty());

    private ImmutableChannelLocationEmpty() {
        this.identifier = ChannelLocationEmpty.super.identifier();
    }

    private ImmutableChannelLocationEmpty(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : ChannelLocationEmpty.super.identifier();
    }

    private ImmutableChannelLocationEmpty(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableChannelLocationEmpty withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableChannelLocationEmpty.validate(new ImmutableChannelLocationEmpty(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannelLocationEmpty && this.equalTo(0, (ImmutableChannelLocationEmpty)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannelLocationEmpty another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "ChannelLocationEmpty{identifier=" + this.identifier + "}";
    }

    public static ImmutableChannelLocationEmpty of() {
        return INSTANCE;
    }

    private static ImmutableChannelLocationEmpty validate(ImmutableChannelLocationEmpty instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableChannelLocationEmpty copyOf(ChannelLocationEmpty instance) {
        if (instance instanceof ImmutableChannelLocationEmpty) {
            return (ImmutableChannelLocationEmpty)instance;
        }
        return ImmutableChannelLocationEmpty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(ChannelLocation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChannelLocationEmpty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmptyObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChannelLocation instance;
            long bits = 0L;
            if (object instanceof ChannelLocation) {
                instance = (ChannelLocation)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChannelLocationEmpty) {
                instance = (ChannelLocationEmpty)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof EmptyObject) {
                instance = (EmptyObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableChannelLocationEmpty build() {
            return ImmutableChannelLocationEmpty.validate(new ImmutableChannelLocationEmpty(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

