/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.ChannelParticipant;
import telegram4j.tl.ChannelParticipantAdmin;
import telegram4j.tl.ChatAdminRights;
import telegram4j.tl.api.TlObject;

public final class ImmutableChannelParticipantAdmin
implements ChannelParticipantAdmin {
    private final int identifier;
    private final int flags;
    private final boolean canEdit;
    private final boolean self;
    private final long userId;
    @Nullable
    private final Long inviterId;
    private final long promotedBy;
    private final int date;
    private final ChatAdminRights adminRights;
    @Nullable
    private final String rank;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableChannelParticipantAdmin(long userId, long promotedBy, int date, ChatAdminRights adminRights) {
        this.userId = userId;
        this.promotedBy = promotedBy;
        this.date = date;
        this.adminRights = Objects.requireNonNull(adminRights, "adminRights");
        this.inviterId = null;
        this.rank = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.canEdit = this.initShim.canEdit();
        this.self = this.initShim.self();
        this.initShim = null;
    }

    private ImmutableChannelParticipantAdmin(Builder builder) {
        this.userId = builder.userId;
        this.inviterId = builder.inviterId;
        this.promotedBy = builder.promotedBy;
        this.date = builder.date;
        this.adminRights = builder.adminRights;
        this.rank = builder.rank;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.canEditIsSet()) {
            this.initShim.canEdit(builder.canEdit);
        }
        if (builder.selfIsSet()) {
            this.initShim.self(builder.self);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.canEdit = this.initShim.canEdit();
        this.self = this.initShim.self();
        this.initShim = null;
    }

    private ImmutableChannelParticipantAdmin(int identifier, int flags, boolean canEdit, boolean self, long userId, @Nullable Long inviterId, long promotedBy, int date, ChatAdminRights adminRights, @Nullable String rank) {
        this.identifier = identifier;
        this.flags = flags;
        this.canEdit = canEdit;
        this.self = self;
        this.userId = userId;
        this.inviterId = inviterId;
        this.promotedBy = promotedBy;
        this.date = date;
        this.adminRights = adminRights;
        this.rank = rank;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ChannelParticipantAdmin.super.identifier();
    }

    private int flagsInitialize() {
        return ChannelParticipantAdmin.super.flags();
    }

    private boolean canEditInitialize() {
        return ChannelParticipantAdmin.super.canEdit();
    }

    private boolean selfInitialize() {
        return ChannelParticipantAdmin.super.self();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean canEdit() {
        InitShim shim = this.initShim;
        return shim != null ? shim.canEdit() : this.canEdit;
    }

    @Override
    public boolean self() {
        InitShim shim = this.initShim;
        return shim != null ? shim.self() : this.self;
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    @Nullable
    public Long inviterId() {
        return this.inviterId;
    }

    @Override
    public long promotedBy() {
        return this.promotedBy;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public ChatAdminRights adminRights() {
        return this.adminRights;
    }

    @Override
    @Nullable
    public String rank() {
        return this.rank;
    }

    public final ImmutableChannelParticipantAdmin withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChannelParticipantAdmin(value, this.flags, this.canEdit, this.self, this.userId, this.inviterId, this.promotedBy, this.date, this.adminRights, this.rank);
    }

    public final ImmutableChannelParticipantAdmin withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableChannelParticipantAdmin(this.identifier, value, this.canEdit, this.self, this.userId, this.inviterId, this.promotedBy, this.date, this.adminRights, this.rank);
    }

    public final ImmutableChannelParticipantAdmin withCanEdit(boolean value) {
        if (this.canEdit == value) {
            return this;
        }
        return new ImmutableChannelParticipantAdmin(this.identifier, this.flags, value, this.self, this.userId, this.inviterId, this.promotedBy, this.date, this.adminRights, this.rank);
    }

    public final ImmutableChannelParticipantAdmin withSelf(boolean value) {
        if (this.self == value) {
            return this;
        }
        return new ImmutableChannelParticipantAdmin(this.identifier, this.flags, this.canEdit, value, this.userId, this.inviterId, this.promotedBy, this.date, this.adminRights, this.rank);
    }

    public final ImmutableChannelParticipantAdmin withUserId(long value) {
        if (this.userId == value) {
            return this;
        }
        return new ImmutableChannelParticipantAdmin(this.identifier, this.flags, this.canEdit, this.self, value, this.inviterId, this.promotedBy, this.date, this.adminRights, this.rank);
    }

    public final ImmutableChannelParticipantAdmin withInviterId(@Nullable Long value) {
        if (Objects.equals(this.inviterId, value)) {
            return this;
        }
        return new ImmutableChannelParticipantAdmin(this.identifier, this.flags, this.canEdit, this.self, this.userId, value, this.promotedBy, this.date, this.adminRights, this.rank);
    }

    public final ImmutableChannelParticipantAdmin withPromotedBy(long value) {
        if (this.promotedBy == value) {
            return this;
        }
        return new ImmutableChannelParticipantAdmin(this.identifier, this.flags, this.canEdit, this.self, this.userId, this.inviterId, value, this.date, this.adminRights, this.rank);
    }

    public final ImmutableChannelParticipantAdmin withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableChannelParticipantAdmin(this.identifier, this.flags, this.canEdit, this.self, this.userId, this.inviterId, this.promotedBy, value, this.adminRights, this.rank);
    }

    public final ImmutableChannelParticipantAdmin withAdminRights(ChatAdminRights value) {
        if (this.adminRights == value) {
            return this;
        }
        ChatAdminRights newValue = Objects.requireNonNull(value, "adminRights");
        return new ImmutableChannelParticipantAdmin(this.identifier, this.flags, this.canEdit, this.self, this.userId, this.inviterId, this.promotedBy, this.date, newValue, this.rank);
    }

    public final ImmutableChannelParticipantAdmin withRank(@Nullable String value) {
        if (Objects.equals(this.rank, value)) {
            return this;
        }
        return new ImmutableChannelParticipantAdmin(this.identifier, this.flags, this.canEdit, this.self, this.userId, this.inviterId, this.promotedBy, this.date, this.adminRights, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannelParticipantAdmin && this.equalTo(0, (ImmutableChannelParticipantAdmin)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannelParticipantAdmin another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.canEdit == another.canEdit && this.self == another.self && this.userId == another.userId && Objects.equals(this.inviterId, another.inviterId) && this.promotedBy == another.promotedBy && this.date == another.date && this.adminRights.equals(another.adminRights) && Objects.equals(this.rank, another.rank);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.canEdit);
        h += (h << 5) + Boolean.hashCode(this.self);
        h += (h << 5) + Long.hashCode(this.userId);
        h += (h << 5) + Objects.hashCode(this.inviterId);
        h += (h << 5) + Long.hashCode(this.promotedBy);
        h += (h << 5) + this.date;
        h += (h << 5) + this.adminRights.hashCode();
        h += (h << 5) + Objects.hashCode(this.rank);
        return h;
    }

    public String toString() {
        return "ChannelParticipantAdmin{identifier=" + this.identifier + ", flags=" + this.flags + ", canEdit=" + this.canEdit + ", self=" + this.self + ", userId=" + this.userId + ", inviterId=" + this.inviterId + ", promotedBy=" + this.promotedBy + ", date=" + this.date + ", adminRights=" + this.adminRights + ", rank=" + this.rank + "}";
    }

    public static ImmutableChannelParticipantAdmin of(long userId, long promotedBy, int date, ChatAdminRights adminRights) {
        return new ImmutableChannelParticipantAdmin(userId, promotedBy, date, adminRights);
    }

    public static ImmutableChannelParticipantAdmin copyOf(ChannelParticipantAdmin instance) {
        if (instance instanceof ImmutableChannelParticipantAdmin) {
            return (ImmutableChannelParticipantAdmin)instance;
        }
        return ImmutableChannelParticipantAdmin.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_PROMOTED_BY = 2L;
        private static final long INIT_BIT_DATE = 4L;
        private static final long INIT_BIT_ADMIN_RIGHTS = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_CAN_EDIT = 4L;
        private static final long OPT_BIT_SELF = 8L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean canEdit;
        private boolean self;
        private long userId;
        private Long inviterId;
        private long promotedBy;
        private int date;
        private ChatAdminRights adminRights;
        private String rank;

        private Builder() {
        }

        public final Builder from(ChannelParticipant instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChannelParticipantAdmin instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChannelParticipant instance;
            long bits = 0L;
            if (object instanceof ChannelParticipant) {
                instance = (ChannelParticipant)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChannelParticipantAdmin) {
                Long inviterIdValue;
                instance = (ChannelParticipantAdmin)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((inviterIdValue = instance.inviterId()) != null) {
                    this.inviterId(inviterIdValue);
                }
                this.canEdit(instance.canEdit());
                this.flags(instance.flags());
                this.self(instance.self());
                String rankValue = instance.rank();
                if (rankValue != null) {
                    this.rank(rankValue);
                }
                this.promotedBy(instance.promotedBy());
                this.userId(instance.userId());
                this.adminRights(instance.adminRights());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder canEdit(boolean canEdit) {
            this.canEdit = canEdit;
            this.optBits |= 4L;
            return this;
        }

        public final Builder self(boolean self) {
            this.self = self;
            this.optBits |= 8L;
            return this;
        }

        public final Builder userId(long userId) {
            this.userId = userId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder inviterId(@Nullable Long inviterId) {
            this.inviterId = inviterId;
            return this;
        }

        public final Builder promotedBy(long promotedBy) {
            this.promotedBy = promotedBy;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder adminRights(ChatAdminRights adminRights) {
            this.adminRights = Objects.requireNonNull(adminRights, "adminRights");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder rank(@Nullable String rank) {
            this.rank = rank;
            return this;
        }

        public ImmutableChannelParticipantAdmin build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChannelParticipantAdmin(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean canEditIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean selfIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("promotedBy");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("adminRights");
            }
            return "Cannot build ChannelParticipantAdmin, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte canEditBuildStage = 0;
        private boolean canEdit;
        private byte selfBuildStage = 0;
        private boolean self;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableChannelParticipantAdmin.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableChannelParticipantAdmin.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean canEdit() {
            if (this.canEditBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.canEditBuildStage == 0) {
                this.canEditBuildStage = (byte)-1;
                this.canEdit = ImmutableChannelParticipantAdmin.this.canEditInitialize();
                this.canEditBuildStage = 1;
            }
            return this.canEdit;
        }

        void canEdit(boolean canEdit) {
            this.canEdit = canEdit;
            this.canEditBuildStage = 1;
        }

        boolean self() {
            if (this.selfBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.selfBuildStage == 0) {
                this.selfBuildStage = (byte)-1;
                this.self = ImmutableChannelParticipantAdmin.this.selfInitialize();
                this.selfBuildStage = 1;
            }
            return this.self;
        }

        void self(boolean self) {
            this.self = self;
            this.selfBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.canEditBuildStage == -1) {
                attributes.add("canEdit");
            }
            if (this.selfBuildStage == -1) {
                attributes.add("self");
            }
            return "Cannot build ChannelParticipantAdmin, attribute initializers form cycle " + attributes;
        }
    }
}

