/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.ChannelParticipant;
import telegram4j.tl.ChannelParticipantBanned;
import telegram4j.tl.ChatBannedRights;
import telegram4j.tl.Peer;
import telegram4j.tl.api.TlObject;

public final class ImmutableChannelParticipantBanned
implements ChannelParticipantBanned {
    private final int identifier;
    private final int flags;
    private final boolean left;
    private final Peer peer;
    private final long kickedBy;
    private final int date;
    private final ChatBannedRights bannedRights;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableChannelParticipantBanned(Peer peer, long kickedBy, int date, ChatBannedRights bannedRights) {
        this.peer = Objects.requireNonNull(peer, "peer");
        this.kickedBy = kickedBy;
        this.date = date;
        this.bannedRights = Objects.requireNonNull(bannedRights, "bannedRights");
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.left = this.initShim.left();
        this.initShim = null;
    }

    private ImmutableChannelParticipantBanned(Builder builder) {
        this.peer = builder.peer;
        this.kickedBy = builder.kickedBy;
        this.date = builder.date;
        this.bannedRights = builder.bannedRights;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.leftIsSet()) {
            this.initShim.left(builder.left);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.left = this.initShim.left();
        this.initShim = null;
    }

    private ImmutableChannelParticipantBanned(int identifier, int flags, boolean left, Peer peer, long kickedBy, int date, ChatBannedRights bannedRights) {
        this.identifier = identifier;
        this.flags = flags;
        this.left = left;
        this.peer = peer;
        this.kickedBy = kickedBy;
        this.date = date;
        this.bannedRights = bannedRights;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ChannelParticipantBanned.super.identifier();
    }

    private int flagsInitialize() {
        return ChannelParticipantBanned.super.flags();
    }

    private boolean leftInitialize() {
        return ChannelParticipantBanned.super.left();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean left() {
        InitShim shim = this.initShim;
        return shim != null ? shim.left() : this.left;
    }

    @Override
    public Peer peer() {
        return this.peer;
    }

    @Override
    public long kickedBy() {
        return this.kickedBy;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public ChatBannedRights bannedRights() {
        return this.bannedRights;
    }

    public final ImmutableChannelParticipantBanned withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChannelParticipantBanned(value, this.flags, this.left, this.peer, this.kickedBy, this.date, this.bannedRights);
    }

    public final ImmutableChannelParticipantBanned withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableChannelParticipantBanned(this.identifier, value, this.left, this.peer, this.kickedBy, this.date, this.bannedRights);
    }

    public final ImmutableChannelParticipantBanned withLeft(boolean value) {
        if (this.left == value) {
            return this;
        }
        return new ImmutableChannelParticipantBanned(this.identifier, this.flags, value, this.peer, this.kickedBy, this.date, this.bannedRights);
    }

    public final ImmutableChannelParticipantBanned withPeer(Peer value) {
        if (this.peer == value) {
            return this;
        }
        Peer newValue = Objects.requireNonNull(value, "peer");
        return new ImmutableChannelParticipantBanned(this.identifier, this.flags, this.left, newValue, this.kickedBy, this.date, this.bannedRights);
    }

    public final ImmutableChannelParticipantBanned withKickedBy(long value) {
        if (this.kickedBy == value) {
            return this;
        }
        return new ImmutableChannelParticipantBanned(this.identifier, this.flags, this.left, this.peer, value, this.date, this.bannedRights);
    }

    public final ImmutableChannelParticipantBanned withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableChannelParticipantBanned(this.identifier, this.flags, this.left, this.peer, this.kickedBy, value, this.bannedRights);
    }

    public final ImmutableChannelParticipantBanned withBannedRights(ChatBannedRights value) {
        if (this.bannedRights == value) {
            return this;
        }
        ChatBannedRights newValue = Objects.requireNonNull(value, "bannedRights");
        return new ImmutableChannelParticipantBanned(this.identifier, this.flags, this.left, this.peer, this.kickedBy, this.date, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannelParticipantBanned && this.equalTo(0, (ImmutableChannelParticipantBanned)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannelParticipantBanned another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.left == another.left && this.peer.equals(another.peer) && this.kickedBy == another.kickedBy && this.date == another.date && this.bannedRights.equals(another.bannedRights);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.left);
        h += (h << 5) + this.peer.hashCode();
        h += (h << 5) + Long.hashCode(this.kickedBy);
        h += (h << 5) + this.date;
        h += (h << 5) + this.bannedRights.hashCode();
        return h;
    }

    public String toString() {
        return "ChannelParticipantBanned{identifier=" + this.identifier + ", flags=" + this.flags + ", left=" + this.left + ", peer=" + this.peer + ", kickedBy=" + this.kickedBy + ", date=" + this.date + ", bannedRights=" + this.bannedRights + "}";
    }

    public static ImmutableChannelParticipantBanned of(Peer peer, long kickedBy, int date, ChatBannedRights bannedRights) {
        return new ImmutableChannelParticipantBanned(peer, kickedBy, date, bannedRights);
    }

    public static ImmutableChannelParticipantBanned copyOf(ChannelParticipantBanned instance) {
        if (instance instanceof ImmutableChannelParticipantBanned) {
            return (ImmutableChannelParticipantBanned)instance;
        }
        return ImmutableChannelParticipantBanned.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PEER = 1L;
        private static final long INIT_BIT_KICKED_BY = 2L;
        private static final long INIT_BIT_DATE = 4L;
        private static final long INIT_BIT_BANNED_RIGHTS = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_LEFT = 4L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean left;
        private Peer peer;
        private long kickedBy;
        private int date;
        private ChatBannedRights bannedRights;

        private Builder() {
        }

        public final Builder from(ChannelParticipant instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChannelParticipantBanned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChannelParticipant instance;
            long bits = 0L;
            if (object instanceof ChannelParticipant) {
                instance = (ChannelParticipant)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChannelParticipantBanned) {
                instance = (ChannelParticipantBanned)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.kickedBy(instance.kickedBy());
                this.left(instance.left());
                this.peer(instance.peer());
                this.flags(instance.flags());
                this.bannedRights(instance.bannedRights());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder left(boolean left) {
            this.left = left;
            this.optBits |= 4L;
            return this;
        }

        public final Builder peer(Peer peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder kickedBy(long kickedBy) {
            this.kickedBy = kickedBy;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder bannedRights(ChatBannedRights bannedRights) {
            this.bannedRights = Objects.requireNonNull(bannedRights, "bannedRights");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableChannelParticipantBanned build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChannelParticipantBanned(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean leftIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("peer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("kickedBy");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("bannedRights");
            }
            return "Cannot build ChannelParticipantBanned, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte leftBuildStage = 0;
        private boolean left;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableChannelParticipantBanned.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableChannelParticipantBanned.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean left() {
            if (this.leftBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.leftBuildStage == 0) {
                this.leftBuildStage = (byte)-1;
                this.left = ImmutableChannelParticipantBanned.this.leftInitialize();
                this.leftBuildStage = 1;
            }
            return this.left;
        }

        void left(boolean left) {
            this.left = left;
            this.leftBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.leftBuildStage == -1) {
                attributes.add("left");
            }
            return "Cannot build ChannelParticipantBanned, attribute initializers form cycle " + attributes;
        }
    }
}

